/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkModulusImageFilter_h
#define sitkModulusImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkBinaryFunctorFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class ModulusImageFilter
\brief Computes the modulus (x % dividend) pixel-wise.

The input pixel type must support the c++ modulus operator (%).

If the dividend is zero, the maximum value will be returned.

\author Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA de Jouy-en-Josas, France.
\sa itk::simple::Modulus for the procedural interface
\sa itk::ModulusImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT ModulusImageFilter : public ImageFilter {
    public:
      using Self = ModulusImageFilter;

      /** Destructor */
      virtual ~ModulusImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      ModulusImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = IntegerPixelIDTypeList;



      /** Name of this class */
      std::string GetName() const { return std::string ("ModulusImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input images */
#ifndef SWIG
      Image Execute ( Image&& image1, const Image& image2 );
#endif
      Image Execute ( const Image& image1, const Image& image2 );

      /** Execute the filter with an image and a constant */
      Image Execute ( const Image& image1, uint32_t constant );
#ifndef SWIG
      Image Execute ( Image&& image1, uint32_t constant );
#endif
      Image Execute ( uint32_t constant, const Image& image2 );


    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = Image (Self::*)( const Image& image1, const Image& image2 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1, const Image& image2 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;
      using MemberFunction1Type = Image (Self::*)( uint32_t constant, const Image& image2 );
      template <class TImageType> Image ExecuteInternal ( uint32_t constant, const Image& image2 );
      friend struct detail::MemberFunctionAddressor<MemberFunction1Type>;
      std::unique_ptr<detail::MemberFunctionFactory<MemberFunction1Type> > m_MemberFactory1;

      using MemberFunction2Type = Image (Self::*)( const Image& image1, uint32_t constant );
      template <class TImageType> Image ExecuteInternal ( const Image& image1, uint32_t constant );
      friend struct detail::MemberFunctionAddressor<MemberFunction2Type>;
      std::unique_ptr<detail::MemberFunctionFactory<MemberFunction2Type> > m_MemberFactory2;



      bool m_InPlace{false};
    };

    /**\
     * \brief Computes the modulus (x % dividend) pixel-wise.
     *
     * This function directly calls the execute method of ModulusImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::ModulusImageFilter for the object oriented interface
     * @{
     */
#ifndef SWIG
     SITKBasicFilters_EXPORT Image Modulus ( Image&& image1, const Image& image2 );
#endif
     SITKBasicFilters_EXPORT Image Modulus ( const Image& image1, const Image& image2 );

     /** @} */
     SITKBasicFilters_EXPORT Image Modulus ( const Image& image1, uint32_t constant );
#ifndef  SWIG
     SITKBasicFilters_EXPORT Image Modulus ( Image&& image1, uint32_t constant );
#endif
     SITKBasicFilters_EXPORT Image Modulus ( uint32_t constant, const Image& image2 );
}
#endif
