/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.hnsw;

import java.io.IOException;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.util.Bits;

public interface RandomVectorScorer {
    public float score(int var1) throws IOException;

    default public void bulkScore(int[] nodes, float[] scores, int numNodes) throws IOException {
        for (int i = 0; i < numNodes; ++i) {
            scores[i] = this.score(nodes[i]);
        }
    }

    public int maxOrd();

    default public int ordToDoc(int ord) {
        return ord;
    }

    default public Bits getAcceptOrds(Bits acceptDocs) {
        return acceptDocs;
    }

    public static abstract class AbstractRandomVectorScorer
    implements RandomVectorScorer {
        private final KnnVectorValues values;

        public AbstractRandomVectorScorer(KnnVectorValues values) {
            this.values = values;
        }

        @Override
        public int maxOrd() {
            return this.values.size();
        }

        @Override
        public int ordToDoc(int ord) {
            return this.values.ordToDoc(ord);
        }

        @Override
        public Bits getAcceptOrds(Bits acceptDocs) {
            return this.values.getAcceptOrds(acceptDocs);
        }
    }
}

