/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.contextmanagement.MLListContextManagementTemplatesAction;
import org.opensearch.ml.common.transport.contextmanagement.MLListContextManagementTemplatesRequest;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.transport.client.node.NodeClient;

public class RestMLListContextManagementTemplatesAction
extends BaseRestHandler {
    private static final String ML_LIST_CONTEXT_MANAGEMENT_TEMPLATES_ACTION = "ml_list_context_management_templates_action";
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLListContextManagementTemplatesAction(MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public String getName() {
        return ML_LIST_CONTEXT_MANAGEMENT_TEMPLATES_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, String.format(Locale.ROOT, "%s/context_management", "/_plugins/_ml")));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MLListContextManagementTemplatesRequest listRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)MLListContextManagementTemplatesAction.INSTANCE, (ActionRequest)listRequest, (ActionListener)new RestToXContentListener(channel));
    }

    @VisibleForTesting
    MLListContextManagementTemplatesRequest getRequest(RestRequest request) throws IOException {
        if (!this.mlFeatureEnabledSetting.isAgentFrameworkEnabled()) {
            throw new IllegalStateException("Agent framework is disabled");
        }
        int from = request.paramAsInt("from", 0);
        int size = request.paramAsInt("size", 10);
        if (from < 0) {
            throw new IllegalArgumentException("Parameter 'from' must be non-negative");
        }
        if (size <= 0 || size > 1000) {
            throw new IllegalArgumentException("Parameter 'size' must be between 1 and 1000");
        }
        return new MLListContextManagementTemplatesRequest(from, size);
    }
}

