/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.type;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.rel.type.RelCrossType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFamily;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.rel.type.StructKind;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.type.ArraySqlType;
import org.apache.calcite.sql.type.JavaToSqlTypeConversionRules;
import org.apache.calcite.sql.type.MapSqlType;
import org.apache.calcite.sql.type.MultisetSqlType;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeMappingRule;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.ReflectUtil;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class RelDataTypeFactoryImpl
implements RelDataTypeFactory {
    private static final LoadingCache<Key, RelDataType> KEY2TYPE_CACHE = CacheBuilder.newBuilder().softValues().build(CacheLoader.from(RelDataTypeFactoryImpl::keyToType));
    private static final Interner<RelDataType> DATATYPE_CACHE = Interners.newWeakInterner();
    private static final Map<Class, RelDataTypeFamily> CLASS_FAMILIES = ImmutableMap.builder().put(String.class, (Object)SqlTypeFamily.CHARACTER).put(byte[].class, (Object)SqlTypeFamily.BINARY).put(Boolean.TYPE, (Object)SqlTypeFamily.BOOLEAN).put(Boolean.class, (Object)SqlTypeFamily.BOOLEAN).put(Character.TYPE, (Object)SqlTypeFamily.NUMERIC).put(Character.class, (Object)SqlTypeFamily.NUMERIC).put(Short.TYPE, (Object)SqlTypeFamily.NUMERIC).put(Short.class, (Object)SqlTypeFamily.NUMERIC).put(Integer.TYPE, (Object)SqlTypeFamily.NUMERIC).put(Integer.class, (Object)SqlTypeFamily.NUMERIC).put(Long.TYPE, (Object)SqlTypeFamily.NUMERIC).put(Long.class, (Object)SqlTypeFamily.NUMERIC).put(Float.TYPE, (Object)SqlTypeFamily.APPROXIMATE_NUMERIC).put(Float.class, (Object)SqlTypeFamily.APPROXIMATE_NUMERIC).put(Double.TYPE, (Object)SqlTypeFamily.APPROXIMATE_NUMERIC).put(Double.class, (Object)SqlTypeFamily.APPROXIMATE_NUMERIC).put(Date.class, (Object)SqlTypeFamily.DATE).put(Time.class, (Object)SqlTypeFamily.TIME).put(Timestamp.class, (Object)SqlTypeFamily.TIMESTAMP).build();
    protected final RelDataTypeSystem typeSystem;

    private static RelDataType keyToType(Key key) {
        ImmutableList.Builder list = ImmutableList.builder();
        for (int i = 0; i < key.names.size(); ++i) {
            list.add((Object)new RelDataTypeFieldImpl((String)key.names.get(i), i, (RelDataType)key.types.get(i)));
        }
        return new RelRecordType(key.kind, (List<RelDataTypeField>)list.build(), key.nullable);
    }

    protected RelDataTypeFactoryImpl(RelDataTypeSystem typeSystem) {
        this.typeSystem = Objects.requireNonNull(typeSystem, "typeSystem");
    }

    @Override
    public RelDataTypeSystem getTypeSystem() {
        return this.typeSystem;
    }

    @Override
    public RelDataType createJavaType(Class clazz) {
        JavaType javaType = clazz == String.class ? new JavaType(clazz, true, this.getDefaultCharset(), SqlCollation.IMPLICIT) : new JavaType(clazz);
        return this.canonize(javaType);
    }

    @Override
    public RelDataType createJoinType(RelDataType ... types) {
        Objects.requireNonNull(types, "types");
        Preconditions.checkArgument((types.length >= 1 ? 1 : 0) != 0);
        ArrayList<RelDataType> flattenedTypes = new ArrayList<RelDataType>();
        RelDataTypeFactoryImpl.getTypeList((List<RelDataType>)ImmutableList.copyOf((Object[])types), flattenedTypes);
        return this.canonize(new RelCrossType(flattenedTypes, RelDataTypeFactoryImpl.getFieldList(flattenedTypes)));
    }

    @Override
    public RelDataType createStructType(List<RelDataType> typeList, List<String> fieldNameList) {
        return this.createStructType(StructKind.FULLY_QUALIFIED, typeList, fieldNameList);
    }

    @Override
    public RelDataType createStructType(StructKind kind, List<RelDataType> typeList, List<String> fieldNameList) {
        return this.createStructType(kind, typeList, fieldNameList, false);
    }

    private RelDataType createStructType(StructKind kind, List<RelDataType> typeList, List<String> fieldNameList, boolean nullable) {
        assert (typeList.size() == fieldNameList.size());
        return this.canonize(kind, fieldNameList, typeList, nullable);
    }

    @Override
    public RelDataType createStructType(final RelDataTypeFactory.FieldInfo fieldInfo) {
        return this.canonize(StructKind.FULLY_QUALIFIED, (List<String>)new AbstractList<String>(){

            @Override
            public String get(int index) {
                return fieldInfo.getFieldName(index);
            }

            @Override
            public int size() {
                return fieldInfo.getFieldCount();
            }
        }, (List<RelDataType>)new AbstractList<RelDataType>(){

            @Override
            public RelDataType get(int index) {
                return fieldInfo.getFieldType(index);
            }

            @Override
            public int size() {
                return fieldInfo.getFieldCount();
            }
        });
    }

    @Override
    public final RelDataType createStructType(List<? extends Map.Entry<String, RelDataType>> fieldList) {
        return this.createStructType(fieldList, false);
    }

    private RelDataType createStructType(List<? extends Map.Entry<String, RelDataType>> fieldList, boolean nullable) {
        return this.canonize(StructKind.FULLY_QUALIFIED, Pair.left(fieldList), Pair.right(fieldList), nullable);
    }

    @Override
    public @Nullable RelDataType leastRestrictive(List<RelDataType> types, SqlTypeMappingRule mappingRule) {
        Objects.requireNonNull(types, "types");
        Objects.requireNonNull(mappingRule, "mappingRule");
        Preconditions.checkArgument((!types.isEmpty() ? 1 : 0) != 0, (Object)"!types.isEmpty");
        RelDataType type0 = types.get(0);
        if (type0.isStruct()) {
            return this.leastRestrictiveStructuredType(types);
        }
        return null;
    }

    protected @Nullable RelDataType leastRestrictiveStructuredType(List<RelDataType> types) {
        RelDataType type0 = types.get(0);
        if (!type0.isStruct()) {
            return null;
        }
        int fieldCount = type0.getFieldCount();
        boolean isNullable = false;
        for (RelDataType type : types) {
            if (!type.isStruct()) {
                return null;
            }
            if (type.getFieldList().size() != fieldCount) {
                return null;
            }
            isNullable |= type.isNullable();
        }
        RelDataTypeFactory.FieldInfoBuilder builder = this.builder().kind(type0.getStructKind());
        for (int j = 0; j < fieldCount; ++j) {
            int k = j;
            RelDataType type = this.leastRestrictive(Util.transform(types, t -> t.getFieldList().get(k).getType()));
            if (type == null) {
                return null;
            }
            ((RelDataTypeFactory.Builder)builder).add(type0.getFieldList().get(j).getName(), type);
        }
        return this.createTypeWithNullability(builder.build(), isNullable);
    }

    protected @Nullable RelDataType leastRestrictiveArrayMultisetType(List<RelDataType> types, SqlTypeName sqlTypeName) {
        assert (sqlTypeName == SqlTypeName.ARRAY || sqlTypeName == SqlTypeName.MULTISET);
        boolean isNullable = false;
        for (RelDataType type : types) {
            if (type.getComponentType() == null) {
                return null;
            }
            isNullable |= type.isNullable();
        }
        RelDataType type = this.leastRestrictive(Util.transform(types, t -> t instanceof ArraySqlType ? ((ArraySqlType)t).getComponentType() : ((MultisetSqlType)t).getComponentType()));
        if (type == null) {
            return null;
        }
        RelDataType collection = sqlTypeName == SqlTypeName.ARRAY ? this.createArrayType(type, -1L) : this.createMultisetType(type, -1L);
        return this.createTypeWithNullability(collection, isNullable);
    }

    protected @Nullable RelDataType leastRestrictiveMapType(List<RelDataType> types, SqlTypeName sqlTypeName) {
        assert (sqlTypeName == SqlTypeName.MAP);
        boolean isNullable = false;
        for (RelDataType type : types) {
            if (!(type instanceof MapSqlType)) {
                return null;
            }
            isNullable |= type.isNullable();
        }
        RelDataType keyType = this.leastRestrictive(Util.transform(types, t -> ((MapSqlType)t).getKeyType()));
        if (keyType == null) {
            return null;
        }
        RelDataType valueType = this.leastRestrictive(Util.transform(types, t -> ((MapSqlType)t).getValueType()));
        if (valueType == null) {
            return null;
        }
        return this.createTypeWithNullability(this.createMapType(keyType, valueType), isNullable);
    }

    protected RelDataType leastRestrictiveIntervalDatetimeType(RelDataType dateTimeType, RelDataType type1) {
        assert (SqlTypeUtil.isDatetime(dateTimeType));
        if (SqlTypeUtil.isIntType(type1)) {
            return dateTimeType;
        }
        SqlIntervalQualifier intervalQualifier = type1.getIntervalQualifier();
        Objects.requireNonNull(intervalQualifier, "intervalQualifier");
        if (!dateTimeType.getSqlTypeName().allowsPrec() || intervalQualifier.useDefaultFractionalSecondPrecision() || intervalQualifier.getFractionalSecondPrecision(this.typeSystem) <= dateTimeType.getPrecision()) {
            return dateTimeType;
        }
        return this.createSqlType(dateTimeType.getSqlTypeName(), intervalQualifier.getFractionalSecondPrecision(this.typeSystem));
    }

    private RelDataType copySimpleType(RelDataType type, boolean nullable) {
        if (type instanceof JavaType) {
            JavaType javaType = (JavaType)type;
            if (SqlTypeUtil.inCharFamily(javaType)) {
                return new JavaType(javaType.clazz, nullable, javaType.charset, javaType.collation);
            }
            return new JavaType(nullable ? Primitive.box((Class)javaType.clazz) : Primitive.unbox((Class)javaType.clazz), nullable);
        }
        return type;
    }

    private RelDataType copyRecordType(final RelRecordType type, final boolean ignoreNullable, final boolean nullable) {
        return this.createStructType(type.getStructKind(), (List<RelDataType>)new AbstractList<RelDataType>(){

            @Override
            public RelDataType get(int index) {
                RelDataType fieldType = type.getFieldList().get(index).getType();
                if (ignoreNullable) {
                    return RelDataTypeFactoryImpl.this.copyType(fieldType);
                }
                return RelDataTypeFactoryImpl.this.createTypeWithNullability(fieldType, nullable);
            }

            @Override
            public int size() {
                return type.getFieldCount();
            }
        }, type.getFieldNames(), nullable);
    }

    @Override
    public RelDataType copyType(RelDataType type) {
        return this.createTypeWithNullability(type, type.isNullable());
    }

    @Override
    public RelDataType createTypeWithNullability(RelDataType type, boolean nullable) {
        Objects.requireNonNull(type, "type");
        RelDataType newType = type.isNullable() == nullable ? type : (type instanceof RelRecordType ? this.copyRecordType((RelRecordType)type, !nullable, nullable) : this.copySimpleType(type, nullable));
        return this.canonize(newType);
    }

    @Override
    public RelDataType enforceTypeWithNullability(final RelDataType type, boolean nullable) {
        RelDataType newType;
        Objects.requireNonNull(type, "type");
        if (type.isNullable() == nullable) {
            newType = type;
        } else {
            if (type instanceof RelRecordType) {
                return this.createStructType(type.getStructKind(), (List<RelDataType>)new AbstractList<RelDataType>(){

                    @Override
                    public RelDataType get(int index) {
                        return type.getFieldList().get(index).getType();
                    }

                    @Override
                    public int size() {
                        return type.getFieldCount();
                    }
                }, type.getFieldNames(), nullable);
            }
            newType = this.copySimpleType(type, nullable);
        }
        return this.canonize(newType);
    }

    protected RelDataType canonize(RelDataType type) {
        return (RelDataType)DATATYPE_CACHE.intern((Object)type);
    }

    protected RelDataType canonize(StructKind kind, List<String> names, List<RelDataType> types, boolean nullable) {
        RelDataType type = (RelDataType)KEY2TYPE_CACHE.getIfPresent((Object)new Key(kind, names, types, nullable));
        if (type != null) {
            return type;
        }
        ImmutableList names2 = ImmutableList.copyOf(names);
        ImmutableList types2 = ImmutableList.copyOf(types);
        return (RelDataType)KEY2TYPE_CACHE.getUnchecked((Object)new Key(kind, (List<String>)names2, (List<RelDataType>)types2, nullable));
    }

    protected RelDataType canonize(StructKind kind, List<String> names, List<RelDataType> types) {
        return this.canonize(kind, names, types, false);
    }

    private static List<RelDataTypeField> getFieldList(List<RelDataType> types) {
        ArrayList<RelDataTypeField> fieldList = new ArrayList<RelDataTypeField>();
        for (RelDataType type : types) {
            RelDataTypeFactoryImpl.addFields(type, fieldList);
        }
        return fieldList;
    }

    private static void getTypeList(List<RelDataType> inTypes, List<RelDataType> flatTypes) {
        for (RelDataType inType : inTypes) {
            if (inType instanceof RelCrossType) {
                RelDataTypeFactoryImpl.getTypeList(((RelCrossType)inType).getTypes(), flatTypes);
                continue;
            }
            flatTypes.add(inType);
        }
    }

    private static void addFields(RelDataType type, List<RelDataTypeField> fieldList) {
        if (type instanceof RelCrossType) {
            RelCrossType crossType = (RelCrossType)type;
            for (RelDataType type1 : crossType.getTypes()) {
                RelDataTypeFactoryImpl.addFields(type1, fieldList);
            }
        } else {
            List<RelDataTypeField> fields = type.getFieldList();
            for (RelDataTypeField field : fields) {
                if (field.getIndex() != fieldList.size()) {
                    field = new RelDataTypeFieldImpl(field.getName(), fieldList.size(), field.getType());
                }
                fieldList.add(field);
            }
        }
    }

    public static boolean isJavaType(RelDataType t) {
        return t instanceof JavaType;
    }

    private @Nullable List<RelDataTypeFieldImpl> fieldsOf(Class clazz) {
        ArrayList<RelDataTypeFieldImpl> list = new ArrayList<RelDataTypeFieldImpl>();
        for (Field field : clazz.getFields()) {
            if (ReflectUtil.isStatic(field)) continue;
            list.add(new RelDataTypeFieldImpl(field.getName(), list.size(), this.createJavaType(field.getType())));
        }
        if (list.isEmpty()) {
            return null;
        }
        return list;
    }

    @Override
    @Deprecated
    public @Nullable RelDataType createDecimalProduct(RelDataType type1, RelDataType type2) {
        return this.typeSystem.deriveDecimalMultiplyType(this, type1, type2);
    }

    @Override
    @Deprecated
    public boolean useDoubleMultiplication(RelDataType type1, RelDataType type2) {
        return this.typeSystem.shouldUseDoubleMultiplication(this, type1, type2);
    }

    @Override
    @Deprecated
    public @Nullable RelDataType createDecimalQuotient(RelDataType type1, RelDataType type2) {
        return this.typeSystem.deriveDecimalDivideType(this, type1, type2);
    }

    @Override
    public RelDataType decimalOf(RelDataType type) {
        return this.createTypeWithNullability(this.decimalOf2(type), type.isNullable());
    }

    private RelDataType decimalOf2(RelDataType type) {
        assert (SqlTypeUtil.isNumeric(type) || SqlTypeUtil.isNull(type));
        SqlTypeName typeName = Objects.requireNonNull(type.getSqlTypeName());
        switch (typeName) {
            case DECIMAL: {
                return RelDataTypeFactoryImpl.isJavaType(type) ? SqlTypeUtil.getMaxPrecisionScaleDecimal(this) : type;
            }
            case TINYINT: {
                return this.createSqlType(SqlTypeName.DECIMAL, 3, 0);
            }
            case SMALLINT: {
                return this.createSqlType(SqlTypeName.DECIMAL, 5, 0);
            }
            case INTEGER: {
                return this.createSqlType(SqlTypeName.DECIMAL, 10, 0);
            }
            case BIGINT: {
                return this.createSqlType(SqlTypeName.DECIMAL, 38, 0);
            }
            case REAL: {
                return this.createSqlType(SqlTypeName.DECIMAL, 14, 7);
            }
            case FLOAT: 
            case DOUBLE: {
                return this.createSqlType(SqlTypeName.DECIMAL, 30, 15);
            }
        }
        return this.createSqlType(SqlTypeName.DECIMAL);
    }

    @Override
    public Charset getDefaultCharset() {
        return Util.getDefaultCharset();
    }

    @Override
    public RelDataTypeFactory.FieldInfoBuilder builder() {
        return new RelDataTypeFactory.FieldInfoBuilder(this);
    }

    private static class Key {
        private final StructKind kind;
        private final List<String> names;
        private final List<RelDataType> types;
        private final boolean nullable;

        Key(StructKind kind, List<String> names, List<RelDataType> types, boolean nullable) {
            this.kind = kind;
            this.names = names;
            this.types = types;
            this.nullable = nullable;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.kind, this.names, this.types, this.nullable});
        }

        public boolean equals(@Nullable Object obj) {
            return obj == this || obj instanceof Key && this.kind == ((Key)obj).kind && this.names.equals(((Key)obj).names) && this.types.equals(((Key)obj).types) && this.nullable == ((Key)obj).nullable;
        }
    }

    public class JavaType
    extends RelDataTypeImpl {
        private final Class clazz;
        private final boolean nullable;
        private final @Nullable SqlCollation collation;
        private final @Nullable Charset charset;

        public JavaType(Class clazz) {
            this(clazz, !clazz.isPrimitive());
        }

        public JavaType(Class clazz, boolean nullable) {
            this(clazz, nullable, null, null);
        }

        public JavaType(Class clazz, @Nullable boolean nullable, @Nullable Charset charset, SqlCollation collation) {
            super(RelDataTypeFactoryImpl.this.fieldsOf(clazz));
            this.clazz = clazz;
            this.nullable = nullable;
            Preconditions.checkArgument((charset != null == SqlTypeUtil.inCharFamily(this) ? 1 : 0) != 0, (Object)"Need to be a chartype");
            this.charset = charset;
            this.collation = collation;
            this.computeDigest();
        }

        public Class getJavaClass() {
            return this.clazz;
        }

        @Override
        public boolean isNullable() {
            return this.nullable;
        }

        @Override
        public RelDataTypeFamily getFamily() {
            RelDataTypeFamily family = (RelDataTypeFamily)CLASS_FAMILIES.get(this.clazz);
            return family != null ? family : this;
        }

        @Override
        protected void generateTypeString(StringBuilder sb, boolean withDetail) {
            sb.append("JavaType(");
            sb.append(this.clazz);
            if (this.clazz == String.class && this.charset != null && !SqlCollation.IMPLICIT.getCharset().equals(this.charset)) {
                sb.append(" CHARACTER SET \"");
                sb.append(this.charset.name());
                sb.append("\"");
            }
            sb.append(")");
        }

        @Override
        public @Nullable RelDataType getComponentType() {
            Class<?> componentType = this.clazz.getComponentType();
            if (componentType == null) {
                return null;
            }
            return RelDataTypeFactoryImpl.this.createJavaType(componentType);
        }

        @Override
        public @Nullable RelDataType getKeyType() {
            if (Map.class.isAssignableFrom(this.clazz)) {
                return RelDataTypeFactoryImpl.this.createSqlType(SqlTypeName.ANY);
            }
            return null;
        }

        @Override
        public @Nullable RelDataType getValueType() {
            if (Map.class.isAssignableFrom(this.clazz)) {
                return RelDataTypeFactoryImpl.this.createSqlType(SqlTypeName.ANY);
            }
            return null;
        }

        @Override
        public @Nullable Charset getCharset() {
            return this.charset;
        }

        @Override
        public @Nullable SqlCollation getCollation() {
            return this.collation;
        }

        @Override
        public SqlTypeName getSqlTypeName() {
            SqlTypeName typeName = JavaToSqlTypeConversionRules.instance().lookup(this.clazz);
            if (typeName == null) {
                return SqlTypeName.OTHER;
            }
            return typeName;
        }
    }
}

