/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.anonymization;

import com.intellij.internal.statistic.eventLog.anonymization.AnonymizerUtil;
import com.intellij.internal.statistic.eventLog.util.StringUtil;
import java.security.MessageDigest;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bJ\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0002R#\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/internal/statistic/eventLog/anonymization/AnonymizerUtil;", "", "()V", "sha256", "Ljava/security/MessageDigest;", "kotlin.jvm.PlatformType", "getSha256", "()Ljava/security/MessageDigest;", "sha256$delegate", "Lkotlin/Lazy;", "anonymize", "", "salt", "", "data", "cloneDigest", "digest", "ap-validation"})
public final class AnonymizerUtil {
    @NotNull
    public static final AnonymizerUtil INSTANCE = new AnonymizerUtil();
    @NotNull
    private static final Lazy sha256$delegate = LazyKt.lazy((Function0)sha256.2.INSTANCE);

    private AnonymizerUtil() {
    }

    private final MessageDigest getSha256() {
        Lazy lazy = sha256$delegate;
        return (MessageDigest)lazy.getValue();
    }

    @NotNull
    public final String anonymize(@NotNull String salt, @NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String string2 = salt;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return this.anonymize(byArray, data);
    }

    @NotNull
    public final String anonymize(@NotNull byte[] salt, @NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (StringsKt.isBlank((CharSequence)data)) {
            return data;
        }
        MessageDigest messageDigest = this.getSha256();
        Intrinsics.checkNotNullExpressionValue((Object)messageDigest, (String)"sha256");
        MessageDigest md = this.cloneDigest(messageDigest);
        md.update(salt);
        String string2 = data;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        md.update(byArray);
        String string3 = StringUtil.toHexString(md.digest());
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toHexString(md.digest())");
        return string3;
    }

    private final MessageDigest cloneDigest(MessageDigest digest) {
        MessageDigest messageDigest;
        try {
            Object object = digest.clone();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.security.MessageDigest");
            messageDigest = (MessageDigest)object;
        }
        catch (CloneNotSupportedException e2) {
            throw new IllegalArgumentException("Message digest is not cloneable: " + this);
        }
        return messageDigest;
    }
}

