﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/swf/SWF_EXPORTS.h>
#include <aws/swf/model/RequestCancelExternalWorkflowExecutionFailedCause.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace SWF {
namespace Model {

/**
 * <p>Provides the details of the
 * <code>RequestCancelExternalWorkflowExecutionFailed</code> event.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/swf-2012-01-25/RequestCancelExternalWorkflowExecutionFailedEventAttributes">AWS
 * API Reference</a></p>
 */
class RequestCancelExternalWorkflowExecutionFailedEventAttributes {
 public:
  AWS_SWF_API RequestCancelExternalWorkflowExecutionFailedEventAttributes() = default;
  AWS_SWF_API RequestCancelExternalWorkflowExecutionFailedEventAttributes(Aws::Utils::Json::JsonView jsonValue);
  AWS_SWF_API RequestCancelExternalWorkflowExecutionFailedEventAttributes& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_SWF_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The <code>workflowId</code> of the external workflow to which the cancel
   * request was to be delivered.</p>
   */
  inline const Aws::String& GetWorkflowId() const { return m_workflowId; }
  inline bool WorkflowIdHasBeenSet() const { return m_workflowIdHasBeenSet; }
  template <typename WorkflowIdT = Aws::String>
  void SetWorkflowId(WorkflowIdT&& value) {
    m_workflowIdHasBeenSet = true;
    m_workflowId = std::forward<WorkflowIdT>(value);
  }
  template <typename WorkflowIdT = Aws::String>
  RequestCancelExternalWorkflowExecutionFailedEventAttributes& WithWorkflowId(WorkflowIdT&& value) {
    SetWorkflowId(std::forward<WorkflowIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The <code>runId</code> of the external workflow execution.</p>
   */
  inline const Aws::String& GetRunId() const { return m_runId; }
  inline bool RunIdHasBeenSet() const { return m_runIdHasBeenSet; }
  template <typename RunIdT = Aws::String>
  void SetRunId(RunIdT&& value) {
    m_runIdHasBeenSet = true;
    m_runId = std::forward<RunIdT>(value);
  }
  template <typename RunIdT = Aws::String>
  RequestCancelExternalWorkflowExecutionFailedEventAttributes& WithRunId(RunIdT&& value) {
    SetRunId(std::forward<RunIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The cause of the failure. This information is generated by the system and can
   * be useful for diagnostic purposes.</p>  <p>If <code>cause</code> is set to
   * <code>OPERATION_NOT_PERMITTED</code>, the decision failed because it lacked
   * sufficient permissions. For details and example IAM policies, see <a
   * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using
   * IAM to Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer
   * Guide</i>.</p>
   */
  inline RequestCancelExternalWorkflowExecutionFailedCause GetCause() const { return m_cause; }
  inline bool CauseHasBeenSet() const { return m_causeHasBeenSet; }
  inline void SetCause(RequestCancelExternalWorkflowExecutionFailedCause value) {
    m_causeHasBeenSet = true;
    m_cause = value;
  }
  inline RequestCancelExternalWorkflowExecutionFailedEventAttributes& WithCause(RequestCancelExternalWorkflowExecutionFailedCause value) {
    SetCause(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the <code>RequestCancelExternalWorkflowExecutionInitiated</code>
   * event corresponding to the <code>RequestCancelExternalWorkflowExecution</code>
   * decision to cancel this external workflow execution. This information can be
   * useful for diagnosing problems by tracing back the chain of events leading up to
   * this event.</p>
   */
  inline long long GetInitiatedEventId() const { return m_initiatedEventId; }
  inline bool InitiatedEventIdHasBeenSet() const { return m_initiatedEventIdHasBeenSet; }
  inline void SetInitiatedEventId(long long value) {
    m_initiatedEventIdHasBeenSet = true;
    m_initiatedEventId = value;
  }
  inline RequestCancelExternalWorkflowExecutionFailedEventAttributes& WithInitiatedEventId(long long value) {
    SetInitiatedEventId(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the
   * decision task that resulted in the
   * <code>RequestCancelExternalWorkflowExecution</code> decision for this
   * cancellation request. This information can be useful for diagnosing problems by
   * tracing back the chain of events leading up to this event.</p>
   */
  inline long long GetDecisionTaskCompletedEventId() const { return m_decisionTaskCompletedEventId; }
  inline bool DecisionTaskCompletedEventIdHasBeenSet() const { return m_decisionTaskCompletedEventIdHasBeenSet; }
  inline void SetDecisionTaskCompletedEventId(long long value) {
    m_decisionTaskCompletedEventIdHasBeenSet = true;
    m_decisionTaskCompletedEventId = value;
  }
  inline RequestCancelExternalWorkflowExecutionFailedEventAttributes& WithDecisionTaskCompletedEventId(long long value) {
    SetDecisionTaskCompletedEventId(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The data attached to the event that the decider can use in subsequent
   * workflow tasks. This data isn't sent to the workflow execution.</p>
   */
  inline const Aws::String& GetControl() const { return m_control; }
  inline bool ControlHasBeenSet() const { return m_controlHasBeenSet; }
  template <typename ControlT = Aws::String>
  void SetControl(ControlT&& value) {
    m_controlHasBeenSet = true;
    m_control = std::forward<ControlT>(value);
  }
  template <typename ControlT = Aws::String>
  RequestCancelExternalWorkflowExecutionFailedEventAttributes& WithControl(ControlT&& value) {
    SetControl(std::forward<ControlT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_workflowId;

  Aws::String m_runId;

  RequestCancelExternalWorkflowExecutionFailedCause m_cause{RequestCancelExternalWorkflowExecutionFailedCause::NOT_SET};

  long long m_initiatedEventId{0};

  long long m_decisionTaskCompletedEventId{0};

  Aws::String m_control;
  bool m_workflowIdHasBeenSet = false;
  bool m_runIdHasBeenSet = false;
  bool m_causeHasBeenSet = false;
  bool m_initiatedEventIdHasBeenSet = false;
  bool m_decisionTaskCompletedEventIdHasBeenSet = false;
  bool m_controlHasBeenSet = false;
};

}  // namespace Model
}  // namespace SWF
}  // namespace Aws
