/*! @azure/msal-browser v4.27.0 2025-12-04 */
'use strict';
import { SignInContinuationState } from '../../../sign_in/auth_flow/state/SignInContinuationState.mjs';
import { SIGN_UP_COMPLETED_STATE_TYPE } from '../../../core/auth_flow/AuthFlowStateTypes.mjs';

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
/**
 * Represents the state of a sign-up operation that has been completed successfully.
 */
class SignUpCompletedState extends SignInContinuationState {
    constructor() {
        super(...arguments);
        /**
         * The type of the state.
         */
        this.stateType = SIGN_UP_COMPLETED_STATE_TYPE;
    }
}

export { SignUpCompletedState };
//# sourceMappingURL=SignUpCompletedState.mjs.map
