/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.ResultSet;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataFile;
import org.jkiss.dbeaver.ext.oracle.model.OracleObject;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleTablePartition;
import org.jkiss.dbeaver.ext.oracle.model.OracleTablespace;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class OracleSegment<PARENT extends DBSObject>
extends OracleObject<PARENT> {
    private String segmentType;
    private String partitionName;
    private long bytes;
    private long blocks;
    private OracleSchema schema;
    private OracleDataFile file;

    protected OracleSegment(DBRProgressMonitor monitor, PARENT parent, ResultSet dbResult) throws DBException {
        super(parent, JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"SEGMENT_NAME"), true);
        String ownerName;
        this.segmentType = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"SEGMENT_TYPE");
        this.partitionName = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"PARTITION_NAME");
        this.bytes = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"BYTES");
        this.blocks = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"BLOCKS");
        long fileNo = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"RELATIVE_FNO");
        Object tablespace = this.getTablespace(monitor);
        if (tablespace instanceof OracleTablespace) {
            this.file = ((OracleTablespace)tablespace).getFile(monitor, fileNo);
        }
        if (this.getDataSource().isAdmin() && !CommonUtils.isEmpty((String)(ownerName = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"OWNER")))) {
            this.schema = this.getDataSource().getSchema(monitor, ownerName);
        }
    }

    public Object getTablespace(DBRProgressMonitor monitor) throws DBException {
        if (this.parent instanceof OracleTablespace) {
            return this.parent;
        }
        if (this.parent instanceof OracleTablePartition) {
            return ((OracleTablePartition)this.parent).getTablespace(monitor);
        }
        return null;
    }

    @Property(viewable=true, editable=true, order=2)
    public OracleSchema getSchema() {
        return this.schema;
    }

    @Property(viewable=true, editable=true, order=3)
    public String getSegmentType() {
        return this.segmentType;
    }

    @Property(viewable=true, editable=true, order=4)
    public String getPartitionName() {
        return this.partitionName;
    }

    @Property(viewable=true, editable=true, order=5)
    public long getBytes() {
        return this.bytes;
    }

    @Property(viewable=true, editable=true, order=6)
    public long getBlocks() {
        return this.blocks;
    }

    @Property(order=7)
    public OracleDataFile getFile() {
        return this.file;
    }
}

