/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.resources.components;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.core.resources.components.PropertyBean;
import org.freeplane.core.ui.components.UITools;

public class TextBoxProperty
extends PropertyBean
implements IPropertyControl {
    final JTextArea mTextArea;

    public TextBoxProperty(String name, int lines) {
        super(name);
        this.mTextArea = new JTextArea(lines, 70);
        this.mTextArea.setLineWrap(true);
    }

    @Override
    public String getValue() {
        return this.mTextArea.getText();
    }

    @Override
    public JComponent getValueComponent() {
        return this.mTextArea;
    }

    @Override
    public void appendToForm(DefaultFormBuilder builder) {
        JScrollPane scrollPane = new JScrollPane(this.mTextArea);
        UITools.setScrollbarIncrement(scrollPane);
        scrollPane.setVerticalScrollBarPolicy(22);
        scrollPane.setHorizontalScrollBarPolicy(32);
        this.appendToForm(builder, scrollPane);
    }

    @Override
    public void setEnabled(boolean pEnabled) {
        this.mTextArea.setEnabled(pEnabled);
        super.setEnabled(pEnabled);
    }

    @Override
    public void setValue(String value) {
        this.mTextArea.setText(value);
        this.mTextArea.selectAll();
    }
}

