/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking.theme;

import java.awt.Color;
import java.awt.Insets;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import net.infonode.docking.properties.RootWindowProperties;
import net.infonode.docking.properties.WindowBarProperties;
import net.infonode.docking.theme.DockingWindowsTheme;
import net.infonode.gui.colorprovider.ColorMultiplier;
import net.infonode.gui.colorprovider.UIManagerColorProvider;
import net.infonode.gui.componentpainter.GradientComponentPainter;
import net.infonode.properties.gui.util.ComponentProperties;
import net.infonode.tabbedpanel.border.OpenContentBorder;
import net.infonode.tabbedpanel.border.TabAreaLineBorder;
import net.infonode.tabbedpanel.theme.GradientTheme;
import net.infonode.tabbedpanel.titledtab.TitledTabProperties;

public class GradientDockingTheme
extends DockingWindowsTheme {
    private boolean opaqueTabArea;
    private boolean shadowEnabled;
    private boolean highlightedBold;
    private boolean focusHighlighterEnabled;
    private Color borderColor;
    private Color tabAreaBackgroundColor;
    private RootWindowProperties rootProperties;

    public GradientDockingTheme() {
        this(true, true, false, true);
    }

    public GradientDockingTheme(boolean opaqueTabArea, boolean shadowEnabled, boolean highlightedBold, boolean focusHighlighterEnabled) {
        this(opaqueTabArea, shadowEnabled, highlightedBold, focusHighlighterEnabled, Color.BLACK);
    }

    public GradientDockingTheme(boolean opaqueTabArea, boolean shadowEnabled, boolean highlightedBold, boolean focusHighlighterEnabled, Color borderColor) {
        this(opaqueTabArea, shadowEnabled, highlightedBold, focusHighlighterEnabled, borderColor, GradientTheme.DEFAULT_TAB_AREA_BACKGROUND_COLOR);
    }

    public GradientDockingTheme(boolean opaqueTabArea, boolean shadowEnabled, boolean highlightedBold, boolean focusHighlighterEnabled, Color borderColor, Color tabAreaBackgroundColor) {
        this.opaqueTabArea = opaqueTabArea;
        this.shadowEnabled = shadowEnabled;
        this.highlightedBold = highlightedBold;
        this.focusHighlighterEnabled = focusHighlighterEnabled;
        this.borderColor = borderColor;
        this.tabAreaBackgroundColor = tabAreaBackgroundColor;
        GradientTheme theme = new GradientTheme(opaqueTabArea, shadowEnabled, borderColor);
        this.rootProperties = new RootWindowProperties();
        this.createRootWindowProperties(theme);
        this.createWindowBarProperties(theme);
    }

    private void createRootWindowProperties(GradientTheme theme) {
        this.rootProperties.getTabWindowProperties().getTabbedPanelProperties().addSuperObject(theme.getTabbedPanelProperties());
        this.rootProperties.getTabWindowProperties().getTabProperties().getTitledTabProperties().addSuperObject(theme.getTitledTabProperties());
        this.rootProperties.getTabWindowProperties().getCloseButtonProperties().setVisible(false);
        if (!this.shadowEnabled) {
            this.rootProperties.getWindowAreaProperties().setInsets(new Insets(6, 6, 6, 6));
        }
        this.rootProperties.getWindowAreaShapedPanelProperties().setComponentPainter(new GradientComponentPainter(UIManagerColorProvider.DESKTOP_BACKGROUND, new ColorMultiplier(UIManagerColorProvider.DESKTOP_BACKGROUND, 0.9f), new ColorMultiplier(UIManagerColorProvider.DESKTOP_BACKGROUND, 0.9f), new ColorMultiplier(UIManagerColorProvider.DESKTOP_BACKGROUND, 0.8f)));
        this.rootProperties.getWindowAreaProperties().setBorder(new LineBorder(Color.BLACK));
        if (this.tabAreaBackgroundColor != null) {
            this.rootProperties.getComponentProperties().setBackgroundColor(this.tabAreaBackgroundColor);
        }
        if (!this.shadowEnabled) {
            this.rootProperties.getSplitWindowProperties().setDividerSize(6);
        }
        TitledTabProperties tabProperties = this.rootProperties.getTabWindowProperties().getTabProperties().getTitledTabProperties();
        tabProperties.getNormalProperties().setIconVisible(false);
        tabProperties.getHighlightedProperties().setIconVisible(true);
        if (!this.highlightedBold) {
            tabProperties.getHighlightedProperties().getComponentProperties().getMap().createRelativeRef(ComponentProperties.FONT, tabProperties.getNormalProperties().getComponentProperties().getMap(), ComponentProperties.FONT);
        }
        if (this.focusHighlighterEnabled) {
            tabProperties.getHighlightedProperties().getComponentProperties().setBorder(new CompoundBorder(this.opaqueTabArea ? new TabAreaLineBorder(false, false, true, true) : new TabAreaLineBorder(this.borderColor), theme.getTabAreaComponentsGradientBorder()));
            this.rootProperties.getTabWindowProperties().getTabProperties().getFocusedProperties().getComponentProperties().setBorder(new CompoundBorder(this.opaqueTabArea ? new TabAreaLineBorder(false, false, true, true) : new TabAreaLineBorder(this.borderColor), theme.getHighlightedTabGradientBorder()));
        }
        this.rootProperties.getTabWindowProperties().getTabbedPanelProperties().getTabAreaComponentsProperties().getComponentProperties().setInsets(this.opaqueTabArea ? new Insets(0, 3, 0, 3) : new Insets(1, 3, 1, 3));
        this.rootProperties.getTabWindowProperties().getTabProperties().getHighlightedButtonProperties().getCloseButtonProperties().setVisible(false);
        this.rootProperties.getTabWindowProperties().getTabProperties().getHighlightedButtonProperties().getMinimizeButtonProperties().setVisible(true);
        this.rootProperties.getTabWindowProperties().getTabProperties().getHighlightedButtonProperties().getRestoreButtonProperties().setVisible(true);
    }

    private void createWindowBarProperties(GradientTheme theme) {
        WindowBarProperties barProperties = this.rootProperties.getWindowBarProperties();
        barProperties.getTabWindowProperties().getTabbedPanelProperties().getContentPanelProperties().getComponentProperties().setBorder(new OpenContentBorder(Color.BLACK, 1));
        barProperties.getTabWindowProperties().getTabProperties().getNormalButtonProperties().getCloseButtonProperties().setVisible(false);
        barProperties.getTabWindowProperties().getTabProperties().getTitledTabProperties().getNormalProperties().setIconVisible(true).getComponentProperties().setBorder(new CompoundBorder(new TabAreaLineBorder(), theme.getTabAreaComponentsGradientBorder()));
        barProperties.getTabWindowProperties().getTabProperties().getFocusedProperties().getComponentProperties().setBorder(new CompoundBorder(new TabAreaLineBorder(Color.BLACK), theme.getHighlightedTabGradientBorder()));
        barProperties.getTabWindowProperties().getTabProperties().getTitledTabProperties().getHighlightedProperties().getComponentProperties().setBorder(new CompoundBorder(new TabAreaLineBorder(Color.BLACK), theme.getHighlightedTabGradientBorder()));
        barProperties.getTabWindowProperties().getTabbedPanelProperties().setTabSpacing(-1);
        barProperties.getTabWindowProperties().getTabbedPanelProperties().getTabAreaProperties().getComponentProperties().setBorder(null).setBackgroundColor(null);
    }

    @Override
    public String getName() {
        String str = String.valueOf(this.opaqueTabArea ? "" : "Transparent Tab Area, ") + (this.shadowEnabled ? "" : "No Shadow, ") + (this.focusHighlighterEnabled ? "" : "No Focus Highlight, ") + (this.highlightedBold ? "Highlighted Bold, " : "");
        return "Gradient Theme" + (str.length() > 0 ? " - " + str.substring(0, str.length() - 2) : "");
    }

    @Override
    public RootWindowProperties getRootWindowProperties() {
        return this.rootProperties;
    }
}

