/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.DOMNotSupportedException;
import io.sf.carte.doc.DOMPolicyException;
import io.sf.carte.doc.DOMSyntaxException;
import io.sf.carte.doc.agent.DeviceFactory;
import io.sf.carte.doc.style.css.CSSCanvas;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.CSSMediaException;
import io.sf.carte.doc.style.css.CSSNode;
import io.sf.carte.doc.style.css.CSSPropertyDefinition;
import io.sf.carte.doc.style.css.CSSStyleDeclaration;
import io.sf.carte.doc.style.css.DocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.ErrorHandler;
import io.sf.carte.doc.style.css.LinkStyle;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.SelectorMatcher;
import io.sf.carte.doc.style.css.SheetErrorHandler;
import io.sf.carte.doc.style.css.StyleDatabase;
import io.sf.carte.doc.style.css.nsac.CSSBudgetException;
import io.sf.carte.doc.style.css.nsac.Condition;
import io.sf.carte.doc.style.css.nsac.SelectorList;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.om.BaseDocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.om.ComputedCSSStyle;
import io.sf.carte.doc.style.css.om.DOMCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.om.DOMNode;
import io.sf.carte.doc.style.css.om.DOMUtil;
import io.sf.carte.doc.style.css.om.DefaultErrorHandler;
import io.sf.carte.doc.style.css.om.InlineStyle;
import io.sf.carte.doc.style.css.om.MediaQueryListImpl;
import io.sf.carte.doc.style.css.om.StyleSheetList;
import io.sf.carte.doc.style.css.om.WrapperSelectorMatcher;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import java.io.IOException;
import java.io.StringReader;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DOMStringList;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.TypeInfo;

public abstract class StylableDocumentWrapper
extends DOMNode
implements CSSDocument {
    private final Document document;
    private final Map<Node, CSSNode> nodemap = new HashMap<Node, CSSNode>();
    private BaseDocumentCSSStyleSheet mergedStyleSheet = null;
    Set<LinkStyleDefiner> linkedStyle = new LinkedHashSet<LinkStyleDefiner>(4);
    Set<LinkStyleDefiner> embeddedStyle = new LinkedHashSet<LinkStyleDefiner>(3);
    private Set<CSSPropertyDefinition> registeredPropertySet = null;
    private final StyleSheetList sheets = new MyOMStyleSheetList(7);
    private final ErrorHandler errorHandler = this.createErrorHandler();
    private String metaDefaultStyleSet = "";
    private String metaReferrerPolicy = "";
    private String lastStyleSheetSet = null;
    private String targetMedium = null;
    private final Map<String, CSSCanvas> canvases = new HashMap<String, CSSCanvas>(3);

    protected StylableDocumentWrapper(Document document) {
        super(document);
        this.document = document;
        this.updateStyleLists();
    }

    protected abstract DOMCSSStyleSheetFactory getStyleSheetFactory();

    @Override
    public String getCompatMode() {
        DocumentType doctype = this.document.getDoctype();
        if (doctype != null) {
            return "CSS1Compat";
        }
        return "BackCompat";
    }

    @Override
    public CSSDocument.ComplianceMode getComplianceMode() {
        DocumentType doctype = this.document.getDoctype();
        if (doctype != null) {
            return CSSDocument.ComplianceMode.STRICT;
        }
        return CSSDocument.ComplianceMode.QUIRKS;
    }

    @Override
    public CSSDocument getOwnerDocument() {
        return null;
    }

    private boolean isWrappedNode(Node node) {
        if (node.getNodeType() == 11) {
            throw new DOMException(7, "This is a readonly wrapper.");
        }
        Document doc = node.getOwnerDocument();
        if (doc == this) {
            return true;
        }
        if (doc == this.document) {
            return false;
        }
        throw new DOMException(4, "The node was created with a different document.");
    }

    @Override
    protected CSSNode getMappedCSSNode(Node node) {
        return this.nodemap.get(node);
    }

    @Override
    protected CSSNode getCSSNode(Node node) {
        CSSNode mynode = this.getMappedCSSNode(node);
        if (mynode == null) {
            switch (node.getNodeType()) {
                case 2: {
                    String name = node.getNodeName();
                    if ("style".equalsIgnoreCase(name) && node.getPrefix() == null) {
                        mynode = new StyleAttr((Attr)node);
                        break;
                    }
                    Element owner = ((Attr)node).getOwnerElement();
                    if (owner != null && node.getPrefix() == null) {
                        String tagname = owner.getTagName();
                        if (("link".equalsIgnoreCase(tagname) || "style".equalsIgnoreCase(tagname)) && ("href".equalsIgnoreCase(name) || "media".equalsIgnoreCase(name) || "title".equalsIgnoreCase(name) || "rel".equalsIgnoreCase(name) || "type".equalsIgnoreCase(name))) {
                            mynode = new StyleEventAttr((Attr)node);
                            break;
                        }
                        if ("meta".equalsIgnoreCase(tagname) && ("http-equiv".equalsIgnoreCase(name) || "content".equalsIgnoreCase(name))) {
                            mynode = new EventAttr((Attr)node);
                            break;
                        }
                        mynode = new MyAttr((Attr)node);
                        break;
                    }
                    mynode = new MyAttr((Attr)node);
                    break;
                }
                case 1: {
                    Element el = (Element)node;
                    String name = el.getNodeName();
                    if (name != null) {
                        if ("link".equals(name = name.toLowerCase(Locale.ROOT))) {
                            mynode = new LinkElement((Element)node);
                            this.onStyleModify();
                            break;
                        }
                        if ("style".equals(name)) {
                            mynode = new StyleElement((Element)node);
                            this.onStyleModify();
                            break;
                        }
                    }
                    mynode = new MyElement((Element)node);
                    break;
                }
                case 3: {
                    mynode = new MyText((Text)node);
                    break;
                }
                case 4: {
                    mynode = new MyCDATASection((CDATASection)node);
                    break;
                }
                case 8: {
                    mynode = new MyComment((Comment)node);
                    break;
                }
                case 10: {
                    mynode = new MyDocumentType((DocumentType)node);
                    break;
                }
                case 7: {
                    if ("xml-stylesheet".equals(node.getNodeName())) {
                        mynode = new MyStyleProcessingInstruction((ProcessingInstruction)node);
                        this.onStyleModify();
                        break;
                    }
                    mynode = new MyProcessingInstruction((ProcessingInstruction)node);
                    break;
                }
                case 5: {
                    mynode = new MyEntityReference((EntityReference)node);
                    break;
                }
                default: {
                    mynode = new MyNode(node);
                }
            }
            this.nodemap.put(node, mynode);
        }
        return mynode;
    }

    @Override
    public DocumentType getDoctype() {
        DocumentType docType = this.document.getDoctype();
        return docType != null ? (DocumentType)((Object)this.getCSSNode(docType)) : null;
    }

    @Override
    public DOMImplementation getImplementation() {
        return this.document.getImplementation();
    }

    @Override
    public boolean isVisitedURI(String href) {
        return false;
    }

    public abstract void setLoadingTime(long var1);

    @Override
    public CSSElement getDocumentElement() {
        Element elm = this.document.getDocumentElement();
        return elm != null ? (CSSElement)this.getCSSNode(elm) : null;
    }

    LinkStyleDefiner getEmbeddedStyleDefiner(CSSElement element) {
        LinkStyleDefiner definer = null;
        if (element != null && (definer = this.getEmbeddedStyleDefiner(element.getId())) == null && element instanceof LinkStyleDefiner) {
            definer = (LinkStyleDefiner)((Object)element);
        }
        return definer;
    }

    private static String escapeAttributeEntities(String text) {
        StringBuilder buf = null;
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (c == '<') {
                buf = StylableDocumentWrapper.appendEntityToBuffer(buf, "lt", text, i, len);
                continue;
            }
            if (c == '>') {
                buf = StylableDocumentWrapper.appendEntityToBuffer(buf, "gt", text, i, len);
                continue;
            }
            if (c == '&') {
                buf = StylableDocumentWrapper.appendEntityToBuffer(buf, "amp", text, i, len);
                continue;
            }
            if (c == '\"') {
                buf = StylableDocumentWrapper.appendEntityToBuffer(buf, "quot", text, i, len);
                continue;
            }
            if (c == '\u00a0') {
                buf = StylableDocumentWrapper.appendEntityToBuffer(buf, "nbsp", text, i, len);
                continue;
            }
            if (buf == null) continue;
            buf.append(c);
        }
        if (buf != null) {
            text = buf.toString();
        }
        return text;
    }

    private static StringBuilder appendEntityToBuffer(StringBuilder buf, String string, String text, int index, int inilen) {
        if (buf == null) {
            buf = new StringBuilder(inilen + string.length() + 2);
            buf.append(text.subSequence(0, index));
        }
        buf.append('&').append(string).append(';');
        return buf;
    }

    private static String getAttributeQuirksMode(Element element, String name) {
        String av;
        Attr attr = StylableDocumentWrapper.getAttributeNodeQuirksMode(element, name);
        if (attr != null && (av = attr.getValue()) != null) {
            return av;
        }
        return "";
    }

    private static Attr getAttributeNodeQuirksMode(Element element, String name) {
        NamedNodeMap nnm = element.getAttributes();
        if (nnm != null) {
            int len = nnm.getLength();
            for (int i = 0; i < len; ++i) {
                Node attr = nnm.item(i);
                if (!name.equalsIgnoreCase(attr.getNodeName())) continue;
                return (Attr)attr;
            }
        }
        return null;
    }

    private MediaQueryList parseMediaList(String media, Node ownerNode) throws CSSMediaException {
        MediaQueryList mediaList;
        if (media.length() == 0) {
            mediaList = new MediaQueryListImpl().unmodifiable();
        } else {
            try {
                mediaList = this.getStyleSheetFactory().createImmutableMediaQueryList(media, ownerNode);
            }
            catch (CSSBudgetException e) {
                throw new CSSMediaException(e);
            }
            if (mediaList.isNotAllMedia() && mediaList.hasErrors()) {
                return null;
            }
        }
        return mediaList;
    }

    private AbstractCSSStyleSheet parseEmbeddedStyleSheet(AbstractCSSStyleSheet sheet, String styleText, String title, String media, Node ownerNode) {
        MediaQueryList mediaList;
        try {
            mediaList = this.parseMediaList(media.trim(), ownerNode);
        }
        catch (CSSMediaException e) {
            this.getErrorHandler().mediaQueryError(ownerNode, e);
            mediaList = null;
        }
        if (mediaList != null) {
            if (sheet == null) {
                sheet = this.getStyleSheetFactory().createLinkedStyleSheet(ownerNode, title, mediaList);
            } else {
                sheet.getCssRules().clear();
                sheet.setTitle(title);
                sheet.setMedia(mediaList);
            }
            if (styleText.length() != 0) {
                sheet.setHref(this.getBaseURI());
                StringReader re = new StringReader(styleText);
                try {
                    sheet.parseStyleSheet(re);
                }
                catch (Exception e) {
                    this.getErrorHandler().linkedSheetError(e, sheet);
                }
            } else {
                sheet.getCssRules().clear();
            }
            return sheet;
        }
        return null;
    }

    private AbstractCSSStyleSheet loadStyleSheet(AbstractCSSStyleSheet sheet, String href, String title, String media, Node ownerNode) {
        MediaQueryList mediaList;
        try {
            mediaList = this.parseMediaList(media.trim(), ownerNode);
        }
        catch (CSSMediaException e) {
            this.getErrorHandler().mediaQueryError(ownerNode, e);
            mediaList = null;
        }
        if (mediaList != null) {
            String referrerPolicy = this.getReferrerpolicyAttribute(ownerNode);
            if (sheet == null) {
                sheet = this.getStyleSheetFactory().createLinkedStyleSheet(ownerNode, title, mediaList);
            } else {
                sheet.setTitle(title);
                sheet.setMedia(mediaList);
                sheet.getCssRules().clear();
            }
            try {
                URL url = this.getURL(href);
                if (this.isAuthorizedOrigin(url)) {
                    sheet.setHref(url.toExternalForm());
                    sheet.loadStyleSheet(url, referrerPolicy);
                } else {
                    this.getErrorHandler().policyError(ownerNode, "Unauthorized URL: " + url.toExternalForm());
                }
            }
            catch (IOException e) {
                this.getErrorHandler().ioError(href, e);
            }
            catch (DOMPolicyException e) {
                sheet = null;
            }
            catch (DOMException e) {
            }
            catch (Exception e) {
                this.getErrorHandler().linkedSheetError(e, sheet);
            }
            return sheet;
        }
        return null;
    }

    private String getReferrerpolicyAttribute(Node node) {
        Node rp;
        NamedNodeMap nnm = node.getAttributes();
        if (nnm != null && (rp = nnm.getNamedItem("referrerpolicy")) != null) {
            return rp.getNodeValue();
        }
        return "";
    }

    @Override
    public CSSElement createElement(String tagName) throws DOMException {
        return (CSSElement)this.getCSSNode(this.document.createElement(tagName));
    }

    @Override
    public DocumentFragment createDocumentFragment() {
        throw new DOMNotSupportedException("This is a readonly wrapper.");
    }

    @Override
    public Text createTextNode(String data) {
        return (Text)((Object)this.getCSSNode(this.document.createTextNode(data)));
    }

    @Override
    public Comment createComment(String data) {
        return (Comment)((Object)this.getCSSNode(this.document.createComment(data)));
    }

    @Override
    public CDATASection createCDATASection(String data) throws DOMException {
        return (CDATASection)((Object)this.getCSSNode(this.document.createCDATASection(data)));
    }

    @Override
    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        throw new DOMNotSupportedException("This is a readonly wrapper.");
    }

    @Override
    public Attr createAttribute(String name) throws DOMException {
        return (Attr)((Object)this.getCSSNode(this.document.createAttribute(name)));
    }

    @Override
    public EntityReference createEntityReference(String name) throws DOMException {
        return (EntityReference)((Object)this.getCSSNode(this.document.createEntityReference(name)));
    }

    @Override
    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        throw new DOMNotSupportedException("This is a readonly wrapper.");
    }

    @Override
    public CSSElement createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        return (CSSElement)this.getCSSNode(this.document.createElementNS(namespaceURI, qualifiedName));
    }

    @Override
    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        return (Attr)((Object)this.getCSSNode(this.document.createAttributeNS(namespaceURI, qualifiedName)));
    }

    @Override
    public NodeList getElementsByTagName(String tagname) {
        return new DOMNode.MyNodeList(this.document.getElementsByTagName(tagname));
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return new DOMNode.MyNodeList(this.document.getElementsByTagNameNS(namespaceURI, localName));
    }

    @Override
    public CSSElement getElementById(String elementId) {
        Element elm = this.document.getElementById(elementId);
        return elm != null ? (CSSElement)this.getCSSNode(elm) : null;
    }

    @Override
    public String getInputEncoding() {
        return this.document.getInputEncoding();
    }

    @Override
    public String getXmlEncoding() {
        return this.document.getXmlEncoding();
    }

    @Override
    public boolean getXmlStandalone() {
        return this.document.getXmlStandalone();
    }

    @Override
    public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
        throw new DOMNotSupportedException("This is a readonly wrapper.");
    }

    @Override
    public String getXmlVersion() {
        return this.document.getXmlVersion();
    }

    @Override
    public void setXmlVersion(String xmlVersion) throws DOMException {
        throw new DOMNotSupportedException("This is a readonly wrapper.");
    }

    @Override
    public boolean getStrictErrorChecking() {
        return this.document.getStrictErrorChecking();
    }

    @Override
    public void setStrictErrorChecking(boolean strictErrorChecking) {
        throw new DOMNotSupportedException("This is a readonly wrapper.");
    }

    @Override
    public String getDocumentURI() {
        return this.document.getDocumentURI();
    }

    @Override
    public void setDocumentURI(String documentURI) {
        this.document.setDocumentURI(documentURI);
        this.onStyleModify();
    }

    @Override
    public Node adoptNode(Node source) throws DOMException {
        throw new DOMException(7, "This is a readonly wrapper.");
    }

    @Override
    public Node cloneNode(boolean deep) {
        return this.getStyleSheetFactory().createCSSDocument((Document)this.document.cloneNode(deep));
    }

    @Override
    public DOMConfiguration getDomConfig() {
        return this.document.getDomConfig();
    }

    @Override
    public void normalizeDocument() {
        throw new DOMException(7, "This is a readonly wrapper.");
    }

    @Override
    public Node renameNode(Node n, String namespaceURI, String qualifiedName) throws DOMException {
        throw new DOMException(7, "This is a readonly wrapper.");
    }

    @Override
    public void registerProperty(CSSPropertyDefinition definition) {
        if (this.registeredPropertySet == null) {
            this.registeredPropertySet = new HashSet<CSSPropertyDefinition>();
        }
        this.registeredPropertySet.add(definition);
        this.mergedStyleSheet = null;
    }

    @Override
    public StyleSheetList getStyleSheets() {
        if (this.sheets.needsUpdate()) {
            this.sheets.update();
        }
        return this.sheets;
    }

    void updateStyleLists() {
        this.linkedStyle.clear();
        this.embeddedStyle.clear();
        this.updateStyleFromProcessingInstructions();
        if (this.linkedStyle.isEmpty() && this.embeddedStyle.isEmpty() || this.isHTML()) {
            this.updateStyleFromHTMLElements();
        }
        Iterator<LinkStyleDefiner> links = this.linkedStyle.iterator();
        while (links.hasNext()) {
            this.addLinkedSheet(links.next().getSheet());
        }
        Iterator<LinkStyleDefiner> embd = this.embeddedStyle.iterator();
        while (embd.hasNext()) {
            this.addLinkedSheet(embd.next().getSheet());
        }
        this.sheets.setNeedsUpdate(false);
        if (this.lastStyleSheetSet != null) {
            this.setSelectedStyleSheetSet(this.lastStyleSheetSet);
        } else {
            this.metaDefaultStyleSet = this.getMetaDefaultStyleSet();
            if (this.metaDefaultStyleSet.length() > 0) {
                this.setSelectedStyleSheetSet(this.metaDefaultStyleSet);
                this.lastStyleSheetSet = null;
            } else {
                this.setSelectedStyleSheetSet(this.sheets.getPreferredStyleSheetSet());
                this.lastStyleSheetSet = null;
            }
        }
        if (this.getCanvas() != null) {
            this.getCanvas().reloadStyleState();
        }
    }

    private void updateStyleFromProcessingInstructions() {
        NodeList child = this.document.getChildNodes();
        for (int i = 0; i < child.getLength(); ++i) {
            Node node = child.item(i);
            short type = node.getNodeType();
            if (type == 7 && "xml-stylesheet".equals(node.getNodeName())) {
                LinkStyleProcessingInstruction pi;
                String href;
                CSSNode mynode = this.getMappedCSSNode(node);
                if (mynode == null) {
                    mynode = new MyStyleProcessingInstruction((ProcessingInstruction)node);
                    this.nodemap.put(node, mynode);
                }
                if ((href = (pi = (LinkStyleProcessingInstruction)((Object)mynode)).getPseudoAttribute("href")).length() <= 1) continue;
                if (href.charAt(0) == '#') {
                    this.embeddedStyle.add(pi);
                    continue;
                }
                this.linkedStyle.add(pi);
                continue;
            }
            if (type == 1) break;
        }
    }

    private boolean isHTML() {
        Element docelm = this.document.getDocumentElement();
        return docelm != null && "html".equalsIgnoreCase(docelm.getTagName());
    }

    private void updateStyleFromHTMLElements() {
        CSSNode mynode;
        Node n;
        int i;
        NodeList nl = this.document.getElementsByTagName("link");
        int len = nl.getLength();
        for (i = 0; i < len; ++i) {
            LinkStyleDefiner link;
            String href;
            n = nl.item(i);
            if (!this.linkedStyle.isEmpty() && ((href = ((Element)n).getAttribute("href").trim()).length() == 0 || this.isAlreadyLoaded(this.linkedStyle, href))) continue;
            mynode = this.getMappedCSSNode(n);
            if (mynode == null) {
                mynode = new LinkElement((Element)n);
                this.nodemap.put(n, mynode);
            }
            if ((link = (LinkStyleDefiner)((Object)mynode)).getSheet() == null) continue;
            this.linkedStyle.add(link);
        }
        nl = this.document.getElementsByTagName("style");
        len = nl.getLength();
        for (i = 0; i < len; ++i) {
            String id;
            n = nl.item(i);
            if (!this.embeddedStyle.isEmpty() && (id = ((Element)n).getAttribute("id")).length() != 0 && this.isAlreadyLoaded(this.embeddedStyle, id)) continue;
            mynode = this.getMappedCSSNode(n);
            if (mynode == null) {
                mynode = new StyleElement((Element)n);
                this.nodemap.put(n, mynode);
            }
            this.embeddedStyle.add((LinkStyleDefiner)((Object)mynode));
        }
    }

    private boolean isAlreadyLoaded(Set<LinkStyleDefiner> definerSet, String href) {
        for (LinkStyleDefiner definer : definerSet) {
            if (!(definer instanceof LinkStyleProcessingInstruction) || !((LinkStyleProcessingInstruction)definer).isSameSheet(href)) continue;
            return true;
        }
        return false;
    }

    private void addLinkedSheet(AbstractCSSStyleSheet linkedSheet) {
        if (linkedSheet != null) {
            this.sheets.add(linkedSheet);
        }
    }

    private LinkStyleDefiner getEmbeddedStyleDefiner(String id) {
        NodeList child = this.getChildNodes();
        for (int i = 0; i < child.getLength(); ++i) {
            Node node = child.item(i);
            short type = node.getNodeType();
            if (type == 7 && "xml-stylesheet".equals(node.getNodeName())) {
                LinkStyleProcessingInstruction pi = (LinkStyleProcessingInstruction)node;
                String href = pi.getPseudoAttribute("href");
                if (href.length() <= 1 || href.charAt(0) != '#' || !id.equals(href.substring(1))) continue;
                return pi;
            }
            if (type == 1) break;
        }
        return null;
    }

    private String getMetaDefaultStyleSet() {
        NodeList headlist = this.document.getElementsByTagName("head");
        if (headlist.getLength() != 0) {
            Element head = (Element)headlist.item(0);
            NodeList metalist = head.getElementsByTagName("meta");
            for (int i = 0; i < metalist.getLength(); ++i) {
                Element meta = (Element)metalist.item(i);
                NamedNodeMap nnm = meta.getAttributes();
                String content = null;
                String httpEquiv = null;
                for (int j = 0; j < nnm.getLength(); ++j) {
                    Node attr = nnm.item(j);
                    if ("http-equiv".equalsIgnoreCase(attr.getNodeName())) {
                        if (httpEquiv != null) break;
                        httpEquiv = attr.getNodeValue();
                        continue;
                    }
                    if (!"content".equalsIgnoreCase(attr.getNodeName())) continue;
                    if (content != null) break;
                    content = attr.getNodeValue();
                }
                if (httpEquiv == null || content == null || !"default-style".equalsIgnoreCase(httpEquiv)) continue;
                return content;
            }
        }
        return "";
    }

    @Override
    public DocumentCSSStyleSheet getStyleSheet() {
        if (this.mergedStyleSheet == null) {
            this.mergeStyleSheets();
        }
        return this.mergedStyleSheet;
    }

    private void mergeStyleSheets() {
        this.getStyleSheets();
        BaseDocumentCSSStyleSheet defSheet = this.getStyleSheetFactory().getDefaultStyleSheet(this.getComplianceMode());
        this.mergedStyleSheet = this.targetMedium == null ? defSheet.clone() : defSheet.clone(this.targetMedium);
        this.mergedStyleSheet.setOwnerDocument(this);
        Iterator<AbstractCSSStyleSheet> it = this.sheets.iterator();
        while (it.hasNext()) {
            this.mergedStyleSheet.addStyleSheet(it.next());
        }
        if (this.registeredPropertySet != null) {
            for (CSSPropertyDefinition def : this.registeredPropertySet) {
                this.mergedStyleSheet.registerProperty(def);
            }
        }
    }

    @Override
    public DOMStringList getStyleSheetSets() {
        if (this.sheets.needsUpdate()) {
            this.sheets.update();
        }
        return this.sheets.getStyleSheetSets();
    }

    @Override
    public String getSelectedStyleSheetSet() {
        if (this.sheets.needsUpdate()) {
            this.sheets.update();
        }
        String selectedSetName = "";
        Iterator<LinkStyleDefiner> links = this.linkedStyle.iterator();
        while (links.hasNext()) {
            String title;
            AbstractCSSStyleSheet sheet = links.next().getSheet();
            if (sheet == null || (title = sheet.getTitle()) == null || title.length() <= 0 || sheet.getDisabled()) continue;
            if (selectedSetName.length() > 0) {
                if (selectedSetName.equalsIgnoreCase(title)) continue;
                return null;
            }
            selectedSetName = title;
        }
        Iterator<LinkStyleDefiner> style = this.linkedStyle.iterator();
        while (links.hasNext()) {
            String title;
            AbstractCSSStyleSheet sheet = style.next().getSheet();
            if (sheet == null || (title = sheet.getTitle()) == null || title.length() <= 0 || sheet.getDisabled()) continue;
            if (selectedSetName.length() > 0) {
                if (selectedSetName.equalsIgnoreCase(title)) continue;
                return null;
            }
            selectedSetName = title;
        }
        return selectedSetName;
    }

    @Override
    public void setSelectedStyleSheetSet(String name) {
        if (name == null || name.length() > 0 && !this.getStyleSheetSets().contains(name)) {
            return;
        }
        this.selectSheetSet(name, this.linkedStyle);
        this.selectSheetSet(name, this.embeddedStyle);
    }

    private void selectSheetSet(String name, Set<LinkStyleDefiner> styleDefinerSet) {
        Iterator<LinkStyleDefiner> links = styleDefinerSet.iterator();
        while (links.hasNext()) {
            String title;
            AbstractCSSStyleSheet sheet = links.next().getSheet();
            if (sheet == null || (title = sheet.getTitle()) == null || title.length() == 0) continue;
            if (title.equalsIgnoreCase(name)) {
                sheet.setDisabled(false);
                this.lastStyleSheetSet = name;
                continue;
            }
            sheet.setDisabled(true);
        }
    }

    @Override
    public String getLastStyleSheetSet() {
        return this.lastStyleSheetSet;
    }

    @Override
    public void enableStyleSheetsForSet(String name) {
        if (name == null || name.length() == 0) {
            return;
        }
        StylableDocumentWrapper.enableStyleSheetSet(name, this.linkedStyle);
        StylableDocumentWrapper.enableStyleSheetSet(name, this.embeddedStyle);
    }

    private static void enableStyleSheetSet(String name, Set<LinkStyleDefiner> styleDefinerSet) {
        Iterator<LinkStyleDefiner> links = styleDefinerSet.iterator();
        while (links.hasNext()) {
            String title;
            AbstractCSSStyleSheet sheet = links.next().getSheet();
            if (sheet == null || (title = sheet.getTitle()) == null || title.length() <= 0 || !title.equals(name)) continue;
            sheet.setDisabled(false);
        }
    }

    void onStyleModify() {
        if (this.mergedStyleSheet != null) {
            this.mergedStyleSheet = null;
            this.sheets.setNeedsUpdate(true);
        } else if (this.sheets != null) {
            this.sheets.setNeedsUpdate(true);
        }
    }

    @Override
    public StyleDatabase getStyleDatabase() {
        DeviceFactory df;
        StyleDatabase sdb = null;
        if (this.targetMedium != null && (df = this.getStyleSheetFactory().getDeviceFactory()) != null) {
            sdb = df.getStyleDatabase(this.targetMedium);
        }
        return sdb;
    }

    @Override
    public String getTargetMedium() {
        return this.targetMedium;
    }

    @Override
    public void setTargetMedium(String medium) throws CSSMediaException {
        if ("all".equals(medium)) {
            this.targetMedium = null;
        } else {
            if (medium != null) {
                medium = medium.intern();
            }
            this.targetMedium = medium;
        }
        this.onStyleModify();
    }

    @Override
    public CSSCanvas getCanvas() {
        CSSCanvas canvas;
        if (this.targetMedium == null) {
            return null;
        }
        if (this.canvases.containsKey(this.targetMedium)) {
            return this.canvases.get(this.targetMedium);
        }
        DeviceFactory df = this.getStyleSheetFactory().getDeviceFactory();
        if (df != null) {
            canvas = df.createCanvas(this.targetMedium, this);
            this.canvases.put(this.targetMedium, canvas);
        } else {
            canvas = null;
        }
        return canvas;
    }

    @Override
    public void rebuildCascade() {
        this.onStyleModify();
    }

    ErrorHandler createErrorHandler() {
        return new MyDefaultErrorHandler();
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public boolean hasStyleIssues() {
        return this.sheets.hasErrorsOrWarnings() || this.getErrorHandler().hasErrors() || this.getErrorHandler().hasWarnings();
    }

    @Override
    public URL getBaseURL() {
        URL url = null;
        String buri = this.getBaseURI();
        if (buri != null) {
            try {
                URI uri = new URI(buri);
                url = uri.toURL();
            }
            catch (Exception e) {
                try {
                    String docuri = this.document.getDocumentURI();
                    if (docuri != null) {
                        URI context = new URI(docuri);
                        URI bUri = new URI(buri);
                        url = context.resolve(bUri).toURL();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return url;
    }

    @Override
    public String getBaseURI() {
        String buri = null;
        Element elm = this.getDocumentElement();
        if (elm != null) {
            NodeList nl;
            String attr = elm.getAttribute("xml:base").trim();
            if (!attr.isEmpty()) {
                buri = attr;
            } else if ("html".equalsIgnoreCase(elm.getTagName()) && (nl = this.document.getElementsByTagName("base")).getLength() != 0) {
                elm = (Element)nl.item(0);
                String s = elm.getAttribute("href").trim();
                if (s.length() != 0) {
                    buri = s;
                } else {
                    s = StylableDocumentWrapper.getAttributeQuirksMode(elm, "href");
                    if (!s.isEmpty()) {
                        buri = s;
                    }
                }
            }
        }
        if (buri != null) {
            String docUri = this.document.getDocumentURI();
            if (docUri != null) {
                URI bUri;
                URI dUri;
                try {
                    dUri = new URI(docUri);
                }
                catch (URISyntaxException e) {
                    this.getErrorHandler().nodeError(elm, "Invalid document URI: " + docUri, e);
                    return this.getBaseForNullDocumentURI(buri, elm);
                }
                try {
                    bUri = new URI(buri);
                    bUri = dUri.resolve(bUri);
                }
                catch (Exception e) {
                    this.getErrorHandler().nodeError(elm, "Cannot convert URI to absolute: " + buri, e);
                    return dUri.toASCIIString();
                }
                buri = bUri.toASCIIString();
                String docscheme = dUri.getScheme();
                String bscheme = bUri.getScheme();
                if (!(docscheme.equals(bscheme) || bscheme.equals("https") || bscheme.equals("http") || docscheme.equals("file") || docscheme.equals("jar"))) {
                    this.getErrorHandler().policyError(elm, "Remote document wants to set a non-http base URL: " + buri);
                    buri = dUri.toASCIIString();
                }
                return buri;
            }
            if ((buri = this.getBaseForNullDocumentURI(buri, elm)) == null) {
                buri = this.document.getDocumentURI();
            }
        } else {
            buri = this.document.getDocumentURI();
        }
        return buri;
    }

    private String getBaseForNullDocumentURI(String baseUri, Element elm) {
        try {
            URI uri = new URI(baseUri);
            String bscheme = uri.getScheme();
            if (bscheme.equals("https") || bscheme.equals("http")) {
                return uri.toASCIIString();
            }
            this.getErrorHandler().policyError(elm, "Untrusted document wants to set a non-http base URL: " + baseUri);
        }
        catch (Exception e) {
            this.getErrorHandler().nodeError(elm, "Invalid base: " + baseUri, e);
        }
        return null;
    }

    @Override
    public boolean isSafeOrigin(URL linkedURL) {
        URL base = this.getBaseURL();
        String docHost = base.getHost();
        int docPort = base.getPort();
        if (docPort == -1) {
            docPort = base.getDefaultPort();
        }
        String linkedHost = linkedURL.getHost();
        int linkedPort = linkedURL.getPort();
        if (linkedPort == -1) {
            linkedPort = linkedURL.getDefaultPort();
        }
        return (docHost.equalsIgnoreCase(linkedHost) || ParseHelper.endsWithIgnoreCase(linkedHost, '.' + docHost)) && docPort == linkedPort;
    }

    @Override
    public boolean isAuthorizedOrigin(URL url) {
        String scheme = url.getProtocol();
        URL base = this.getBaseURL();
        if (base != null) {
            String baseScheme = base.getProtocol();
            if (!(scheme.equalsIgnoreCase("https") || scheme.equalsIgnoreCase("http") || baseScheme.equals("file") || baseScheme.equals("jar"))) {
                return false;
            }
        } else if (!scheme.equalsIgnoreCase("https") && !scheme.equalsIgnoreCase("http")) {
            return false;
        }
        return true;
    }

    @Override
    public String getReferrerPolicy() {
        NodeList nl = this.document.getElementsByTagName("meta");
        for (int i = nl.getLength() - 1; i >= 0; --i) {
            String policy;
            Element el = (Element)nl.item(i);
            if (!"referrer".equalsIgnoreCase(el.getAttribute("name")) || (policy = el.getAttribute("content")).length() == 0) continue;
            this.metaReferrerPolicy = policy;
            break;
        }
        return this.metaReferrerPolicy;
    }

    protected void setReferrerPolicyHeader(String policy) {
        if (this.metaReferrerPolicy.isEmpty()) {
            this.metaReferrerPolicy = policy;
        }
    }

    private void reset() {
        this.linkedStyle.clear();
        this.embeddedStyle.clear();
        this.errorHandler.reset();
        this.mergedStyleSheet = null;
    }

    class MyOMStyleSheetList
    extends StyleSheetList {
        private static final long serialVersionUID = 1L;

        protected MyOMStyleSheetList(int initialCapacity) {
            super(initialCapacity);
        }

        @Override
        protected boolean hasErrorsOrWarnings() {
            boolean hasRuleErrors = false;
            Iterator<AbstractCSSStyleSheet> it = this.iterator();
            while (it.hasNext()) {
                AbstractCSSStyleSheet sheet = it.next();
                SheetErrorHandler eh = sheet.getErrorHandler();
                if (!sheet.hasRuleErrorsOrWarnings() && !eh.hasSacErrors() && !eh.hasSacWarnings() && !eh.hasOMErrors() && !eh.hasOMWarnings()) continue;
                hasRuleErrors = true;
                break;
            }
            return hasRuleErrors;
        }

        @Override
        protected void update() {
            super.update();
            StylableDocumentWrapper.this.updateStyleLists();
        }
    }

    class StyleAttr
    extends MyAttr {
        private final AbstractCSSStyleDeclaration inlineStyle;

        StyleAttr(Attr attr) {
            super(attr);
            this.inlineStyle = StylableDocumentWrapper.this.getStyleSheetFactory().createInlineStyle(this);
            this.setInlineStyle(attr.getValue());
        }

        @Override
        public String getNodeValue() throws DOMException {
            return this.getValue();
        }

        @Override
        public String getValue() {
            return this.inlineStyle.getCssText();
        }

        @Override
        public void setValue(String value) throws DOMException {
            super.setValue(value);
            this.setInlineStyle(value);
        }

        public AbstractCSSStyleDeclaration getStyle() {
            return this.inlineStyle;
        }

        void setInlineStyle(String value) {
            if (value == null) {
                value = "";
            }
            try {
                this.inlineStyle.setCssText(value);
            }
            catch (DOMException e) {
                StylableDocumentWrapper.this.getErrorHandler().inlineStyleError(this.getOwnerElement(), e, value);
            }
        }
    }

    class StyleEventAttr
    extends MyAttr {
        StyleEventAttr(Attr attr) {
            super(attr);
        }

        @Override
        public void setValue(String value) throws DOMException {
            super.setValue(value);
            this.onDOMChange(this.getOwnerElement());
        }

        void onDOMChange(Node ownerNode) {
            if (ownerNode instanceof LinkStyleDefiner) {
                ((LinkStyleDefiner)ownerNode).resetLinkedSheet();
            }
        }
    }

    class EventAttr
    extends MyAttr {
        EventAttr(Attr attr) {
            super(attr);
        }

        @Override
        public void setValue(String value) throws DOMException {
            super.setValue(value);
            this.onDOMChange(this.getOwnerElement());
        }

        void onDOMChange(Node ownerNode) {
            StylableDocumentWrapper.this.onStyleModify();
        }
    }

    class MyAttr
    extends MyNode
    implements Attr {
        MyAttr(Attr attr) {
            super(attr);
        }

        @Override
        public CSSNode getParentNode() {
            return null;
        }

        @Override
        public CSSNode getPreviousSibling() {
            return null;
        }

        @Override
        public CSSNode getNextSibling() {
            return null;
        }

        @Override
        public String getName() {
            return ((Attr)this.rawnode).getName();
        }

        @Override
        public void setNodeValue(String nodeValue) throws DOMException {
            this.setValue(nodeValue);
        }

        @Override
        public boolean getSpecified() {
            return ((Attr)this.rawnode).getSpecified();
        }

        @Override
        public String getValue() {
            return ((Attr)this.rawnode).getValue();
        }

        @Override
        public void setValue(String value) throws DOMException {
            ((Attr)this.rawnode).setValue(value);
        }

        @Override
        public CSSElement getOwnerElement() {
            Element elm = ((Attr)this.rawnode).getOwnerElement();
            if (elm == null) {
                return null;
            }
            return (CSSElement)this.getCSSNode(elm);
        }

        @Override
        public TypeInfo getSchemaTypeInfo() {
            return ((Attr)this.rawnode).getSchemaTypeInfo();
        }

        @Override
        public boolean isId() {
            return ((Attr)this.rawnode).isId();
        }

        public String toString() {
            return this.getName() + "=\"" + StylableDocumentWrapper.escapeAttributeEntities(this.getValue()) + '\"';
        }
    }

    class LinkElement
    extends StyleDefinerElement {
        LinkElement(Element element) {
            super(element);
        }

        @Override
        public AbstractCSSStyleSheet getSheet() {
            if (this.needsUpdate) {
                String rel = this.getAttribute("rel");
                String type = this.getAttribute("type");
                int typelen = type.length();
                if (typelen == 0 ? rel.length() == 0 : !"text/css".equalsIgnoreCase(type)) {
                    return null;
                }
                byte relAttr = AbstractCSSStyleSheet.parseRelAttribute(rel);
                if (relAttr != -1) {
                    String href;
                    String title = this.getAttribute("title");
                    if (title.length() == 0) {
                        title = null;
                    }
                    if ((href = this.getAttribute("href")).length() != 0) {
                        if (relAttr == 0) {
                            if (this.loadDefinedSheet(href, title)) {
                                this.needsUpdate = false;
                            }
                        } else if (title != null) {
                            if (href.length() != 0) {
                                boolean disable;
                                boolean bl = disable = this.definedSheet == null || !title.equalsIgnoreCase(StylableDocumentWrapper.this.getSelectedStyleSheetSet());
                                if (this.loadDefinedSheet(href, title)) {
                                    if (disable) {
                                        this.definedSheet.setDisabled(true);
                                    }
                                    this.needsUpdate = false;
                                }
                            }
                        } else {
                            StylableDocumentWrapper.this.getErrorHandler().linkedStyleError(this, "Alternate sheet without title.");
                        }
                    } else {
                        StylableDocumentWrapper.this.getErrorHandler().linkedStyleError(this, "Missing or void href attribute.");
                    }
                } else {
                    this.definedSheet = null;
                }
            }
            return this.definedSheet;
        }

        private boolean loadDefinedSheet(String href, String title) {
            this.definedSheet = StylableDocumentWrapper.this.loadStyleSheet(this.definedSheet, href, title, this.getAttribute("media"), this);
            return this.definedSheet != null;
        }
    }

    class StyleElement
    extends StyleDefinerElement {
        StyleElement(Element element) {
            super(element);
        }

        @Override
        public AbstractCSSStyleSheet getSheet() {
            if (this.needsUpdate) {
                String type = this.getAttribute("type");
                if (!"text/css".equalsIgnoreCase(type) && type.length() != 0) {
                    return null;
                }
                this.definedSheet = StylableDocumentWrapper.this.parseEmbeddedStyleSheet(this.definedSheet, this.getTextContent().trim(), this.getAttribute("title"), this.getAttribute("media"), this);
                if (this.definedSheet != null) {
                    this.needsUpdate = false;
                }
            }
            return this.definedSheet;
        }

        @Override
        public void resetLinkedSheet() {
            this.needsUpdate = true;
            StylableDocumentWrapper.this.onStyleModify();
        }

        @Override
        public void setTextContent(String textContent) throws DOMException {
            CSSNode first;
            if (this.getChildNodes().getLength() == 1 && ((first = this.getFirstChild()).getNodeType() == 4 || first.getNodeType() == 3)) {
                first.setNodeValue(textContent);
            } else {
                this.removeAllChild();
                this.rawnode.setTextContent(textContent);
            }
            this.needsUpdate = true;
        }

        @Override
        public void normalize() {
            if (this.definedSheet != null) {
                CDATASection cdata = StylableDocumentWrapper.this.document.createCDATASection(this.definedSheet.toString());
                this.removeAllChild();
                this.rawnode.appendChild(cdata);
                this.needsUpdate = true;
            }
        }
    }

    class MyElement
    extends MyNode
    implements CSSElement {
        private final Element element;
        WeakReference<SelectorMatcher> selectorMatcherRef;
        private Map<Condition, InlineStyle> overrideStyleSet;

        MyElement(Element element) {
            super(element);
            this.selectorMatcherRef = null;
            this.overrideStyleSet = null;
            this.element = element;
        }

        @Override
        public String getTagName() {
            return this.element.getTagName();
        }

        @Override
        public String getId() {
            return this.element.getAttribute("id");
        }

        @Override
        public String getAttribute(String name) {
            Attr anode = this.element.getAttributeNode(name);
            if (anode == null) {
                return "";
            }
            return this.getCSSNode(anode).getNodeValue();
        }

        @Override
        public void setAttribute(String name, String value) throws DOMException {
            this.element.setAttribute(name, value);
        }

        @Override
        public void removeAttribute(String name) throws DOMException {
            Attr attr = this.element.getAttributeNode(name);
            StylableDocumentWrapper.this.nodemap.remove(attr);
            this.element.removeAttribute(name);
        }

        @Override
        public Attr getAttributeNode(String name) {
            Attr anode = this.element.getAttributeNode(name);
            if (anode == null) {
                return null;
            }
            return (Attr)((Object)this.getCSSNode(anode));
        }

        @Override
        public Attr setAttributeNode(Attr newAttr) throws DOMException {
            DOMNode node = (DOMNode)((Object)newAttr);
            Attr rawnode = (Attr)node.rawnode;
            this.element.setAttributeNode(rawnode);
            StylableDocumentWrapper.this.nodemap.put(rawnode, node);
            return newAttr;
        }

        @Override
        public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
            Attr rawAttr = StylableDocumentWrapper.this.isWrappedNode(oldAttr) ? (Attr)((DOMNode)((Object)oldAttr)).rawnode : oldAttr;
            this.element.removeAttributeNode(rawAttr);
            StylableDocumentWrapper.this.nodemap.remove(rawAttr);
            return oldAttr;
        }

        @Override
        public NodeList getElementsByTagName(String name) {
            return new DOMNode.MyNodeList(this.element.getElementsByTagName(name));
        }

        @Override
        public String getAttributeNS(String namespaceURI, String localName) throws DOMException {
            Attr anode = this.element.getAttributeNodeNS(namespaceURI, localName);
            if (anode == null) {
                return "";
            }
            return this.getCSSNode(anode).getNodeValue();
        }

        @Override
        public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
            this.element.setAttributeNS(namespaceURI, qualifiedName, value);
        }

        @Override
        public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
            Attr attr = this.element.getAttributeNodeNS(namespaceURI, localName);
            if (attr == null) {
                return;
            }
            StylableDocumentWrapper.this.nodemap.remove(attr);
            this.element.removeAttributeNS(namespaceURI, localName);
        }

        @Override
        public Attr getAttributeNodeNS(String namespaceURI, String localName) throws DOMException {
            Attr anode = this.element.getAttributeNodeNS(namespaceURI, localName);
            if (anode == null) {
                return null;
            }
            return (Attr)((Object)this.getCSSNode(anode));
        }

        @Override
        public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
            Attr rawAttr = StylableDocumentWrapper.this.isWrappedNode(newAttr) ? (Attr)((DOMNode)((Object)newAttr)).rawnode : newAttr;
            this.element.setAttributeNodeNS(rawAttr);
            return newAttr;
        }

        public String getAttributeQuirksMode(String name) {
            return StylableDocumentWrapper.getAttributeQuirksMode(this.element, name);
        }

        public Attr getAttributeNodeQuirksMode(String name) {
            return StylableDocumentWrapper.getAttributeNodeQuirksMode(this.element, name);
        }

        @Override
        public NodeList getElementsByTagNameNS(String namespaceURI, String localName) throws DOMException {
            return new DOMNode.MyNodeList(this.element.getElementsByTagNameNS(namespaceURI, localName));
        }

        @Override
        public boolean hasAttribute(String name) {
            return this.element.hasAttribute(name);
        }

        @Override
        public boolean hasAttributeNS(String namespaceURI, String localName) throws DOMException {
            return this.element.hasAttributeNS(namespaceURI, localName);
        }

        @Override
        public TypeInfo getSchemaTypeInfo() {
            return this.element.getSchemaTypeInfo();
        }

        @Override
        public void setIdAttribute(String name, boolean isId) throws DOMException {
            this.element.setIdAttribute(name, isId);
        }

        @Override
        public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
            this.element.setIdAttributeNS(namespaceURI, localName, isId);
        }

        @Override
        public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
            Attr rawAttr = StylableDocumentWrapper.this.isWrappedNode(idAttr) ? (Attr)((DOMNode)((Object)idAttr)).rawnode : idAttr;
            this.element.setIdAttributeNode(rawAttr, isId);
        }

        @Override
        public Node insertBefore(Node newChild, Node refChild) throws DOMException {
            Node toAdd;
            if (StylableDocumentWrapper.this.isWrappedNode(newChild)) {
                DOMNode cssNode = (DOMNode)newChild;
                toAdd = cssNode.rawnode;
                StylableDocumentWrapper.this.nodemap.put(toAdd, cssNode);
            } else {
                toAdd = newChild;
            }
            Node other = StylableDocumentWrapper.this.isWrappedNode(refChild) ? ((DOMNode)refChild).rawnode : refChild;
            Node child = this.element.insertBefore(toAdd, other);
            StylableDocumentWrapper.this.reset();
            return this.getCSSNode(child);
        }

        @Override
        public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
            Node toAdd;
            if (StylableDocumentWrapper.this.isWrappedNode(newChild)) {
                DOMNode cssNode = (DOMNode)newChild;
                toAdd = cssNode.rawnode;
                StylableDocumentWrapper.this.nodemap.put(toAdd, cssNode);
            } else {
                toAdd = newChild;
            }
            Node other = StylableDocumentWrapper.this.isWrappedNode(oldChild) ? ((DOMNode)oldChild).rawnode : oldChild;
            Node child = this.element.replaceChild(toAdd, other);
            StylableDocumentWrapper.this.nodemap.remove(other);
            StylableDocumentWrapper.this.reset();
            return this.getCSSNode(child);
        }

        @Override
        public Node removeChild(Node oldChild) throws DOMException {
            Node toRemove = StylableDocumentWrapper.this.isWrappedNode(oldChild) ? ((DOMNode)oldChild).rawnode : oldChild;
            this.element.removeChild(toRemove);
            StylableDocumentWrapper.this.nodemap.remove(toRemove);
            StylableDocumentWrapper.this.reset();
            return oldChild;
        }

        @Override
        public Node appendChild(Node newChild) throws DOMException {
            if (StylableDocumentWrapper.this.isWrappedNode(newChild)) {
                DOMNode node = (DOMNode)newChild;
                this.element.appendChild(node.rawnode);
                StylableDocumentWrapper.this.nodemap.put(this.rawnode, node);
                StylableDocumentWrapper.this.reset();
                return newChild;
            }
            this.element.appendChild(newChild);
            StylableDocumentWrapper.this.reset();
            return this.getCSSNode(newChild);
        }

        @Override
        public void setTextContent(String textContent) throws DOMException {
            this.removeAllChild();
            this.element.setTextContent(textContent);
        }

        @Override
        public SelectorMatcher getSelectorMatcher() {
            SelectorMatcher matcher = null;
            if (this.selectorMatcherRef != null) {
                matcher = (SelectorMatcher)this.selectorMatcherRef.get();
            }
            if (matcher == null) {
                matcher = new WrapperSelectorMatcher(this, this.element);
                this.selectorMatcherRef = new WeakReference<SelectorMatcher>(matcher);
            }
            return matcher;
        }

        @Override
        public boolean matches(String selectorString, String pseudoElement) throws DOMException {
            Condition peCond;
            SelectorList list;
            CSSParser parser = new CSSParser();
            try {
                list = parser.parseSelectors(new StringReader(selectorString));
            }
            catch (Exception e) {
                throw new DOMSyntaxException("Unable to parse selector in: " + selectorString);
            }
            if (pseudoElement != null) {
                try {
                    peCond = parser.parsePseudoElement(pseudoElement);
                }
                catch (Exception e) {
                    throw new DOMSyntaxException("Unable to parse pseudo-element in: " + pseudoElement);
                }
            } else {
                peCond = null;
            }
            return this.matches(list, peCond);
        }

        @Override
        public boolean matches(SelectorList selist, Condition pseudoElement) {
            SelectorMatcher matcher = this.getSelectorMatcher();
            matcher.setPseudoElement(pseudoElement);
            return matcher.matches(selist) != -1;
        }

        @Override
        public CSSStyleDeclaration getStyle() {
            StyleAttr styleAttr = (StyleAttr)this.getAttributeNode("style");
            if (styleAttr == null) {
                if (StylableDocumentWrapper.this.getComplianceMode() == CSSDocument.ComplianceMode.QUIRKS) {
                    NamedNodeMap nmap = this.element.getAttributes();
                    int len = nmap.getLength();
                    for (int i = 0; i < len; ++i) {
                        Node node = nmap.item(i);
                        if (!"style".equalsIgnoreCase(node.getNodeName())) continue;
                        return ((StyleAttr)this.getCSSNode(node)).getStyle();
                    }
                }
                return null;
            }
            return styleAttr.getStyle();
        }

        @Override
        public boolean hasPresentationalHints() {
            return false;
        }

        @Override
        public void exportHintsToStyle(CSSStyleDeclaration style) {
        }

        @Override
        public boolean hasOverrideStyle(Condition pseudoElt) {
            if (this.overrideStyleSet == null) {
                return false;
            }
            return this.overrideStyleSet.containsKey(pseudoElt);
        }

        @Override
        public CSSStyleDeclaration getOverrideStyle(Condition pseudoElt) {
            InlineStyle overrideStyle = null;
            if (this.overrideStyleSet == null) {
                this.overrideStyleSet = new HashMap<Condition, InlineStyle>(1);
            } else {
                overrideStyle = this.overrideStyleSet.get(pseudoElt);
            }
            if (overrideStyle == null) {
                overrideStyle = StylableDocumentWrapper.this.getStyleSheetFactory().createInlineStyle(this);
                this.overrideStyleSet.put(pseudoElt, overrideStyle);
            }
            return overrideStyle;
        }

        @Override
        public ComputedCSSStyle getComputedStyle(String pseudoElt) {
            Condition peCond;
            if (pseudoElt != null) {
                CSSParser parser = new CSSParser();
                peCond = parser.parsePseudoElement(pseudoElt);
            } else {
                peCond = null;
            }
            return (ComputedCSSStyle)StylableDocumentWrapper.this.getStyleSheet().getComputedStyle(this, peCond);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append('<').append(this.getTagName());
            NamedNodeMap nodeMap = this.getAttributes();
            int len = nodeMap.getLength();
            if (len > 0) {
                for (int i = 0; i < len; ++i) {
                    Node node = nodeMap.item(i);
                    buf.append(' ').append(node.toString());
                }
            }
            if (this.hasChildNodes()) {
                buf.append('>');
                NodeList list = this.getChildNodes();
                for (int i = 0; i < list.getLength(); ++i) {
                    buf.append(list.item(i).toString());
                }
                buf.append("</").append(this.getTagName()).append('>').append('\n');
            } else {
                buf.append(" />");
            }
            return buf.toString();
        }
    }

    class MyText
    extends MyCharacterData
    implements Text {
        MyText(Text text) {
            super(text);
        }

        @Override
        public Text splitText(int offset) throws DOMException {
            throw new DOMException(7, "This is a readonly wrapper.");
        }

        @Override
        public boolean isElementContentWhitespace() {
            return ((Text)this.rawnode).isElementContentWhitespace();
        }

        @Override
        public String getWholeText() {
            return ((Text)this.rawnode).getWholeText();
        }

        @Override
        public Text replaceWholeText(String content) throws DOMException {
            throw new DOMException(7, "This is a readonly wrapper.");
        }

        public String toString() {
            return this.getData();
        }

        @Override
        void onDOMChange() {
            LinkStyleDefiner definer = StylableDocumentWrapper.this.getEmbeddedStyleDefiner((CSSElement)this.getParentNode());
            if (definer != null) {
                definer.resetLinkedSheet();
                definer.getSheet();
            }
        }
    }

    class MyCDATASection
    extends MyText
    implements CDATASection {
        MyCDATASection(CDATASection cdata) {
            super(cdata);
        }

        @Override
        void onDOMChange() {
            LinkStyleDefiner definer = StylableDocumentWrapper.this.getEmbeddedStyleDefiner((CSSElement)this.getParentNode());
            if (definer != null) {
                definer.resetLinkedSheet();
            }
        }

        @Override
        public String toString() {
            return "<![CDATA[" + this.getData() + "]]>";
        }
    }

    class MyComment
    extends MyCharacterData
    implements Comment {
        MyComment(Comment cdata) {
            super(cdata);
        }

        public String toString() {
            return "<!--" + this.getData() + "-->";
        }
    }

    class MyDocumentType
    extends MyNode
    implements DocumentType {
        MyDocumentType(DocumentType node) {
            super(node);
        }

        @Override
        public String getName() {
            return ((DocumentType)this.rawnode).getName();
        }

        @Override
        public NamedNodeMap getEntities() {
            return ((DocumentType)this.rawnode).getEntities();
        }

        @Override
        public NamedNodeMap getNotations() {
            return ((DocumentType)this.rawnode).getNotations();
        }

        @Override
        public String getPublicId() {
            return ((DocumentType)this.rawnode).getPublicId();
        }

        @Override
        public String getSystemId() {
            return ((DocumentType)this.rawnode).getSystemId();
        }

        @Override
        public String getInternalSubset() {
            return ((DocumentType)this.rawnode).getInternalSubset();
        }
    }

    class MyStyleProcessingInstruction
    extends MyProcessingInstruction
    implements LinkStyleProcessingInstruction {
        private boolean needsUpdate;
        private AbstractCSSStyleSheet linkedSheet;
        private final LinkedHashMap<String, String> pseudoAttrs;

        MyStyleProcessingInstruction(ProcessingInstruction node) {
            super(node);
            this.needsUpdate = true;
            this.linkedSheet = null;
            this.pseudoAttrs = new LinkedHashMap();
            this.parseData();
        }

        @Override
        public void setData(String data) throws DOMException {
            this.rawnode.setNodeValue(data);
            this.parseData();
            this.resetLinkedSheet();
            if (this.getParentNode() != null) {
                StylableDocumentWrapper.this.onStyleModify();
            }
        }

        private void parseData() throws DOMException {
            DOMUtil.parsePseudoAttributes(this.getData(), this.pseudoAttrs);
        }

        @Override
        public void setNodeValue(String nodeValue) throws DOMException {
            this.setData(nodeValue);
        }

        @Override
        public AbstractCSSStyleSheet getSheet() {
            if (this.needsUpdate) {
                boolean alternate;
                String type = this.getPseudoAttribute("type");
                if (type.length() != 0 && !"text/css".equals(type)) {
                    return null;
                }
                String title = this.getPseudoAttribute("title");
                if (title.length() == 0) {
                    title = null;
                }
                if ((alternate = "yes".equalsIgnoreCase(this.getPseudoAttribute("alternate"))) && title == null) {
                    StylableDocumentWrapper.this.getErrorHandler().linkedStyleError(this, "Alternate sheet without title");
                    return null;
                }
                boolean disable = alternate && (this.linkedSheet == null || !title.equalsIgnoreCase(StylableDocumentWrapper.this.getSelectedStyleSheetSet()));
                String href = this.getPseudoAttribute("href");
                int hreflen = href.length();
                if (hreflen > 1) {
                    if (href.charAt(0) != '#') {
                        this.linkedSheet = StylableDocumentWrapper.this.loadStyleSheet(this.linkedSheet, href, title, this.getPseudoAttribute("media"), this);
                        if (this.linkedSheet != null) {
                            this.needsUpdate = false;
                        }
                    } else {
                        String id = href.substring(1);
                        CSSElement elm = StylableDocumentWrapper.this.getElementById(id);
                        if (elm != null) {
                            String text = elm.getTextContent().trim();
                            this.linkedSheet = StylableDocumentWrapper.this.parseEmbeddedStyleSheet(this.linkedSheet, text, title, this.getPseudoAttribute("media"), this);
                            if (this.linkedSheet != null) {
                                this.needsUpdate = false;
                            }
                        } else {
                            this.linkedSheet = null;
                            StylableDocumentWrapper.this.getErrorHandler().linkedStyleError(this, "Could not find element with id: " + id);
                        }
                    }
                    if (disable && this.linkedSheet != null) {
                        this.linkedSheet.setDisabled(true);
                    }
                } else {
                    StylableDocumentWrapper.this.getErrorHandler().linkedStyleError(this, "Missing or void href pseudo-attribute.");
                }
            }
            return this.linkedSheet;
        }

        @Override
        public String getPseudoAttribute(String attrname) {
            String value = this.pseudoAttrs.get(attrname);
            if (value == null) {
                value = "";
            }
            return value;
        }

        @Override
        public boolean isSameSheet(String idOrUri) {
            String href = this.getPseudoAttribute("href");
            int hreflen = href.length();
            if (hreflen > 1) {
                if (href.charAt(0) != '#') {
                    return href.equals(idOrUri);
                }
                return idOrUri.equals(href.substring(1));
            }
            return false;
        }

        @Override
        public void resetLinkedSheet() {
            this.needsUpdate = true;
            StylableDocumentWrapper.this.onStyleModify();
        }
    }

    class MyProcessingInstruction
    extends MyNode
    implements ProcessingInstruction {
        MyProcessingInstruction(ProcessingInstruction node) {
            super(node);
        }

        @Override
        public String getData() {
            return ((ProcessingInstruction)this.rawnode).getData();
        }

        @Override
        public String getTarget() {
            return ((ProcessingInstruction)this.rawnode).getTarget();
        }

        @Override
        public void setData(String data) throws DOMException {
            ((ProcessingInstruction)this.rawnode).setData(data);
        }

        @Override
        public void setNodeValue(String nodeValue) throws DOMException {
            this.rawnode.setNodeValue(nodeValue);
        }
    }

    class MyEntityReference
    extends MyNode
    implements EntityReference {
        MyEntityReference(EntityReference node) {
            super(node);
        }
    }

    class MyNode
    extends DOMNode {
        MyNode(Node node) {
            super(node);
        }

        @Override
        public CSSDocument getOwnerDocument() {
            return StylableDocumentWrapper.this;
        }

        @Override
        protected CSSNode getCSSNode(Node node) {
            return StylableDocumentWrapper.this.getCSSNode(node);
        }

        @Override
        protected CSSNode getMappedCSSNode(Node node) {
            return StylableDocumentWrapper.this.getMappedCSSNode(node);
        }

        @Override
        public String getBaseURI() {
            return StylableDocumentWrapper.this.getBaseURI();
        }

        @Override
        void removeAllChild() throws DOMException {
            Node node;
            while ((node = this.rawnode.getLastChild()) != null) {
                this.rawnode.removeChild(node);
                StylableDocumentWrapper.this.nodemap.remove(node);
            }
        }
    }

    static interface LinkStyleDefiner
    extends LinkStyle<AbstractCSSRule>,
    Node {
        public AbstractCSSStyleSheet getSheet();

        public void resetLinkedSheet();
    }

    static interface LinkStyleProcessingInstruction
    extends LinkStyleDefiner,
    ProcessingInstruction {
        public String getPseudoAttribute(String var1);

        public boolean isSameSheet(String var1);
    }

    class MyDefaultErrorHandler
    extends DefaultErrorHandler {
        private static final long serialVersionUID = 1L;

        MyDefaultErrorHandler() {
        }

        @Override
        protected AbstractCSSStyleSheetFactory getStyleSheetFactory() {
            return StylableDocumentWrapper.this.getStyleSheetFactory();
        }
    }

    abstract class StyleDefinerElement
    extends MyElement
    implements LinkStyleDefiner {
        AbstractCSSStyleSheet definedSheet;
        boolean needsUpdate;

        StyleDefinerElement(Element element) {
            super(element);
            this.definedSheet = null;
            this.needsUpdate = true;
        }

        @Override
        public void resetLinkedSheet() {
            if (this.definedSheet != null) {
                this.definedSheet.getCssRules().clear();
            }
            this.needsUpdate = true;
            StylableDocumentWrapper.this.onStyleModify();
        }
    }

    class MyCharacterData
    extends MyNode
    implements CharacterData {
        MyCharacterData(CharacterData cdata) {
            super(cdata);
        }

        @Override
        public String getData() throws DOMException {
            return this.rawnode.getNodeValue();
        }

        @Override
        public void setData(String data) throws DOMException {
            ((CharacterData)this.rawnode).setData(data);
            this.onDOMChange();
        }

        @Override
        public String getNodeValue() throws DOMException {
            return this.getData();
        }

        @Override
        public void setNodeValue(String nodeValue) throws DOMException {
            this.setData(nodeValue);
        }

        @Override
        public void setTextContent(String textContent) throws DOMException {
            this.setNodeValue(textContent);
        }

        @Override
        public int getLength() {
            return ((CharacterData)this.rawnode).getLength();
        }

        @Override
        public String substringData(int offset, int count) throws DOMException {
            return ((CharacterData)this.rawnode).substringData(offset, count);
        }

        @Override
        public void appendData(String arg) throws DOMException {
            ((CharacterData)this.rawnode).appendData(arg);
            this.onDOMChange();
        }

        @Override
        public void insertData(int offset, String arg) throws DOMException {
            ((CharacterData)this.rawnode).insertData(offset, arg);
            this.onDOMChange();
        }

        @Override
        public void deleteData(int offset, int count) throws DOMException {
            ((CharacterData)this.rawnode).deleteData(offset, count);
            this.onDOMChange();
        }

        @Override
        public void replaceData(int offset, int count, String arg) throws DOMException {
            ((CharacterData)this.rawnode).replaceData(offset, count, arg);
            this.onDOMChange();
        }

        void onDOMChange() {
        }
    }
}

