/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.DOMNotSupportedException;
import io.sf.carte.doc.DOMSyntaxException;
import io.sf.carte.doc.color.Illuminant;
import io.sf.carte.doc.style.css.CSSColor;
import io.sf.carte.doc.style.css.CSSColorMixFunction;
import io.sf.carte.doc.style.css.CSSColorValue;
import io.sf.carte.doc.style.css.CSSExpressionValue;
import io.sf.carte.doc.style.css.CSSMathFunctionValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.RGBAColor;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.parser.SyntaxParser;
import io.sf.carte.doc.style.css.property.BaseColor;
import io.sf.carte.doc.style.css.property.BaseProfiledColor;
import io.sf.carte.doc.style.css.property.CSSLexicalProcessingException;
import io.sf.carte.doc.style.css.property.ColorIdentifiers;
import io.sf.carte.doc.style.css.property.ColorSpaceHelper;
import io.sf.carte.doc.style.css.property.ColorValue;
import io.sf.carte.doc.style.css.property.HSLColorImpl;
import io.sf.carte.doc.style.css.property.HWBColorImpl;
import io.sf.carte.doc.style.css.property.LABColorImpl;
import io.sf.carte.doc.style.css.property.LABColorValue;
import io.sf.carte.doc.style.css.property.LCHColorImpl;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.PercentageEvaluator;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.ProfiledRGBColor;
import io.sf.carte.doc.style.css.property.RGBColor;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.XYZColorImpl;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.Objects;
import org.w3c.dom.DOMException;

class ColorMixFunction
extends ColorValue
implements CSSColorMixFunction {
    private static final long serialVersionUID = 1L;
    private CSSColorValue.ColorModel inColorModel;
    private String inColorSpace;
    private ColorSpaceHelper.HueInterpolationMethod inMethod;
    private PrimitiveValue unknownMethod = null;
    private int hueIndex = -1;
    private PrimitiveValue colorValue1;
    private PrimitiveValue percent1 = null;
    private PrimitiveValue colorValue2;
    private PrimitiveValue percent2 = null;
    private BaseColor color;

    ColorMixFunction() {
        super(CSSValue.Type.COLOR_MIX);
    }

    ColorMixFunction(ColorMixFunction copied) {
        super(copied);
        this.inColorSpace = copied.inColorSpace;
        this.inMethod = copied.inMethod;
        this.unknownMethod = copied.unknownMethod;
        this.colorValue1 = copied.colorValue1.clone();
        this.colorValue2 = copied.colorValue2.clone();
        if (copied.percent1 != null) {
            this.percent1 = copied.percent1.clone();
        }
        if (copied.percent2 != null) {
            this.percent2 = copied.percent2.clone();
        }
        this.setColorModelSpace(this.inColorSpace);
    }

    @Override
    void set(StyleValue value) {
        super.set(value);
        ColorMixFunction setfrom = (ColorMixFunction)value;
        this.inColorSpace = setfrom.inColorSpace;
        this.inColorModel = setfrom.inColorModel;
        this.inMethod = setfrom.inMethod;
        this.unknownMethod = setfrom.unknownMethod;
        this.colorValue1 = setfrom.colorValue1;
        this.colorValue2 = setfrom.colorValue2;
        this.percent1 = setfrom.percent1;
        this.percent2 = setfrom.percent2;
    }

    @Override
    public CSSColorValue.ColorModel getColorModel() {
        return this.inColorModel;
    }

    @Override
    public String getCSSColorSpace() {
        return this.inColorSpace;
    }

    @Override
    public PrimitiveValue getColorValue1() {
        return this.colorValue1;
    }

    public void setColorValue1(PrimitiveValue colorValue) {
        ColorMixFunction.checkColorValidity(colorValue);
        this.colorValue1 = colorValue;
        this.mixColors();
    }

    @Override
    public PrimitiveValue getColorValue2() {
        return this.colorValue2;
    }

    public void setColorValue2(PrimitiveValue colorValue) {
        ColorMixFunction.checkColorValidity(colorValue);
        this.colorValue2 = colorValue;
        this.mixColors();
    }

    private static void checkColorValidity(PrimitiveValue primi) {
        if (!ColorMixFunction.isValidColor(primi)) {
            throw new DOMException(17, "Unsupported value: " + primi.getCssText());
        }
    }

    private static boolean isValidColor(PrimitiveValue primi) {
        CSSValue.Type pType = primi.getPrimitiveType();
        return pType == CSSValue.Type.COLOR || primi.getCssValueType() == CSSValue.CssType.PROXY || pType == CSSValue.Type.IDENT && ColorIdentifiers.getInstance().isColorIdentifier(((TypedValue)primi).getStringValue());
    }

    @Override
    public PrimitiveValue getPercentage1() {
        return this.percent1;
    }

    public void setPercentage1(PrimitiveValue percent1) {
        this.percent1 = ColorMixFunction.normalizePercent(percent1);
    }

    @Override
    public PrimitiveValue getPercentage2() {
        return this.percent2;
    }

    public void setPercentage2(PrimitiveValue percent2) throws DOMException {
        this.percent2 = ColorMixFunction.normalizePercent(percent2);
    }

    private static PrimitiveValue normalizePercent(PrimitiveValue primi) {
        if (primi == null) {
            return null;
        }
        if (primi.getPrimitiveType() == CSSValue.Type.EXPRESSION) {
            PercentageEvaluator eval = new PercentageEvaluator();
            primi = (PrimitiveValue)((Object)eval.evaluateExpression((CSSExpressionValue)((Object)primi)));
        } else if (primi.getPrimitiveType() == CSSValue.Type.MATH_FUNCTION) {
            PercentageEvaluator eval = new PercentageEvaluator();
            primi = (PrimitiveValue)((Object)eval.evaluateFunction((CSSMathFunctionValue)((Object)primi)));
        }
        if (primi.getUnitType() != 2 && primi.getPrimitiveType() != CSSValue.Type.EXPRESSION && primi.getPrimitiveType() != CSSValue.Type.MATH_FUNCTION && primi.getPrimitiveType() != CSSValue.Type.ENV && primi.getPrimitiveType() != CSSValue.Type.FUNCTION) {
            throw new DOMException(17, "Type not compatible: " + primi.getCssText());
        }
        return primi;
    }

    @Override
    public String getCssText() {
        BufferSimpleWriter wri = new BufferSimpleWriter();
        try {
            this.writeCssText((SimpleWriter)wri);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return wri.toString();
    }

    @Override
    public String getMinifiedCssText(String propertyName) {
        StringBuilder buf = new StringBuilder();
        buf.append("color-mix(in ");
        buf.append(this.getCSSColorSpace());
        switch (this.inMethod) {
            case LONGER: {
                buf.append(" longer hue");
                break;
            }
            case INCREASING: {
                buf.append(" increasing hue");
                break;
            }
            case DECREASING: {
                buf.append(" decreasing hue");
                break;
            }
            case UNKNOWN: {
                buf.append(' ').append(this.unknownMethod).append(" hue");
                break;
            }
        }
        buf.append(',');
        buf.append(this.colorValue1.getMinifiedCssText(propertyName));
        if (this.percent1 != null) {
            buf.append(' ');
            buf.append(this.percent1.getMinifiedCssText(propertyName));
        }
        buf.append(',');
        buf.append(this.colorValue2.getMinifiedCssText(propertyName));
        if (this.percent2 != null) {
            buf.append(' ');
            buf.append(this.percent2.getMinifiedCssText(propertyName));
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        wri.write((CharSequence)"color-mix(in ");
        wri.write((CharSequence)this.getCSSColorSpace());
        switch (this.inMethod) {
            case LONGER: {
                wri.write((CharSequence)" longer hue");
                break;
            }
            case INCREASING: {
                wri.write((CharSequence)" increasing hue");
                break;
            }
            case DECREASING: {
                wri.write((CharSequence)" decreasing hue");
                break;
            }
            case UNKNOWN: {
                wri.write(' ');
                this.unknownMethod.writeCssText(wri);
                wri.write((CharSequence)" hue");
                break;
            }
        }
        wri.write((CharSequence)", ");
        this.colorValue1.writeCssText(wri);
        if (this.percent1 != null) {
            wri.write(' ');
            this.percent1.writeCssText(wri);
        }
        wri.write((CharSequence)", ");
        this.colorValue2.writeCssText(wri);
        if (this.percent2 != null) {
            wri.write(' ');
            this.percent2.writeCssText(wri);
        }
        wri.write(')');
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        LexicalUnit lunit;
        CSSParser parser = new CSSParser();
        try {
            lunit = parser.parsePropertyValue(new StringReader(cssText));
        }
        catch (CSSParseException e) {
            throw new DOMSyntaxException("Wrong color-mix() value: " + cssText, e);
        }
        catch (IOException e) {
            lunit = null;
        }
        PrimitiveValue.LexicalSetter setter = this.newLexicalSetter();
        try {
            setter.setLexicalUnit(lunit);
        }
        catch (RuntimeException e) {
            DOMException ex = new DOMException(13, "Not a valid color-mix() value: " + lunit.toString());
            ex.initCause(e);
            throw ex;
        }
    }

    @Override
    public PrimitiveValue getComponent(int index) {
        PrimitiveValue comp;
        switch (index) {
            case 0: {
                comp = this.colorValue1;
                break;
            }
            case 1: {
                comp = this.percent1;
                break;
            }
            case 2: {
                comp = this.colorValue2;
                break;
            }
            case 3: {
                comp = this.percent2;
                break;
            }
            case 4: {
                comp = this.unknownMethod;
                break;
            }
            default: {
                comp = null;
            }
        }
        return comp;
    }

    @Override
    public void setComponent(int index, StyleValue component) {
        PrimitiveValue comp = (PrimitiveValue)component;
        switch (index) {
            case 0: {
                this.setColorValue1(comp);
                break;
            }
            case 1: {
                this.setPercentage1(comp);
                break;
            }
            case 2: {
                this.setColorValue2(comp);
                break;
            }
            case 3: {
                this.setPercentage2(comp);
                break;
            }
            case 4: {
                this.setInterpolationMethod(comp);
                break;
            }
        }
    }

    private void setInterpolationMethod(PrimitiveValue primi) {
        if (primi.getPrimitiveType() == CSSValue.Type.IDENT) {
            String s = ((TypedValue)primi).getStringValue();
            this.inMethod = ColorSpaceHelper.parseInterpolationMethod(s);
            if (this.inMethod != ColorSpaceHelper.HueInterpolationMethod.UNKNOWN) {
                this.unknownMethod = null;
                return;
            }
        } else {
            this.inMethod = ColorSpaceHelper.HueInterpolationMethod.UNKNOWN;
        }
        this.unknownMethod = primi;
    }

    @Override
    public int getComponentCount() {
        return this.unknownMethod == null ? 4 : 5;
    }

    @Override
    public RGBAColor toRGBColor() throws DOMException {
        return this.toRGBColor(true);
    }

    @Override
    public RGBAColor toRGBColor(boolean clamp) throws DOMException {
        BaseColor color = this.getColor();
        if (!color.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        switch (color.getSpace()) {
            case sRGB: {
                return (RGBColor)color;
            }
            case CIE_XYZ: 
            case CIE_XYZ_D50: {
                return ((XYZColorImpl)color).toSRGBColor(clamp);
            }
        }
        if (this.getColorModel() == CSSColorValue.ColorModel.RGB) {
            return ((ProfiledRGBColor)color).toSRGBColor(clamp);
        }
        return (RGBAColor)((Object)color.toColorSpace("srgb"));
    }

    @Override
    public BaseColor getColor() {
        if (this.mixColors()) {
            return this.color;
        }
        return null;
    }

    @Override
    boolean hasConvertibleComponents() {
        return !(!this.isConvertibleColor(this.colorValue1) || !this.isConvertibleColor(this.colorValue2) || this.percent1 != null && this.percent1.getUnitType() != 2 || this.percent2 != null && this.percent2.getUnitType() != 2 || this.unknownMethod != null);
    }

    private boolean isConvertibleColor(PrimitiveValue colorValue) {
        return colorValue instanceof ColorValue && ((ColorValue)colorValue).hasConvertibleComponents() || colorValue.getPrimitiveType() == CSSValue.Type.IDENT;
    }

    @Override
    public float deltaE2000(CSSColorValue otherColor) {
        BaseColor color = this.getColor();
        if (color == null || !((ColorValue)otherColor).hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot compute delta.");
        }
        return color.packInValue().deltaE2000(otherColor);
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    private void setColorModelSpace(String colorSpace) {
        if ("srgb".equalsIgnoreCase(colorSpace)) {
            this.inColorSpace = "srgb";
            this.color = new RGBColor();
        } else if ("srgb-linear".equalsIgnoreCase(colorSpace)) {
            this.inColorSpace = "srgb-linear";
            this.color = new ProfiledRGBColor(this.inColorSpace);
        } else if ("display-p3".equalsIgnoreCase(colorSpace)) {
            this.inColorSpace = "display-p3";
            this.color = new ProfiledRGBColor(this.inColorSpace);
        } else if ("a98-rgb".equalsIgnoreCase(colorSpace)) {
            this.inColorSpace = "a98-rgb";
            this.color = new ProfiledRGBColor(this.inColorSpace);
        } else if ("prophoto-rgb".equalsIgnoreCase(colorSpace)) {
            this.inColorSpace = "prophoto-rgb";
            this.color = new ProfiledRGBColor(this.inColorSpace);
        } else if ("rec2020".equalsIgnoreCase(colorSpace)) {
            this.inColorSpace = "rec2020";
            this.color = new ProfiledRGBColor(this.inColorSpace);
        } else if ("xyz".equalsIgnoreCase(colorSpace) || "xyz-d65".equalsIgnoreCase(colorSpace)) {
            this.inColorSpace = "xyz";
            this.color = new XYZColorImpl(Illuminant.D65);
        } else if ("xyz-d50".equalsIgnoreCase(colorSpace)) {
            this.inColorSpace = "xyz-d50";
            this.color = new XYZColorImpl(Illuminant.D50);
        } else if ("hsl".equalsIgnoreCase(colorSpace) || "hsla".equalsIgnoreCase(colorSpace)) {
            this.inColorSpace = "hsl";
            this.color = new HSLColorImpl();
            this.hueIndex = 0;
        } else if ("hwb".equalsIgnoreCase(colorSpace)) {
            this.inColorSpace = "hwb";
            this.color = new HWBColorImpl();
            this.hueIndex = 0;
        } else if ("lab".equalsIgnoreCase(colorSpace)) {
            this.inColorSpace = "lab";
            this.color = new LABColorImpl(BaseColor.Space.CIE_Lab, "lab");
        } else if ("lch".equalsIgnoreCase(colorSpace)) {
            this.inColorSpace = "lch";
            this.color = new LCHColorImpl(BaseColor.Space.CIE_LCh, "lch");
            this.hueIndex = 2;
        } else if ("oklab".equalsIgnoreCase(colorSpace)) {
            this.inColorSpace = "oklab";
            this.color = new LABColorImpl(BaseColor.Space.OK_Lab, "oklab");
        } else if ("oklch".equalsIgnoreCase(colorSpace)) {
            this.inColorSpace = "oklch";
            this.color = new LCHColorImpl(BaseColor.Space.OK_LCh, "oklch");
            this.hueIndex = 2;
        } else if (colorSpace.startsWith("--")) {
            this.inColorSpace = colorSpace;
            this.color = new BaseProfiledColor(colorSpace);
        } else {
            throw new DOMNotSupportedException("Unsupported color space: " + colorSpace);
        }
        this.inColorModel = this.color.getColorModel();
    }

    private boolean mixColors() {
        if (this.hasConvertibleComponents()) {
            NumberValue alpha;
            BaseColor conv2;
            BaseColor conv1;
            try {
                conv1 = this.colorInSpace(this.colorValue1);
                conv2 = this.colorInSpace(this.colorValue2);
            }
            catch (DOMException e) {
                return false;
            }
            float[] frac = this.fractions();
            if (Float.isNaN(frac[0])) {
                return false;
            }
            PrimitiveValue primi1 = conv1.getAlpha();
            PrimitiveValue primi2 = conv2.getAlpha();
            if (primi1 == null || primi1.getPrimitiveType() == CSSValue.Type.IDENT) {
                alpha = primi2.getPrimitiveType() == CSSValue.Type.IDENT ? NumberValue.createCSSNumberValue((short)0, 0.0f) : NumberValue.createCSSNumberValue((short)0, ((TypedValue)primi2).getFloatValue((short)0));
            } else if (primi2 == null || primi2.getPrimitiveType() == CSSValue.Type.IDENT) {
                alpha = primi1.getPrimitiveType() == CSSValue.Type.IDENT ? NumberValue.createCSSNumberValue((short)0, 0.0f) : NumberValue.createCSSNumberValue((short)0, ((TypedValue)primi1).getFloatValue((short)0));
            } else {
                float fa2;
                float fa1;
                try {
                    fa1 = ((TypedValue)primi1).getFloatValue((short)0);
                    fa2 = ((TypedValue)primi2).getFloatValue((short)0);
                }
                catch (DOMException e) {
                    return false;
                }
                float falpha = fa1 * frac[0] + fa2 * frac[1];
                alpha = NumberValue.createCSSNumberValue((short)0, falpha);
            }
            this.color.setAlpha(alpha);
            double[] components1 = conv1.toNumberArray();
            double[] components2 = conv2.toNumberArray();
            int len = Math.max(components1.length, components2.length);
            double[] components = new double[len];
            for (int i = 0; i < len; ++i) {
                TypedValue color1comp = (TypedValue)conv1.item(i + 1);
                TypedValue color2comp = (TypedValue)conv2.item(i + 1);
                if (color1comp == null || color1comp.getPrimitiveType() == CSSValue.Type.IDENT) {
                    if (color2comp.getPrimitiveType() == CSSValue.Type.IDENT) {
                        components[i] = 0.0;
                        continue;
                    }
                    components[i] = components2[i];
                    continue;
                }
                if (color2comp == null || color2comp.getPrimitiveType() == CSSValue.Type.IDENT) {
                    if (color1comp.getPrimitiveType() == CSSValue.Type.IDENT) {
                        components[i] = 0.0;
                        continue;
                    }
                    components[i] = components1[i];
                    continue;
                }
                double fv1 = components1[i];
                double fv2 = components2[i];
                double result = i == this.hueIndex ? this.hueInterpolation(fv1, frac[0], fv2, frac[1]) : fv1 * (double)frac[0] + fv2 * (double)frac[1];
                components[i] = result;
            }
            this.color.setColorComponents(components);
            return true;
        }
        return false;
    }

    private BaseColor colorInSpace(PrimitiveValue colorValue) {
        CSSColor conv;
        if (colorValue.getPrimitiveType() == CSSValue.Type.COLOR) {
            conv = ((ColorValue)colorValue).getColor().toColorSpace(this.inColorSpace);
        } else {
            conv = ((TypedValue)colorValue).toRGBColor();
            conv = conv.toColorSpace(this.inColorSpace);
        }
        return (BaseColor)conv;
    }

    private float[] fractions() {
        float pcnt2;
        float pcnt1;
        if (this.percent1 == null) {
            if (this.percent2 == null) {
                pcnt1 = 50.0f;
                pcnt2 = 50.0f;
            } else {
                pcnt2 = ((TypedValue)this.percent2).getFloatValue((short)2);
                pcnt1 = 100.0f - pcnt2;
            }
        } else if (this.percent2 == null) {
            pcnt1 = ((TypedValue)this.percent1).getFloatValue((short)2);
            pcnt2 = 100.0f - pcnt1;
        } else {
            pcnt1 = ((TypedValue)this.percent1).getFloatValue((short)2);
            pcnt2 = ((TypedValue)this.percent2).getFloatValue((short)2);
        }
        float p12 = pcnt1 + pcnt2;
        float[] frac = new float[2];
        if ((double)Math.abs(p12) >= 1.0E-7) {
            frac[0] = pcnt1 / p12;
            frac[1] = pcnt2 / p12;
        } else {
            frac[0] = Float.NaN;
            frac[1] = Float.NaN;
        }
        return frac;
    }

    private double hueInterpolation(double angle1, float frac1, double angle2, float frac2) {
        double diff = angle2 - angle1;
        switch (this.inMethod) {
            case UNKNOWN: 
            case SHORTER: {
                if (diff > 180.0) {
                    angle1 += 360.0;
                    break;
                }
                if (!(diff < -180.0)) break;
                angle2 += 360.0;
                break;
            }
            case LONGER: {
                if (diff > 0.0 && diff < 180.0) {
                    angle1 += 360.0;
                    break;
                }
                if (!(diff > -180.0) || !(diff <= 0.0)) break;
                angle2 += 360.0;
                break;
            }
            case INCREASING: {
                if (!(diff < 0.0)) break;
                angle2 += 360.0;
                break;
            }
            case DECREASING: {
                if (!(diff > 0.0)) break;
                angle1 += 360.0;
            }
        }
        double hue = angle1 * (double)frac1 + angle2 * (double)frac2;
        if (hue >= 360.0) {
            hue -= 360.0;
        } else if (hue < 0.0) {
            hue += 360.0;
        }
        return hue;
    }

    @Override
    public LABColorValue toLABColorValue() {
        BaseColor color = this.getColor();
        LABColorValue labColor = new LABColorValue();
        LABColorImpl lab = (LABColorImpl)labColor.getColor();
        switch (color.getColorModel()) {
            case RGB: {
                color.toLABColor(lab);
                break;
            }
            case XYZ: {
                color.toLABColor(lab);
                break;
            }
            default: {
                throw new DOMNotSupportedException("Custom profiles are not suported.");
            }
        }
        return labColor;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(new Object[]{this.inColorSpace, this.inColorModel, this.inMethod, this.colorValue1, this.colorValue2, this.percent1, this.percent2});
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColorMixFunction other = (ColorMixFunction)obj;
        return this.inColorModel == other.inColorModel && this.inMethod == other.inMethod && Objects.equals(this.inColorSpace, other.inColorSpace) && Objects.equals(this.colorValue1, other.colorValue1) && Objects.equals(this.colorValue2, other.colorValue2) && Objects.equals(this.percent1, other.percent1) && Objects.equals(this.percent2, other.percent2);
    }

    @Override
    public ColorMixFunction clone() {
        return new ColorMixFunction(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
            super(ColorMixFunction.this);
        }

        @Override
        void setLexicalUnit(LexicalUnit lunit) {
            try {
                if (lunit.getLexicalUnitType() != LexicalUnit.LexicalType.COLOR_MIX) {
                    throw new IllegalStateException("No color-mix() value: " + lunit.toString());
                }
                this.setLexical(lunit);
            }
            catch (DOMException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new DOMSyntaxException("Invalid value: " + lunit.toString());
            }
            this.nextLexicalUnit = lunit.getNextLexicalUnit();
        }

        private void setLexical(LexicalUnit lunit) {
            PrimitiveValue color2;
            PrimitiveValue pcnt2;
            PrimitiveValue color1;
            PrimitiveValue pcnt1;
            String colorSpace;
            LexicalUnit lu = lunit.getParameters();
            ValueFactory factory = new ValueFactory();
            LexicalUnit.LexicalType type = lu.getLexicalUnitType();
            switch (type) {
                case VAR: 
                case ATTR: {
                    throw new CSSLexicalProcessingException("Unprocessable proxy inside color-mix() found.");
                }
                case IDENT: {
                    if ("in".equalsIgnoreCase(lu.getStringValue())) break;
                }
                default: {
                    throw new DOMSyntaxException("Color-Mix begings with 'in', not with " + lunit.toString());
                }
            }
            lu = lu.getNextLexicalUnit();
            type = lu.getLexicalUnitType();
            switch (type) {
                case VAR: 
                case ATTR: {
                    throw new CSSLexicalProcessingException("Unprocessable proxy inside color-mix() found.");
                }
                case IDENT: {
                    colorSpace = lu.getStringValue();
                    break;
                }
                default: {
                    throw new DOMException(17, "Color space must be identifier, not: " + lunit.toString());
                }
            }
            lu = lu.getNextLexicalUnit();
            if (lu == null) {
                this.wrongValueSyntax(lunit);
            }
            ColorSpaceHelper.HueInterpolationMethod method = ColorSpaceHelper.HueInterpolationMethod.SHORTER;
            PrimitiveValue unknownMethod = null;
            if (lu.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                if (lu.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT) {
                    String s = lu.getStringValue();
                    method = ColorSpaceHelper.parseInterpolationMethod(s);
                    if (method == ColorSpaceHelper.HueInterpolationMethod.UNKNOWN) {
                        unknownMethod = factory.createCSSPrimitiveValue(lu, true);
                        this.reportSyntaxWarning("Unknown interpolation method: " + s);
                    }
                } else {
                    CSSValueSyntax syn = SyntaxParser.createSimpleSyntax("custom-ident");
                    if (lu.shallowMatch(syn) != CSSValueSyntax.Match.TRUE) {
                        this.wrongValueSyntax(lunit);
                        return;
                    }
                    method = ColorSpaceHelper.HueInterpolationMethod.UNKNOWN;
                    unknownMethod = factory.createCSSPrimitiveValue(lu, true);
                }
                lu = lu.getNextLexicalUnit();
                if (lu == null) {
                    this.wrongValueSyntax(lunit);
                    return;
                }
                if (lu.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT) {
                    if (!"hue".equalsIgnoreCase(lu.getStringValue())) {
                        this.wrongValueSyntax(lunit);
                        return;
                    }
                    if ((lu = lu.getNextLexicalUnit()) == null) {
                        this.wrongValueSyntax(lunit);
                        return;
                    }
                }
                if (lu.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                    this.wrongValueSyntax(lunit);
                    return;
                }
            }
            if ((lu = lu.getNextLexicalUnit()) == null) {
                this.wrongValueSyntax(lunit);
            }
            CSSValueSyntax synPcnt = SyntaxParser.createSimpleSyntax("percentage");
            PrimitiveValue primi = factory.createCSSPrimitiveValue(lu, true);
            if (!ColorMixFunction.isValidColor(primi)) {
                if (primi.matches(synPcnt) == CSSValueSyntax.Match.FALSE) {
                    this.wrongValueSyntax(lunit);
                    return;
                }
                pcnt1 = primi;
                if ((lu = lu.getNextLexicalUnit()) == null) {
                    this.wrongValueSyntax(lunit);
                    return;
                }
                primi = factory.createCSSPrimitiveValue(lu, true);
                if (!ColorMixFunction.isValidColor(primi)) {
                    this.wrongValueSyntax(lunit);
                    return;
                }
                color1 = primi;
                if ((lu = lu.getNextLexicalUnit()) == null || lu.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                    this.wrongValueSyntax(lunit);
                    return;
                }
            } else {
                color1 = primi;
                if ((lu = lu.getNextLexicalUnit()) == null) {
                    this.wrongValueSyntax(lunit);
                    return;
                }
                if (lu.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                    primi = factory.createCSSPrimitiveValue(lu, true);
                    if (primi.matches(synPcnt) == CSSValueSyntax.Match.FALSE) {
                        this.wrongValueSyntax(lunit);
                        return;
                    }
                    pcnt1 = primi;
                    if ((lu = lu.getNextLexicalUnit()) == null || lu.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                        this.wrongValueSyntax(lunit);
                        return;
                    }
                } else {
                    pcnt1 = null;
                }
            }
            if ((lu = lu.getNextLexicalUnit()) == null) {
                this.wrongValueSyntax(lunit);
                return;
            }
            primi = factory.createCSSPrimitiveValue(lu, true);
            if (!ColorMixFunction.isValidColor(primi)) {
                if (primi.matches(synPcnt) == CSSValueSyntax.Match.FALSE) {
                    this.wrongValueSyntax(lunit);
                    return;
                }
                pcnt2 = primi;
                if ((lu = lu.getNextLexicalUnit()) == null) {
                    this.wrongValueSyntax(lunit);
                    return;
                }
                primi = factory.createCSSPrimitiveValue(lu, true);
                if (!ColorMixFunction.isValidColor(primi)) {
                    this.wrongValueSyntax(lunit);
                    return;
                }
                color2 = primi;
                if ((lu = lu.getNextLexicalUnit()) != null) {
                    this.wrongValueSyntax(lunit);
                    return;
                }
            } else {
                color2 = primi;
                if ((lu = lu.getNextLexicalUnit()) != null) {
                    primi = factory.createCSSPrimitiveValue(lu, true);
                    if (primi.matches(synPcnt) == CSSValueSyntax.Match.FALSE) {
                        this.wrongValueSyntax(lunit);
                        return;
                    }
                    pcnt2 = primi;
                    if ((lu = lu.getNextLexicalUnit()) != null) {
                        this.wrongValueSyntax(lunit);
                        return;
                    }
                } else {
                    pcnt2 = null;
                }
            }
            ColorMixFunction.this.inColorSpace = colorSpace;
            ColorMixFunction.this.inMethod = method;
            ColorMixFunction.this.unknownMethod = unknownMethod;
            ColorMixFunction.this.colorValue1 = color1;
            ColorMixFunction.this.colorValue2 = color2;
            ColorMixFunction.this.setPercentage1(pcnt1);
            ColorMixFunction.this.setPercentage2(pcnt2);
            ColorMixFunction.this.setColorModelSpace(colorSpace);
        }

        private void wrongValueSyntax(LexicalUnit lunit) {
            throw new DOMSyntaxException("Wrong color-mix() value: " + lunit.toString());
        }
    }
}

