/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.ne;

import ghidra.app.util.bin.BinaryReader;
import java.io.IOException;

public class SegmentRelocation {
    public static final int VALUES_SIZE = 5;
    public static final short MOVEABLE = 255;
    public static final byte TYPE_MASK = 15;
    public static final byte TYPE_LO_BYTE = 0;
    public static final byte TYPE_SEGMENT = 2;
    public static final byte TYPE_FAR_ADDR = 3;
    public static final byte TYPE_OFFSET = 5;
    public static final byte TYPE_FAR_ADDR_48 = 12;
    public static final byte TYPE_OFFSET_32 = 13;
    public static final String[] TYPE_STRINGS = new String[]{"Low Byte", "???1", "16-bit Segment Selector", "32-bit Pointer", "???4", "16-bit Pointer", "???6", "???7", "???8", "???9", "???10", "48-bit Pointer", "???12", "32-bit Offset"};
    public static final int[] TYPE_LENGTHS = new int[]{1, 0, 2, 4, 0, 2, 0, 0, 0, 0, 0, 0, 6, 4};
    public static final byte FLAG_TARGET_MASK = 3;
    public static final byte FLAG_INTERNAL_REF = 0;
    public static final byte FLAG_IMPORT_ORDINAL = 1;
    public static final byte FLAG_IMPORT_NAME = 2;
    public static final byte FLAG_OS_FIXUP = 3;
    public static final byte FLAG_ADDITIVE = 4;
    private int segment;
    private byte type;
    private byte flagbyte;
    private short offset;
    private short targetSegment;
    private short targetOffset;

    SegmentRelocation(BinaryReader reader, int segment) throws IOException {
        this.segment = segment;
        this.type = reader.readNextByte();
        this.flagbyte = reader.readNextByte();
        this.offset = reader.readNextShort();
        this.targetSegment = reader.readNextShort();
        this.targetOffset = reader.readNextShort();
    }

    SegmentRelocation(byte type, long[] values) {
        this.type = type;
        if (values.length != 5) {
            throw new IllegalArgumentException("Expected 5 values");
        }
        this.segment = (int)values[0];
        this.flagbyte = (byte)values[1];
        this.offset = (short)values[2];
        this.targetSegment = (short)values[3];
        this.targetOffset = (short)values[4];
    }

    public boolean isInternalRef() {
        return (this.flagbyte & 3) == 0;
    }

    public boolean isImportOrdinal() {
        return (this.flagbyte & 3) == 1;
    }

    public boolean isImportName() {
        return (this.flagbyte & 3) == 2;
    }

    public boolean isOpSysFixup() {
        return (this.flagbyte & 3) == 3;
    }

    public boolean isAdditive() {
        return (this.flagbyte & 4) != 0;
    }

    public byte getType() {
        return this.type;
    }

    public byte getFlagByte() {
        return this.flagbyte;
    }

    public short getOffset() {
        return this.offset;
    }

    public short getTargetSegment() {
        return this.targetSegment;
    }

    public short getTargetOffset() {
        return this.targetOffset;
    }

    public long[] getValues() {
        return new long[]{this.segment, this.flagbyte, this.offset, this.targetSegment, this.targetOffset};
    }
}

