/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.values;

import docking.widgets.button.BrowseButton;
import docking.widgets.values.AbstractValue;
import docking.widgets.values.ValuesMapParseException;
import ghidra.app.script.SelectLanguageDialog;
import ghidra.program.model.lang.CompilerSpecDescription;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.LanguageDescription;
import ghidra.program.model.lang.LanguageService;
import ghidra.program.util.DefaultLanguageService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class LanguageValue
extends AbstractValue<LanguageCompilerSpecPair> {
    private LangaugeValuePanel languagePanel;

    public LanguageValue(String name) {
        super(name, null);
    }

    public LanguageValue(String name, LanguageCompilerSpecPair defaultValue) {
        super(name, (Object)defaultValue);
    }

    public JComponent getComponent() {
        if (this.languagePanel == null) {
            this.languagePanel = new LangaugeValuePanel(this.getName());
        }
        return this.languagePanel;
    }

    protected void updateValueFromComponent() throws ValuesMapParseException {
        this.setValue(this.languagePanel.getLanguage());
    }

    protected void updateComponentFromValue() {
        this.languagePanel.setLanguage((LanguageCompilerSpecPair)this.getValue());
    }

    public LanguageCompilerSpecPair fromString(String valueString) {
        try {
            return this.parseLanguageCompileSpecPair(valueString);
        }
        catch (ValuesMapParseException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public LanguageCompilerSpecPair parseLanguageCompileSpecPair(String languageString) throws ValuesMapParseException {
        String compilerId;
        String langId;
        LanguageCompilerSpecPair storedLCS;
        if (languageString.isBlank()) {
            return null;
        }
        int lastColon = languageString.lastIndexOf(58);
        if (lastColon < 1) {
            throw new ValuesMapParseException(this.getName(), "Language/Compiler Spec", "Could not parse \"" + languageString + "\".");
        }
        Set<LanguageCompilerSpecPair> languages = this.getLanguagesCompilerPairs();
        if (!languages.contains(storedLCS = new LanguageCompilerSpecPair(langId = languageString.substring(0, lastColon), compilerId = languageString.substring(lastColon + 1)))) {
            throw new ValuesMapParseException(this.getName(), "Language/Compiler Spec", "Unknown language/Compiler Pair for \"" + languageString + "\"");
        }
        return storedLCS;
    }

    private Set<LanguageCompilerSpecPair> getLanguagesCompilerPairs() {
        HashSet<LanguageCompilerSpecPair> languages = new HashSet<LanguageCompilerSpecPair>();
        LanguageService languageService = DefaultLanguageService.getLanguageService();
        List descriptions = languageService.getLanguageDescriptions(false);
        for (LanguageDescription description : descriptions) {
            Collection csDescriptions = description.getCompatibleCompilerSpecDescriptions();
            for (CompilerSpecDescription csDescription : csDescriptions) {
                languages.add(new LanguageCompilerSpecPair(description.getLanguageID(), csDescription.getCompilerSpecID()));
            }
        }
        return languages;
    }

    class LangaugeValuePanel
    extends JPanel {
        private JTextField textField;
        private JButton browseButton;

        public LangaugeValuePanel(String name) {
            super(new BorderLayout());
            this.setName(name);
            this.textField = new JTextField(20);
            this.browseButton = new BrowseButton();
            this.browseButton.addActionListener(e -> this.showLanguageDialog());
            this.add((Component)this.textField, "Center");
            this.add((Component)this.browseButton, "East");
        }

        public LanguageCompilerSpecPair getLanguage() throws ValuesMapParseException {
            return LanguageValue.this.parseLanguageCompileSpecPair(this.textField.getText());
        }

        public void setLanguage(LanguageCompilerSpecPair value) {
            String text = value == null ? "" : value.toString();
            this.textField.setText(text);
        }

        private void showLanguageDialog() {
            SelectLanguageDialog dialog = new SelectLanguageDialog("Select Language", "Ok");
            try {
                dialog.setSelectedLanguage(this.getLanguage());
            }
            catch (ValuesMapParseException valuesMapParseException) {
                // empty catch block
            }
            dialog.show();
            LanguageCompilerSpecPair selectedLanguage = dialog.getSelectedLanguage();
            if (selectedLanguage != null) {
                this.textField.setText(selectedLanguage.toString());
            }
            dialog.dispose();
        }

        public File getFile() {
            String text = this.textField.getText().trim();
            if (text.isBlank()) {
                return null;
            }
            return new File(text);
        }

        public void setText(String val) {
            this.textField.setText(val);
        }
    }
}

