/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.listing;

import ghidra.app.util.template.TemplateSimplifier;
import ghidra.program.model.data.DataTypeDisplayOptions;

public class CodeUnitFormatOptions {
    protected volatile ShowBlockName showBlockName = ShowBlockName.NEVER;
    protected volatile ShowNamespace showNamespace = ShowNamespace.NEVER;
    protected volatile String localPrefixOverride = null;
    protected volatile boolean showLibraryInNamespace = true;
    protected volatile boolean doRegVariableMarkup = true;
    protected volatile boolean doStackVariableMarkup = true;
    protected volatile boolean includeInferredVariableMarkup = false;
    protected volatile boolean alwaysShowPrimaryReference = false;
    protected volatile boolean followReferencedPointers = false;
    protected volatile boolean includeScalarReferenceAdjustment = false;
    protected volatile boolean showDataMutability = false;
    protected volatile boolean showOffcutInfo = true;
    protected DataTypeDisplayOptions displayOptions = DataTypeDisplayOptions.DEFAULT;
    protected TemplateSimplifier templateSimplifier;

    public CodeUnitFormatOptions() {
        this.templateSimplifier = new TemplateSimplifier();
    }

    public CodeUnitFormatOptions(ShowBlockName showBlockName, ShowNamespace showNamespace) {
        this.showBlockName = showBlockName;
        this.showNamespace = showNamespace;
        this.templateSimplifier = new TemplateSimplifier();
    }

    public CodeUnitFormatOptions(ShowBlockName showBlockName, ShowNamespace showNamespace, String localPrefixOverride, boolean doRegVariableMarkup, boolean doStackVariableMarkup, boolean includeInferredVariableMarkup, boolean alwaysShowPrimaryReference, boolean includeScalarReferenceAdjustment, boolean showLibraryInNamespace, boolean followReferencedPointers, TemplateSimplifier templateSimplifier) {
        this.showBlockName = showBlockName;
        this.showNamespace = showNamespace;
        this.showLibraryInNamespace = showLibraryInNamespace;
        this.localPrefixOverride = localPrefixOverride;
        this.doRegVariableMarkup = doRegVariableMarkup;
        this.doStackVariableMarkup = doStackVariableMarkup;
        this.includeInferredVariableMarkup = includeInferredVariableMarkup;
        this.alwaysShowPrimaryReference = alwaysShowPrimaryReference;
        this.followReferencedPointers = followReferencedPointers;
        this.includeScalarReferenceAdjustment = includeScalarReferenceAdjustment;
        this.templateSimplifier = templateSimplifier;
    }

    public ShowBlockName getShowBlockNameOption() {
        return this.showBlockName;
    }

    public String simplifyTemplate(String name) {
        return this.templateSimplifier.simplify(name);
    }

    public static enum ShowBlockName {
        NEVER,
        ALWAYS,
        NON_LOCAL;

    }

    public static enum ShowNamespace {
        NEVER,
        ALWAYS,
        NON_LOCAL,
        LOCAL;

    }
}

