/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.generic;

import ghidra.app.plugin.processors.generic.Operand;
import ghidra.app.plugin.processors.generic.SledException;
import ghidra.program.model.mem.MemBuffer;
import java.io.Serializable;
import java.util.Hashtable;

public class Offset
implements Serializable {
    private int offset;
    private Operand relTo;
    private String relToName;

    public Offset(int off, String name) throws SledException {
        if (off % 8 != 0) {
            throw new SledException("offset must be a multiple of eight bits");
        }
        this.offset = off / 8;
        this.relToName = name == null || name.length() == 0 ? "" : name;
    }

    public Offset(int off, Operand rel) {
        this(off, rel.name());
        this.relTo = rel;
    }

    public void setRelativeOffset(Hashtable<String, Operand> opHash) throws SledException {
        if (this.relToName != null && this.relToName.length() != 0) {
            this.relTo = opHash.get(this.relToName);
            if (this.relTo == null) {
                throw new SledException("unable to find relative operand");
            }
        }
    }

    public int getOffset(MemBuffer buf, int off) throws Exception {
        int o = off + this.offset;
        if (this.relTo != null) {
            o += this.relTo.length(buf, off);
        }
        return o;
    }
}

