/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import docking.DialogComponentProvider;
import docking.ReusableDialogComponentProvider;
import docking.widgets.button.GButton;
import docking.widgets.button.GRadioButton;
import docking.widgets.label.GDLabel;
import docking.widgets.label.GLabel;
import docking.widgets.list.GList;
import ghidra.framework.client.ClientUtil;
import ghidra.framework.client.NotConnectedException;
import ghidra.framework.client.RepositoryServerAdapter;
import ghidra.framework.main.FrontEndTool;
import ghidra.framework.main.ServerInfoComponent;
import ghidra.framework.model.ServerInfo;
import ghidra.framework.protocol.ghidra.GhidraURL;
import ghidra.util.MessageType;
import ghidra.util.Msg;
import ghidra.util.StatusListener;
import ghidra.util.layout.MiddleLayout;
import ghidra.util.layout.PairLayout;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.MouseInputAdapter;
import resources.Icons;

class RepositoryChooser
extends ReusableDialogComponentProvider {
    static final Icon REFRESH_ICON = Icons.REFRESH_ICON;
    private static final String SERVER_INFO = "ServerInfo";
    private static final String GHIDRA_URL = "GhidraURL";
    private JRadioButton serverInfoChoice;
    private JRadioButton urlChoice;
    private JPanel cardPanel;
    private CardLayout cardLayout;
    private ServerInfoComponent serverInfoComponent;
    private JButton queryButton;
    private GList<String> nameList;
    private DefaultListModel<String> listModel;
    private JTextField urlTextField;
    private boolean okPressed;

    RepositoryChooser(String title) {
        super(title);
        this.setRememberLocation(false);
        this.buildMainPanel();
    }

    private JPanel buildServerInfoPanel() {
        JPanel serverInfoPanel = new JPanel(new BorderLayout(10, 10));
        JPanel topPanel = new JPanel(new BorderLayout(10, 10));
        this.serverInfoComponent = new ServerInfoComponent();
        this.serverInfoComponent.setStatusListener((StatusListener)this);
        this.serverInfoComponent.setChangeListener(e -> this.serverInfoChanged());
        this.serverInfoComponent.getAccessibleContext().setAccessibleName("Server Info");
        topPanel.add((Component)this.serverInfoComponent, "Center");
        this.queryButton = new GButton(REFRESH_ICON);
        this.queryButton.setToolTipText("Refresh Repository Names List");
        this.setDefaultButton(this.queryButton);
        this.queryButton.addActionListener(e -> this.queryServer());
        this.queryButton.getAccessibleContext().setAccessibleName("Query");
        JPanel buttonPanel = new JPanel((LayoutManager)new MiddleLayout());
        buttonPanel.add(this.queryButton);
        buttonPanel.getAccessibleContext().setAccessibleName("Query Button");
        topPanel.add((Component)buttonPanel, "East");
        topPanel.getAccessibleContext().setAccessibleName("Server Info Query");
        serverInfoPanel.add((Component)topPanel, "North");
        JPanel lowerPanel = new JPanel(new BorderLayout());
        lowerPanel.getAccessibleContext().setAccessibleName("Name List");
        GDLabel label = new GDLabel("Repository Names", 2);
        label.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 5));
        label.getAccessibleContext().setAccessibleName("Repository Name");
        lowerPanel.add((Component)label, "North");
        this.listModel = new DefaultListModel();
        this.nameList = new GList(this.listModel);
        this.nameList.setSelectionMode(0);
        this.nameList.addListSelectionListener(e -> this.selectionChanged());
        this.nameList.getAccessibleContext().setAccessibleName("Name");
        this.nameList.addMouseListener((MouseListener)new MouseInputAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() != 1 || e.getClickCount() != 2) {
                    return;
                }
                if (RepositoryChooser.this.nameList.getSelectedValue() != null) {
                    e.consume();
                    RepositoryChooser.this.okCallback();
                }
            }
        });
        JScrollPane sp = new JScrollPane((Component)this.nameList);
        lowerPanel.add(sp);
        serverInfoPanel.add((Component)lowerPanel, "Center");
        serverInfoPanel.getAccessibleContext().setAccessibleName("Server Info");
        return serverInfoPanel;
    }

    private JPanel buildURLPanel() {
        JPanel urlPanel = new JPanel(new BorderLayout(10, 10));
        this.urlTextField = new JTextField("ghidra:");
        this.urlTextField.getAccessibleContext().setAccessibleName("URL");
        JPanel panel = new JPanel((LayoutManager)new PairLayout());
        panel.add((Component)new GLabel("URL:"));
        panel.add(this.urlTextField);
        panel.getAccessibleContext().setAccessibleName("Url Text Field");
        urlPanel.add((Component)panel, "North");
        urlPanel.getAccessibleContext().setAccessibleName("URL");
        return urlPanel;
    }

    private void choiceActivated(JRadioButton choiceButton) {
        if (choiceButton == this.urlChoice) {
            this.cardLayout.show(this.cardPanel, GHIDRA_URL);
        } else {
            this.cardLayout.show(this.cardPanel, SERVER_INFO);
        }
        this.cardPanel.requestFocus();
        this.choiceChanged();
    }

    private void choiceChanged() {
        this.setStatusText("");
        if (this.urlChoice.isSelected()) {
            this.urlInfoChanged();
        } else {
            this.serverInfoChanged();
        }
    }

    private void buildMainPanel() {
        JPanel panel = new JPanel(new BorderLayout(10, 10));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel radioButtonPanel = new JPanel((LayoutManager)new PairLayout(5, 5));
        radioButtonPanel.getAccessibleContext().setAccessibleName("Radio Buttons");
        radioButtonPanel.setBorder(BorderFactory.createTitledBorder("Repository Specification"));
        ItemListener choiceListener = e -> {
            JRadioButton choiceButton = (JRadioButton)e.getSource();
            if (choiceButton.isSelected()) {
                this.choiceActivated(choiceButton);
            }
        };
        this.serverInfoChoice = new GRadioButton("Ghidra Server");
        this.serverInfoChoice.getAccessibleContext().setAccessibleName("Ghidra Server");
        this.serverInfoChoice.setSelected(true);
        this.serverInfoChoice.addItemListener(choiceListener);
        radioButtonPanel.add(this.serverInfoChoice);
        this.urlChoice = new GRadioButton("Ghidra URL");
        this.urlChoice.getAccessibleContext().setAccessibleName("Ghidra URL");
        this.urlChoice.addItemListener(choiceListener);
        radioButtonPanel.add(this.urlChoice);
        ButtonGroup panelChoices = new ButtonGroup();
        panelChoices.add(this.serverInfoChoice);
        panelChoices.add(this.urlChoice);
        panel.add((Component)radioButtonPanel, "North");
        this.cardLayout = new CardLayout();
        this.cardPanel = new JPanel(this.cardLayout);
        this.cardPanel.getAccessibleContext().setAccessibleName("Card");
        this.cardPanel.add((Component)this.buildServerInfoPanel(), SERVER_INFO);
        this.cardPanel.add((Component)this.buildURLPanel(), GHIDRA_URL);
        panel.add((Component)this.cardPanel, "Center");
        this.cardLayout.show(this.cardPanel, SERVER_INFO);
        panel.getAccessibleContext().setAccessibleName("Repository Chooser");
        this.addWorkPanel(panel);
        this.addCancelButton();
        this.addOKButton();
        this.setOkButtonText("Select Repository");
        this.setOkEnabled(false);
    }

    private void selectionChanged() {
        String name = (String)this.nameList.getSelectedValue();
        this.setOkEnabled(name != null);
    }

    private void queryServer() {
        this.listModel.clear();
        RepositoryServerAdapter repositoryServer = ClientUtil.getRepositoryServer((String)this.serverInfoComponent.getServerName(), (int)this.serverInfoComponent.getPortNumber(), (boolean)true);
        if (repositoryServer == null) {
            return;
        }
        try {
            for (String name : repositoryServer.getRepositoryNames()) {
                this.listModel.addElement(name);
            }
        }
        catch (NotConnectedException e) {
            return;
        }
        catch (IOException e) {
            Msg.showError((Object)((Object)this), null, (String)"Server Error", (Object)("Failed to query list of repositories: " + e.getMessage()));
        }
        if (this.listModel.size() == 0) {
            this.setStatusText("No repositories found");
        }
    }

    private void urlInfoChanged() {
        this.setStatusText("");
        this.setOkEnabled(false);
        try {
            URL url = new URL(this.urlTextField.getText());
            if (!"ghidra".equals(url.getProtocol())) {
                this.setStatusText("URL must specify 'ghidra:' protocol", MessageType.ERROR);
            } else {
                this.setOkEnabled(true);
            }
        }
        catch (MalformedURLException e) {
            this.setStatusText(e.getMessage(), MessageType.ERROR);
        }
    }

    private void serverInfoChanged() {
        this.setStatusText("");
        this.setOkEnabled(false);
        this.listModel.clear();
        this.queryButton.setEnabled(this.serverInfoComponent.isValidInformation());
    }

    URL getSelectedRepository(FrontEndTool tool, URL initURL) {
        this.init(initURL);
        tool.showDialog((DialogComponentProvider)this);
        if (!this.okPressed) {
            return null;
        }
        if (this.serverInfoChoice.isSelected()) {
            return GhidraURL.makeURL(this.serverInfoComponent.getServerName(), this.serverInfoComponent.getPortNumber(), (String)this.nameList.getSelectedValue());
        }
        try {
            return new URL(this.urlTextField.getText());
        }
        catch (MalformedURLException e) {
            Msg.error((Object)((Object)this), (Object)e.getMessage());
            return null;
        }
    }

    protected void okCallback() {
        if (this.serverInfoChoice.isSelected()) {
            if (this.nameList.getSelectedValue() != null) {
                this.okPressed = true;
                this.close();
            }
        } else {
            this.okPressed = true;
            this.close();
        }
    }

    private void init(URL initURL) {
        this.okPressed = false;
        if (initURL != null) {
            String ghidraProtocol;
            String url = initURL.toExternalForm();
            if (url.startsWith(ghidraProtocol = "ghidra:")) {
                if (!url.startsWith(ghidraProtocol + "//")) {
                    this.urlTextField.setText(url);
                    this.urlChoice.setSelected(true);
                    return;
                }
            } else {
                initURL = null;
            }
        }
        ServerInfo serverInfo = null;
        if (initURL != null) {
            String host = initURL.getHost();
            int port = initURL.getPort();
            if (port <= 0) {
                port = 13100;
            }
            serverInfo = new ServerInfo(host, port);
        }
        this.serverInfoComponent.setServerInfo(serverInfo);
        this.serverInfoChoice.setSelected(true);
    }
}

