/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.renderers;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.io.Serializable;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jungrapht.visualization.renderers.VertexLabelRenderer;

public class JTextAreaVertexLabelRenderer
extends JTextArea
implements VertexLabelRenderer,
Serializable {
    protected static Border noFocusBorder = new EmptyBorder(0, 0, 0, 0);
    protected Color pickedVertexLabelColor = Color.black;

    public JTextAreaVertexLabelRenderer(Color pickedVertexLabelColor) {
        this.pickedVertexLabelColor = pickedVertexLabelColor;
        this.setEditable(false);
        this.setOpaque(true);
        this.setBorder(noFocusBorder);
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
    }

    @Override
    public void setForeground(Color c) {
        super.setForeground(c);
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setForeground(null);
        this.setBackground(null);
    }

    @Override
    public <V> Component getVertexLabelRendererComponent(JComponent vv, Object value, Font font, boolean isSelected, V vertex) {
        super.setForeground(vv.getForeground());
        if (isSelected) {
            this.setForeground(this.pickedVertexLabelColor);
        }
        super.setBackground(vv.getBackground());
        if (font != null) {
            this.setFont(font);
        } else {
            this.setFont(vv.getFont());
        }
        this.setBorder(noFocusBorder);
        this.setValue(value);
        return this;
    }

    @Override
    public boolean isOpaque() {
        Color back = this.getBackground();
        Container p = this.getParent();
        if (p != null) {
            p = p.getParent();
        }
        boolean colorMatch = back != null && p != null && back.equals(p.getBackground()) && p.isOpaque();
        return !colorMatch && super.isOpaque();
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (Objects.equals(propertyName, "text")) {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    protected void setValue(Object value) {
        this.setText(value == null ? "" : value.toString());
    }
}

