/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.breakpoint;

import db.Transaction;
import ghidra.app.plugin.core.debug.service.breakpoint.BreakpointActionItem;
import ghidra.async.AsyncUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSpace;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.breakpoint.TraceBreakpointKind;
import ghidra.trace.model.breakpoint.TraceBreakpointLocation;
import ghidra.trace.model.breakpoint.TraceBreakpointSpec;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.path.KeyPath;
import ghidra.trace.model.target.path.PathFilter;
import ghidra.util.exception.DuplicateNameException;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public record PlaceEmuBreakpointActionItem(Trace trace, long snap, Address address, long length, Set<TraceBreakpointKind> kinds, String emuSleigh) implements BreakpointActionItem
{
    public PlaceEmuBreakpointActionItem(Trace trace, long snap, Address address, long length, Set<TraceBreakpointKind> kinds, String emuSleigh) {
        this.trace = trace;
        this.snap = snap;
        this.address = address;
        this.length = length;
        this.kinds = Set.copyOf(kinds);
        this.emuSleigh = emuSleigh;
    }

    public static String createName(Address address) {
        return "emu-" + String.valueOf(address);
    }

    private TraceMemoryRegion findRegion() {
        TraceMemoryRegion region = this.trace.getMemoryManager().getRegionContaining(this.snap, this.address);
        if (region != null) {
            return region;
        }
        AddressSpace space = this.address.getAddressSpace();
        Collection regionsInSpace = this.trace.getMemoryManager().getRegionsIntersecting(Lifespan.at((long)this.snap), (AddressRange)new AddressRangeImpl(space.getMinAddress(), space.getMaxAddress()));
        if (!regionsInSpace.isEmpty()) {
            return (TraceMemoryRegion)regionsInSpace.iterator().next();
        }
        return null;
    }

    private TraceObject findBreakpointContainer() {
        TraceMemoryRegion region = this.findRegion();
        if (region == null) {
            throw new IllegalArgumentException("Address does not belong to a memory in the trace");
        }
        return region.getObject().findSuitableContainerInterface(TraceBreakpointSpec.class);
    }

    private String computePath() {
        String name = PlaceEmuBreakpointActionItem.createName(this.address);
        TraceObject container = this.findBreakpointContainer();
        if (container == null) {
            throw new IllegalArgumentException("Address is not associated with a breakpoint container");
        }
        PathFilter specFilter = container.getSchema().searchFor(TraceBreakpointSpec.class, true);
        if (specFilter == null) {
            throw new IllegalArgumentException("Cannot find path to breakpoint specifications");
        }
        KeyPath specRelPath = specFilter.applyKeys(new String[]{name}).getSingletonPath();
        if (specRelPath == null) {
            throw new IllegalArgumentException("Too many wildcards to breakpoint specification");
        }
        PathFilter locFilter = container.getSchema().getSuccessorSchema(specRelPath).searchFor(TraceBreakpointLocation.class, true);
        if (locFilter == null) {
            throw new IllegalArgumentException("Cannot find path to breakpoint locations");
        }
        KeyPath locRelPath = locFilter.applyIntKeys(new int[]{0}).getSingletonPath();
        if (locRelPath == null) {
            throw new IllegalArgumentException("Too many wildcards to breakpoint location");
        }
        return container.getCanonicalPath().extend(specRelPath).extend(locRelPath).toString();
    }

    @Override
    public CompletableFuture<Void> execute() {
        CompletableFuture completableFuture;
        block8: {
            Transaction tx = this.trace.openTransaction("Place Emulated Breakpoint");
            try {
                TraceBreakpointLocation loc = this.trace.getBreakpointManager().addBreakpoint(this.computePath(), Lifespan.at((long)this.snap), BreakpointActionItem.range(this.address, this.length), Set.of(), this.kinds, false, null);
                loc.setName(this.snap, PlaceEmuBreakpointActionItem.createName(this.address));
                loc.setEmuSleigh(this.snap, this.emuSleigh);
                completableFuture = AsyncUtils.nil();
                if (tx == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (tx != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (DuplicateNameException e) {
                    throw new AssertionError((Object)e);
                }
            }
            tx.close();
        }
        return completableFuture;
    }
}

