/*
 * Decompiled with CFR 0.152.
 */
package datagraph.graph.explore;

import com.google.common.base.Function;
import datagraph.graph.explore.EgVertex;
import ghidra.graph.viewer.GraphViewerUtils;
import ghidra.graph.viewer.VisualEdge;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class EgEdgeTransformer<V extends EgVertex, E extends VisualEdge<V>>
implements Function<E, Shape> {
    private static final double OVERLAP_GAP = 20.0;
    private static int LOOP_SIZE = 12;

    public Shape apply(E e) {
        EgVertex start = (EgVertex)((Object)e.getStart());
        EgVertex end = (EgVertex)((Object)e.getEnd());
        Dimension startSize = start.getComponent().getSize();
        Point2D location = start.getLocation();
        double originX = location.getX();
        double originY = location.getY();
        Point2D startPoint = start.getStartingEdgePoint(end);
        Point2D endPoint = end.getEndingEdgePoint(start);
        boolean isLoop = ((Object)((Object)start)).equals((Object)end);
        if (isLoop) {
            Shape hollowEgdeLoop = GraphViewerUtils.createHollowEgdeLoop();
            AffineTransform xform = AffineTransform.getTranslateInstance(startSize.width / 2 + LOOP_SIZE / 2, start.getOutgoingEdgeOffsetFromCenter(end));
            xform.scale(LOOP_SIZE, LOOP_SIZE);
            return xform.createTransformedShape(hollowEgdeLoop);
        }
        GeneralPath path = new GeneralPath();
        path.moveTo(startPoint.getX() - originX, startPoint.getY() - originY);
        if (startPoint.getX() > endPoint.getX() - 20.0) {
            if (start.getLocation().getX() != startPoint.getX()) {
                path.lineTo(startPoint.getX() - originX + 20.0, startPoint.getY() - originY);
            }
            if (end.getLocation().getX() != endPoint.getX()) {
                path.lineTo(endPoint.getX() - originX - 20.0, endPoint.getY() - originY);
            }
        }
        path.lineTo(endPoint.getX() - originX, endPoint.getY() - originY);
        return path;
    }
}

