# frozen_string_literal: true

class UpdateUnsetHasIssuesOnVulnerabilityReadsFunction < Gitlab::Database::Migration[2.3]
  milestone '18.7'

  def up
    execute <<~SQL
      CREATE OR REPLACE FUNCTION unset_has_issues_on_vulnerability_reads() RETURNS trigger
        LANGUAGE plpgsql
        AS $$
      DECLARE
        has_issue_links integer;
      BEGIN
        IF (SELECT current_setting('vulnerability_management.dont_execute_db_trigger', true) = 'true') THEN
          RETURN NULL;
        END IF;

        PERFORM 1
        FROM
          vulnerability_reads
        WHERE
          vulnerability_id = OLD.vulnerability_id
        FOR UPDATE;

        SELECT 1 INTO has_issue_links FROM vulnerability_issue_links WHERE vulnerability_id = OLD.vulnerability_id LIMIT 1;

        IF (has_issue_links = 1) THEN
          RETURN NULL;
        END IF;

        UPDATE
          vulnerability_reads
        SET
          has_issues = false
        WHERE
          vulnerability_id = OLD.vulnerability_id;

        RETURN NULL;
      END
      $$;
    SQL
  end

  def down
    execute <<~SQL
      CREATE OR REPLACE FUNCTION unset_has_issues_on_vulnerability_reads() RETURNS trigger
        LANGUAGE plpgsql
        AS $$
      DECLARE
        has_issue_links integer;
      BEGIN
        PERFORM 1
        FROM
          vulnerability_reads
        WHERE
          vulnerability_id = OLD.vulnerability_id
        FOR UPDATE;

        SELECT 1 INTO has_issue_links FROM vulnerability_issue_links WHERE vulnerability_id = OLD.vulnerability_id LIMIT 1;

        IF (has_issue_links = 1) THEN
          RETURN NULL;
        END IF;

        UPDATE
          vulnerability_reads
        SET
          has_issues = false
        WHERE
          vulnerability_id = OLD.vulnerability_id;

        RETURN NULL;
      END
      $$;
    SQL
  end
end
