---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: '機密性の高いシークレットまたはトークンMailgun公開キーの公開'
---

## 説明 {#description}

応答本文には、Mailgunの公開キーのパターンに一致するコンテンツが含まれていることが確認されました。これらのキーは非推奨であり、代わりにv4検証サービスを使用する必要があります。このキーへのアクセス権を持つ悪意のある攻撃者は、それを使用してメールアドレスを検証できます。この値を公開すると、攻撃者がこのトークンによって許可されたすべてのリソースにアクセスできるようになる可能性があります。

## 修正 {#remediation}

キーの漏洩に関するセキュリティインシデントの取り扱いに関する一般的なガイダンスについては、GitLabドキュメントの[インターネットへの認証情報の公開](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet)を参照してください。

公開検証キーをローテーションするには:

- Mailgunアカウントにサインインし、ダッシュボード（<https://app.mailgun.com/>）にアクセスします
- 右上側で、アカウントプロファイルを選択し、次に「APIセキュリティ」を選択します
- 「公開検証キー」セクションで、右側の回転矢印アイコンを選択します
- プロンプトが表示されたら、「公開検証キーのリセット」ダイアログで「リセットキー」を選択します

詳細については、[MailgunのAPIキーに関するドキュメント](https://mailchimp.com/help/about-api-keys)を参照してください。

## 詳細 {#details}

| ID | 集約 | CWE | 型 | リスク |
|:---|:-----------|:----|:-----|:-----|
| 798.73 | いいえ | 798 | パッシブ | 高 |

## リンク {#links}

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
