---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: '機密性の高いシークレットまたはトークンであるPulumi APIトークンの暴露'
---

## 説明 {#description}

応答の本文には、Pulumi APIトークンのパターンに一致するコンテンツが含まれていることが確認されました。パーソナルアクセストークンは、ユーザーの権限にマップされます。このトークンにアクセスできる悪意のある攻撃者は、アクセストークンのオーナーとして、スタック、タグ、更新、Webhookを削除できます。この値を公開すると、攻撃者がこのトークンによって許可されたすべてのリソースにアクセスできるようになる可能性があります。

## 修正 {#remediation}

漏洩したキーに関するセキュリティインシデントの処理に関する一般的なガイダンスについては、[インターネットへの認証情報の公開](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet)に関するGitLabドキュメントを参照してください。APIトークンを失効するには:

- Pulumiアカウントにサインインして<https://app.pulumi.com/>にアクセスします
- 右上隅で、プロファイル画像を選択し、「パーソナルアクセストークン」を選択します
- 識別されたトークンを見つけ、キーの「アクション」列の省略記号を選択し、「トークンの削除」を選択します
- プロンプトが表示されたら、[トークンの削除]ダイアログで[トークンの削除]を選択します

詳細については、[パーソナルアクセストークンに関するPulumiのドキュメント](https://www.pulumi.com/docs/pulumi-cloud/access-management/access-tokens/#personal-access-tokens)を参照してください。

## 詳細 {#details}

| ID | 集計 | CWE | 型 | リスク |
|:---|:-----------|:----|:-----|:-----|
| 798.95 | いいえ | 798 | パッシブ | 高 |

## リンク {#links}

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
