---
stage: Create
group: Code Review
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: GitLabでマージリクエストを作成する方法。
title: マージリクエストの作成
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

マージリクエストを作成する準備ができたら、ワークフローに合った方法を使用してください。マージリクエストは、次の方法で作成できます:

- GitLab UIの場合
- コマンドラインで、[`glab mr`](https://gitlab.com/gitlab-org/cli/-/tree/main/docs/source/mr)コマンドを使用するか、Gitコマンドと[プッシュオプション](../../../topics/git/commit.md#push-options)を組み合わせて使用します。
- [Visual Studio Code拡張機能](../../../editor_extensions/visual_studio_code/_index.md)。
- メールを送信します
- [マージリクエストAPI](../../../api/merge_requests.md)。

マージリクエストを作成すると、GitLabによってプロジェクトのブランチ命名規則が適用されます。マージリクエストをブランチに接続するには、ブランチの命名パターンに従ってください。詳しくは[ブランチに名前を付ける](../repository/branches/_index.md#name-your-branch)をご覧ください。

## マージリクエストリストから {#from-the-merge-request-list}

マージリクエストのリストからマージリクエストを作成できます。

1. 左側のサイドバーで、**検索または移動先**を選択して、GitLabプロジェクトを見つけます。
1. **コード** > **マージリクエスト**を選択します。
1. 右上隅で、**新しいマージリクエスト**を選択します。
1. ソースブランチとターゲットブランチを選択し、**ブランチを比較して続行する**を選択します。
1. **新しいマージリクエスト**ページのフィールドに必要事項を入力し、**マージリクエストを作成**を選択します。

各ブランチを関連付けることができるのは、1つのオープンなマージリクエストのみです。このブランチのマージリクエストがすでに存在する場合、既存のマージリクエストへのリンクが表示されます。

## イシューから {#from-an-issue}

開発ワークフローで、すべてのマージリクエストにイシューが必要な場合、イシューから直接ブランチを作成することでスピードアップできます。新しいブランチと、後でそのマージリクエストは、このイシューに関連付けられているというマークが付きます。[イシューの自動完了が無効](../issues/managing_issues.md#disable-automatic-issue-closing)になっていない限り、マージリクエストをマージすると、イシューが自動的に完了します:

ブランチとマージリクエストを同時に作成するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **Plan** > **イシュー**を選択して、イシューを見つけます。
1. イシューの説明の一番下まで移動します。
1. **マージリクエストを作成** > **マージリクエストとブランチを作成**を選択します。
1. ダイアログで、提案されたブランチ名をレビューします。これは、プロジェクトの[ブランチ名テンプレート](../repository/branches/_index.md)に基づいています。
1. オプション。ブランチ名がすでに使用されている場合、または別のブランチ名が必要な場合は、名前を変更します。
1. ソースブランチまたはタグを選択します。
1. **マージリクエストを作成**を選択します。

## タスクから {#from-a-task}

{{< history >}}

- GitLab 17.8で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/477785)されました。

{{< /history >}}

チームがイシューをタスクに分割する場合、タスクから直接ブランチを作成して、プロセスをスピードアップできます。新しいブランチと、後でそのマージリクエストは、このタスクに関連付けられているというマークが付きます。[イシューの自動完了が無効](../issues/managing_issues.md#disable-automatic-issue-closing)になっていない限り、マージリクエストをマージすると、タスクが自動的に完了します:

前提要件:

- ロールが、タスクを含むプロジェクトのデベロッパー以上である必要があります。

ブランチとマージリクエストを同時に作成するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **Plan** > **イシュー**を選択します。
1. イシューリストで、タスクを見つけます。
1. タスクの説明の一番下まで移動します。
1. **マージリクエストを作成**を選択します。
1. ダイアログで、提案されたブランチ名をレビューします。これは、プロジェクトの[ブランチ名テンプレート](../repository/branches/_index.md)に基づいています。
1. オプション。ブランチ名がすでに使用されている場合、または別のブランチ名が必要な場合は、名前を変更します。
1. ソースブランチまたはタグを選択します。
1. **マージリクエストを作成**を選択します。

Gitリポジトリが空の場合、GitLabは以下を実行します:

- デフォルトブランチを作成します。
- 空白の`README.md`ファイルをコミットします。
- イシューのタイトルに基づいて新規のブランチを作成し、リダイレクトします。
- プロジェクトがKubernetesなどのデプロイサービスで設定されている場合、GitLabは`.gitlab-ci.yml`ファイルの作成を支援し、[自動デプロイ](../../../topics/autodevops/stages.md#auto-deploy)を設定するよう求めるプロンプトを表示します。

作成するブランチの名前の[プレフィックス](../repository/branches/_index.md#prefix-branch-names-with-a-number)がタスク番号である場合、GitLabはイシューとマージリクエストをクロスリンクし、[完了パターン](../issues/managing_issues.md#closing-issues-automatically)をマージリクエストの説明に追加します。ほとんどの場合、これは`Closes #ID`のようになります。ここで、`ID`はタスクのIDです。プロジェクトがクローズパターンで設定されている場合、マージリクエストがマージされると、タスクはクローズされます。

## Webエディタから {#from-the-web-editor}

次の操作を行う場合、[Webエディタ](../repository/web_editor.md)を使用してマージリクエストを作成できます:

- ファイルを作成、編集、アップロード、または削除します。
- ディレクトリを作成する。

## ブランチを作成する場合 {#when-you-create-a-branch}

ブランチを作成する際、マージリクエストを作成できます。

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **コード** > **ブランチ**を選択します。
1. ブランチ名を入力して、**新しいブランチ**を選択します。
1. ファイルリストの上にある**マージリクエストを作成**を選択します。マージリクエストが作成されます。デフォルトブランチがターゲットです。
1. フィールドに入力し、**マージリクエストを作成**を選択します。

## フォークで作業する場合 {#when-you-work-in-a-fork}

フォークからマージリクエストを作成して、メインプロジェクトにコントリビュートできます。

1. 左側のサイドバーで、**検索または移動先**を選択して、フォークを見つけます。
1. **コード** > **マージリクエスト**を選択し、**新しいマージリクエスト**を選択します。
1. **ソースブランチ**に対しては、変更を含むフォーク内のブランチを選択します。
1. **ターゲットブランチ**の場合:

   1. フォークではなく、アップストリームリポジトリを選択します。変更を頻繁にアップストリームにコントリビュートする場合、フォークのデフォルトのターゲットブランチを設定することを検討してください。
   1. アップストリームリポジトリからブランチを選択します:

      ![ブランチの選択](img/forking_workflow_branch_select_v15_9.png)

   {{< alert type="note" >}}

   フォークの表示レベルの制限が親リポジトリよりも厳格な場合、ターゲットブランチはデフォルトでフォークのデフォルトブランチになります。これにより、フォーク内のプライベート情報が公開されることがなくなります。

   {{< /alert >}}

1. **ブランチを比較して続行する**を選択します。
1. **マージリクエストを作成**を選択します。マージリクエストは、フォークではなく、ターゲットリポジトリに作成されます。
1. デベロッパーロール以上の場合は、希望する担当者、レビュアー、ラベル、およびマイルストーンを追加します。
1. **Submit merge request**（マージリクエストを送信）を選択します。

マージリクエストが別のリポジトリをターゲットとする場合、次が使用されます:

- ターゲットプロジェクトの承認ルール。
- フォークのCI/CD設定、リソース、およびプロジェクトCI/CD変数。

アップストリームプロジェクトで[CI/CD](../../../ci/pipelines/merge_request_pipelines.md#use-with-forked-projects)パイプラインを実行するには、そのプロジェクトのメンバーである必要があります。フォークからのマージリクエストに対して親プロジェクトでマージリクエストパイプラインを実行すると、すべての変数がパイプラインで使用可能になります。

作業がマージされ、それ以上のコントリビューションを行う予定がない場合は、[フォークとそのアップストリームリポジトリとのリンクを解除します](../repository/forking_workflow.md#unlink-a-fork)。

### デフォルトのターゲットプロジェクトを設定する {#set-the-default-target-project}

デフォルトでは、フォークから送信されたマージリクエストは、フォークではなくアップストリームリポジトリをターゲットとします。アップストリームリポジトリではなく、フォークされたリポジトリをデフォルトのターゲットとして設定できます。

前提要件:

- フォークで作業している。
- ロールがデベロッパー以上か、プロジェクトでのマージリクエスト作成が許可されている。
- アップストリームリポジトリでマージリクエストを作成できる。
- フォークの[表示レベル設定](../../public_access.md#change-project-visibility)の厳格度が、アップストリームリポジトリ以下である。例: フォークがプライベートで、アップストリームがパブリックの場合、この設定は表示されません。

これを行うには、以下を実行します:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **設定** > **マージリクエスト**を選択します。
1. **ターゲットプロジェクト**セクションで、デフォルトのターゲットプロジェクトに使用するオプションを選択します。
1. **変更を保存**を選択します。

## メールを送信する {#by-sending-an-email}

メールメッセージをGitLabに送信することにより、マージリクエストを作成できます。マージリクエストのターゲットブランチは、リポジトリのデフォルトブランチです。

前提要件:

- マージリクエストが、アップストリームリポジトリではなく、現在のリポジトリをターゲットとしている。
- GitLab [管理者](../../../administration/incoming_email.md)が、受信メールを設定している。この設定はGitLab.comで有効になっています。
- GitLab [管理者](../../../administration/reply_by_email.md)が、メールによる返信を設定している。この設定はGitLab.comで有効になっています。
- ロールがデベロッパー以上か、プロジェクトでのマージリクエスト作成が許可されている。

メールを送信してマージリクエストを作成するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **コード** > **マージリクエスト**を選択します。
1. プロジェクトに**Email a new merge request to this project**（マージリクエスト）が含まれている場合は、このプロジェクトに新しいマージリクエストをメールで送信するを選択します。
1. ダイアログで、表示されているメールアドレスをコピーします。このアドレスをプライベートにしてください。それを持っている人は誰でも、本人になりすましたり、イシューとマージリクエストを作成したりできます。
1. メールを開き、次の情報を含むメッセージを作成します:

   - **To**は、コピーしたメールアドレスです。
   - **件名**は、ソースブランチ名です。
   - メールの本文は、マージリクエストの説明です。

1. コミットを追加するには、`.patch`ファイルをメッセージに添付します。
1. メールを送信します。

マージリクエストが作成されます。

### メールでマージリクエストを作成する際に添付ファイルを追加する {#add-attachments-when-creating-a-merge-request-by-email}

パッチをメールの添付ファイルとして追加することにより、マージリクエストにコミットを追加します。

- パッチの合計サイズは2 MB以下である必要があります。
- パッチと見なされるには、添付ファイルのファイル名の最後が`.patch`である必要があります。
- パッチは、名前順に処理されます。
- 件名からのソースブランチが存在しない場合、リポジトリの`HEAD`、またはデフォルトのターゲットブランチから作成されます。ターゲットブランチを手動で変更するには、`/target_branch`クイックアクションを使用します。
- ソースブランチがすでに存在する場合、パッチがその上に適用されます。

## 関連トピック {#related-topics}

- [マージリクエストAPI](../../../api/merge_requests.md)
- [クイックアクション](../quick_actions.md)

## トラブルシューティング {#troubleshooting}

### イシューでマージリクエストを作成するオプションがない {#no-option-to-create-a-merge-request-on-an-issue}

**マージリクエストを作成**オプションがイシューに表示されないのは、次のような場合です:

- 同じ名前のブランチがすでに存在する。
- このブランチのマージリクエストがすでに存在している。
- プロジェクトにアクティブなフォーク関係がある。
- プロジェクトがプライベートで、イシューが機密である。

このボタンを表示するために考えられる[回避策](../repository/forking_workflow.md#unlink-a-fork)の1つは、プロジェクトのフォーク関係を削除すること削除後、フォーク関係を復元することはできません。プロジェクトでは、ソースプロジェクト、またはその他のフォークとの間でマージリクエストを送受信できなくなります。

### メールメッセージを処理できませんでした {#email-message-could-not-be-processed}

マージリクエストを作成するためにメールを送信し、アップストリームリポジトリをターゲットにしようとすると、GitLabがこのエラーメッセージを返します:

```plaintext
Unfortunately, your email message to GitLab could not be processed.

You are not allowed to perform this action. If you believe this is in error, contact a staff member.
```
