---
stage: Create
group: Source Code
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: リポジトリのコミット履歴に関する情報を表示します。
title: コミット
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

**コミット**リストには、リポジトリのコミット履歴が表示されます。これを使用して、コードの変更を閲覧し、コミットの詳細を表示し、コミットの署名を確認します。コミットリストをGitリビジョンでフィルタリングして、特定のリビジョンの変更を確認できます。

リストには以下が表示されます:

- コミットハッシュ: 各コミットの固有識別子（SHA）です。
- コミットメッセージ: コミットのタイトルと説明です。
- 作成者: コミットを作成したユーザーの名前とアバターです。
- タイムスタンプ: コミットが作成された日時。
- パイプラインステータス: CI/CDパイプラインの結果（設定されている場合）。
- 署名の検証: GPG、SSH、またはX.509署名のステータス。
- タグ: このコミットを指すタグ。

![リポジトリのコミットリストの例](img/repository_commits_list_v18_2.png)

## コミットを表示 {#view-commits}

リポジトリのコミット履歴を表示するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **コード** > **コミット**を選択します。

コミットの概要を表示するには、**コミットの説明の切り替え**アイコン（{{< icon name="ellipsis_h">}}）を選択します。この概要には、ファイルの変更や統計は表示されません。

## コミットの詳細を表示 {#view-commit-details}

ファイルの修正、追加、削除など、コミットで行われた特定の変更を調べます。

コミットの詳細を表示するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **コード** > **コミット**を選択します。
1. コミットを選択して、コミットの詳細ページを開きます。

コミットの詳細ページには、以下が表示されます:

- コミット情報: コミットハッシュ、作成者、コミッター、親コミット、タイムスタンプ。
- コミットメッセージ: コミットのタイトルと説明です。
- ファイルの変更: 差分ビューですべての変更されたファイル。
- 統計: 変更、追加、削除された行数。
- パイプラインの詳細: 関連付けられたCI/CDパイプラインのステータスと詳細。
- 参照: このコミットを含むブランチとタグ。
- 関連するマージリクエスト: コミットに関連付けられたマージリクエストへのリンク。

## Gitリビジョンでリポジトリファイルを参照 {#browse-repository-files-by-git-revision}

コミットSHA、ブランチ名、タグなど、特定のGitリビジョンにおけるすべてのリポジトリファイルとフォルダーを表示するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **コード** > **コミット**を選択します。
1. 次のいずれかのオプションを選択します:
   - Gitリビジョンでフィルター:
      1. 上部で選択して、**Gitリビジョンの選択**ドロップダウンリストを開きます。
      1. Gitリビジョンを選択または検索します。
   - コミットリストから特定のコミットを選択します。
1. 右上にある**ファイルを参照**を選択します。

特定のバージョンで、その[リポジトリ](../_index.md)ページに移動します。

## コミットをフィルタリングして検索 {#filter-and-search-commits}

コミット履歴をフィルタリングおよび検索して、特定の変更を見つけたり、特定の作成者による作業を追跡したりします。

### 作成者でフィルター {#filter-by-author}

特定の作成者でコミットをフィルタリングするには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **コード** > **コミット**を選択します。
1. **作成者**ドロップダウンリストで、作成者の名前またはユーザー名を選択または検索します。

作成者のフィルタリングが特殊文字を含む名前で機能しない場合は、URLパラメータ形式を使用します。たとえば、`?author=Elliot%20Stevens`をURLに追加します。

### Gitリビジョンでフィルター {#filter-by-git-revision}

ブランチ、タグ、コミットSHAなど、Gitリビジョンでコミットを絞り込むには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **コード** > **コミット**を選択します。
1. ドロップダウンリストで、Gitリビジョンを選択または検索します。たとえば、ブランチ名、タグ、またはコミットSHAです。
1. Gitリビジョンを選択して、フィルタリングされたコミットのリストを表示します。

### コミットメッセージで検索 {#search-by-commit-message}

メッセージの内容でコミットを検索するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **コード** > **コミット**を選択します。
1. **メッセージで検索**フィールドに、検索用語を入力します。

コミットSHA（全部または一部）で検索して、特定のコミットを直接見つけることもできます。

## コミットをチェリーピックする {#cherry-pick-a-commit}

特定のコミットからの変更を別のコミットに適用します。

前提要件: 

- プロジェクトのデベロッパーロール以上を持っている必要があります。
- ターゲットブランチが存在する必要があります。

コミットをcherry-pickするには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **コード** > **コミット**を選択します。
1. cherry-pickするコミットを選択します。
1. 右上隅で、**オプション**を選択し、次に**cherry-pick**を選択します。
1. ダイアログで:
   - ドロップダウンリストから、ターゲットプロジェクトとブランチを選択します。
   - オプション。**Start a new merge request**（新しいマージリクエストを開始）を選択して、変更を加えてマージリクエストを作成します。
   - **cherry-pick**を選択します。

GitLabは、チェリーピックされた変更を含むターゲットブランチに新しいコミットを作成します。ブランチが[保護](../branches/protected.md)されている場合、または正しい権限がない場合、GitLabは[新しいマージリクエストを作成](../../merge_requests/_index.md#create-a-merge-request)するように求めます。

## コミットをリバートする {#revert-a-commit}

前のコミットからの変更を元に戻す新しいコミットを作成します。

前提要件: 

- プロジェクトのデベロッパーロール以上を持っている必要があります。

コミットをrevertするには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **コード** > **コミット**を選択します。
1. Revertするコミットを選択します。
1. 右上隅で**オプション**を選択し、次に**revert**を選択します。
1. ダイアログで:
   - Revertコミットのターゲットブランチを選択します。
   - オプション。**Start a new merge request**（新しいマージリクエストを開始）を選択して、マージリクエストを作成します。
   - **revert**を選択します。

GitLabは、選択したコミットからの変更を反転する新しいコミットを作成します。ブランチが[保護](../branches/protected.md)されている場合、または正しい権限がない場合、GitLabは[新しいマージリクエストを作成](../../merge_requests/_index.md#create-a-merge-request)するように求めます。

## コミットの内容をダウンロード {#download-commit-contents}

コミットの差分の内容をダウンロードするには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **コード** > **コミット**を選択します。
1. ダウンロードするコミットを選択します。
1. 右上隅で、**オプション**を選択します。
1. **ダウンロード**で、**テキスト差分**を選択します。

## コミット署名を確認 {#verify-commit-signatures}

GitLabは、GPG、SSH、およびX.509署名を検証して、コミットの真正性を確認します。検証済みのコミットには、**検証済み**バッジが表示されます。

詳細については、[署名されたコミット](../signed_commits/_index.md)を参照してください。

### 署名の詳細を表示 {#view-signature-details}

署名情報を表示するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **コード** > **コミット**を選択します。
1. **検証済み**または**未検証**のバッジが付いたコミットを探します。
1. バッジを選択して、以下を含む署名の詳細を表示します:
   - 署名の種類（GPG、SSH、またはX.509）
   - キーのフィンガープリント
   - 検証ステータス
   - 署名者のID

## パイプラインのステータスと詳細を表示 {#view-pipeline-status-and-details}

コミットリストには、各コミットの横にCI/CDパイプラインステータスアイコンが含まれています。パイプラインの詳細を表示するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **コード** > **コミット**を選択します。
1. 任意のコミットの横にあるパイプラインステータスアイコンを選択します。

## 関連トピック {#related-topics}

- [署名済みコミット](../signed_commits/_index.md)
- [リビジョンを比較する](../compare_revisions.md)
- [Git file history](../files/git_history.md)
- [タグ](../tags/_index.md)
