---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token Google (GCP) service account'
---

## Description

The response body contains content that matches the pattern of a GCP service account was identified. Service accounts can be assigned a wide range of permissions or access. A malicious actor with access to the service account can potentially compromise the entire GCP account or have limited access to resources, depending on the access granted.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet).

To revoke the GCP Service account:

- Sign in to your GCP account and go to <https://console.cloud.google.com/iam-admin/serviceaccounts>
- Select the correct project from the list (if given a choice)
- Find the key ID and the associated service account in the "Service accounts" table
- Select the kebab menu (vertical ellipsis) for the identified key and select "Manage keys"
- Select the trash icon next to the identified key

For more information, please see [Googles documentation on creating service account keys](https://cloud.google.com/iam/docs/keys-create-delete).

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.139 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
