/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.inspection.StructuralSearchProfileActionProvider;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.StructuralSearchUsageTarget;
import com.intellij.usages.ConfigurableUsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.jetbrains.annotations.NotNull;

public class UsageViewContext {
    @NotNull
    protected final SearchContext mySearchContext;
    @NotNull
    protected final Configuration myConfiguration;
    @NotNull
    private final ConfigurableUsageTarget myTarget;
    protected UsageView myUsageView;

    protected UsageViewContext(@NotNull Configuration configuration, @NotNull SearchContext searchContext, @NotNull Runnable searchStarter) {
        if (configuration == null) {
            UsageViewContext.$$$reportNull$$$0(0);
        }
        if (searchContext == null) {
            UsageViewContext.$$$reportNull$$$0(1);
        }
        if (searchStarter == null) {
            UsageViewContext.$$$reportNull$$$0(2);
        }
        this.myConfiguration = configuration;
        this.mySearchContext = searchContext;
        this.myTarget = new StructuralSearchUsageTarget(configuration, searchContext, searchStarter);
    }

    public void setUsageView(@NotNull UsageView usageView) {
        if (usageView == null) {
            UsageViewContext.$$$reportNull$$$0(3);
        }
        this.myUsageView = usageView;
        MessageBusConnection connection = this.mySearchContext.getProject().getMessageBus().connect((Disposable)usageView);
        connection.subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(0);
                }
                UsageViewContext.this.myUsageView.close();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/structuralsearch/plugin/ui/UsageViewContext$1", "beforePluginUnload"));
            }
        });
    }

    @NotNull
    public ConfigurableUsageTarget getTarget() {
        ConfigurableUsageTarget configurableUsageTarget = this.myTarget;
        if (configurableUsageTarget == null) {
            UsageViewContext.$$$reportNull$$$0(4);
        }
        return configurableUsageTarget;
    }

    public void configure(@NotNull UsageViewPresentation presentation) {
        if (presentation == null) {
            UsageViewContext.$$$reportNull$$$0(5);
        }
        String pattern = this.myConfiguration.getMatchOptions().getSearchPattern();
        SearchScope scope = this.myConfiguration.getMatchOptions().getScope();
        assert (scope != null);
        String scopeText = scope.getDisplayName();
        presentation.setScopeText(scopeText);
        String usagesString = SSRBundle.message("occurrences.of", pattern);
        presentation.setUsagesString(usagesString);
        presentation.setTabText(StringUtil.shortenTextWithEllipsis((String)usagesString, (int)60, (int)0, (boolean)false));
        presentation.setCodeUsagesString(SSRBundle.message("found.occurrences", scopeText));
        presentation.setTargetsNodeText(SSRBundle.message("targets.node.text", new Object[0]));
        presentation.setCodeUsages(false);
        presentation.setUsageTypeFilteringAvailable(true);
    }

    protected void configureActions() {
        this.myUsageView.addButtonToLowerPane((Action)new AbstractAction(SSRBundle.message("create.inspection.from.template.action.text", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                StructuralSearchProfileActionProvider.createNewInspection(UsageViewContext.this.myConfiguration.copy(), UsageViewContext.this.mySearchContext.getProject());
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchStarter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageView";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/UsageViewContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/UsageViewContext";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setUsageView";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "configure";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

