/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.AbstractExternalDependency;
import org.jetbrains.plugins.gradle.model.DefaultExternalLibraryDependency;
import org.jetbrains.plugins.gradle.model.DefaultExternalProjectDependency;
import org.jetbrains.plugins.gradle.model.DefaultFileCollectionDependency;
import org.jetbrains.plugins.gradle.model.DefaultUnresolvedExternalDependency;
import org.jetbrains.plugins.gradle.model.ExternalDependency;
import org.jetbrains.plugins.gradle.model.ExternalLibraryDependency;
import org.jetbrains.plugins.gradle.model.ExternalProjectDependency;
import org.jetbrains.plugins.gradle.model.FileCollectionDependency;
import org.jetbrains.plugins.gradle.model.UnresolvedExternalDependency;

public final class ModelFactory {
    @NotNull
    public static ExternalDependency createCopy(@NotNull ExternalDependency dependency) {
        AbstractExternalDependency newDep;
        if (dependency == null) {
            ModelFactory.$$$reportNull$$$0(0);
        }
        if (dependency instanceof ExternalProjectDependency) {
            newDep = new DefaultExternalProjectDependency((ExternalProjectDependency)dependency);
        } else if (dependency instanceof ExternalLibraryDependency) {
            newDep = new DefaultExternalLibraryDependency((ExternalLibraryDependency)dependency);
        } else if (dependency instanceof FileCollectionDependency) {
            newDep = new DefaultFileCollectionDependency((FileCollectionDependency)dependency);
        } else if (dependency instanceof UnresolvedExternalDependency) {
            newDep = new DefaultUnresolvedExternalDependency((UnresolvedExternalDependency)dependency);
        } else {
            throw new AssertionError((Object)("unknown dependency object which implements: " + Arrays.toString(dependency.getClass().getInterfaces())));
        }
        DefaultExternalProjectDependency defaultExternalProjectDependency = newDep;
        if (defaultExternalProjectDependency == null) {
            ModelFactory.$$$reportNull$$$0(1);
        }
        return defaultExternalProjectDependency;
    }

    @NotNull
    public static Collection<ExternalDependency> createCopy(@Nullable Collection<? extends ExternalDependency> dependencies) {
        if (dependencies == null) {
            return new ArrayList<ExternalDependency>(0);
        }
        ArrayList<ExternalDependency> result = new ArrayList<ExternalDependency>(dependencies.size());
        for (ExternalDependency externalDependency : dependencies) {
            result.add(ModelFactory.createCopy(externalDependency));
        }
        ArrayList<ExternalDependency> arrayList = result;
        if (arrayList == null) {
            ModelFactory.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/model/ModelFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/model/ModelFactory";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createCopy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createCopy";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

