/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.i18n.GitBundle;
import git4idea.util.GitUIUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class GitReferenceValidator {
    private boolean myLastResult;
    private String myLastResultText = null;
    private final Project myProject;
    private final JComboBox myGitRoot;
    private final JTextField myTextField;
    private final JButton myButton;

    public GitReferenceValidator(final Project project, JComboBox gitRoot, JTextField textField, JButton button2, final Runnable statusChanged) {
        this.myProject = project;
        this.myGitRoot = gitRoot;
        this.myTextField = textField;
        this.myButton = button2;
        this.myGitRoot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitReferenceValidator.this.myLastResult = false;
                GitReferenceValidator.this.myLastResultText = null;
            }
        });
        this.myTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                GitReferenceValidator.this.myButton.setEnabled(!GitReferenceValidator.this.myTextField.getText().trim().isEmpty());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "git4idea/ui/GitReferenceValidator$2", "textChanged"));
            }
        });
        this.myButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String revisionExpression;
                GitReferenceValidator.this.myLastResultText = revisionExpression = GitReferenceValidator.this.myTextField.getText();
                GitReferenceValidator.this.myLastResult = false;
                try {
                    GitRevisionNumber revision = (GitRevisionNumber)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> GitRevisionNumber.resolve(GitReferenceValidator.this.myProject, GitReferenceValidator.this.gitRoot(), revisionExpression), GitBundle.message("progress.title.validating.revision", new Object[0]), true, project);
                    GitUtil.showSubmittedFiles(GitReferenceValidator.this.myProject, revision.asString(), GitReferenceValidator.this.gitRoot(), false, false);
                    GitReferenceValidator.this.myLastResult = true;
                }
                catch (VcsException ex) {
                    GitUIUtil.showOperationError(GitReferenceValidator.this.myProject, ex, GitBundle.message("operation.name.validating.revision.0", revisionExpression));
                }
                if (statusChanged != null) {
                    statusChanged.run();
                }
            }
        });
        this.myButton.setEnabled(!this.myTextField.getText().isEmpty());
    }

    public boolean isInvalid() {
        String revisionExpression = this.myTextField.getText();
        return revisionExpression.equals(this.myLastResultText) && !this.myLastResult;
    }

    private VirtualFile gitRoot() {
        return (VirtualFile)this.myGitRoot.getSelectedItem();
    }
}

