/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.keycloak.protocol.oid4vc.model.CredentialSubject;
import org.keycloak.util.JsonSerialization;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class VerifiableCredential {
    public static final String VC_CONTEXT_V1 = "https://www.w3.org/ns/credentials/v1";
    public static final String VC_CONTEXT_V2 = "https://www.w3.org/ns/credentials/v2";
    @JsonProperty(value="@context")
    private List<String> context = new ArrayList<String>(List.of("https://www.w3.org/ns/credentials/v1"));
    private List<String> type = new ArrayList<String>();
    @JsonDeserialize(using=IssuerDeserializer.class)
    private Object issuer;
    private Instant issuanceDate;
    private URI id;
    private Instant expirationDate;
    private CredentialSubject credentialSubject = new CredentialSubject();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public VerifiableCredential setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    public VerifiableCredential setAdditionalProperties(String name, Object property) {
        this.additionalProperties.put(name, property);
        return this;
    }

    public List<String> getContext() {
        return this.context;
    }

    public VerifiableCredential setContext(List<String> context) {
        this.context = context;
        return this;
    }

    public List<String> getType() {
        return this.type;
    }

    public VerifiableCredential setType(List<String> type) {
        this.type = type;
        return this;
    }

    public Object getIssuer() {
        return this.issuer;
    }

    public VerifiableCredential setIssuer(Object issuer) {
        if (issuer instanceof Map) {
            Map issuerMap = (Map)issuer;
            Optional.ofNullable(issuerMap).ifPresent(map -> {
                String id = (String)Optional.ofNullable(map.get("id")).orElseThrow(() -> new IllegalArgumentException("id is a required field for issuer"));
                try {
                    new URI(id);
                }
                catch (URISyntaxException e) {
                    throw new IllegalStateException("id must be a valid URI", e);
                }
            });
            this.issuer = issuerMap;
        } else {
            try {
                this.issuer = new URI(String.valueOf(issuer));
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException("id must be a valid URI", e);
            }
        }
        return this;
    }

    public VerifiableCredential setIssuerMap(Map<String, String> issuer) {
        this.issuer = issuer;
        return this;
    }

    public Instant getIssuanceDate() {
        return this.issuanceDate;
    }

    public VerifiableCredential setIssuanceDate(Instant issuanceDate) {
        this.issuanceDate = issuanceDate;
        return this;
    }

    public URI getId() {
        return this.id;
    }

    public VerifiableCredential setId(URI id) {
        this.id = id;
        return this;
    }

    public Instant getExpirationDate() {
        return this.expirationDate;
    }

    public VerifiableCredential setExpirationDate(Instant expirationDate) {
        this.expirationDate = expirationDate;
        return this;
    }

    public CredentialSubject getCredentialSubject() {
        return this.credentialSubject;
    }

    public VerifiableCredential setCredentialSubject(CredentialSubject credentialSubject) {
        this.credentialSubject = credentialSubject;
        return this;
    }

    public static class IssuerDeserializer
    extends JsonDeserializer<Object> {
        public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)p.readValueAsTree();
            if (node instanceof TextNode) {
                try {
                    return new URI(node.textValue());
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
            if (node instanceof ObjectNode) {
                ObjectNode objectNode = (ObjectNode)node;
                return JsonSerialization.mapper.convertValue((Object)objectNode, Map.class);
            }
            throw new IllegalArgumentException("Issuer must be a valid URI or a JSON object");
        }
    }
}

