/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.uuid;

import java.security.SecureRandom;
import java.time.Instant;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.hibernate.Internal;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.UUIDGenerationStrategy;
import org.hibernate.id.uuid.UuidValueGenerator;

public class UuidVersion7Strategy
implements UUIDGenerationStrategy,
UuidValueGenerator {
    private static final long MAX_RANDOM_SEQUENCE = 0x3FFFFFFFFFFFFFFFL;
    public static final UuidVersion7Strategy INSTANCE = new UuidVersion7Strategy();
    private final AtomicReference<State> lastState;

    @Internal
    public UuidVersion7Strategy() {
        this(Instant.EPOCH, Long.MIN_VALUE);
    }

    @Internal
    public UuidVersion7Strategy(Instant initialTimestamp, long initialSequence) {
        this.lastState = new AtomicReference<State>(new State(initialTimestamp, initialSequence));
    }

    @Override
    public int getGeneratedVersion() {
        return 7;
    }

    @Override
    public UUID generateUUID(SharedSessionContractImplementor session) {
        return this.generateUuid(session);
    }

    @Override
    public UUID generateUuid(SharedSessionContractImplementor session) {
        State state = this.lastState.updateAndGet(State::getNextState);
        return new UUID(state.millis() << 16 & 0xFFFFFFFFFFFF0000L | 0x7000L | state.nanos() & 0xFFFL, Long.MIN_VALUE | state.lastSequence);
    }

    public record State(Instant lastTimestamp, long lastSequence, long nanos) {
        State(Instant lastTimestamp, long lastSequence) {
            this(lastTimestamp, lastSequence, State.nanos(lastTimestamp));
        }

        public long millis() {
            return this.lastTimestamp.toEpochMilli();
        }

        private static long nanos(Instant timestamp) {
            return (long)((double)((long)timestamp.getNano() % 1000000L) * 0.004096);
        }

        public State getNextState() {
            Instant now = Instant.now();
            if (this.lastTimestamp.toEpochMilli() < now.toEpochMilli() || this.lastTimestamp.toEpochMilli() == now.toEpochMilli() && this.nanos < State.nanos(now)) {
                return new State(now, State.randomSequence());
            }
            long nextSequence = this.lastSequence + Holder.numberGenerator.nextLong(0xFFFFFFFFL);
            if (nextSequence > 0x3FFFFFFFFFFFFFFFL) {
                return new State(this.lastTimestamp.plusNanos(250L), State.randomSequence());
            }
            return new State(this.lastTimestamp, nextSequence);
        }

        private static long randomSequence() {
            return Holder.numberGenerator.nextLong(0x3FFFFFFFFFFFFFFFL);
        }
    }

    @Internal
    public static class Holder {
        private static final SecureRandom numberGenerator = new SecureRandom();
    }
}

