/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.functional;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.functional.AbstractWriteManyCommand;
import org.infinispan.commands.functional.Mutation;
import org.infinispan.commands.functional.Mutations;
import org.infinispan.commands.functional.functions.InjectableComponent;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.context.InvocationContext;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.impl.Params;

public final class ReadWriteManyEntriesCommand<K, V, T, R>
extends AbstractWriteManyCommand<K, V> {
    public static final byte COMMAND_ID = 53;
    private Map<?, ?> arguments;
    private BiFunction<T, EntryView.ReadWriteEntryView<K, V>, R> f;
    boolean isForwarded = false;

    public ReadWriteManyEntriesCommand(Map<?, ?> arguments, BiFunction<T, EntryView.ReadWriteEntryView<K, V>, R> f, Params params, CommandInvocationId commandInvocationId, DataConversion keyDataConversion, DataConversion valueDataConversion) {
        super(commandInvocationId, params, keyDataConversion, valueDataConversion);
        this.arguments = arguments;
        this.f = f;
    }

    public ReadWriteManyEntriesCommand(ReadWriteManyEntriesCommand command) {
        super(command);
        this.arguments = command.arguments;
        this.f = command.f;
    }

    public ReadWriteManyEntriesCommand() {
    }

    @Override
    public void init(ComponentRegistry componentRegistry) {
        super.init(componentRegistry);
        if (this.f instanceof InjectableComponent) {
            ((InjectableComponent)((Object)this.f)).inject(componentRegistry);
        }
    }

    public BiFunction<T, EntryView.ReadWriteEntryView<K, V>, R> getBiFunction() {
        return this.f;
    }

    public Map<?, ?> getArguments() {
        return this.arguments;
    }

    public void setArguments(Map<?, ?> arguments) {
        this.arguments = arguments;
        this.internalMetadataMap.keySet().retainAll(arguments.keySet());
    }

    public final ReadWriteManyEntriesCommand<K, V, T, R> withArguments(Map<?, ?> entries) {
        this.setArguments(entries);
        return this;
    }

    @Override
    public byte getCommandId() {
        return 53;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        CommandInvocationId.writeTo(output, this.commandInvocationId);
        MarshallUtil.marshallMap(this.arguments, (ObjectOutput)output);
        output.writeObject(this.f);
        output.writeBoolean(this.isForwarded);
        Params.writeObject(output, this.params);
        output.writeInt(this.topologyId);
        output.writeLong(this.flags);
        DataConversion.writeTo(output, this.keyDataConversion);
        DataConversion.writeTo(output, this.valueDataConversion);
        MarshallUtil.marshallMap((Map)this.internalMetadataMap, (ObjectOutput)output);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.commandInvocationId = CommandInvocationId.readFrom(input);
        this.arguments = MarshallUtil.unmarshallMap((ObjectInput)input, LinkedHashMap::new);
        this.f = (BiFunction)input.readObject();
        this.isForwarded = input.readBoolean();
        this.params = Params.readObject(input);
        this.topologyId = input.readInt();
        this.flags = input.readLong();
        this.keyDataConversion = DataConversion.readFrom(input);
        this.valueDataConversion = DataConversion.readFrom(input);
        this.internalMetadataMap = MarshallUtil.unmarshallMap((ObjectInput)input, ConcurrentHashMap::new);
    }

    @Override
    public boolean isForwarded() {
        return this.isForwarded;
    }

    @Override
    public void setForwarded(boolean forwarded) {
        this.isForwarded = forwarded;
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitReadWriteManyEntriesCommand(ctx, this);
    }

    @Override
    public boolean isSuccessful() {
        return true;
    }

    @Override
    public boolean isConditional() {
        return false;
    }

    @Override
    public Collection<?> getAffectedKeys() {
        return this.arguments.keySet();
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        return VisitableCommand.LoadType.OWNER;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ReadWriteManyEntriesCommand{");
        sb.append("arguments=").append(this.arguments);
        sb.append(", f=").append(this.f.getClass().getName());
        sb.append(", isForwarded=").append(this.isForwarded);
        sb.append(", keyDataConversion=").append(this.keyDataConversion);
        sb.append(", valueDataConversion=").append(this.valueDataConversion);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public Collection<?> getKeysToLock() {
        return this.arguments.keySet();
    }

    @Override
    public Mutation<K, V, ?> toMutation(Object key) {
        return new Mutations.ReadWriteWithValue<K, V, T, R>(this.keyDataConversion, this.valueDataConversion, this.arguments.get(key), this.f);
    }
}

