/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;

public class AnalyzedTokenReadingsTest {
    @Test
    public void testNewTags() {
        AnalyzedTokenReadings tokenReadings = new AnalyzedTokenReadings(new AnalyzedToken("word", "POS", "lemma"));
        Assert.assertEquals((Object)false, (Object)tokenReadings.isLinebreak());
        Assert.assertEquals((Object)false, (Object)tokenReadings.isSentenceEnd());
        Assert.assertEquals((Object)false, (Object)tokenReadings.isParagraphEnd());
        Assert.assertEquals((Object)false, (Object)tokenReadings.isSentenceStart());
        tokenReadings.setSentEnd();
        Assert.assertEquals((Object)false, (Object)tokenReadings.isSentenceStart());
        Assert.assertEquals((Object)true, (Object)tokenReadings.isSentenceEnd());
        tokenReadings = new AnalyzedTokenReadings(new AnalyzedToken("word", null, "lemma"));
        tokenReadings.addReading(new AnalyzedToken("word", "SENT_END", null), "");
        Assert.assertEquals((Object)true, (Object)tokenReadings.isSentenceEnd());
        Assert.assertEquals((Object)false, (Object)tokenReadings.isParagraphEnd());
        tokenReadings.addReading(new AnalyzedToken("word", "PARA_END", null), "");
        Assert.assertEquals((Object)true, (Object)tokenReadings.isParagraphEnd());
        Assert.assertEquals((Object)false, (Object)tokenReadings.isSentenceStart());
        tokenReadings.addReading(new AnalyzedToken("word", "SENT_START", null), "");
        Assert.assertEquals((Object)false, (Object)tokenReadings.isSentenceStart());
        AnalyzedToken aTok = new AnalyzedToken("word", "POS", "lemma");
        aTok.setWhitespaceBefore(true);
        tokenReadings = new AnalyzedTokenReadings(aTok);
        Assert.assertEquals((Object)aTok, (Object)tokenReadings.getAnalyzedToken(0));
        AnalyzedToken aTok2 = new AnalyzedToken("word", "POS", "lemma");
        Assert.assertTrue((!aTok2.equals((Object)tokenReadings.getAnalyzedToken(0)) ? 1 : 0) != 0);
        AnalyzedToken aTok3 = new AnalyzedToken("word", "POS", "lemma");
        aTok3.setWhitespaceBefore(true);
        Assert.assertEquals((Object)aTok3, (Object)tokenReadings.getAnalyzedToken(0));
        AnalyzedTokenReadings testReadings = new AnalyzedTokenReadings(aTok3);
        testReadings.removeReading(aTok3, "");
        Assert.assertTrue((testReadings.getReadingsLength() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"word", (Object)testReadings.getToken());
        Assert.assertTrue((!testReadings.hasPosTag("POS") ? 1 : 0) != 0);
        testReadings.leaveReading(aTok2);
        Assert.assertEquals((Object)"word", (Object)testReadings.getToken());
        Assert.assertTrue((!testReadings.hasPosTag("POS") ? 1 : 0) != 0);
        testReadings.removeReading(aTok2, "");
        Assert.assertEquals((Object)"word", (Object)testReadings.getToken());
        Assert.assertTrue((!testReadings.hasPosTag("POS") ? 1 : 0) != 0);
    }

    @Test
    public void testToString() {
        AnalyzedTokenReadings tokenReadings = new AnalyzedTokenReadings(new AnalyzedToken("word", "POS", "lemma"));
        Assert.assertEquals((Object)"word[lemma/POS*]", (Object)tokenReadings.toString());
        AnalyzedToken aTok2 = new AnalyzedToken("word", "POS2", "lemma2");
        tokenReadings.addReading(aTok2, "");
        Assert.assertEquals((Object)"word[lemma/POS*,lemma2/POS2*]", (Object)tokenReadings.toString());
    }

    @Test
    public void testHasPosTag() {
        AnalyzedTokenReadings tokenReadings = new AnalyzedTokenReadings(new AnalyzedToken("word", "POS:FOO:BAR", "lemma"));
        Assert.assertTrue((boolean)tokenReadings.hasPosTag("POS:FOO:BAR"));
        Assert.assertFalse((boolean)tokenReadings.hasPosTag("POS:FOO:bar"));
        Assert.assertFalse((boolean)tokenReadings.hasPosTag("POS:FOO"));
        Assert.assertFalse((boolean)tokenReadings.hasPosTag("xaz"));
    }

    @Test
    public void testHasPartialPosTag() {
        AnalyzedTokenReadings tokenReadings = new AnalyzedTokenReadings(new AnalyzedToken("word", "POS:FOO:BAR", "lemma"));
        Assert.assertTrue((boolean)tokenReadings.hasPartialPosTag("POS:FOO:BAR"));
        Assert.assertTrue((boolean)tokenReadings.hasPartialPosTag("POS:FOO:"));
        Assert.assertTrue((boolean)tokenReadings.hasPartialPosTag("POS:FOO"));
        Assert.assertTrue((boolean)tokenReadings.hasPartialPosTag(":FOO:"));
        Assert.assertTrue((boolean)tokenReadings.hasPartialPosTag("FOO:BAR"));
        Assert.assertFalse((boolean)tokenReadings.hasPartialPosTag("POS:FOO:BARX"));
        Assert.assertFalse((boolean)tokenReadings.hasPartialPosTag("POS:foo:BAR"));
        Assert.assertFalse((boolean)tokenReadings.hasPartialPosTag("xaz"));
    }

    @Test
    public void testMatchesPosTagRegex() {
        AnalyzedTokenReadings tokenReadings = new AnalyzedTokenReadings(new AnalyzedToken("word", "POS:FOO:BAR", "lemma"));
        Assert.assertTrue((boolean)tokenReadings.matchesPosTagRegex("POS:FOO:BAR"));
        Assert.assertTrue((boolean)tokenReadings.matchesPosTagRegex("POS:...:BAR"));
        Assert.assertTrue((boolean)tokenReadings.matchesPosTagRegex("POS:[A-Z]+:BAR"));
        Assert.assertFalse((boolean)tokenReadings.matchesPosTagRegex("POS:[AB]OO:BAR"));
        Assert.assertFalse((boolean)tokenReadings.matchesPosTagRegex("POS:FOO:BARX"));
    }

    @Test
    public void testIteration() {
        AnalyzedTokenReadings tokenReadings = new AnalyzedTokenReadings(Arrays.asList(new AnalyzedToken("word1", null, null), new AnalyzedToken("word2", null, null)), 0);
        int i = 0;
        for (AnalyzedToken tokenReading : tokenReadings) {
            if (i == 0) {
                Assert.assertThat((Object)tokenReading.getToken(), (Matcher)CoreMatchers.is((Object)"word1"));
            } else if (i == 1) {
                Assert.assertThat((Object)tokenReading.getToken(), (Matcher)CoreMatchers.is((Object)"word2"));
            } else {
                Assert.fail();
            }
            ++i;
        }
    }
}

