/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.painless.ir;

import org.objectweb.asm.Label;
import org.opensearch.painless.ClassWriter;
import org.opensearch.painless.Location;
import org.opensearch.painless.MethodWriter;
import org.opensearch.painless.ir.LoopNode;
import org.opensearch.painless.phase.IRTreeVisitor;
import org.opensearch.painless.symbol.WriteScope;

public class DoWhileLoopNode
extends LoopNode {
    @Override
    public <Scope> void visit(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        irTreeVisitor.visitDoWhileLoop(this, scope);
    }

    @Override
    public <Scope> void visitChildren(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        this.getBlockNode().visit(irTreeVisitor, scope);
        if (this.getConditionNode() != null) {
            this.getConditionNode().visit(irTreeVisitor, scope);
        }
    }

    public DoWhileLoopNode(Location location) {
        super(location);
    }

    @Override
    protected void write(ClassWriter classWriter, MethodWriter methodWriter, WriteScope writeScope) {
        WriteScope.Variable loop;
        methodWriter.writeStatementOffset(this.getLocation());
        writeScope = writeScope.newScope();
        Label start = new Label();
        Label begin = new Label();
        Label end = new Label();
        methodWriter.mark(start);
        this.getBlockNode().continueLabel = begin;
        this.getBlockNode().breakLabel = end;
        this.getBlockNode().write(classWriter, methodWriter, writeScope);
        methodWriter.mark(begin);
        if (!this.isContinuous()) {
            this.getConditionNode().write(classWriter, methodWriter, writeScope);
            methodWriter.ifZCmp(153, end);
        }
        if ((loop = writeScope.getInternalVariable("loop")) != null) {
            methodWriter.writeLoopCounter(loop.getSlot(), this.getLocation());
        }
        methodWriter.goTo(start);
        methodWriter.mark(end);
    }
}

