/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.buffer;

import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.math.MathUtil;
import org.locationtech.jts.noding.ScaledNoder;
import org.locationtech.jts.noding.snapround.MCIndexSnapRounder;
import org.locationtech.jts.operation.buffer.BufferBuilder;
import org.locationtech.jts.operation.buffer.BufferParameters;

public class BufferOp {
    public static final int CAP_ROUND = 1;
    public static final int CAP_BUTT = 2;
    public static final int CAP_FLAT = 2;
    public static final int CAP_SQUARE = 3;
    private static int MAX_PRECISION_DIGITS = 12;
    private Geometry argGeom;
    private double distance;
    private BufferParameters bufParams = new BufferParameters();
    private Geometry resultGeometry = null;
    private RuntimeException saveException;

    private static double precisionScaleFactor(Geometry g, double distance, int maxPrecisionDigits) {
        Envelope env = g.getEnvelopeInternal();
        double envMax = MathUtil.max(Math.abs(env.getMaxX()), Math.abs(env.getMaxY()), Math.abs(env.getMinX()), Math.abs(env.getMinY()));
        double expandByDistance = distance > 0.0 ? distance : 0.0;
        double bufEnvMax = envMax + 2.0 * expandByDistance;
        int bufEnvPrecisionDigits = (int)(Math.log(bufEnvMax) / Math.log(10.0) + 1.0);
        int minUnitLog10 = maxPrecisionDigits - bufEnvPrecisionDigits;
        double scaleFactor = Math.pow(10.0, minUnitLog10);
        return scaleFactor;
    }

    public static Geometry bufferOp(Geometry g, double distance) {
        BufferOp gBuf = new BufferOp(g);
        Geometry geomBuf = gBuf.getResultGeometry(distance);
        return geomBuf;
    }

    public static Geometry bufferOp(Geometry g, double distance, BufferParameters params) {
        BufferOp bufOp = new BufferOp(g, params);
        Geometry geomBuf = bufOp.getResultGeometry(distance);
        return geomBuf;
    }

    public static Geometry bufferOp(Geometry g, double distance, int quadrantSegments) {
        BufferOp bufOp = new BufferOp(g);
        bufOp.setQuadrantSegments(quadrantSegments);
        Geometry geomBuf = bufOp.getResultGeometry(distance);
        return geomBuf;
    }

    public static Geometry bufferOp(Geometry g, double distance, int quadrantSegments, int endCapStyle) {
        BufferOp bufOp = new BufferOp(g);
        bufOp.setQuadrantSegments(quadrantSegments);
        bufOp.setEndCapStyle(endCapStyle);
        Geometry geomBuf = bufOp.getResultGeometry(distance);
        return geomBuf;
    }

    public BufferOp(Geometry g) {
        this.argGeom = g;
    }

    public BufferOp(Geometry g, BufferParameters bufParams) {
        this.argGeom = g;
        this.bufParams = bufParams;
    }

    public void setEndCapStyle(int endCapStyle) {
        this.bufParams.setEndCapStyle(endCapStyle);
    }

    public void setQuadrantSegments(int quadrantSegments) {
        this.bufParams.setQuadrantSegments(quadrantSegments);
    }

    public Geometry getResultGeometry(double distance) {
        this.distance = distance;
        this.computeGeometry();
        return this.resultGeometry;
    }

    private void computeGeometry() {
        this.bufferOriginalPrecision();
        if (this.resultGeometry != null) {
            return;
        }
        PrecisionModel argPM = this.argGeom.getFactory().getPrecisionModel();
        if (argPM.getType() == PrecisionModel.FIXED) {
            this.bufferFixedPrecision(argPM);
        } else {
            this.bufferReducedPrecision();
        }
    }

    private void bufferReducedPrecision() {
        for (int precDigits = MAX_PRECISION_DIGITS; precDigits >= 0; --precDigits) {
            try {
                this.bufferReducedPrecision(precDigits);
            }
            catch (TopologyException ex) {
                this.saveException = ex;
            }
            if (this.resultGeometry == null) continue;
            return;
        }
        throw this.saveException;
    }

    private void bufferOriginalPrecision() {
        try {
            BufferBuilder bufBuilder = new BufferBuilder(this.bufParams);
            this.resultGeometry = bufBuilder.buffer(this.argGeom, this.distance);
        }
        catch (RuntimeException ex) {
            this.saveException = ex;
        }
    }

    private void bufferReducedPrecision(int precisionDigits) {
        double sizeBasedScaleFactor = BufferOp.precisionScaleFactor(this.argGeom, this.distance, precisionDigits);
        PrecisionModel fixedPM = new PrecisionModel(sizeBasedScaleFactor);
        this.bufferFixedPrecision(fixedPM);
    }

    private void bufferFixedPrecision(PrecisionModel fixedPM) {
        ScaledNoder noder = new ScaledNoder(new MCIndexSnapRounder(new PrecisionModel(1.0)), fixedPM.getScale());
        BufferBuilder bufBuilder = new BufferBuilder(this.bufParams);
        bufBuilder.setWorkingPrecisionModel(fixedPM);
        bufBuilder.setNoder(noder);
        this.resultGeometry = bufBuilder.buffer(this.argGeom, this.distance);
    }
}

