/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.task;

import com.amazon.randomcutforest.RandomCutForest;
import com.amazon.randomcutforest.parkservices.ThresholdedRandomCutForest;
import com.google.common.collect.ImmutableList;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ad.constant.ADCommonMessages;
import org.opensearch.ad.model.ADTask;
import org.opensearch.ad.model.ADTaskType;
import org.opensearch.ad.model.AnomalyDetector;
import org.opensearch.ad.settings.AnomalyDetectorSettings;
import org.opensearch.ad.task.ADBatchTaskCache;
import org.opensearch.ad.task.ADHCBatchTaskCache;
import org.opensearch.ad.task.ADHCBatchTaskRunState;
import org.opensearch.ad.task.ADTaskCancellationState;
import org.opensearch.ad.task.ADTaskSlotLimit;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.timeseries.MemoryTracker;
import org.opensearch.timeseries.common.exception.DuplicateTaskException;
import org.opensearch.timeseries.common.exception.LimitExceededException;
import org.opensearch.timeseries.model.Entity;
import org.opensearch.timeseries.task.TaskCacheManager;
import org.opensearch.timeseries.util.ParseUtils;

public class ADTaskCacheManager
extends TaskCacheManager {
    private final Logger logger = LogManager.getLogger(ADTaskCacheManager.class);
    private volatile Integer maxAdBatchTaskPerNode;
    private final MemoryTracker memoryTracker;
    private final int numberSize = 8;
    public static final int TASK_RETRY_LIMIT = 3;
    private final Semaphore cleanExpiredHCBatchTaskRunStatesSemaphore;
    private Map<String, String> detectorTasks;
    private Map<String, ADHCBatchTaskCache> hcBatchTaskCaches;
    private Map<String, ADTaskSlotLimit> detectorTaskSlotLimit;
    private final Map<String, ADBatchTaskCache> batchTaskCaches;
    private Map<String, Map<String, ADHCBatchTaskRunState>> hcBatchTaskRunState;

    public ADTaskCacheManager(Settings settings, ClusterService clusterService, MemoryTracker memoryTracker) {
        super(settings, clusterService);
        this.maxAdBatchTaskPerNode = (Integer)AnomalyDetectorSettings.MAX_BATCH_TASK_PER_NODE.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AnomalyDetectorSettings.MAX_BATCH_TASK_PER_NODE, it -> {
            this.maxAdBatchTaskPerNode = it;
        });
        this.batchTaskCaches = new ConcurrentHashMap<String, ADBatchTaskCache>();
        this.memoryTracker = memoryTracker;
        this.detectorTasks = new ConcurrentHashMap<String, String>();
        this.hcBatchTaskCaches = new ConcurrentHashMap<String, ADHCBatchTaskCache>();
        this.detectorTaskSlotLimit = new ConcurrentHashMap<String, ADTaskSlotLimit>();
        this.hcBatchTaskRunState = new ConcurrentHashMap<String, Map<String, ADHCBatchTaskRunState>>();
        this.cleanExpiredHCBatchTaskRunStatesSemaphore = new Semaphore(1);
    }

    public synchronized void add(ADTask adTask) {
        ADHCBatchTaskRunState hcBatchTaskRunState;
        String taskId = adTask.getTaskId();
        String detectorId = adTask.getConfigId();
        if (this.contains(taskId)) {
            throw new DuplicateTaskException(ADCommonMessages.DETECTOR_IS_RUNNING);
        }
        if (!adTask.isHistoricalEntityTask() && this.containsTaskOfDetector(detectorId)) {
            throw new DuplicateTaskException(ADCommonMessages.DETECTOR_IS_RUNNING);
        }
        this.checkRunningTaskLimit();
        long neededCacheSize = this.calculateADTaskCacheSize(adTask);
        if (!this.memoryTracker.canAllocateReserved(neededCacheSize)) {
            throw new LimitExceededException("Not enough memory to run detector");
        }
        this.memoryTracker.consumeMemory(neededCacheSize, true, MemoryTracker.Origin.HISTORICAL_SINGLE_ENTITY_DETECTOR);
        ADBatchTaskCache taskCache = new ADBatchTaskCache(adTask);
        taskCache.getCacheMemorySize().set(neededCacheSize);
        this.batchTaskCaches.put(taskId, taskCache);
        if (adTask.isHistoricalEntityTask() && (hcBatchTaskRunState = this.getHCBatchTaskRunState(detectorId, adTask.getConfigLevelTaskId())) != null) {
            hcBatchTaskRunState.setLastTaskRunTimeInMillis(Instant.now().toEpochMilli());
        }
        this.cleanExpiredHCBatchTaskRunStates();
    }

    public synchronized void add(String detectorId, ADTask adTask) {
        if (this.detectorTasks.containsKey(detectorId)) {
            this.logger.warn("detector is already in running detector cache, detectorId: " + detectorId);
            throw new DuplicateTaskException(ADCommonMessages.DETECTOR_IS_RUNNING);
        }
        this.logger.info("add detector in running detector cache, detectorId: {}, taskId: {}", (Object)detectorId, (Object)adTask.getTaskId());
        this.detectorTasks.put(detectorId, adTask.getTaskId());
        if (ADTaskType.HISTORICAL_HC_DETECTOR.name().equals(adTask.getTaskType())) {
            ADHCBatchTaskCache adhcBatchTaskCache = new ADHCBatchTaskCache();
            this.hcBatchTaskCaches.put(detectorId, adhcBatchTaskCache);
        }
        this.hcBatchTaskRunState.remove(detectorId);
    }

    public void checkRunningTaskLimit() {
        if (this.size() >= this.maxAdBatchTaskPerNode) {
            String error = ADCommonMessages.EXCEED_HISTORICAL_ANALYSIS_LIMIT + ": " + this.maxAdBatchTaskPerNode;
            throw new LimitExceededException(error);
        }
    }

    public ThresholdedRandomCutForest getTRcfModel(String taskId) {
        return this.getBatchTaskCache(taskId).getTRcfModel();
    }

    public int getThresholdModelTrainingDataSize(String taskId) {
        return this.getBatchTaskCache(taskId).getThresholdModelTrainingDataSize().get();
    }

    public boolean isThresholdModelTrained(String taskId) {
        return this.getBatchTaskCache(taskId).isThresholdModelTrained();
    }

    protected void setThresholdModelTrained(String taskId, boolean trained) {
        ADBatchTaskCache taskCache = this.getBatchTaskCache(taskId);
        taskCache.setThresholdModelTrained(trained);
    }

    public boolean contains(String taskId) {
        return this.batchTaskCaches.containsKey(taskId);
    }

    public boolean containsTaskOfDetector(String detectorId) {
        return this.batchTaskCaches.values().stream().filter(v -> Objects.equals(detectorId, v.getId())).findAny().isPresent();
    }

    public List<String> getTasksOfDetector(String detectorId) {
        return this.batchTaskCaches.values().stream().filter(v -> Objects.equals(detectorId, v.getId())).map(c -> c.getTaskId()).collect(Collectors.toList());
    }

    private ADBatchTaskCache getBatchTaskCache(String taskId) {
        if (!this.contains(taskId)) {
            throw new IllegalArgumentException("AD task not in cache");
        }
        return this.batchTaskCaches.get(taskId);
    }

    private List<ADBatchTaskCache> getBatchTaskCacheByDetectorId(String detectorId) {
        return this.batchTaskCaches.values().stream().filter(v -> Objects.equals(detectorId, v.getId())).collect(Collectors.toList());
    }

    private long calculateADTaskCacheSize(ADTask adTask) {
        AnomalyDetector detector = adTask.getDetector();
        int dimension = detector.getEnabledFeatureIds().size() * detector.getShingleSize();
        return this.memoryTracker.estimateTRCFModelSize(dimension, 50, 1.0, detector.getShingleSize(), 256);
    }

    public long getModelSize(String taskId) {
        ADBatchTaskCache batchTaskCache = this.getBatchTaskCache(taskId);
        ThresholdedRandomCutForest tRCF = batchTaskCache.getTRcfModel();
        RandomCutForest rcfForest = tRCF.getForest();
        int dimensions = rcfForest.getDimensions();
        int numberOfTrees = rcfForest.getNumberOfTrees();
        return this.memoryTracker.estimateTRCFModelSize(dimensions, numberOfTrees, 1.0, 1, 256);
    }

    public void remove(String taskId, String detectorId, String detectorTaskId) {
        ADBatchTaskCache taskCache = this.batchTaskCaches.get(taskId);
        if (taskCache != null) {
            this.logger.debug("Remove batch task from cache, task id: {}", (Object)taskId);
            this.memoryTracker.releaseMemory(taskCache.getCacheMemorySize().get(), true, MemoryTracker.Origin.HISTORICAL_SINGLE_ENTITY_DETECTOR);
            this.batchTaskCaches.remove(taskId);
            ADHCBatchTaskRunState hcBatchTaskRunState = this.getHCBatchTaskRunState(detectorId, detectorTaskId);
            if (hcBatchTaskRunState != null) {
                hcBatchTaskRunState.setLastTaskRunTimeInMillis(Instant.now().toEpochMilli());
            }
        }
    }

    public void removeHistoricalTaskCacheIfNoRunningEntity(String detectorId) {
        ADHCBatchTaskCache taskCache = this.hcBatchTaskCaches.get(detectorId);
        if (taskCache != null && taskCache.hasRunningEntity()) {
            throw new IllegalArgumentException("HC detector still has running entities");
        }
        this.removeHistoricalTaskCache(detectorId);
    }

    public void removeHistoricalTaskCache(String detectorId) {
        ADHCBatchTaskCache taskCache = this.hcBatchTaskCaches.get(detectorId);
        if (taskCache != null) {
            if (this.hasEntity(detectorId)) {
                this.logger.warn("There are still entities for detector. pending: {}, running: {}, temp: {}", (Object)Arrays.toString(taskCache.getPendingEntities()), (Object)Arrays.toString(taskCache.getRunningEntities()), (Object)Arrays.toString(taskCache.getTempEntities()));
            }
            taskCache.clear();
            this.hcBatchTaskCaches.remove(detectorId);
        }
        List<String> tasksOfDetector = this.getTasksOfDetector(detectorId);
        for (String taskId : tasksOfDetector) {
            this.remove(taskId, null, null);
        }
        if (tasksOfDetector.size() > 0) {
            this.logger.warn("Removed historical AD task from cache for detector {}, taskId: {}", (Object)detectorId, (Object)Arrays.toString(tasksOfDetector.toArray(new String[0])));
        }
        if (this.detectorTasks.containsKey(detectorId)) {
            this.detectorTasks.remove(detectorId);
            this.logger.info("Removed detector from AD task coordinating node cache, detectorId: " + detectorId);
        }
        this.detectorTaskSlotLimit.remove(detectorId);
        this.hcBatchTaskRunState.remove(detectorId);
    }

    public ADTaskCancellationState cancelByDetectorId(String detectorId, String detectorTaskId, String reason, String userName) {
        if (detectorId == null || detectorTaskId == null) {
            throw new IllegalArgumentException("Can't cancel task for null detector id or detector task id");
        }
        ADHCBatchTaskCache hcTaskCache = this.hcBatchTaskCaches.get(detectorId);
        List<ADBatchTaskCache> taskCaches = this.getBatchTaskCacheByDetectorId(detectorId);
        if (hcTaskCache != null) {
            this.logger.debug("Set HC historical analysis as cancelled for detector {}", (Object)detectorId);
            hcTaskCache.clearPendingEntities();
            hcTaskCache.setEntityTaskLanes(0);
        }
        ADHCBatchTaskRunState taskStateCache = this.getOrCreateHCDetectorTaskStateCache(detectorId, detectorTaskId);
        taskStateCache.setCancelledTimeInMillis(Instant.now().toEpochMilli());
        taskStateCache.setHistoricalAnalysisCancelled(true);
        taskStateCache.setCancelReason(reason);
        taskStateCache.setCancelledBy(userName);
        if (ParseUtils.isNullOrEmpty(taskCaches)) {
            return ADTaskCancellationState.NOT_FOUND;
        }
        ADTaskCancellationState cancellationState = ADTaskCancellationState.ALREADY_CANCELLED;
        for (ADBatchTaskCache cache : taskCaches) {
            if (cache.isCancelled()) continue;
            cancellationState = ADTaskCancellationState.CANCELLED;
            cache.cancel(reason, userName);
        }
        return cancellationState;
    }

    public boolean isCancelled(String taskId) {
        ADBatchTaskCache taskCache = this.getBatchTaskCache(taskId);
        String detectorId = taskCache.getId();
        String detectorTaskId = taskCache.getDetectorTaskId();
        ADHCBatchTaskRunState taskStateCache = this.getHCBatchTaskRunState(detectorId, detectorTaskId);
        boolean hcDetectorStopped = false;
        if (taskStateCache != null) {
            hcDetectorStopped = taskStateCache.getHistoricalAnalysisCancelled();
        }
        return taskCache.isCancelled() || hcDetectorStopped;
    }

    public int size() {
        return this.batchTaskCaches.size();
    }

    public void clear() {
        this.batchTaskCaches.clear();
        this.detectorTasks.clear();
    }

    public long trainingDataMemorySize(int size) {
        return 8 * size;
    }

    public synchronized boolean topEntityInited(String detectorId) {
        return this.hcBatchTaskCaches.containsKey(detectorId) ? this.hcBatchTaskCaches.get(detectorId).getTopEntitiesInited() : false;
    }

    public void setTopEntityInited(String detectorId) {
        this.getExistingHCTaskCache(detectorId).setTopEntitiesInited(true);
    }

    public int getPendingEntityCount(String detectorId) {
        return this.hcBatchTaskCaches.containsKey(detectorId) ? this.hcBatchTaskCaches.get(detectorId).getPendingEntityCount() : 0;
    }

    public int getRunningEntityCount(String detectorId) {
        ADHCBatchTaskCache taskCache = this.hcBatchTaskCaches.get(detectorId);
        if (taskCache != null) {
            return taskCache.getRunningEntityCount();
        }
        return 0;
    }

    public int getTempEntityCount(String detectorId) {
        ADHCBatchTaskCache taskCache = this.hcBatchTaskCaches.get(detectorId);
        if (taskCache != null) {
            return taskCache.getTempEntityCount();
        }
        return 0;
    }

    public Integer getTopEntityCount(String detectorId) {
        ADHCBatchTaskCache batchTaskCache = this.hcBatchTaskCaches.get(detectorId);
        if (batchTaskCache != null) {
            return batchTaskCache.getTopEntityCount();
        }
        return 0;
    }

    public List<String> getRunningEntities(String detectorId) {
        if (this.hcBatchTaskCaches.containsKey(detectorId)) {
            ADHCBatchTaskCache hcTaskCache = this.getExistingHCTaskCache(detectorId);
            return Arrays.asList(hcTaskCache.getRunningEntities());
        }
        return null;
    }

    public void setAllowedRunningEntities(String detectorId, int allowedRunningEntities) {
        this.logger.debug("Set allowed running entities of detector {} as {}", (Object)detectorId, (Object)allowedRunningEntities);
        this.getExistingHCTaskCache(detectorId).setEntityTaskLanes(allowedRunningEntities);
    }

    public synchronized void setDetectorTaskSlots(String detectorId, int taskSlots) {
        this.logger.debug("Set task slots of detector {} as {}", (Object)detectorId, (Object)taskSlots);
        ADTaskSlotLimit adTaskSlotLimit = this.detectorTaskSlotLimit.computeIfAbsent(detectorId, key -> new ADTaskSlotLimit(taskSlots, taskSlots));
        adTaskSlotLimit.setDetectorTaskSlots(taskSlots);
    }

    public synchronized void scaleUpDetectorTaskSlots(String detectorId, int delta) {
        ADTaskSlotLimit adTaskSlotLimit = this.detectorTaskSlotLimit.get(detectorId);
        int taskSlots = this.getDetectorTaskSlots(detectorId);
        if (adTaskSlotLimit != null && delta > 0) {
            int newTaskSlots = adTaskSlotLimit.getDetectorTaskSlots() + delta;
            this.logger.info("Scale up task slots of detector {} from {} to {}", (Object)detectorId, (Object)taskSlots, (Object)newTaskSlots);
            adTaskSlotLimit.setDetectorTaskSlots(newTaskSlots);
        }
    }

    public synchronized int scaleDownHCDetectorTaskSlots(String detectorId, int delta) {
        int newTaskSlots;
        ADTaskSlotLimit adTaskSlotLimit = this.detectorTaskSlotLimit.get(detectorId);
        int taskSlots = this.getDetectorTaskSlots(detectorId);
        if (adTaskSlotLimit != null && delta > 0 && (newTaskSlots = taskSlots - delta) > 0) {
            this.logger.info("Scale down task slots of detector {} from {} to {}", (Object)detectorId, (Object)taskSlots, (Object)newTaskSlots);
            adTaskSlotLimit.setDetectorTaskSlots(newTaskSlots);
            return newTaskSlots;
        }
        return taskSlots;
    }

    public synchronized void setDetectorTaskLaneLimit(String detectorId, int taskLaneLimit) {
        ADTaskSlotLimit adTaskSlotLimit = this.detectorTaskSlotLimit.get(detectorId);
        if (adTaskSlotLimit != null) {
            adTaskSlotLimit.setDetectorTaskLaneLimit(taskLaneLimit);
        }
    }

    public int getDetectorTaskSlots(String detectorId) {
        ADTaskSlotLimit taskSlotLimit = this.detectorTaskSlotLimit.get(detectorId);
        if (taskSlotLimit != null) {
            return taskSlotLimit.getDetectorTaskSlots();
        }
        return 0;
    }

    public int getUnfinishedEntityCount(String detectorId) {
        ADHCBatchTaskCache taskCache = this.hcBatchTaskCaches.get(detectorId);
        if (taskCache != null) {
            return taskCache.getUnfinishedEntityCount();
        }
        return 0;
    }

    public int getTotalDetectorTaskSlots() {
        int totalTaskSLots = 0;
        for (Map.Entry<String, ADTaskSlotLimit> entry : this.detectorTaskSlotLimit.entrySet()) {
            totalTaskSLots += entry.getValue().getDetectorTaskSlots().intValue();
        }
        return totalTaskSLots;
    }

    public int getTotalBatchTaskCount() {
        return this.batchTaskCaches.size();
    }

    public synchronized int getAndDecreaseEntityTaskLanes(String detectorId) {
        return this.getExistingHCTaskCache(detectorId).getAndDecreaseEntityTaskLanes();
    }

    public int getAvailableNewEntityTaskLanes(String detectorId) {
        return this.getExistingHCTaskCache(detectorId).getEntityTaskLanes();
    }

    private ADHCBatchTaskCache getExistingHCTaskCache(String detectorId) {
        ADHCBatchTaskCache taskCache = this.hcBatchTaskCaches.get(detectorId);
        if (taskCache != null) {
            return taskCache;
        }
        throw new IllegalArgumentException("Can't find HC detector in cache");
    }

    public void addPendingEntities(String detectorId, List<String> entities) {
        this.getExistingHCTaskCache(detectorId).addPendingEntities(entities);
    }

    public boolean isHCTaskRunning(String detectorId) {
        if (this.isHCTaskCoordinatingNode(detectorId)) {
            return true;
        }
        Optional<ADBatchTaskCache> entityTask = this.batchTaskCaches.values().stream().filter(cache -> Objects.equals(detectorId, cache.getId()) && cache.getEntity() != null).findFirst();
        return entityTask.isPresent();
    }

    public boolean isHCTaskCoordinatingNode(String detectorId) {
        return this.hcBatchTaskCaches.containsKey(detectorId);
    }

    public void setTopEntityCount(String detectorId, Integer count) {
        Integer detectorTaskSlots;
        ADHCBatchTaskCache hcTaskCache = this.getExistingHCTaskCache(detectorId);
        hcTaskCache.setTopEntityCount(count);
        ADTaskSlotLimit adTaskSlotLimit = this.detectorTaskSlotLimit.get(detectorId);
        if (count != null && adTaskSlotLimit != null && (detectorTaskSlots = adTaskSlotLimit.getDetectorTaskSlots()) != null && detectorTaskSlots > count) {
            this.logger.debug("Scale down task slots from {} to the same as top entity count {}", (Object)detectorTaskSlots, (Object)count);
            adTaskSlotLimit.setDetectorTaskSlots(count);
        }
    }

    public synchronized String pollEntity(String detectorId) {
        if (this.hcBatchTaskCaches.containsKey(detectorId)) {
            ADHCBatchTaskCache hcTaskCache = this.hcBatchTaskCaches.get(detectorId);
            String entity = hcTaskCache.pollEntity();
            return entity;
        }
        return null;
    }

    public void addPendingEntity(String detectorId, String entity) {
        this.addPendingEntities(detectorId, (List<String>)ImmutableList.of((Object)entity));
    }

    public void moveToRunningEntity(String detectorId, String entity) {
        ADHCBatchTaskCache hcTaskCache = this.hcBatchTaskCaches.get(detectorId);
        if (hcTaskCache != null) {
            hcTaskCache.moveToRunningEntity(entity);
        }
    }

    public boolean exceedRetryLimit(String detectorId, String taskId) {
        return this.getExistingHCTaskCache(detectorId).getTaskRetryTimes(taskId) > 3;
    }

    public void pushBackEntity(String taskId, String detectorId, String entity) {
        this.addPendingEntity(detectorId, entity);
        this.increaseEntityTaskRetry(detectorId, taskId);
    }

    public int increaseEntityTaskRetry(String detectorId, String taskId) {
        return this.getExistingHCTaskCache(detectorId).increaseTaskRetry(taskId);
    }

    public void removeEntity(String detectorId, String entity) {
        if (this.hcBatchTaskCaches.containsKey(detectorId)) {
            this.hcBatchTaskCaches.get(detectorId).removeEntity(entity);
        }
    }

    public Entity getEntity(String taskId) {
        return this.getBatchTaskCache(taskId).getEntity();
    }

    public synchronized boolean hasEntity(String detectorId) {
        return this.hcBatchTaskCaches.containsKey(detectorId) && this.hcBatchTaskCaches.get(detectorId).hasEntity();
    }

    public boolean removeRunningEntity(String detectorId, String entity) {
        ADHCBatchTaskCache hcTaskCache = this.hcBatchTaskCaches.get(detectorId);
        if (hcTaskCache != null) {
            boolean removed = hcTaskCache.removeRunningEntity(entity);
            this.logger.debug("Remove entity from running entities cache: {}: {}", (Object)entity, (Object)removed);
            return removed;
        }
        return false;
    }

    public boolean tryAcquireTaskUpdatingSemaphore(String detectorId, long timeoutInMillis) throws InterruptedException {
        ADHCBatchTaskCache taskCache = this.hcBatchTaskCaches.get(detectorId);
        if (taskCache != null) {
            return taskCache.tryAcquireTaskUpdatingSemaphore(timeoutInMillis);
        }
        return false;
    }

    public void releaseTaskUpdatingSemaphore(String detectorId) {
        ADHCBatchTaskCache taskCache = this.hcBatchTaskCaches.get(detectorId);
        if (taskCache != null) {
            taskCache.releaseTaskUpdatingSemaphore();
        }
    }

    public void clearPendingEntities(String detectorId) {
        ADHCBatchTaskCache taskCache = this.hcBatchTaskCaches.get(detectorId);
        if (taskCache != null) {
            taskCache.clearPendingEntities();
        }
    }

    public String getDetectorTaskId(String detectorId) {
        return this.detectorTasks.get(detectorId);
    }

    public Instant getLastScaleEntityTaskLaneTime(String detectorId) {
        ADHCBatchTaskCache taskCache = this.hcBatchTaskCaches.get(detectorId);
        if (taskCache != null) {
            return taskCache.getLastScaleEntityTaskSlotsTime();
        }
        return null;
    }

    public void refreshLastScaleEntityTaskLaneTime(String detectorId) {
        ADHCBatchTaskCache taskCache = this.hcBatchTaskCaches.get(detectorId);
        if (taskCache != null) {
            taskCache.setLastScaleEntityTaskSlotsTime(Instant.now());
        }
    }

    public Instant getLatestHCTaskRunTime(String detectorId) {
        ADHCBatchTaskCache taskCache = this.hcBatchTaskCaches.get(detectorId);
        if (taskCache != null) {
            return taskCache.getLatestTaskRunTime();
        }
        return null;
    }

    public void refreshLatestHCTaskRunTime(String detectorId) {
        ADHCBatchTaskCache taskCache = this.hcBatchTaskCaches.get(detectorId);
        if (taskCache != null) {
            taskCache.refreshLatestTaskRunTime();
        }
    }

    public synchronized void updateDetectorTaskState(String detectorId, String detectorTaskId, String newState) {
        ADHCBatchTaskRunState cache = this.getOrCreateHCDetectorTaskStateCache(detectorId, detectorTaskId);
        if (cache != null) {
            cache.setDetectorTaskState(newState);
            cache.setLastTaskRunTimeInMillis(Instant.now().toEpochMilli());
        }
    }

    public ADHCBatchTaskRunState getOrCreateHCDetectorTaskStateCache(String detectorId, String detectorTaskId) {
        Map states = this.hcBatchTaskRunState.computeIfAbsent(detectorId, it -> new ConcurrentHashMap());
        return states.computeIfAbsent(detectorTaskId, it -> new ADHCBatchTaskRunState());
    }

    public String getDetectorTaskState(String detectorId, String detectorTaskId) {
        ADHCBatchTaskRunState batchTaskRunStates = this.getHCBatchTaskRunState(detectorId, detectorTaskId);
        if (batchTaskRunStates != null) {
            return batchTaskRunStates.getDetectorTaskState();
        }
        return null;
    }

    public boolean detectorTaskStateExists(String detectorId, String detectorTaskId) {
        Map<String, ADHCBatchTaskRunState> taskStateCache = this.hcBatchTaskRunState.get(detectorId);
        return taskStateCache != null && taskStateCache.containsKey(detectorTaskId);
    }

    private ADHCBatchTaskRunState getHCBatchTaskRunState(String detectorId, String detectorTaskId) {
        if (detectorId == null || detectorTaskId == null) {
            return null;
        }
        Map<String, ADHCBatchTaskRunState> batchTaskRunStates = this.hcBatchTaskRunState.get(detectorId);
        if (batchTaskRunStates != null) {
            return batchTaskRunStates.get(detectorTaskId);
        }
        return null;
    }

    public boolean isHistoricalAnalysisCancelledForHC(String detectorId, String detectorTaskId) {
        ADHCBatchTaskRunState taskStateCache = this.getHCBatchTaskRunState(detectorId, detectorTaskId);
        if (taskStateCache != null) {
            return taskStateCache.getHistoricalAnalysisCancelled();
        }
        return false;
    }

    public String getCancelReason(String taskId) {
        return this.getBatchTaskCache(taskId).getCancelReason();
    }

    public String getCancelledBy(String taskId) {
        return this.getBatchTaskCache(taskId).getCancelledBy();
    }

    public String getCancelledByForHC(String detectorId, String detectorTaskId) {
        ADHCBatchTaskRunState taskCache = this.getHCBatchTaskRunState(detectorId, detectorTaskId);
        if (taskCache != null) {
            return taskCache.getCancelledBy();
        }
        return null;
    }

    public String getCancelReasonForHC(String detectorId, String detectorTaskId) {
        ADHCBatchTaskRunState taskCache = this.getHCBatchTaskRunState(detectorId, detectorTaskId);
        if (taskCache != null) {
            return taskCache.getCancelReason();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanExpiredHCBatchTaskRunStates() {
        if (!this.cleanExpiredHCBatchTaskRunStatesSemaphore.tryAcquire()) {
            return;
        }
        try {
            ArrayList<String> detectorIdOfEmptyStates = new ArrayList<String>();
            for (Map.Entry<String, Map<String, ADHCBatchTaskRunState>> detectorRunStates : this.hcBatchTaskRunState.entrySet()) {
                ArrayList<String> taskIdOfExpiredStates = new ArrayList<String>();
                String detectorId = detectorRunStates.getKey();
                boolean noRunningTask = ParseUtils.isNullOrEmpty(this.getTasksOfDetector(detectorId));
                Map<String, ADHCBatchTaskRunState> taskRunStates = detectorRunStates.getValue();
                if (taskRunStates == null) {
                    detectorIdOfEmptyStates.add(detectorId);
                    continue;
                }
                if (!noRunningTask) continue;
                for (Map.Entry<String, ADHCBatchTaskRunState> taskRunState : taskRunStates.entrySet()) {
                    ADHCBatchTaskRunState state = taskRunState.getValue();
                    if (state == null || !noRunningTask || !state.expired()) continue;
                    taskIdOfExpiredStates.add(taskRunState.getKey());
                }
                this.logger.debug("Remove expired HC batch task run states for these tasks: {}", (Object)Arrays.toString(taskIdOfExpiredStates.toArray(new String[0])));
                taskIdOfExpiredStates.forEach(id -> taskRunStates.remove(id));
                if (!taskRunStates.isEmpty()) continue;
                detectorIdOfEmptyStates.add(detectorId);
            }
            this.logger.debug("Remove empty HC batch task run states for these detectors : {}", (Object)Arrays.toString(detectorIdOfEmptyStates.toArray(new String[0])));
            detectorIdOfEmptyStates.forEach(id -> this.hcBatchTaskRunState.remove(id));
        }
        catch (Exception e) {
            this.logger.error("Failed to clean expired HC batch task run states", (Throwable)e);
        }
        finally {
            this.cleanExpiredHCBatchTaskRunStatesSemaphore.release();
        }
    }
}

