// Copyright Amazon.com Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
export { AlgorithmSuiteIdentifier, AlgorithmSuite, CommitmentPolicy, CommitmentPolicySuites, SignaturePolicy, SignaturePolicySuites, MessageFormat, NonCommittingAlgorithmSuiteIdentifier, CommittingAlgorithmSuiteIdentifier, } from './algorithm_suites';
export { WebCryptoAlgorithmSuite } from './web_crypto_algorithms';
export { NodeAlgorithmSuite } from './node_algorithms';
export * from './keyring';
export { KeyringTraceFlag } from './keyring_trace';
export { MultiKeyringNode, MultiKeyringWebCrypto, } from './multi_keyring';
export * from './materials_manager';
export { NodeEncryptionMaterial, NodeDecryptionMaterial, NodeBranchKeyMaterial, } from './cryptographic_material';
export { isValidCryptoKey, isCryptoKey, keyUsageForMaterial, subtleFunctionForMaterial, } from './cryptographic_material';
export { WebCryptoEncryptionMaterial, WebCryptoDecryptionMaterial, } from './cryptographic_material';
export { isEncryptionMaterial, isDecryptionMaterial, isBranchKeyMaterial, } from './cryptographic_material';
export { unwrapDataKey, wrapWithKeyObjectIfSupported, } from './cryptographic_material';
export { decorateCryptographicMaterial, decorateWebCryptoMaterial, } from './cryptographic_material';
export { SignatureKey, VerificationKey } from './signature_key';
export { EncryptedDataKey } from './encrypted_data_key';
export { immutableBaseClass, immutableClass, frozenClass, readOnlyProperty, } from './immutable_class';
export { needs } from './needs';
export { cloneMaterial } from './clone_cryptographic_material';
export * from './types';
export { NotSupported } from './error';
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvaW5kZXgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsb0VBQW9FO0FBQ3BFLHNDQUFzQztBQUV0QyxPQUFPLEVBQ0wsd0JBQXdCLEVBRXhCLGNBQWMsRUFhZCxnQkFBZ0IsRUFDaEIsc0JBQXNCLEVBQ3RCLGVBQWUsRUFDZixxQkFBcUIsRUFDckIsYUFBYSxFQUNiLHFDQUFxQyxFQUNyQyxrQ0FBa0MsR0FDbkMsTUFBTSxvQkFBb0IsQ0FBQTtBQUUzQixPQUFPLEVBQUUsdUJBQXVCLEVBQUUsTUFBTSx5QkFBeUIsQ0FBQTtBQUNqRSxPQUFPLEVBQUUsa0JBQWtCLEVBQUUsTUFBTSxtQkFBbUIsQ0FBQTtBQUV0RCxjQUFjLFdBQVcsQ0FBQTtBQUN6QixPQUFPLEVBQWdCLGdCQUFnQixFQUFFLE1BQU0saUJBQWlCLENBQUE7QUFDaEUsT0FBTyxFQUNMLGdCQUFnQixFQUNoQixxQkFBcUIsR0FFdEIsTUFBTSxpQkFBaUIsQ0FBQTtBQUN4QixjQUFjLHFCQUFxQixDQUFBO0FBRW5DLE9BQU8sRUFDTCxzQkFBc0IsRUFDdEIsc0JBQXNCLEVBQ3RCLHFCQUFxQixHQUN0QixNQUFNLDBCQUEwQixDQUFBO0FBQ2pDLE9BQU8sRUFDTCxnQkFBZ0IsRUFDaEIsV0FBVyxFQUNYLG1CQUFtQixFQUNuQix5QkFBeUIsR0FDMUIsTUFBTSwwQkFBMEIsQ0FBQTtBQUNqQyxPQUFPLEVBQ0wsMkJBQTJCLEVBQzNCLDJCQUEyQixHQUM1QixNQUFNLDBCQUEwQixDQUFBO0FBQ2pDLE9BQU8sRUFDTCxvQkFBb0IsRUFDcEIsb0JBQW9CLEVBQ3BCLG1CQUFtQixHQUNwQixNQUFNLDBCQUEwQixDQUFBO0FBQ2pDLE9BQU8sRUFDTCxhQUFhLEVBQ2IsNEJBQTRCLEdBQzdCLE1BQU0sMEJBQTBCLENBQUE7QUFDakMsT0FBTyxFQUVMLDZCQUE2QixFQUM3Qix5QkFBeUIsR0FFMUIsTUFBTSwwQkFBMEIsQ0FBQTtBQUNqQyxPQUFPLEVBQUUsWUFBWSxFQUFFLGVBQWUsRUFBRSxNQUFNLGlCQUFpQixDQUFBO0FBQy9ELE9BQU8sRUFBRSxnQkFBZ0IsRUFBcUIsTUFBTSxzQkFBc0IsQ0FBQTtBQUUxRSxPQUFPLEVBQ0wsa0JBQWtCLEVBQ2xCLGNBQWMsRUFDZCxXQUFXLEVBQ1gsZ0JBQWdCLEdBQ2pCLE1BQU0sbUJBQW1CLENBQUE7QUFFMUIsT0FBTyxFQUFFLEtBQUssRUFBRSxNQUFNLFNBQVMsQ0FBQTtBQUMvQixPQUFPLEVBQUUsYUFBYSxFQUFFLE1BQU0sZ0NBQWdDLENBQUE7QUFFOUQsY0FBYyxTQUFTLENBQUE7QUFDdkIsT0FBTyxFQUFFLFlBQVksRUFBRSxNQUFNLFNBQVMsQ0FBQSJ9