/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.provenance.primitives;

import com.oracle.labs.mlrg.olcut.provenance.PrimitiveProvenance;
import java.io.File;
import java.nio.file.Path;
import java.util.Objects;

public final class FileProvenance
implements PrimitiveProvenance<File> {
    private static final long serialVersionUID = 1L;
    private final String key;
    private final File value;

    public FileProvenance(String key, File value) {
        this.key = key;
        this.value = value.toPath().toAbsolutePath().normalize().toFile();
    }

    public FileProvenance(String key, Path value) {
        this.key = key;
        this.value = value.toAbsolutePath().normalize().toFile();
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public File getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileProvenance)) {
            return false;
        }
        FileProvenance that = (FileProvenance)o;
        return this.key.equals(that.key) && this.value.equals(that.value);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    public String toString() {
        return this.value.toString();
    }
}

