/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.memorycontainer.memory;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.common.inject.Inject;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.ml.common.memorycontainer.MLMemoryContainer;
import org.opensearch.ml.common.memorycontainer.MemoryType;
import org.opensearch.ml.common.settings.MLCommonsSettings;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.memorycontainer.memory.MLUpdateMemoryInput;
import org.opensearch.ml.common.transport.memorycontainer.memory.MLUpdateMemoryRequest;
import org.opensearch.ml.helper.MemoryContainerHelper;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class TransportUpdateMemoryAction
extends HandledTransportAction<ActionRequest, IndexResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(TransportUpdateMemoryAction.class);
    private final Client client;
    private final SdkClient sdkClient;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;
    private final MemoryContainerHelper memoryContainerHelper;

    @Inject
    public TransportUpdateMemoryAction(TransportService transportService, ActionFilters actionFilters, Client client, SdkClient sdkClient, MLFeatureEnabledSetting mlFeatureEnabledSetting, MemoryContainerHelper memoryContainerHelper) {
        super("cluster:admin/opensearch/ml/memory_containers/memory/update", transportService, actionFilters, MLUpdateMemoryRequest::new);
        this.client = client;
        this.sdkClient = sdkClient;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
        this.memoryContainerHelper = memoryContainerHelper;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<IndexResponse> actionListener) {
        if (!this.mlFeatureEnabledSetting.isAgenticMemoryEnabled()) {
            actionListener.onFailure((Exception)new OpenSearchStatusException(MLCommonsSettings.ML_COMMONS_AGENTIC_MEMORY_DISABLED_MESSAGE, RestStatus.FORBIDDEN, new Object[0]));
            return;
        }
        MLUpdateMemoryRequest updateRequest = MLUpdateMemoryRequest.fromActionRequest((ActionRequest)request);
        String memoryContainerId = updateRequest.getMemoryContainerId();
        MemoryType memoryType = updateRequest.getMemoryType();
        String memoryId = updateRequest.getMemoryId();
        String tenantId = updateRequest.getTenantId();
        this.memoryContainerHelper.getMemoryContainer(memoryContainerId, tenantId, (ActionListener<MLMemoryContainer>)ActionListener.wrap(container -> {
            User user = RestActionUtils.getUserContext(this.client);
            if (!this.memoryContainerHelper.checkMemoryContainerAccess(user, (MLMemoryContainer)container)) {
                actionListener.onFailure((Exception)new OpenSearchStatusException("User doesn't have permissions to update memories in this container", RestStatus.FORBIDDEN, new Object[0]));
                return;
            }
            String memoryIndexName = this.memoryContainerHelper.getMemoryIndexName((MLMemoryContainer)container, memoryType);
            if (memoryIndexName == null) {
                actionListener.onFailure((Exception)new OpenSearchStatusException("Memory index not found", RestStatus.NOT_FOUND, new Object[0]));
                return;
            }
            if (memoryIndexName.endsWith("-memory-history")) {
                actionListener.onFailure((Exception)new OpenSearchStatusException("Can't update memory history", RestStatus.NOT_FOUND, new Object[0]));
                return;
            }
            GetRequest getRequest = new GetRequest(memoryIndexName, memoryId);
            ActionListener getResponseActionListener = ActionListener.wrap(getResponse -> {
                if (!getResponse.isExists()) {
                    actionListener.onFailure((Exception)new OpenSearchStatusException("Memory not found", RestStatus.NOT_FOUND, new Object[0]));
                    return;
                }
                Map originalDoc = getResponse.getSourceAsMap();
                String ownerId = (String)originalDoc.get("owner_id");
                if (!this.memoryContainerHelper.checkMemoryAccess(user, ownerId)) {
                    actionListener.onFailure((Exception)new OpenSearchStatusException("User doesn't have permissions to update this memory", RestStatus.FORBIDDEN, new Object[0]));
                    return;
                }
                Map<String, Object> newDoc = this.constructNewDoc(updateRequest.getMlUpdateMemoryInput(), memoryType, originalDoc);
                IndexRequest indexRequest = new IndexRequest(memoryIndexName).id(memoryId).source(newDoc);
                indexRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                this.memoryContainerHelper.indexData(container.getConfiguration(), indexRequest, actionListener);
            }, arg_0 -> ((ActionListener)actionListener).onFailure(arg_0));
            this.memoryContainerHelper.getData(container.getConfiguration(), getRequest, (ActionListener<GetResponse>)getResponseActionListener);
        }, arg_0 -> actionListener.onFailure(arg_0)));
    }

    public Map<String, Object> constructNewDoc(MLUpdateMemoryInput input, MemoryType memoryType, Map<String, Object> originalDoc) {
        HashMap<String, Object> updateFields = new HashMap<String, Object>();
        updateFields.putAll(originalDoc);
        Map updateContent = input.getUpdateContent();
        if (memoryType != null) {
            switch (memoryType) {
                case SESSIONS: {
                    this.constructSessionMemUpdateFields(updateFields, updateContent);
                    break;
                }
                case WORKING: {
                    this.constructWorkingMemUpdateFields(updateFields, updateContent);
                    break;
                }
                case LONG_TERM: {
                    this.constructLongTermMemUpdateFields(updateFields, updateContent);
                    break;
                }
            }
        }
        updateFields.put("last_updated_time", Instant.now().toEpochMilli());
        return updateFields;
    }

    public Map<String, Object> constructSessionMemUpdateFields(Map<String, Object> updateFields, Map<String, Object> updateContent) {
        if (updateContent.containsKey("summary")) {
            updateFields.put("summary", updateContent.get("summary"));
        }
        if (updateContent.containsKey("metadata")) {
            updateFields.put("metadata", updateContent.get("metadata"));
        }
        if (updateContent.containsKey("agents")) {
            updateFields.put("agents", updateContent.get("agents"));
        }
        if (updateContent.containsKey("additional_info")) {
            updateFields.put("additional_info", updateContent.get("additional_info"));
        }
        return updateFields;
    }

    public Map<String, Object> constructWorkingMemUpdateFields(Map<String, Object> updateFields, Map<String, Object> updateContent) {
        if (updateContent.containsKey("messages")) {
            updateFields.put("messages", updateContent.get("messages"));
        }
        if (updateContent.containsKey("binary_data")) {
            updateFields.put("binary_data", updateContent.get("binary_data"));
        }
        if (updateContent.containsKey("structured_data")) {
            updateFields.put("structured_data", updateContent.get("structured_data"));
        }
        if (updateContent.containsKey("structured_data_blob")) {
            updateFields.put("structured_data_blob", updateContent.get("structured_data_blob"));
        }
        if (updateContent.containsKey("metadata")) {
            updateFields.put("metadata", updateContent.get("metadata"));
        }
        if (updateContent.containsKey("tags")) {
            updateFields.put("tags", updateContent.get("tags"));
        }
        return updateFields;
    }

    public Map<String, Object> constructLongTermMemUpdateFields(Map<String, Object> updateFields, Map<String, Object> updateContent) {
        if (updateContent.containsKey("memory")) {
            updateFields.put("memory", updateContent.get("memory"));
        }
        if (updateContent.containsKey("tags")) {
            updateFields.put("tags", updateContent.get("tags"));
        }
        return updateFields;
    }
}

