/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling.encryption.providers;

import com.amazonaws.services.dynamodbv2.datamodeling.encryption.EncryptionContext;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.materials.DecryptionMaterials;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.materials.EncryptionMaterials;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.providers.EncryptionMaterialsProvider;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.providers.store.ProviderStore;
import com.amazonaws.services.dynamodbv2.datamodeling.internal.TTLCache;
import com.amazonaws.services.dynamodbv2.datamodeling.internal.Utils;
import java.util.concurrent.TimeUnit;

public class CachingMostRecentProvider
implements EncryptionMaterialsProvider {
    private static final long INITIAL_VERSION = 0L;
    private static final String PROVIDER_CACHE_KEY_DELIM = "#";
    private static final int DEFAULT_CACHE_MAX_SIZE = 1000;
    private final long ttlInNanos;
    private final ProviderStore keystore;
    protected final String defaultMaterialName;
    private final TTLCache<EncryptionMaterialsProvider> providerCache;
    private final TTLCache<Long> versionCache;
    private final TTLCache.EntryLoader<Long> versionLoader = new TTLCache.EntryLoader<Long>(){

        @Override
        public Long load(String entryKey) {
            return CachingMostRecentProvider.this.keystore.getMaxVersion(entryKey);
        }
    };
    private final TTLCache.EntryLoader<EncryptionMaterialsProvider> providerLoader = new TTLCache.EntryLoader<EncryptionMaterialsProvider>(){

        @Override
        public EncryptionMaterialsProvider load(String entryKey) {
            String[] parts = entryKey.split(CachingMostRecentProvider.PROVIDER_CACHE_KEY_DELIM, 2);
            if (parts.length != 2) {
                throw new IllegalStateException("Invalid cache key for provider cache: " + entryKey);
            }
            return CachingMostRecentProvider.this.keystore.getProvider(parts[0], Long.parseLong(parts[1]));
        }
    };

    public CachingMostRecentProvider(ProviderStore keystore, String materialName, long ttlInMillis) {
        this(keystore, materialName, ttlInMillis, 1000);
    }

    public CachingMostRecentProvider(ProviderStore keystore, String materialName, long ttlInMillis, int maxCacheSize) {
        this.keystore = Utils.checkNotNull(keystore, "keystore must not be null");
        this.defaultMaterialName = materialName;
        this.ttlInNanos = TimeUnit.MILLISECONDS.toNanos(ttlInMillis);
        this.providerCache = new TTLCache<EncryptionMaterialsProvider>(maxCacheSize, ttlInMillis, this.providerLoader);
        this.versionCache = new TTLCache<Long>(maxCacheSize, ttlInMillis, this.versionLoader);
    }

    @Override
    public EncryptionMaterials getEncryptionMaterials(EncryptionContext context) {
        String materialName = this.getMaterialName(context);
        long currentVersion = this.versionCache.load(materialName);
        if (currentVersion < 0L) {
            String cacheKey = CachingMostRecentProvider.buildCacheKey(materialName, 0L);
            EncryptionMaterialsProvider newProvider = this.providerCache.load(cacheKey, s -> {
                String[] parts = s.split(PROVIDER_CACHE_KEY_DELIM, 2);
                if (parts.length != 2) {
                    throw new IllegalStateException("Invalid cache key for provider cache: " + s);
                }
                EncryptionMaterialsProvider provider = this.keystore.getOrCreate(parts[0], Long.parseLong(parts[1]));
                this.versionCache.put(materialName, 0L);
                return provider;
            });
            return newProvider.getEncryptionMaterials(context);
        }
        String cacheKey = CachingMostRecentProvider.buildCacheKey(materialName, currentVersion);
        return this.providerCache.load(cacheKey).getEncryptionMaterials(context);
    }

    @Override
    public DecryptionMaterials getDecryptionMaterials(EncryptionContext context) {
        long version = this.keystore.getVersionFromMaterialDescription(context.getMaterialDescription());
        String materialName = this.getMaterialName(context);
        String cacheKey = CachingMostRecentProvider.buildCacheKey(materialName, version);
        EncryptionMaterialsProvider provider = this.providerCache.load(cacheKey);
        return provider.getDecryptionMaterials(context);
    }

    @Override
    public void refresh() {
        this.versionCache.clear();
        this.providerCache.clear();
    }

    public String getMaterialName() {
        return this.defaultMaterialName;
    }

    public long getTtlInMills() {
        return TimeUnit.NANOSECONDS.toMillis(this.ttlInNanos);
    }

    public long getCurrentVersion() {
        return this.versionCache.load(this.getMaterialName());
    }

    public long getLastUpdated() {
        if (this.versionCache.load(this.getMaterialName()) < 0L) {
            return 0L;
        }
        return TimeUnit.NANOSECONDS.toMillis(this.versionCache.getLastUpdated(this.getMaterialName()));
    }

    protected String getMaterialName(EncryptionContext context) {
        return this.defaultMaterialName;
    }

    private static String buildCacheKey(String materialName, long version) {
        StringBuilder result = new StringBuilder(materialName);
        result.append(PROVIDER_CACHE_KEY_DELIM);
        result.append(version);
        return result.toString();
    }
}

