/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.tree;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.store.IPointStoreView;
import com.amazon.randomcutforest.tree.AbstractNodeStore;
import com.amazon.randomcutforest.tree.BoundingBox;
import com.amazon.randomcutforest.tree.IBoundingBoxView;
import com.amazon.randomcutforest.tree.INodeView;
import java.util.HashMap;

public class NodeView
implements INodeView {
    AbstractNodeStore nodeStore;
    int currentNodeOffset;
    float[] leafPoint;
    IPointStoreView<float[]> pointStoreView;
    BoundingBox currentBox;

    public NodeView(AbstractNodeStore nodeStore, IPointStoreView<float[]> pointStoreView, int root) {
        this.currentNodeOffset = root;
        this.pointStoreView = pointStoreView;
        this.nodeStore = nodeStore;
    }

    @Override
    public int getMass() {
        return this.nodeStore.getMass(this.currentNodeOffset);
    }

    @Override
    public IBoundingBoxView getBoundingBox() {
        if (this.currentBox == null) {
            return this.nodeStore.getBox(this.currentNodeOffset);
        }
        return this.currentBox;
    }

    @Override
    public IBoundingBoxView getSiblingBoundingBox(float[] point) {
        return this.toLeft(point) ? this.nodeStore.getRightBox(this.currentNodeOffset) : this.nodeStore.getLeftBox(this.currentNodeOffset);
    }

    @Override
    public int getCutDimension() {
        return this.nodeStore.getCutDimension(this.currentNodeOffset);
    }

    @Override
    public double getCutValue() {
        return this.nodeStore.getCutValue(this.currentNodeOffset);
    }

    @Override
    public float[] getLeafPoint() {
        return this.leafPoint;
    }

    @Override
    public HashMap<Long, Integer> getSequenceIndexes() {
        CommonUtils.checkState(this.isLeaf(), "can only be invoked for a leaf");
        if (this.nodeStore.storeSequenceIndexesEnabled) {
            return this.nodeStore.sequenceMap.get(this.nodeStore.getPointIndex(this.currentNodeOffset));
        }
        return new HashMap<Long, Integer>();
    }

    @Override
    public double probailityOfSeparation(float[] point) {
        return this.nodeStore.probabilityOfCut(this.currentNodeOffset, point, this.pointStoreView, this.currentBox);
    }

    @Override
    public int getLeafPointIndex() {
        CommonUtils.checkState(this.isLeaf(), "cannot invoke 'getLeafPointIndex' from a non-leaf node");
        return this.nodeStore.getPointIndex(this.currentNodeOffset);
    }

    @Override
    public boolean isLeaf() {
        return this.nodeStore.isLeaf(this.currentNodeOffset);
    }

    protected void setCurrentNode(int newNode, int index, boolean setBox) {
        this.currentNodeOffset = newNode;
        this.leafPoint = this.pointStoreView.get(index);
        if (setBox && this.nodeStore.boundingboxCacheFraction < AbstractNodeStore.SWITCH_FRACTION) {
            this.currentBox = new BoundingBox(this.leafPoint, this.leafPoint);
        }
    }

    protected void setCurrentNodeOnly(int newNode) {
        this.currentNodeOffset = newNode;
    }

    public void updateToParent(int parent, int currentSibling, boolean updateBox) {
        this.currentNodeOffset = parent;
        if (updateBox && this.nodeStore.boundingboxCacheFraction < AbstractNodeStore.SWITCH_FRACTION) {
            this.nodeStore.growNodeBox(this.currentBox, this.pointStoreView, parent, currentSibling);
        }
    }

    protected boolean toLeft(float[] point) {
        return (double)point[this.nodeStore.getCutDimension(this.currentNodeOffset)] <= this.nodeStore.getCutValue(this.currentNodeOffset);
    }
}

