/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.util;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.ingest.IngestService;
import org.opensearch.ingest.PipelineConfiguration;
import org.opensearch.search.pipeline.SearchPipelineService;

public class PipelineServiceUtil {
    @Generated
    private static final Logger log = LogManager.getLogger(PipelineServiceUtil.class);
    private ClusterService clusterService;

    public PipelineServiceUtil(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    public List<Map<String, Object>> getSearchPipelineConfigs() {
        List<Map<String, Object>> pipelineConfigs = this.getSearchPipelines().stream().map(org.opensearch.search.pipeline.PipelineConfiguration::getConfigAsMap).collect(Collectors.toList());
        return pipelineConfigs;
    }

    public List<Map<String, Object>> getIngestPipelineConfigs() {
        List<Map<String, Object>> pipelineConfigs = this.getIngestPipelines().stream().map(PipelineConfiguration::getConfigAsMap).collect(Collectors.toList());
        return pipelineConfigs;
    }

    @VisibleForTesting
    protected List<PipelineConfiguration> getIngestPipelines() {
        return IngestService.getPipelines((ClusterState)this.clusterService.state(), (String[])new String[0]);
    }

    @VisibleForTesting
    protected List<org.opensearch.search.pipeline.PipelineConfiguration> getSearchPipelines() {
        return SearchPipelineService.getPipelines((ClusterState)this.clusterService.state(), (String[])new String[0]);
    }
}

