/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.folding;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementTypes;
import org.jetbrains.yaml.folding.YAMLFoldingSettings;
import org.jetbrains.yaml.psi.YAMLCompoundValue;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.impl.YAMLArrayImpl;
import org.jetbrains.yaml.psi.impl.YAMLBlockSequenceImpl;

public class YAMLFoldingBuilder
extends CustomFoldingBuilder {
    private static final int LIMIT_FOR_ELLIPSIS_IN_THE_END = 2;

    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> descriptors, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        if (descriptors == null) {
            YAMLFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (root == null) {
            YAMLFoldingBuilder.$$$reportNull$$$0(1);
        }
        if (document == null) {
            YAMLFoldingBuilder.$$$reportNull$$$0(2);
        }
        YAMLFoldingBuilder.collectDescriptors(root, descriptors);
    }

    private static void collectDescriptors(@NotNull PsiElement element, @NotNull List<? super FoldingDescriptor> descriptors) {
        TextRange nodeTextRange;
        if (element == null) {
            YAMLFoldingBuilder.$$$reportNull$$$0(3);
        }
        if (descriptors == null) {
            YAMLFoldingBuilder.$$$reportNull$$$0(4);
        }
        if ((nodeTextRange = element.getTextRange()).getLength() < 2) {
            return;
        }
        if (element instanceof YAMLDocument) {
            if (PsiTreeUtil.findChildrenOfAnyType((PsiElement)element.getParent(), (Class[])new Class[]{YAMLDocument.class}).size() > 1) {
                descriptors.add((FoldingDescriptor)new FoldingDescriptor(element, nodeTextRange));
            }
        } else if (element instanceof YAMLScalar && ((YAMLScalar)element).isMultiline() || element instanceof YAMLKeyValue && ((YAMLKeyValue)element).getValue() instanceof YAMLCompoundValue || element instanceof YAMLSequenceItem && ((YAMLSequenceItem)element).getValue() instanceof YAMLCompoundValue) {
            descriptors.add((FoldingDescriptor)new FoldingDescriptor(element, nodeTextRange));
        }
        for (PsiElement child = element.getFirstChild(); child != null && (child = YAMLFoldingBuilder.foldComments(child, descriptors)) != null; child = child.getNextSibling()) {
            YAMLFoldingBuilder.collectDescriptors(child, descriptors);
        }
    }

    @Nullable
    private static PsiElement foldComments(PsiElement child, @NotNull List<? super FoldingDescriptor> descriptors) {
        if (descriptors == null) {
            YAMLFoldingBuilder.$$$reportNull$$$0(5);
        }
        PsiComment startComment = null;
        PsiComment endComment = null;
        int commentsCount = 0;
        while (child instanceof PsiComment) {
            ++commentsCount;
            if (startComment == null) {
                startComment = (PsiComment)child;
            }
            endComment = (PsiComment)child;
            child = YAMLFoldingBuilder.skipSpaceElementsUpToLine(child.getNextSibling());
        }
        if (commentsCount > 2) {
            descriptors.add((FoldingDescriptor)new FoldingDescriptor((PsiElement)startComment, TextRange.create((int)startComment.getTextRange().getStartOffset(), (int)endComment.getTextRange().getEndOffset())));
        }
        return child;
    }

    private static PsiElement skipSpaceElementsUpToLine(PsiElement element) {
        int eol = 0;
        while (element != null) {
            IElementType elementType = PsiUtilCore.getElementType((PsiElement)element);
            if (YAMLElementTypes.EOL_ELEMENTS.contains(elementType)) {
                if (eol > 0) break;
                ++eol;
            }
            if (!YAMLElementTypes.SPACE_ELEMENTS.contains(elementType)) break;
            element = element.getNextSibling();
        }
        return element;
    }

    @Nullable
    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        if (node == null) {
            YAMLFoldingBuilder.$$$reportNull$$$0(6);
        }
        if (range == null) {
            YAMLFoldingBuilder.$$$reportNull$$$0(7);
        }
        return YAMLFoldingBuilder.getPlaceholderText(SourceTreeToPsiMap.treeElementToPsi((ASTNode)node));
    }

    @NotNull
    private static String getPlaceholderText(@Nullable PsiElement psiElement) {
        if (psiElement instanceof YAMLDocument) {
            return "---";
        }
        if (psiElement instanceof PsiComment) {
            return "# ...";
        }
        if (psiElement instanceof YAMLScalar) {
            String string = YAMLFoldingBuilder.normalizePlaceHolderText(((YAMLScalar)psiElement).getTextValue());
            if (string == null) {
                YAMLFoldingBuilder.$$$reportNull$$$0(8);
            }
            return string;
        }
        if (psiElement instanceof YAMLSequence) {
            int size = ((YAMLSequence)psiElement).getItems().size();
            String placeholder = size + " " + StringUtil.pluralize((String)"item", (int)size);
            if (psiElement instanceof YAMLArrayImpl) {
                String string = "[" + placeholder + "]";
                if (string == null) {
                    YAMLFoldingBuilder.$$$reportNull$$$0(9);
                }
                return string;
            }
            if (psiElement instanceof YAMLBlockSequenceImpl) {
                String string = "<" + placeholder + ">";
                if (string == null) {
                    YAMLFoldingBuilder.$$$reportNull$$$0(10);
                }
                return string;
            }
        } else {
            if (psiElement instanceof YAMLMapping) {
                int size = ((YAMLMapping)psiElement).getKeyValues().size();
                String placeholder = size + " " + StringUtil.pluralize((String)"key", (int)size);
                String string = "{" + placeholder + "}";
                if (string == null) {
                    YAMLFoldingBuilder.$$$reportNull$$$0(11);
                }
                return string;
            }
            if (psiElement instanceof YAMLKeyValue) {
                String string = YAMLFoldingBuilder.normalizePlaceHolderText(((YAMLKeyValue)psiElement).getKeyText()) + ": " + YAMLFoldingBuilder.getPlaceholderText((PsiElement)((YAMLKeyValue)psiElement).getValue());
                if (string == null) {
                    YAMLFoldingBuilder.$$$reportNull$$$0(12);
                }
                return string;
            }
            if (psiElement instanceof YAMLSequenceItem) {
                String string = "- " + YAMLFoldingBuilder.getPlaceholderText((PsiElement)((YAMLSequenceItem)psiElement).getValue());
                if (string == null) {
                    YAMLFoldingBuilder.$$$reportNull$$$0(13);
                }
                return string;
            }
        }
        return "...";
    }

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            YAMLFoldingBuilder.$$$reportNull$$$0(14);
        }
        return false;
    }

    protected static String normalizePlaceHolderText(@Nullable String text) {
        if (text == null) {
            return null;
        }
        YAMLFoldingSettings settings = YAMLFoldingSettings.getInstance();
        if (!settings.useAbbreviation || text.length() <= settings.abbreviationLengthLimit) {
            return text;
        }
        if (settings.abbreviationLengthLimit <= 2) {
            return text.substring(0, settings.abbreviationLengthLimit) + "\u2026";
        }
        return StringUtil.trimMiddle((String)text, (int)settings.abbreviationLengthLimit);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/folding/YAMLFoldingBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/folding/YAMLFoldingBuilder";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceholderText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildLanguageFoldRegions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectDescriptors";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "foldComments";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagePlaceholderText";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isRegionCollapsedByDefault";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10, 11, 12, 13 -> new IllegalStateException(string);
        };
    }
}

