/*
 * SPDX-FileCopyrightText: Copyright (c) 2021-2022 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */


#include "common_nvswitch.h"
#include "ls10/ls10.h"
#include "ls10/sugen_ls10.h"

//
// AUTO-GENERATED FILE -- DO NOT MODIFY
// This file is automatically generated from SU scripts
//


/*
 * @Brief : Fill In
 *
 * @Description : Fill In
 *
 * @paramin : Fill In
 *
 */
#if 0
NvlStatus
nvswitch_npg_prod_ls10
(
    nvswitch_device *device
)
{
    

    // .NPG PROD value application
    
    NVSWITCH_ENG_WR32(device, NPORT, _BCAST, 0, _EGRESS, _ERR_CONTAIN_EN_0,
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_0, _CREDIT_TIME_OUT_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_0, _EGRESSBUFERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_0, _HWRSPERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_0, _INVALIDVCSET_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_0, _NCISOCCREDITOVFL, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_0, _NCISOC_CREDIT_PARITY_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_0, _NXBAR_FLITTYPE_MISMATCH_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_0, _NXBAR_HDR_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_0, _NXBAR_HDR_ECC_LIMIT_ERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_0, _NXBAR_HDR_PARITY_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_0, _NXBAR_SIDEBAND_PD_PARITY_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_0, _PKTROUTEERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_0, _PRIVRSPERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_0, _RAM_OUT_HDR_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_0, _RAM_OUT_HDR_ECC_LIMIT_ERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_0, _REQTGTIDMISMATCHERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_0, _RFU, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_0, _RSPREQIDMISMATCHERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_0, _SEQIDERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_0, _URRSPERR, __PROD));
    
    NVSWITCH_ENG_WR32(device, NPORT, _BCAST, 0, _EGRESS, _ERR_CONTAIN_EN_1,
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_1, _MCREDBUF_ECC_DBE_ERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_1, _MCREDBUF_ECC_LIMIT_ERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_1, _MCREDSGT_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_1, _MCREDSGT_ECC_LIMIT_ERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_1, _MCRSPCTRLSTORE_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_1, _MCRSPCTRLSTORE_ECC_LIMIT_ERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_1, _MCRSP_CNT_ERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_1, _MCRSP_RAM_HDR_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_1, _MCRSP_RAM_HDR_ECC_LIMIT_ERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_1, _NXBAR_REDUCTION_FLITTYPE_MISMATCH_ERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_1, _NXBAR_REDUCTION_HDR_ECC_DBE_ERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_1, _NXBAR_REDUCTION_HDR_ECC_LIMIT_ERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_1, _NXBAR_REDUCTION_HDR_PARITY_ERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_1, _RBCTRLSTORE_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_1, _RBCTRLSTORE_ECC_LIMIT_ERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_1, _RBRSP_CNT_ERR, _DISABLE));
    
    NVSWITCH_ENG_WR32(device, NPORT, _BCAST, 0, _EGRESS, _ERR_ECC_CTRL,
                      DRF_DEF(_EGRESS, _ERR_ECC_CTRL, _MCREDBUF_ECC_ENABLE, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_ECC_CTRL, _MCREDSGT_ECC_ENABLE, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_ECC_CTRL, _MCRSPCTRLSTORE_ECC_ENABLE, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_ECC_CTRL, _MCRSP_RAM_ECC_ENABLE, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_ECC_CTRL, _NCISOC_ECC_ENABLE, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_ECC_CTRL, _NCISOC_PARITY_ENABLE, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_ECC_CTRL, _NXBAR_ECC_ENABLE, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_ECC_CTRL, _NXBAR_PARITY_ENABLE, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_ECC_CTRL, _NXBAR_REDUCTION_ECC_ENABLE, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_ECC_CTRL, _NXBAR_REDUCTION_PARITY_ENABLE, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_ECC_CTRL, _NXBAR_SIDEBAND_PD_PARITY_ENABLE, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_ECC_CTRL, _RAM_OUT_ECC_ENABLE, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_ECC_CTRL, _RBCTRLSTORE_ECC_ENABLE, __PROD));
    
    NVSWITCH_ENG_WR32(device, NPORT, _BCAST, 0, _EGRESS, _ERR_FATAL_REPORT_EN_0,
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_0, _CREDIT_TIME_OUT_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_0, _EGRESSBUFERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_0, _HWRSPERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_0, _INVALIDVCSET_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_0, _NCISOCCREDITOVFL, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_0, _NCISOC_CREDIT_PARITY_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_0, _NXBAR_FLITTYPE_MISMATCH_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_0, _NXBAR_HDR_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_0, _NXBAR_HDR_ECC_LIMIT_ERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_0, _NXBAR_HDR_PARITY_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_0, _NXBAR_SIDEBAND_PD_PARITY_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_0, _PKTROUTEERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_0, _PRIVRSPERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_0, _RAM_OUT_HDR_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_0, _RAM_OUT_HDR_ECC_LIMIT_ERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_0, _REQTGTIDMISMATCHERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_0, _RFU, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_0, _RSPREQIDMISMATCHERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_0, _SEQIDERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_0, _URRSPERR, __PROD));
    
    NVSWITCH_ENG_WR32(device, NPORT, _BCAST, 0, _EGRESS, _ERR_FATAL_REPORT_EN_1,
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_1, _MCREDBUF_ECC_DBE_ERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_1, _MCREDBUF_ECC_LIMIT_ERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_1, _MCREDSGT_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_1, _MCREDSGT_ECC_LIMIT_ERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_1, _MCRSPCTRLSTORE_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_1, _MCRSPCTRLSTORE_ECC_LIMIT_ERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_1, _MCRSP_CNT_ERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_1, _MCRSP_RAM_HDR_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_1, _MCRSP_RAM_HDR_ECC_LIMIT_ERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_1, _NXBAR_REDUCTION_FLITTYPE_MISMATCH_ERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_1, _NXBAR_REDUCTION_HDR_ECC_DBE_ERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_1, _NXBAR_REDUCTION_HDR_ECC_LIMIT_ERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_1, _NXBAR_REDUCTION_HDR_PARITY_ERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_1, _RBCTRLSTORE_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_1, _RBCTRLSTORE_ECC_LIMIT_ERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_1, _RBRSP_CNT_ERR, _DISABLE));
    
    NVSWITCH_ENG_WR32(device, NPORT, _BCAST, 0, _EGRESS, _ERR_LOG_EN_0,
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_0, _CREDIT_TIME_OUT_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_0, _EGRESSBUFERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_0, _HWRSPERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_0, _INVALIDVCSET_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_0, _NCISOCCREDITOVFL, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_0, _NCISOC_CREDIT_PARITY_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_0, _NXBAR_FLITTYPE_MISMATCH_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_0, _NXBAR_HDR_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_0, _NXBAR_HDR_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_0, _NXBAR_HDR_PARITY_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_0, _NXBAR_SIDEBAND_PD_PARITY_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_0, _PKTROUTEERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_0, _PRIVRSPERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_0, _RAM_OUT_HDR_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_0, _RAM_OUT_HDR_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_0, _REQTGTIDMISMATCHERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_0, _RFU, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_0, _RSPREQIDMISMATCHERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_0, _SEQIDERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_0, _URRSPERR, __PROD));
    
    NVSWITCH_ENG_WR32(device, NPORT, _BCAST, 0, _EGRESS, _ERR_LOG_EN_1,
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_1, _MCREDBUF_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_1, _MCREDBUF_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_1, _MCREDSGT_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_1, _MCREDSGT_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_1, _MCRSPCTRLSTORE_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_1, _MCRSPCTRLSTORE_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_1, _MCRSP_CNT_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_1, _MCRSP_RAM_HDR_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_1, _MCRSP_RAM_HDR_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_1, _NXBAR_REDUCTION_FLITTYPE_MISMATCH_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_1, _NXBAR_REDUCTION_HDR_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_1, _NXBAR_REDUCTION_HDR_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_1, _NXBAR_REDUCTION_HDR_PARITY_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_1, _RBCTRLSTORE_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_1, _RBCTRLSTORE_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_1, _RBRSP_CNT_ERR, __PROD));
    
    NVSWITCH_ENG_WR32(device, NPORT, _BCAST, 0, _EGRESS, _ERR_NON_FATAL_REPORT_EN_0,
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_0, _CREDIT_TIME_OUT_ERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_0, _EGRESSBUFERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_0, _HWRSPERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_0, _INVALIDVCSET_ERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_0, _NCISOCCREDITOVFL, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_0, _NCISOC_CREDIT_PARITY_ERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_0, _NXBAR_FLITTYPE_MISMATCH_ERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_0, _NXBAR_HDR_ECC_DBE_ERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_0, _NXBAR_HDR_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_0, _NXBAR_HDR_PARITY_ERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_0, _NXBAR_SIDEBAND_PD_PARITY_ERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_0, _PKTROUTEERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_0, _PRIVRSPERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_0, _RAM_OUT_HDR_ECC_DBE_ERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_0, _RAM_OUT_HDR_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_0, _REQTGTIDMISMATCHERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_0, _RFU, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_0, _RSPREQIDMISMATCHERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_0, _SEQIDERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_0, _URRSPERR, _DISABLE));
    
    NVSWITCH_ENG_WR32(device, NPORT, _BCAST, 0, _EGRESS, _ERR_NON_FATAL_REPORT_EN_1,
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_1, _MCREDBUF_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_1, _MCREDBUF_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_1, _MCREDSGT_ECC_DBE_ERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_1, _MCREDSGT_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_1, _MCRSPCTRLSTORE_ECC_DBE_ERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_1, _MCRSPCTRLSTORE_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_1, _MCRSP_CNT_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_1, _MCRSP_RAM_HDR_ECC_DBE_ERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_1, _MCRSP_RAM_HDR_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_1, _NXBAR_REDUCTION_FLITTYPE_MISMATCH_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_1, _NXBAR_REDUCTION_HDR_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_1, _NXBAR_REDUCTION_HDR_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_1, _NXBAR_REDUCTION_HDR_PARITY_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_1, _RBCTRLSTORE_ECC_DBE_ERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_1, _RBCTRLSTORE_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_1, _RBRSP_CNT_ERR, __PROD));
    
    NVSWITCH_ENG_WR32(device, NPORT, _BCAST, 0, _INGRESS, _ERR_CONTAIN_EN_0,
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _ACLFAIL, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _ADDRBOUNDSERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _ADDRTYPEERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _CMDDECODEERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _EXTAREMAPTAB_ACLFAIL, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _EXTAREMAPTAB_ADDRBOUNDSERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _EXTAREMAPTAB_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _EXTAREMAPTAB_INDEX_ERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _EXTAREMAPTAB_REQCONTEXTMISMATCHERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _EXTBREMAPTAB_ACLFAIL, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _EXTBREMAPTAB_ADDRBOUNDSERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _EXTBREMAPTAB_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _EXTBREMAPTAB_INDEX_ERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _EXTBREMAPTAB_REQCONTEXTMISMATCHERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _INVALIDVCSET, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _MCREMAPTAB_ACLFAIL, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _MCREMAPTAB_ADDRBOUNDSERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _MCREMAPTAB_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _MCREMAPTAB_INDEX_ERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _MCREMAPTAB_REQCONTEXTMISMATCHERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _NCISOC_HDR_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _NCISOC_HDR_ECC_LIMIT_ERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _NCISOC_PARITY_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _REMAPTAB_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _REMAPTAB_ECC_LIMIT_ERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _REQCONTEXTMISMATCHERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _RIDTABCFGERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _RIDTAB_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _RIDTAB_ECC_LIMIT_ERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _RLANTABCFGERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _RLANTAB_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _RLANTAB_ECC_LIMIT_ERR, _DISABLE));
    
    NVSWITCH_ENG_WR32(device, NPORT, _BCAST, 0, _INGRESS, _ERR_ECC_CTRL,
                      DRF_DEF(_INGRESS, _ERR_ECC_CTRL, _EXTAREMAPTAB_ECC_ENABLE, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_ECC_CTRL, _EXTBREMAPTAB_ECC_ENABLE, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_ECC_CTRL, _MCREMAPTAB_ECC_ENABLE, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_ECC_CTRL, _NCISOC_HDR_ECC_ENABLE, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_ECC_CTRL, _NCISOC_PARITY_ENABLE, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_ECC_CTRL, _REMAPTAB_ECC_ENABLE, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_ECC_CTRL, _RIDTAB_ECC_ENABLE, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_ECC_CTRL, _RLANTAB_ECC_ENABLE, __PROD));
    
    NVSWITCH_ENG_WR32(device, NPORT, _BCAST, 0, _INGRESS, _ERR_FATAL_REPORT_EN_0,
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _ACLFAIL, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _ADDRBOUNDSERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _ADDRTYPEERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _CMDDECODEERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _EXTAREMAPTAB_ACLFAIL, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _EXTAREMAPTAB_ADDRBOUNDSERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _EXTAREMAPTAB_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _EXTAREMAPTAB_INDEX_ERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _EXTAREMAPTAB_REQCONTEXTMISMATCHERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _EXTBREMAPTAB_ACLFAIL, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _EXTBREMAPTAB_ADDRBOUNDSERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _EXTBREMAPTAB_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _EXTBREMAPTAB_INDEX_ERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _EXTBREMAPTAB_REQCONTEXTMISMATCHERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _INVALIDVCSET, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _MCREMAPTAB_ACLFAIL, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _MCREMAPTAB_ADDRBOUNDSERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _MCREMAPTAB_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _MCREMAPTAB_INDEX_ERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _MCREMAPTAB_REQCONTEXTMISMATCHERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _NCISOC_HDR_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _NCISOC_HDR_ECC_LIMIT_ERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _NCISOC_PARITY_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _REMAPTAB_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _REMAPTAB_ECC_LIMIT_ERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _REQCONTEXTMISMATCHERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _RIDTABCFGERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _RIDTAB_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _RIDTAB_ECC_LIMIT_ERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _RLANTABCFGERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _RLANTAB_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _RLANTAB_ECC_LIMIT_ERR, _DISABLE));
    
    NVSWITCH_ENG_WR32(device, NPORT, _BCAST, 0, _INGRESS, _ERR_LOG_EN_0,
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _ACLFAIL, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _ADDRBOUNDSERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _ADDRTYPEERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _CMDDECODEERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _EXTAREMAPTAB_ACLFAIL, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _EXTAREMAPTAB_ADDRBOUNDSERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _EXTAREMAPTAB_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _EXTAREMAPTAB_INDEX_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _EXTAREMAPTAB_REQCONTEXTMISMATCHERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _EXTBREMAPTAB_ACLFAIL, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _EXTBREMAPTAB_ADDRBOUNDSERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _EXTBREMAPTAB_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _EXTBREMAPTAB_INDEX_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _EXTBREMAPTAB_REQCONTEXTMISMATCHERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _INVALIDVCSET, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _MCREMAPTAB_ACLFAIL, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _MCREMAPTAB_ADDRBOUNDSERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _MCREMAPTAB_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _MCREMAPTAB_INDEX_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _MCREMAPTAB_REQCONTEXTMISMATCHERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _NCISOC_HDR_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _NCISOC_HDR_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _NCISOC_PARITY_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _REMAPTAB_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _REMAPTAB_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _REQCONTEXTMISMATCHERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _RIDTABCFGERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _RIDTAB_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _RIDTAB_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _RLANTABCFGERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _RLANTAB_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _RLANTAB_ECC_LIMIT_ERR, __PROD));
    
    NVSWITCH_ENG_WR32(device, NPORT, _BCAST, 0, _INGRESS, _ERR_LOG_EN_1,
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_1, _EXTAREMAPTAB_ADDRTYPEERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_1, _EXTAREMAPTAB_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_1, _EXTBREMAPTAB_ADDRTYPEERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_1, _EXTBREMAPTAB_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_1, _MCCMDTOUCADDRERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_1, _MCREMAPTAB_ADDRTYPEERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_1, _MCREMAPTAB_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_1, _READMCREFLECTMEMERR, __PROD));
    
    NVSWITCH_ENG_WR32(device, NPORT, _BCAST, 0, _INGRESS, _ERR_NON_FATAL_REPORT_EN_0,
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _ACLFAIL, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _ADDRBOUNDSERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _ADDRTYPEERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _CMDDECODEERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _EXTAREMAPTAB_ACLFAIL, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _EXTAREMAPTAB_ADDRBOUNDSERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _EXTAREMAPTAB_ECC_DBE_ERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _EXTAREMAPTAB_INDEX_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _EXTAREMAPTAB_REQCONTEXTMISMATCHERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _EXTBREMAPTAB_ACLFAIL, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _EXTBREMAPTAB_ADDRBOUNDSERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _EXTBREMAPTAB_ECC_DBE_ERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _EXTBREMAPTAB_INDEX_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _EXTBREMAPTAB_REQCONTEXTMISMATCHERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _INVALIDVCSET, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _MCREMAPTAB_ACLFAIL, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _MCREMAPTAB_ADDRBOUNDSERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _MCREMAPTAB_ECC_DBE_ERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _MCREMAPTAB_INDEX_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _MCREMAPTAB_REQCONTEXTMISMATCHERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _NCISOC_HDR_ECC_DBE_ERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _NCISOC_HDR_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _NCISOC_PARITY_ERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _REMAPTAB_ECC_DBE_ERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _REMAPTAB_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _REQCONTEXTMISMATCHERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _RIDTABCFGERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _RIDTAB_ECC_DBE_ERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _RIDTAB_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _RLANTABCFGERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _RLANTAB_ECC_DBE_ERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _RLANTAB_ECC_LIMIT_ERR, __PROD));
    
    NVSWITCH_ENG_WR32(device, NPORT, _BCAST, 0, _INGRESS, _ERR_NON_FATAL_REPORT_EN_1,
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_1, _EXTAREMAPTAB_ADDRTYPEERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_1, _EXTAREMAPTAB_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_1, _EXTBREMAPTAB_ADDRTYPEERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_1, _EXTBREMAPTAB_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_1, _MCCMDTOUCADDRERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_1, _MCREMAPTAB_ADDRTYPEERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_1, _MCREMAPTAB_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_1, _READMCREFLECTMEMERR, __PROD));
    
    NVSWITCH_ENG_WR32(device, NPORT, _BCAST, 0, _MULTICASTTSTATE, _ERR_CONTAIN_EN_0,
                      DRF_DEF(_MULTICASTTSTATE, _ERR_CONTAIN_EN_0, _CRUMBSTORE_BUF_OVERWRITE_ERR, __PROD) |
                      DRF_DEF(_MULTICASTTSTATE, _ERR_CONTAIN_EN_0, _CRUMBSTORE_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_MULTICASTTSTATE, _ERR_CONTAIN_EN_0, _CRUMBSTORE_ECC_LIMIT_ERR, _DISABLE) |
                      DRF_DEF(_MULTICASTTSTATE, _ERR_CONTAIN_EN_0, _CRUMBSTORE_MCTO_ERR, _DISABLE) |
                      DRF_DEF(_MULTICASTTSTATE, _ERR_CONTAIN_EN_0, _TAGPOOL_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_MULTICASTTSTATE, _ERR_CONTAIN_EN_0, _TAGPOOL_ECC_LIMIT_ERR, _DISABLE));
    
    NVSWITCH_ENG_WR32(device, NPORT, _BCAST, 0, _MULTICASTTSTATE, _ERR_ECC_CTRL,
                      DRF_DEF(_MULTICASTTSTATE, _ERR_ECC_CTRL, _CRUMBSTORE_ECC_ENABLE, __PROD) |
                      DRF_DEF(_MULTICASTTSTATE, _ERR_ECC_CTRL, _TAGPOOL_ECC_ENABLE, __PROD));
    
    NVSWITCH_ENG_WR32(device, NPORT, _BCAST, 0, _MULTICASTTSTATE, _ERR_FATAL_REPORT_EN_0,
                      DRF_DEF(_MULTICASTTSTATE, _ERR_FATAL_REPORT_EN_0, _CRUMBSTORE_BUF_OVERWRITE_ERR, __PROD) |
                      DRF_DEF(_MULTICASTTSTATE, _ERR_FATAL_REPORT_EN_0, _CRUMBSTORE_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_MULTICASTTSTATE, _ERR_FATAL_REPORT_EN_0, _CRUMBSTORE_ECC_LIMIT_ERR, _DISABLE) |
                      DRF_DEF(_MULTICASTTSTATE, _ERR_FATAL_REPORT_EN_0, _CRUMBSTORE_MCTO_ERR, _DISABLE) |
                      DRF_DEF(_MULTICASTTSTATE, _ERR_FATAL_REPORT_EN_0, _TAGPOOL_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_MULTICASTTSTATE, _ERR_FATAL_REPORT_EN_0, _TAGPOOL_ECC_LIMIT_ERR, _DISABLE));
    
    NVSWITCH_ENG_WR32(device, NPORT, _BCAST, 0, _MULTICASTTSTATE, _ERR_LOG_EN_0,
                      DRF_DEF(_MULTICASTTSTATE, _ERR_LOG_EN_0, _CRUMBSTORE_BUF_OVERWRITE_ERR, __PROD) |
                      DRF_DEF(_MULTICASTTSTATE, _ERR_LOG_EN_0, _CRUMBSTORE_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_MULTICASTTSTATE, _ERR_LOG_EN_0, _CRUMBSTORE_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_MULTICASTTSTATE, _ERR_LOG_EN_0, _CRUMBSTORE_MCTO_ERR, __PROD) |
                      DRF_DEF(_MULTICASTTSTATE, _ERR_LOG_EN_0, _TAGPOOL_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_MULTICASTTSTATE, _ERR_LOG_EN_0, _TAGPOOL_ECC_LIMIT_ERR, __PROD));
    
    NVSWITCH_ENG_WR32(device, NPORT, _BCAST, 0, _MULTICASTTSTATE, _ERR_NON_FATAL_REPORT_EN_0,
                      DRF_DEF(_MULTICASTTSTATE, _ERR_NON_FATAL_REPORT_EN_0, _CRUMBSTORE_BUF_OVERWRITE_ERR, _DISABLE) |
                      DRF_DEF(_MULTICASTTSTATE, _ERR_NON_FATAL_REPORT_EN_0, _CRUMBSTORE_ECC_DBE_ERR, _DISABLE) |
                      DRF_DEF(_MULTICASTTSTATE, _ERR_NON_FATAL_REPORT_EN_0, _CRUMBSTORE_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_MULTICASTTSTATE, _ERR_NON_FATAL_REPORT_EN_0, _CRUMBSTORE_MCTO_ERR, __PROD) |
                      DRF_DEF(_MULTICASTTSTATE, _ERR_NON_FATAL_REPORT_EN_0, _TAGPOOL_ECC_DBE_ERR, _DISABLE) |
                      DRF_DEF(_MULTICASTTSTATE, _ERR_NON_FATAL_REPORT_EN_0, _TAGPOOL_ECC_LIMIT_ERR, __PROD));
    
    NVSWITCH_ENG_WR32(device, NPG_PERFMON, _BCAST, 0, _NPGPERF, _CTRL_CLOCK_GATING,
                      DRF_DEF(_NPGPERF, _CTRL_CLOCK_GATING, _CG1_SLCG, __PROD));
    
    NVSWITCH_ENG_WR32(device, NPG_PERFMON, _BCAST, 0, _NPGPERF, _PERF_CTRL_CLOCK_GATING,
                      DRF_DEF(_NPGPERF, _PERF_CTRL_CLOCK_GATING, _CG1_SLCG, __PROD) |
                      DRF_DEF(_NPGPERF, _PERF_CTRL_CLOCK_GATING, _CONTEXT_FREEZE, __PROD));
    
    NVSWITCH_ENG_WR32(device, NPG, _BCAST, 0, _NPG, _CTRL_CLOCK_GATING,
                      DRF_DEF(_NPG, _CTRL_CLOCK_GATING, _CG1_BLCG, __PROD) |
                      DRF_DEF(_NPG, _CTRL_CLOCK_GATING, _CG1_SLCG, __PROD));
    
    NVSWITCH_ENG_WR32(device, NPORT, _BCAST, 0, _NPORT, _CTRL_SLCG,
                      DRF_DEF(_NPORT, _CTRL_SLCG, _DIS_CG_EGRESS, __PROD) |
                      DRF_DEF(_NPORT, _CTRL_SLCG, _DIS_CG_INGRESS, __PROD) |
                      DRF_DEF(_NPORT, _CTRL_SLCG, _DIS_CG_MCTAGSTATE, __PROD) |
                      DRF_DEF(_NPORT, _CTRL_SLCG, _DIS_CG_RDTAGSTATE, __PROD) |
                      DRF_DEF(_NPORT, _CTRL_SLCG, _DIS_CG_ROUTE, __PROD) |
                      DRF_DEF(_NPORT, _CTRL_SLCG, _DIS_CG_STRACK, __PROD) |
                      DRF_DEF(_NPORT, _CTRL_SLCG, _DIS_CG_TAGSTATE, __PROD) |
                      DRF_DEF(_NPORT, _CTRL_SLCG, _DIS_CG_TREX, __PROD) |
                      DRF_DEF(_NPORT, _CTRL_SLCG, _DIS_CG_WATCHPOINT, __PROD));
    
    NVSWITCH_ENG_WR32(device, NPORT_PERFMON, _BCAST, 0, _PERF_PMM, ROUTER_CG1_SECURE,
                      DRF_DEF(_PERF_PMM, ROUTER_CG1_SECURE, _FLCG_PERFMON, __PROD));
    
    NVSWITCH_ENG_WR32(device, NPORT_PERFMON, _BCAST, 0, _PERF_PMM, ROUTER_PERFMON_CG2_SECURE,
                      DRF_DEF(_PERF_PMM, ROUTER_PERFMON_CG2_SECURE, _SLCG, __PROD));
    
    NVSWITCH_ENG_WR32(device, NPORT, _BCAST, 0, _REDUCTIONTSTATE, _ERR_CONTAIN_EN_0,
                      DRF_DEF(_REDUCTIONTSTATE, _ERR_CONTAIN_EN_0, _CRUMBSTORE_BUF_OVERWRITE_ERR, __PROD) |
                      DRF_DEF(_REDUCTIONTSTATE, _ERR_CONTAIN_EN_0, _CRUMBSTORE_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_REDUCTIONTSTATE, _ERR_CONTAIN_EN_0, _CRUMBSTORE_ECC_LIMIT_ERR, _DISABLE) |
                      DRF_DEF(_REDUCTIONTSTATE, _ERR_CONTAIN_EN_0, _CRUMBSTORE_RTO_ERR, _DISABLE) |
                      DRF_DEF(_REDUCTIONTSTATE, _ERR_CONTAIN_EN_0, _TAGPOOL_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_REDUCTIONTSTATE, _ERR_CONTAIN_EN_0, _TAGPOOL_ECC_LIMIT_ERR, _DISABLE));
    
    NVSWITCH_ENG_WR32(device, NPORT, _BCAST, 0, _REDUCTIONTSTATE, _ERR_ECC_CTRL,
                      DRF_DEF(_REDUCTIONTSTATE, _ERR_ECC_CTRL, _CRUMBSTORE_ECC_ENABLE, __PROD) |
                      DRF_DEF(_REDUCTIONTSTATE, _ERR_ECC_CTRL, _TAGPOOL_ECC_ENABLE, __PROD));
    
    NVSWITCH_ENG_WR32(device, NPORT, _BCAST, 0, _REDUCTIONTSTATE, _ERR_FATAL_REPORT_EN_0,
                      DRF_DEF(_REDUCTIONTSTATE, _ERR_FATAL_REPORT_EN_0, _CRUMBSTORE_BUF_OVERWRITE_ERR, __PROD) |
                      DRF_DEF(_REDUCTIONTSTATE, _ERR_FATAL_REPORT_EN_0, _CRUMBSTORE_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_REDUCTIONTSTATE, _ERR_FATAL_REPORT_EN_0, _CRUMBSTORE_ECC_LIMIT_ERR, _DISABLE) |
                      DRF_DEF(_REDUCTIONTSTATE, _ERR_FATAL_REPORT_EN_0, _CRUMBSTORE_RTO_ERR, _DISABLE) |
                      DRF_DEF(_REDUCTIONTSTATE, _ERR_FATAL_REPORT_EN_0, _TAGPOOL_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_REDUCTIONTSTATE, _ERR_FATAL_REPORT_EN_0, _TAGPOOL_ECC_LIMIT_ERR, _DISABLE));
    
    NVSWITCH_ENG_WR32(device, NPORT, _BCAST, 0, _REDUCTIONTSTATE, _ERR_LOG_EN_0,
                      DRF_DEF(_REDUCTIONTSTATE, _ERR_LOG_EN_0, _CRUMBSTORE_BUF_OVERWRITE_ERR, __PROD) |
                      DRF_DEF(_REDUCTIONTSTATE, _ERR_LOG_EN_0, _CRUMBSTORE_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_REDUCTIONTSTATE, _ERR_LOG_EN_0, _CRUMBSTORE_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_REDUCTIONTSTATE, _ERR_LOG_EN_0, _CRUMBSTORE_RTO_ERR, __PROD) |
                      DRF_DEF(_REDUCTIONTSTATE, _ERR_LOG_EN_0, _TAGPOOL_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_REDUCTIONTSTATE, _ERR_LOG_EN_0, _TAGPOOL_ECC_LIMIT_ERR, __PROD));
    
    NVSWITCH_ENG_WR32(device, NPORT, _BCAST, 0, _REDUCTIONTSTATE, _ERR_NON_FATAL_REPORT_EN_0,
                      DRF_DEF(_REDUCTIONTSTATE, _ERR_NON_FATAL_REPORT_EN_0, _CRUMBSTORE_BUF_OVERWRITE_ERR, _DISABLE) |
                      DRF_DEF(_REDUCTIONTSTATE, _ERR_NON_FATAL_REPORT_EN_0, _CRUMBSTORE_ECC_DBE_ERR, _DISABLE) |
                      DRF_DEF(_REDUCTIONTSTATE, _ERR_NON_FATAL_REPORT_EN_0, _CRUMBSTORE_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_REDUCTIONTSTATE, _ERR_NON_FATAL_REPORT_EN_0, _CRUMBSTORE_RTO_ERR, __PROD) |
                      DRF_DEF(_REDUCTIONTSTATE, _ERR_NON_FATAL_REPORT_EN_0, _TAGPOOL_ECC_DBE_ERR, _DISABLE) |
                      DRF_DEF(_REDUCTIONTSTATE, _ERR_NON_FATAL_REPORT_EN_0, _TAGPOOL_ECC_LIMIT_ERR, __PROD));
    
    NVSWITCH_ENG_WR32(device, NPORT, _BCAST, 0, _ROUTE, _ERR_CONTAIN_EN_0,
                      DRF_DEF(_ROUTE, _ERR_CONTAIN_EN_0, _CDTPARERR, __PROD) |
                      DRF_DEF(_ROUTE, _ERR_CONTAIN_EN_0, _EXTMCRID_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_ROUTE, _ERR_CONTAIN_EN_0, _EXTMCRID_ECC_LIMIT_ERR, _DISABLE) |
                      DRF_DEF(_ROUTE, _ERR_CONTAIN_EN_0, _GLT_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_ROUTE, _ERR_CONTAIN_EN_0, _GLT_ECC_LIMIT_ERR, _DISABLE) |
                      DRF_DEF(_ROUTE, _ERR_CONTAIN_EN_0, _INVALIDROUTEPOLICYERR, _DISABLE) |
                      DRF_DEF(_ROUTE, _ERR_CONTAIN_EN_0, _INVALID_MCRID_ERR, _DISABLE) |
                      DRF_DEF(_ROUTE, _ERR_CONTAIN_EN_0, _MCRID_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_ROUTE, _ERR_CONTAIN_EN_0, _MCRID_ECC_LIMIT_ERR, _DISABLE) |
                      DRF_DEF(_ROUTE, _ERR_CONTAIN_EN_0, _MC_TRIGGER_ERR, _DISABLE) |
                      DRF_DEF(_ROUTE, _ERR_CONTAIN_EN_0, _NOPORTDEFINEDERR, _DISABLE) |
                      DRF_DEF(_ROUTE, _ERR_CONTAIN_EN_0, _NVS_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_ROUTE, _ERR_CONTAIN_EN_0, _NVS_ECC_LIMIT_ERR, _DISABLE) |
                      DRF_DEF(_ROUTE, _ERR_CONTAIN_EN_0, _PDCTRLPARERR, __PROD) |
                      DRF_DEF(_ROUTE, _ERR_CONTAIN_EN_0, _RAM_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_ROUTE, _ERR_CONTAIN_EN_0, _RAM_ECC_LIMIT_ERR, _DISABLE) |
                      DRF_DEF(_ROUTE, _ERR_CONTAIN_EN_0, _ROUTEBUFERR, __PROD));
    
    NVSWITCH_ENG_WR32(device, NPORT, _BCAST, 0, _ROUTE, _ERR_ECC_CTRL,
                      DRF_DEF(_ROUTE, _ERR_ECC_CTRL, _ECCWRITEBACKENBGLT, _ENABLE) |
                      DRF_DEF(_ROUTE, _ERR_ECC_CTRL, _ECCWRITEBACKEXTMCRIDENB, _ENABLE) |
                      DRF_DEF(_ROUTE, _ERR_ECC_CTRL, _ECCWRITEBACKMCRIDENB, _ENABLE) |
                      DRF_DEF(_ROUTE, _ERR_ECC_CTRL, _EXTMCRID_ECC_ENABLE, __PROD) |
                      DRF_DEF(_ROUTE, _ERR_ECC_CTRL, _GLT_ECC_ENABLE, __PROD) |
                      DRF_DEF(_ROUTE, _ERR_ECC_CTRL, _MCRID_ECC_ENABLE, __PROD) |
                      DRF_DEF(_ROUTE, _ERR_ECC_CTRL, _NVS_ECC_ENABLE, __PROD) |
                      DRF_DEF(_ROUTE, _ERR_ECC_CTRL, _RAM_ECC_ENABLE, __PROD));
    
    NVSWITCH_ENG_WR32(device, NPORT, _BCAST, 0, _ROUTE, _ERR_FATAL_REPORT_EN_0,
                      DRF_DEF(_ROUTE, _ERR_FATAL_REPORT_EN_0, _CDTPARERR, __PROD) |
                      DRF_DEF(_ROUTE, _ERR_FATAL_REPORT_EN_0, _EXTMCRID_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_ROUTE, _ERR_FATAL_REPORT_EN_0, _EXTMCRID_ECC_LIMIT_ERR, _DISABLE) |
                      DRF_DEF(_ROUTE, _ERR_FATAL_REPORT_EN_0, _GLT_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_ROUTE, _ERR_FATAL_REPORT_EN_0, _GLT_ECC_LIMIT_ERR, _DISABLE) |
                      DRF_DEF(_ROUTE, _ERR_FATAL_REPORT_EN_0, _INVALIDROUTEPOLICYERR, _DISABLE) |
                      DRF_DEF(_ROUTE, _ERR_FATAL_REPORT_EN_0, _INVALID_MCRID_ERR, _DISABLE) |
                      DRF_DEF(_ROUTE, _ERR_FATAL_REPORT_EN_0, _MCRID_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_ROUTE, _ERR_FATAL_REPORT_EN_0, _MCRID_ECC_LIMIT_ERR, _DISABLE) |
                      DRF_DEF(_ROUTE, _ERR_FATAL_REPORT_EN_0, _MC_TRIGGER_ERR, _DISABLE) |
                      DRF_DEF(_ROUTE, _ERR_FATAL_REPORT_EN_0, _NOPORTDEFINEDERR, _DISABLE) |
                      DRF_DEF(_ROUTE, _ERR_FATAL_REPORT_EN_0, _NVS_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_ROUTE, _ERR_FATAL_REPORT_EN_0, _NVS_ECC_LIMIT_ERR, _DISABLE) |
                      DRF_DEF(_ROUTE, _ERR_FATAL_REPORT_EN_0, _PDCTRLPARERR, __PROD) |
                      DRF_DEF(_ROUTE, _ERR_FATAL_REPORT_EN_0, _RAM_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_ROUTE, _ERR_FATAL_REPORT_EN_0, _RAM_ECC_LIMIT_ERR, _DISABLE) |
                      DRF_DEF(_ROUTE, _ERR_FATAL_REPORT_EN_0, _ROUTEBUFERR, __PROD));
    
    NVSWITCH_ENG_WR32(device, NPORT, _BCAST, 0, _ROUTE, _ERR_LOG_EN_0,
                      DRF_DEF(_ROUTE, _ERR_LOG_EN_0, _CDTPARERR, __PROD) |
                      DRF_DEF(_ROUTE, _ERR_LOG_EN_0, _EXTMCRID_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_ROUTE, _ERR_LOG_EN_0, _EXTMCRID_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_ROUTE, _ERR_LOG_EN_0, _GLT_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_ROUTE, _ERR_LOG_EN_0, _GLT_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_ROUTE, _ERR_LOG_EN_0, _INVALIDROUTEPOLICYERR, __PROD) |
                      DRF_DEF(_ROUTE, _ERR_LOG_EN_0, _INVALID_MCRID_ERR, __PROD) |
                      DRF_DEF(_ROUTE, _ERR_LOG_EN_0, _MCRID_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_ROUTE, _ERR_LOG_EN_0, _MCRID_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_ROUTE, _ERR_LOG_EN_0, _MC_TRIGGER_ERR, _DISABLE) |
                      DRF_DEF(_ROUTE, _ERR_LOG_EN_0, _NOPORTDEFINEDERR, __PROD) |
                      DRF_DEF(_ROUTE, _ERR_LOG_EN_0, _NVS_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_ROUTE, _ERR_LOG_EN_0, _NVS_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_ROUTE, _ERR_LOG_EN_0, _PDCTRLPARERR, __PROD) |
                      DRF_DEF(_ROUTE, _ERR_LOG_EN_0, _RAM_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_ROUTE, _ERR_LOG_EN_0, _RAM_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_ROUTE, _ERR_LOG_EN_0, _ROUTEBUFERR, __PROD));
    
    NVSWITCH_ENG_WR32(device, NPORT, _BCAST, 0, _ROUTE, _ERR_NON_FATAL_REPORT_EN_0,
                      DRF_DEF(_ROUTE, _ERR_NON_FATAL_REPORT_EN_0, _CDTPARERR, _DISABLE) |
                      DRF_DEF(_ROUTE, _ERR_NON_FATAL_REPORT_EN_0, _EXTMCRID_ECC_DBE_ERR, _DISABLE) |
                      DRF_DEF(_ROUTE, _ERR_NON_FATAL_REPORT_EN_0, _EXTMCRID_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_ROUTE, _ERR_NON_FATAL_REPORT_EN_0, _GLT_ECC_DBE_ERR, _DISABLE) |
                      DRF_DEF(_ROUTE, _ERR_NON_FATAL_REPORT_EN_0, _GLT_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_ROUTE, _ERR_NON_FATAL_REPORT_EN_0, _INVALIDROUTEPOLICYERR, __PROD) |
                      DRF_DEF(_ROUTE, _ERR_NON_FATAL_REPORT_EN_0, _INVALID_MCRID_ERR, __PROD) |
                      DRF_DEF(_ROUTE, _ERR_NON_FATAL_REPORT_EN_0, _MCRID_ECC_DBE_ERR, _DISABLE) |
                      DRF_DEF(_ROUTE, _ERR_NON_FATAL_REPORT_EN_0, _MCRID_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_ROUTE, _ERR_NON_FATAL_REPORT_EN_0, _MC_TRIGGER_ERR, _DISABLE) |
                      DRF_DEF(_ROUTE, _ERR_NON_FATAL_REPORT_EN_0, _NOPORTDEFINEDERR, __PROD) |
                      DRF_DEF(_ROUTE, _ERR_NON_FATAL_REPORT_EN_0, _NVS_ECC_DBE_ERR, _DISABLE) |
                      DRF_DEF(_ROUTE, _ERR_NON_FATAL_REPORT_EN_0, _NVS_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_ROUTE, _ERR_NON_FATAL_REPORT_EN_0, _PDCTRLPARERR, _DISABLE) |
                      DRF_DEF(_ROUTE, _ERR_NON_FATAL_REPORT_EN_0, _RAM_ECC_DBE_ERR, _DISABLE) |
                      DRF_DEF(_ROUTE, _ERR_NON_FATAL_REPORT_EN_0, _RAM_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_ROUTE, _ERR_NON_FATAL_REPORT_EN_0, _ROUTEBUFERR, _DISABLE));
    
    NVSWITCH_ENG_WR32(device, NPORT, _BCAST, 0, _SOURCETRACK, _ERR_CONTAIN_EN_0,
                      DRF_DEF(_SOURCETRACK, _ERR_CONTAIN_EN_0, _CREQ_TCEN0_CRUMBSTORE_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_SOURCETRACK, _ERR_CONTAIN_EN_0, _CREQ_TCEN0_CRUMBSTORE_ECC_LIMIT_ERR, _DISABLE) |
                      DRF_DEF(_SOURCETRACK, _ERR_CONTAIN_EN_0, _DUP_CREQ_TCEN0_TAG_ERR, __PROD) |
                      DRF_DEF(_SOURCETRACK, _ERR_CONTAIN_EN_0, _INVALID_TCEN0_RSP_ERR, __PROD) |
                      DRF_DEF(_SOURCETRACK, _ERR_CONTAIN_EN_0, _INVALID_TCEN1_RSP_ERR, __PROD) |
                      DRF_DEF(_SOURCETRACK, _ERR_CONTAIN_EN_0, _SOURCETRACK_TIME_OUT_ERR, __PROD));
    
    NVSWITCH_ENG_WR32(device, NPORT, _BCAST, 0, _SOURCETRACK, _ERR_ECC_CTRL,
                      DRF_DEF(_SOURCETRACK, _ERR_ECC_CTRL, _CREQ_TCEN0_CRUMBSTORE_ECC_ENABLE, __PROD));
    
    NVSWITCH_ENG_WR32(device, NPORT, _BCAST, 0, _SOURCETRACK, _ERR_FATAL_REPORT_EN_0,
                      DRF_DEF(_SOURCETRACK, _ERR_FATAL_REPORT_EN_0, _CREQ_TCEN0_CRUMBSTORE_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_SOURCETRACK, _ERR_FATAL_REPORT_EN_0, _CREQ_TCEN0_CRUMBSTORE_ECC_LIMIT_ERR, _DISABLE) |
                      DRF_DEF(_SOURCETRACK, _ERR_FATAL_REPORT_EN_0, _DUP_CREQ_TCEN0_TAG_ERR, __PROD) |
                      DRF_DEF(_SOURCETRACK, _ERR_FATAL_REPORT_EN_0, _INVALID_TCEN0_RSP_ERR, __PROD) |
                      DRF_DEF(_SOURCETRACK, _ERR_FATAL_REPORT_EN_0, _INVALID_TCEN1_RSP_ERR, __PROD) |
                      DRF_DEF(_SOURCETRACK, _ERR_FATAL_REPORT_EN_0, _SOURCETRACK_TIME_OUT_ERR, __PROD));
    
    NVSWITCH_ENG_WR32(device, NPORT, _BCAST, 0, _SOURCETRACK, _ERR_LOG_EN_0,
                      DRF_DEF(_SOURCETRACK, _ERR_LOG_EN_0, _CREQ_TCEN0_CRUMBSTORE_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_SOURCETRACK, _ERR_LOG_EN_0, _CREQ_TCEN0_CRUMBSTORE_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_SOURCETRACK, _ERR_LOG_EN_0, _DUP_CREQ_TCEN0_TAG_ERR, __PROD) |
                      DRF_DEF(_SOURCETRACK, _ERR_LOG_EN_0, _INVALID_TCEN0_RSP_ERR, __PROD) |
                      DRF_DEF(_SOURCETRACK, _ERR_LOG_EN_0, _INVALID_TCEN1_RSP_ERR, __PROD) |
                      DRF_DEF(_SOURCETRACK, _ERR_LOG_EN_0, _SOURCETRACK_TIME_OUT_ERR, __PROD));
    
    NVSWITCH_ENG_WR32(device, NPORT, _BCAST, 0, _SOURCETRACK, _ERR_NON_FATAL_REPORT_EN_0,
                      DRF_DEF(_SOURCETRACK, _ERR_NON_FATAL_REPORT_EN_0, _CREQ_TCEN0_CRUMBSTORE_ECC_DBE_ERR, _DISABLE) |
                      DRF_DEF(_SOURCETRACK, _ERR_NON_FATAL_REPORT_EN_0, _CREQ_TCEN0_CRUMBSTORE_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_SOURCETRACK, _ERR_NON_FATAL_REPORT_EN_0, _DUP_CREQ_TCEN0_TAG_ERR, _DISABLE) |
                      DRF_DEF(_SOURCETRACK, _ERR_NON_FATAL_REPORT_EN_0, _INVALID_TCEN0_RSP_ERR, _DISABLE) |
                      DRF_DEF(_SOURCETRACK, _ERR_NON_FATAL_REPORT_EN_0, _INVALID_TCEN1_RSP_ERR, _DISABLE) |
                      DRF_DEF(_SOURCETRACK, _ERR_NON_FATAL_REPORT_EN_0, _SOURCETRACK_TIME_OUT_ERR, _DISABLE));
    
    NVSWITCH_ENG_WR32(device, NPORT, _BCAST, 0, _TSTATE, _ERR_CONTAIN_EN_0,
                      DRF_DEF(_TSTATE, _ERR_CONTAIN_EN_0, _ATO_ERR, __PROD) |
                      DRF_DEF(_TSTATE, _ERR_CONTAIN_EN_0, _CAMRSP_ERR, __PROD) |
                      DRF_DEF(_TSTATE, _ERR_CONTAIN_EN_0, _CRUMBSTOREBUFERR, __PROD) |
                      DRF_DEF(_TSTATE, _ERR_CONTAIN_EN_0, _CRUMBSTORE_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_TSTATE, _ERR_CONTAIN_EN_0, _CRUMBSTORE_ECC_LIMIT_ERR, _DISABLE) |
                      DRF_DEF(_TSTATE, _ERR_CONTAIN_EN_0, _TAGPOOLBUFERR, __PROD) |
                      DRF_DEF(_TSTATE, _ERR_CONTAIN_EN_0, _TAGPOOL_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_TSTATE, _ERR_CONTAIN_EN_0, _TAGPOOL_ECC_LIMIT_ERR, _DISABLE));
    
    NVSWITCH_ENG_WR32(device, NPORT, _BCAST, 0, _TSTATE, _ERR_ECC_CTRL,
                      DRF_DEF(_TSTATE, _ERR_ECC_CTRL, _CRUMBSTORE_ECC_ENABLE, __PROD) |
                      DRF_DEF(_TSTATE, _ERR_ECC_CTRL, _TAGPOOL_ECC_ENABLE, __PROD));
    
    NVSWITCH_ENG_WR32(device, NPORT, _BCAST, 0, _TSTATE, _ERR_FATAL_REPORT_EN_0,
                      DRF_DEF(_TSTATE, _ERR_FATAL_REPORT_EN_0, _ATO_ERR, __PROD) |
                      DRF_DEF(_TSTATE, _ERR_FATAL_REPORT_EN_0, _CAMRSP_ERR, __PROD) |
                      DRF_DEF(_TSTATE, _ERR_FATAL_REPORT_EN_0, _CRUMBSTOREBUFERR, __PROD) |
                      DRF_DEF(_TSTATE, _ERR_FATAL_REPORT_EN_0, _CRUMBSTORE_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_TSTATE, _ERR_FATAL_REPORT_EN_0, _CRUMBSTORE_ECC_LIMIT_ERR, _DISABLE) |
                      DRF_DEF(_TSTATE, _ERR_FATAL_REPORT_EN_0, _TAGPOOLBUFERR, __PROD) |
                      DRF_DEF(_TSTATE, _ERR_FATAL_REPORT_EN_0, _TAGPOOL_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_TSTATE, _ERR_FATAL_REPORT_EN_0, _TAGPOOL_ECC_LIMIT_ERR, _DISABLE));
    
    NVSWITCH_ENG_WR32(device, NPORT, _BCAST, 0, _TSTATE, _ERR_LOG_EN_0,
                      DRF_DEF(_TSTATE, _ERR_LOG_EN_0, _ATO_ERR, __PROD) |
                      DRF_DEF(_TSTATE, _ERR_LOG_EN_0, _CAMRSP_ERR, __PROD) |
                      DRF_DEF(_TSTATE, _ERR_LOG_EN_0, _CRUMBSTOREBUFERR, __PROD) |
                      DRF_DEF(_TSTATE, _ERR_LOG_EN_0, _CRUMBSTORE_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_TSTATE, _ERR_LOG_EN_0, _CRUMBSTORE_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_TSTATE, _ERR_LOG_EN_0, _TAGPOOLBUFERR, __PROD) |
                      DRF_DEF(_TSTATE, _ERR_LOG_EN_0, _TAGPOOL_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_TSTATE, _ERR_LOG_EN_0, _TAGPOOL_ECC_LIMIT_ERR, __PROD));
    
    NVSWITCH_ENG_WR32(device, NPORT, _BCAST, 0, _TSTATE, _ERR_NON_FATAL_REPORT_EN_0,
                      DRF_DEF(_TSTATE, _ERR_NON_FATAL_REPORT_EN_0, _ATO_ERR, _DISABLE) |
                      DRF_DEF(_TSTATE, _ERR_NON_FATAL_REPORT_EN_0, _CAMRSP_ERR, _DISABLE) |
                      DRF_DEF(_TSTATE, _ERR_NON_FATAL_REPORT_EN_0, _CRUMBSTOREBUFERR, _DISABLE) |
                      DRF_DEF(_TSTATE, _ERR_NON_FATAL_REPORT_EN_0, _CRUMBSTORE_ECC_DBE_ERR, _DISABLE) |
                      DRF_DEF(_TSTATE, _ERR_NON_FATAL_REPORT_EN_0, _CRUMBSTORE_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_TSTATE, _ERR_NON_FATAL_REPORT_EN_0, _TAGPOOLBUFERR, _DISABLE) |
                      DRF_DEF(_TSTATE, _ERR_NON_FATAL_REPORT_EN_0, _TAGPOOL_ECC_DBE_ERR, _DISABLE) |
                      DRF_DEF(_TSTATE, _ERR_NON_FATAL_REPORT_EN_0, _TAGPOOL_ECC_LIMIT_ERR, __PROD));

    return NVL_SUCCESS;
}
#endif


/*
 * @Brief : Fill In
 *
 * @Description : Fill In
 *
 * @paramin : Fill In
 *
 */

NvlStatus
nvswitch_apply_prod_nvlw_ls10
(
    nvswitch_device *device
)
{
    

    // .Apply PROD to NVLW registers
    
    NVSWITCH_ENG_WR32(device, CPR, _BCAST, 0, _CPR_SYS, _ERR_LOG_EN_0,
                      DRF_DEF(_CPR_SYS, _ERR_LOG_EN_0, _ENGINE_RESET_ERR, __PROD));
    
    NVSWITCH_ENG_WR32(device, CPR, _BCAST, 0, _CPR_SYS, _NVLW_CG1,
                      DRF_DEF(_CPR_SYS, _NVLW_CG1, _SLCG, __PROD));

    return NVL_SUCCESS;
}


/*
 * @Brief : Fill In
 *
 * @Description : Fill In
 *
 * @paramin : Fill In
 *
 */

NvlStatus
nvswitch_apply_prod_nxbar_ls10
(
    nvswitch_device *device
)
{
// Moving this L2 register access to SOE. Refer bug #3747687 
#if 0 
    // .NXBAR PROD value application
    
    NVSWITCH_ENG_WR32(device, TILEOUT, _BCAST, 0, _NXBAR_TILEOUT, _CTRL0,
                      DRF_DEF(_NXBAR_TILEOUT, _CTRL0, _MULTI_VALID_XFN_CTRL, _ENABLE) |
                      DRF_DEF(_NXBAR_TILEOUT, _CTRL0, _PARTIAL_RAM_WR_CTRL, _ENABLE) |
                      DRF_DEF(_NXBAR_TILEOUT, _CTRL0, _PRI_FGCG_CTRL, __PROD));
    
    NVSWITCH_ENG_WR32(device, TILEOUT, _BCAST, 0, _NXBAR_TILEOUT, _ERR_FATAL_INTR_EN,
                      DRF_DEF(_NXBAR_TILEOUT, _ERR_FATAL_INTR_EN, _EGRESS_CDT_PARITY_ERROR, __PROD) |
                      DRF_DEF(_NXBAR_TILEOUT, _ERR_FATAL_INTR_EN, _EGRESS_CREDIT_OVERFLOW, __PROD) |
                      DRF_DEF(_NXBAR_TILEOUT, _ERR_FATAL_INTR_EN, _EGRESS_CREDIT_UNDERFLOW, __PROD) |
                      DRF_DEF(_NXBAR_TILEOUT, _ERR_FATAL_INTR_EN, _INGRESS_BUFFER_OVERFLOW, __PROD) |
                      DRF_DEF(_NXBAR_TILEOUT, _ERR_FATAL_INTR_EN, _INGRESS_BUFFER_UNDERFLOW, __PROD) |
                      DRF_DEF(_NXBAR_TILEOUT, _ERR_FATAL_INTR_EN, _INGRESS_BURST_GT_9_DATA_VC, __PROD) |
                      DRF_DEF(_NXBAR_TILEOUT, _ERR_FATAL_INTR_EN, _INGRESS_NON_BURSTY_PKT, __PROD) |
                      DRF_DEF(_NXBAR_TILEOUT, _ERR_FATAL_INTR_EN, _INGRESS_NON_STICKY_PKT, __PROD));
#endif // 0
    
    NVSWITCH_ENG_WR32(device, TILEOUT, _BCAST, 0, _NXBAR_TILEOUT, _PRI_NXBAR_TILEOUT_CG,
                      DRF_DEF(_NXBAR_TILEOUT, _PRI_NXBAR_TILEOUT_CG, _DI_DT_SKEW_VAL, __PROD) |
                      DRF_DEF(_NXBAR_TILEOUT, _PRI_NXBAR_TILEOUT_CG, _HALT_CG_EN, __PROD) |
                      DRF_DEF(_NXBAR_TILEOUT, _PRI_NXBAR_TILEOUT_CG, _IDLE_CG_DLY_CNT, __PROD) |
                      DRF_DEF(_NXBAR_TILEOUT, _PRI_NXBAR_TILEOUT_CG, _IDLE_CG_EN, __PROD) |
                      DRF_DEF(_NXBAR_TILEOUT, _PRI_NXBAR_TILEOUT_CG, _PAUSE_CG_EN, __PROD) |
                      DRF_DEF(_NXBAR_TILEOUT, _PRI_NXBAR_TILEOUT_CG, _QUIESCENT_CG_EN, __PROD) |
                      DRF_DEF(_NXBAR_TILEOUT, _PRI_NXBAR_TILEOUT_CG, _STALL_CG_DLY_CNT, __PROD) |
                      DRF_DEF(_NXBAR_TILEOUT, _PRI_NXBAR_TILEOUT_CG, _STALL_CG_EN, __PROD) |
                      DRF_DEF(_NXBAR_TILEOUT, _PRI_NXBAR_TILEOUT_CG, _STATE_CG_EN, __PROD) |
                      DRF_DEF(_NXBAR_TILEOUT, _PRI_NXBAR_TILEOUT_CG, _THROT_CLK_CNT, __PROD) |
                      DRF_DEF(_NXBAR_TILEOUT, _PRI_NXBAR_TILEOUT_CG, _THROT_CLK_EN, __PROD) |
                      DRF_DEF(_NXBAR_TILEOUT, _PRI_NXBAR_TILEOUT_CG, _THROT_CLK_SW_OVER, __PROD) |
                      DRF_DEF(_NXBAR_TILEOUT, _PRI_NXBAR_TILEOUT_CG, _WAKEUP_DLY_CNT, __PROD));
    
    NVSWITCH_ENG_WR32(device, TILEOUT, _BCAST, 0, _NXBAR_TILEOUT, _PRI_NXBAR_TILEOUT_CG1,
                      DRF_DEF(_NXBAR_TILEOUT, _PRI_NXBAR_TILEOUT_CG1, _MONITOR_CG_EN, __PROD));

// Moving this L2 register access to SOE. Refer bug #3747687 
#if 0
    NVSWITCH_ENG_WR32(device, TILE, _BCAST, 0, _NXBAR_TILE, _CTRL0,
                      DRF_DEF(_NXBAR_TILE, _CTRL0, _MULTI_VALID_XFN_CTRL, _ENABLE) |
                      DRF_DEF(_NXBAR_TILE, _CTRL0, _PARTIAL_RAM_WR_CTRL, _ENABLE) |
                      DRF_DEF(_NXBAR_TILE, _CTRL0, _PRI_FGCG_CTRL, __PROD));
    
    NVSWITCH_ENG_WR32(device, TILE, _BCAST, 0, _NXBAR_TILE, _ERR_FATAL_INTR_EN,
                      DRF_DEF(_NXBAR_TILE, _ERR_FATAL_INTR_EN, _EGRESS_CREDIT_OVERFLOW, __PROD) |
                      DRF_DEF(_NXBAR_TILE, _ERR_FATAL_INTR_EN, _EGRESS_CREDIT_UNDERFLOW, __PROD) |
                      DRF_DEF(_NXBAR_TILE, _ERR_FATAL_INTR_EN, _INGRESS_BUFFER_OVERFLOW, __PROD) |
                      DRF_DEF(_NXBAR_TILE, _ERR_FATAL_INTR_EN, _INGRESS_BUFFER_UNDERFLOW, __PROD) |
                      DRF_DEF(_NXBAR_TILE, _ERR_FATAL_INTR_EN, _INGRESS_BURST_GT_9_DATA_VC, __PROD) |
                      DRF_DEF(_NXBAR_TILE, _ERR_FATAL_INTR_EN, _INGRESS_NON_BURSTY_PKT, __PROD) |
                      DRF_DEF(_NXBAR_TILE, _ERR_FATAL_INTR_EN, _INGRESS_NON_STICKY_PKT, __PROD) |
                      DRF_DEF(_NXBAR_TILE, _ERR_FATAL_INTR_EN, _INGRESS_PKT_INVALID_DST, __PROD) |
                      DRF_DEF(_NXBAR_TILE, _ERR_FATAL_INTR_EN, _INGRESS_PKT_PARITY_ERROR, __PROD) |
                      DRF_DEF(_NXBAR_TILE, _ERR_FATAL_INTR_EN, _INGRESS_REDUCTION_PKT_ERROR, __PROD) |
                      DRF_DEF(_NXBAR_TILE, _ERR_FATAL_INTR_EN, _INGRESS_SIDEBAND_PARITY_ERROR, __PROD));
#endif  // 0
    NVSWITCH_ENG_WR32(device, TILE, _BCAST, 0, _NXBAR_TILE, _PRI_NXBAR_TILE_CG,
                      DRF_DEF(_NXBAR_TILE, _PRI_NXBAR_TILE_CG, _DI_DT_SKEW_VAL, __PROD) |
                      DRF_DEF(_NXBAR_TILE, _PRI_NXBAR_TILE_CG, _HALT_CG_EN, __PROD) |
                      DRF_DEF(_NXBAR_TILE, _PRI_NXBAR_TILE_CG, _IDLE_CG_DLY_CNT, __PROD) |
                      DRF_DEF(_NXBAR_TILE, _PRI_NXBAR_TILE_CG, _IDLE_CG_EN, __PROD) |
                      DRF_DEF(_NXBAR_TILE, _PRI_NXBAR_TILE_CG, _PAUSE_CG_EN, __PROD) |
                      DRF_DEF(_NXBAR_TILE, _PRI_NXBAR_TILE_CG, _QUIESCENT_CG_EN, __PROD) |
                      DRF_DEF(_NXBAR_TILE, _PRI_NXBAR_TILE_CG, _STALL_CG_DLY_CNT, __PROD) |
                      DRF_DEF(_NXBAR_TILE, _PRI_NXBAR_TILE_CG, _STALL_CG_EN, __PROD) |
                      DRF_DEF(_NXBAR_TILE, _PRI_NXBAR_TILE_CG, _STATE_CG_EN, __PROD) |
                      DRF_DEF(_NXBAR_TILE, _PRI_NXBAR_TILE_CG, _THROT_CLK_CNT, __PROD) |
                      DRF_DEF(_NXBAR_TILE, _PRI_NXBAR_TILE_CG, _THROT_CLK_EN, __PROD) |
                      DRF_DEF(_NXBAR_TILE, _PRI_NXBAR_TILE_CG, _THROT_CLK_SW_OVER, __PROD) |
                      DRF_DEF(_NXBAR_TILE, _PRI_NXBAR_TILE_CG, _WAKEUP_DLY_CNT, __PROD));
    
    NVSWITCH_ENG_WR32(device, TILE, _BCAST, 0, _NXBAR_TILE, _PRI_NXBAR_TILE_CG1,
                      DRF_DEF(_NXBAR_TILE, _PRI_NXBAR_TILE_CG1, _MONITOR_CG_EN, __PROD));

    return NVL_SUCCESS;
}


/*
 * @Brief : Fill In
 *
 * @Description : Fill In
 *
 * @paramin : Fill In
 *
 */

NvlStatus
nvswitch_nvs_top_prod_ls10
(
    nvswitch_device *device
)
{
    NvU32   i;

    // .NVS_TOP PROD application
 // Moving this L2 register access to SOE. Refer bug #3747687 
#if 0 
    NVSWITCH_ENG_WR32(device, CLKS_P0,  , 0, _CLOCK_NVSW_PRT, _NVLINK_UPHY0_PLL0_SLCG,
                      DRF_DEF(_CLOCK_NVSW_PRT, _NVLINK_UPHY0_PLL0_SLCG, _CFGSM, __PROD));
    
    NVSWITCH_ENG_WR32(device, CLKS_P0,  , 1, _CLOCK_NVSW_PRT, _NVLINK_UPHY0_PLL0_SLCG,
                      DRF_DEF(_CLOCK_NVSW_PRT, _NVLINK_UPHY0_PLL0_SLCG, _CFGSM, __PROD));
    
    NVSWITCH_ENG_WR32(device, CLKS_P0,  , 2, _CLOCK_NVSW_PRT, _NVLINK_UPHY0_PLL0_SLCG,
                      DRF_DEF(_CLOCK_NVSW_PRT, _NVLINK_UPHY0_PLL0_SLCG, _CFGSM, __PROD));
    
    NVSWITCH_ENG_WR32(device, CLKS_P0,  , 3, _CLOCK_NVSW_PRT, _NVLINK_UPHY0_PLL0_SLCG,
                      DRF_DEF(_CLOCK_NVSW_PRT, _NVLINK_UPHY0_PLL0_SLCG, _CFGSM, __PROD));
#endif // 0
    NVSWITCH_ENG_WR32(device, GIN,  , 0, _CTRL, _PRI_CTRL_CG1,
                      DRF_DEF(_CTRL, _PRI_CTRL_CG1, _SLCG_CTRLPRI, __PROD) |
                      DRF_DEF(_CTRL, _PRI_CTRL_CG1, _SLCG_MSIX, __PROD));
    
    NVSWITCH_ENG_WR32(device, PRI_MASTER_RS,  , 0, _PPRIV_MASTER, _CG1,
                      DRF_DEF(_PPRIV_MASTER, _CG1, _SLCG, __PROD));
    
    //
    // SU-generated code blindly writes each PRT_PRI_HUB and PRT_PRI_RS_CTRL
    // without checking to see if it is floorswept.  This code fragment is 
    // hand editted into SU-generated code to handle floorsweeping.
    //
    for (i = 0; i < NVSWITCH_ENG_COUNT(device, PRT_PRI_HUB, ); i++)
    {
        if (NVSWITCH_ENG_IS_VALID(device, PRT_PRI_HUB, i))
        {
            NVSWITCH_ENG_WR32(device, PRT_PRI_HUB,  , i, _PPRIV_PRT, _CG1,
                              DRF_DEF(_PPRIV_PRT, _CG1, _SLCG_LOC_PRIV, __PROD) |
                              DRF_DEF(_PPRIV_PRT, _CG1, _SLCG_PM, __PROD) |
                              DRF_DEF(_PPRIV_PRT, _CG1, _SLCG_PRIV_CONFIG_REGS, __PROD) |
                              DRF_DEF(_PPRIV_PRT, _CG1, _SLCG_PRIV_FUNNEL_ARB, __PROD) |
                              DRF_DEF(_PPRIV_PRT, _CG1, _SLCG_PRIV_FUNNEL_DECODER, __PROD) |
                              DRF_DEF(_PPRIV_PRT, _CG1, _SLCG_PRIV_HISTORY_BUFFER, __PROD) |
                              DRF_DEF(_PPRIV_PRT, _CG1, _SLCG_PRIV_MASTER, __PROD) |
                              DRF_DEF(_PPRIV_PRT, _CG1, _SLCG_PRIV_SLAVE, __PROD) |
                              DRF_DEF(_PPRIV_PRT, _CG1, _SLCG_SLOWCLK, __PROD));
        }
    }

    for (i = 0; i < NVSWITCH_ENG_COUNT(device, PRT_PRI_RS_CTRL, ); i++)
    {
        if (NVSWITCH_ENG_IS_VALID(device, PRT_PRI_RS_CTRL, i))
        {
            NVSWITCH_ENG_WR32(device, PRT_PRI_RS_CTRL,  , i, _PPRIV_RS_CTRL_PRT, _CG1,
                              DRF_DEF(_PPRIV_RS_CTRL_PRT, _CG1, _SLCG, __PROD));
        }
    }

    NVSWITCH_ENG_WR32(device, PTIMER,  , 0, _PTIMER, _PRI_TMR_CG1,
                      DRF_DEF(_PTIMER, _PRI_TMR_CG1, _MONITOR_CG_EN, __PROD) |
                      DRF_DEF(_PTIMER, _PRI_TMR_CG1, _SLCG, __PROD));

// Moving this L2 register access to SOE. Refer bug #3747687 
#if 0 
    NVSWITCH_ENG_WR32(device, SAW,  , 0, _NVLSAW, _CTRL_CLOCK_GATING,
                      DRF_DEF(_NVLSAW, _CTRL_CLOCK_GATING, _CG1_SLCG_PCIE, __PROD) |
                      DRF_DEF(_NVLSAW, _CTRL_CLOCK_GATING, _CG1_SLCG_SAW, __PROD));
#endif // 0
    NVSWITCH_ENG_WR32(device, SAW,  , 0, _NVLSAW, _GLBLLATENCYTIMERCTRL,
                      DRF_DEF(_NVLSAW, _GLBLLATENCYTIMERCTRL, _ENABLE, __PROD));
// Moving this L2 register access to SOE. Refer bug #3747687 
#if 0     
    NVSWITCH_ENG_WR32(device, SAW,  , 0, _NVLSAW, _PCIE_PRI_CLOCK_GATING,
                      DRF_DEF(_NVLSAW, _PCIE_PRI_CLOCK_GATING, _CG1_SLCG, __PROD));
#endif // 0

    NVSWITCH_REG_WR32(device, _PSE, _CG1,
                           DRF_DEF(_PSE, _CG1, _SLCG, __PROD));
    
    NVSWITCH_ENG_WR32(device, SOE,  , 0, _SOE, _BAR0_TMOUT,
                      DRF_DEF(_SOE, _BAR0_TMOUT, _CYCLES, __PROD));
    
    NVSWITCH_ENG_WR32(device, SOE,  , 0, _SOE, _FALCON_CG2,
                      DRF_DEF(_SOE, _FALCON_CG2, _SLCG_FALCON_CFG, _DISABLED) |
                      DRF_DEF(_SOE, _FALCON_CG2, _SLCG_FALCON_CTXSW, _DISABLED) |
                      DRF_DEF(_SOE, _FALCON_CG2, _SLCG_FALCON_DIV, _DISABLED) |
                      DRF_DEF(_SOE, _FALCON_CG2, _SLCG_FALCON_DMA, _DISABLED) |
                      DRF_DEF(_SOE, _FALCON_CG2, _SLCG_FALCON_GC6_SR_FSM, _DISABLED) |
                      DRF_DEF(_SOE, _FALCON_CG2, _SLCG_FALCON_GDMA, __PROD) |
                      DRF_DEF(_SOE, _FALCON_CG2, _SLCG_FALCON_GPTMR, _DISABLED) |
                      DRF_DEF(_SOE, _FALCON_CG2, _SLCG_FALCON_ICD, _DISABLED) |
                      DRF_DEF(_SOE, _FALCON_CG2, _SLCG_FALCON_IRQSTAT, _DISABLED) |
                      DRF_DEF(_SOE, _FALCON_CG2, _SLCG_FALCON_LDST, _DISABLED) |
                      DRF_DEF(_SOE, _FALCON_CG2, _SLCG_FALCON_MUL, _DISABLED) |
                      DRF_DEF(_SOE, _FALCON_CG2, _SLCG_FALCON_PIPE, _DISABLED) |
                      DRF_DEF(_SOE, _FALCON_CG2, _SLCG_FALCON_PMB, _DISABLED) |
                      DRF_DEF(_SOE, _FALCON_CG2, _SLCG_FALCON_RF, _DISABLED) |
                      DRF_DEF(_SOE, _FALCON_CG2, _SLCG_FALCON_SHA, __PROD) |
                      DRF_DEF(_SOE, _FALCON_CG2, _SLCG_FALCON_TOP, _DISABLED) |
                      DRF_DEF(_SOE, _FALCON_CG2, _SLCG_FALCON_TSE, __PROD) |
                      DRF_DEF(_SOE, _FALCON_CG2, _SLCG_FALCON_TSYNC, _DISABLED) |
                      DRF_DEF(_SOE, _FALCON_CG2, _SLCG_FALCON_WDTMR, _DISABLED) |
                      DRF_DEF(_SOE, _FALCON_CG2, _SLCG_FBIF, _DISABLED));
    
    NVSWITCH_ENG_WR32(device, SOE,  , 0, _SOE, _MISC_CG1,
                      DRF_DEF(_SOE, _MISC_CG1, _SLCG, __PROD));
    
    NVSWITCH_ENG_WR32(device, SOE,  , 0, _SOE, _PRIV_BLOCKER_CTRL_CG1,
                      DRF_DEF(_SOE, _PRIV_BLOCKER_CTRL_CG1, _SLCG, __PROD));
    
    NVSWITCH_ENG_WR32(device, SYSB_PRI_HUB,  , 0, _PPRIV_SYSB, _CG1,
                      DRF_DEF(_PPRIV_SYSB, _CG1, _SLCG_LOC_PRIV, __PROD) |
                      DRF_DEF(_PPRIV_SYSB, _CG1, _SLCG_PM, __PROD) |
                      DRF_DEF(_PPRIV_SYSB, _CG1, _SLCG_PRIV_CONFIG_REGS, __PROD) |
                      DRF_DEF(_PPRIV_SYSB, _CG1, _SLCG_PRIV_FUNNEL_ARB, __PROD) |
                      DRF_DEF(_PPRIV_SYSB, _CG1, _SLCG_PRIV_FUNNEL_DECODER, __PROD) |
                      DRF_DEF(_PPRIV_SYSB, _CG1, _SLCG_PRIV_HISTORY_BUFFER, __PROD) |
                      DRF_DEF(_PPRIV_SYSB, _CG1, _SLCG_PRIV_MASTER, __PROD) |
                      DRF_DEF(_PPRIV_SYSB, _CG1, _SLCG_PRIV_SLAVE, __PROD) |
                      DRF_DEF(_PPRIV_SYSB, _CG1, _SLCG_SLOWCLK, __PROD));
    
    NVSWITCH_ENG_WR32(device, SYSB_PRI_RS_CTRL,  , 0, _PPRIV_RS_CTRL_SYSB, _CG1,
                      DRF_DEF(_PPRIV_RS_CTRL_SYSB, _CG1, _SLCG, __PROD));
    
    NVSWITCH_ENG_WR32(device, SYS_PRI_HUB,  , 0, _PPRIV_SYS, _CG1,
                      DRF_DEF(_PPRIV_SYS, _CG1, _SLCG_LOC_PRIV, __PROD) |
                      DRF_DEF(_PPRIV_SYS, _CG1, _SLCG_PM, __PROD) |
                      DRF_DEF(_PPRIV_SYS, _CG1, _SLCG_PRIV_CONFIG_REGS, __PROD) |
                      DRF_DEF(_PPRIV_SYS, _CG1, _SLCG_PRIV_FUNNEL_ARB, __PROD) |
                      DRF_DEF(_PPRIV_SYS, _CG1, _SLCG_PRIV_FUNNEL_DECODER, __PROD) |
                      DRF_DEF(_PPRIV_SYS, _CG1, _SLCG_PRIV_HISTORY_BUFFER, __PROD) |
                      DRF_DEF(_PPRIV_SYS, _CG1, _SLCG_PRIV_MASTER, __PROD) |
                      DRF_DEF(_PPRIV_SYS, _CG1, _SLCG_PRIV_SLAVE, __PROD) |
                      DRF_DEF(_PPRIV_SYS, _CG1, _SLCG_SLOWCLK, __PROD));
    
    NVSWITCH_ENG_WR32(device, SYS_PRI_RS_CTRL,  , 0, _PPRIV_RS_CTRL_SYS, _CG1,
                      DRF_DEF(_PPRIV_RS_CTRL_SYS, _CG1, _SLCG, __PROD));
    
    NVSWITCH_ENG_WR32(device, XAL,  , 0, _XAL_EP, _CG,
                      DRF_DEF(_XAL_EP, _CG, _IDLE_CG_DLY_CNT, __PROD) |
                      DRF_DEF(_XAL_EP, _CG, _IDLE_CG_EN, __PROD) |
                      DRF_DEF(_XAL_EP, _CG, _STALL_CG_EN, __PROD) |
                      DRF_DEF(_XAL_EP, _CG, _WAKEUP_DLY_CNT, __PROD));
    
    NVSWITCH_ENG_WR32(device, XAL,  , 0, _XAL_EP, _CG1,
                      DRF_DEF(_XAL_EP, _CG1, _MONITOR_CG_EN, __PROD) |
                      DRF_DEF(_XAL_EP, _CG1, _SLCG_DFD, __PROD) |
                      DRF_DEF(_XAL_EP, _CG1, _SLCG_DOWNARB, __PROD) |
                      DRF_DEF(_XAL_EP, _CG1, _SLCG_FASTFLUSH, __PROD) |
                      DRF_DEF(_XAL_EP, _CG1, _SLCG_FBI_UP, __PROD) |
                      DRF_DEF(_XAL_EP, _CG1, _SLCG_JOIN, __PROD) |
                      DRF_DEF(_XAL_EP, _CG1, _SLCG_JTAG, __PROD) |
                      DRF_DEF(_XAL_EP, _CG1, _SLCG_MEMOP, __PROD) |
                      DRF_DEF(_XAL_EP, _CG1, _SLCG_MEMRSP, __PROD) |
                      DRF_DEF(_XAL_EP, _CG1, _SLCG_MSIX, __PROD) |
                      DRF_DEF(_XAL_EP, _CG1, _SLCG_PM, __PROD) |
                      DRF_DEF(_XAL_EP, _CG1, _SLCG_PRIREQ, __PROD) |
                      DRF_DEF(_XAL_EP, _CG1, _SLCG_PRIRSP, __PROD) |
                      DRF_DEF(_XAL_EP, _CG1, _SLCG_PRI_TRACKER, __PROD) |
                      DRF_DEF(_XAL_EP, _CG1, _SLCG_RXMAP, __PROD) |
                      DRF_DEF(_XAL_EP, _CG1, _SLCG_TXMAP, __PROD) |
                      DRF_DEF(_XAL_EP, _CG1, _SLCG_UNROLL_MEM, __PROD) |
                      DRF_DEF(_XAL_EP, _CG1, _SLCG_UPARB, __PROD));
    
    NVSWITCH_ENG_WR32(device, XPL,  , 0, _XPL, _PL_PAD_CTL_PRI_XPL_RXCLK_CG,
                      DRF_DEF(_XPL, _PL_PAD_CTL_PRI_XPL_RXCLK_CG, _IDLE_CG_DLY_CNT, __PROD) |
                      DRF_DEF(_XPL, _PL_PAD_CTL_PRI_XPL_RXCLK_CG, _IDLE_CG_EN, __PROD) |
                      DRF_DEF(_XPL, _PL_PAD_CTL_PRI_XPL_RXCLK_CG, _STALL_CG_EN, __PROD) |
                      DRF_DEF(_XPL, _PL_PAD_CTL_PRI_XPL_RXCLK_CG, _WAKEUP_DLY_CNT, __PROD));
    
    NVSWITCH_ENG_WR32(device, XPL,  , 0, _XPL, _PL_PAD_CTL_PRI_XPL_RXCLK_CG1,
                      DRF_DEF(_XPL, _PL_PAD_CTL_PRI_XPL_RXCLK_CG1, _MONITOR_CG_EN, __PROD) |
                      DRF_DEF(_XPL, _PL_PAD_CTL_PRI_XPL_RXCLK_CG1, _SLCG, __PROD));
    
    NVSWITCH_ENG_WR32(device, XPL,  , 0, _XPL, _PL_PAD_CTL_PRI_XPL_TXCLK_CG,
                      DRF_DEF(_XPL, _PL_PAD_CTL_PRI_XPL_TXCLK_CG, _IDLE_CG_DLY_CNT, __PROD) |
                      DRF_DEF(_XPL, _PL_PAD_CTL_PRI_XPL_TXCLK_CG, _IDLE_CG_EN, __PROD) |
                      DRF_DEF(_XPL, _PL_PAD_CTL_PRI_XPL_TXCLK_CG, _STALL_CG_EN, __PROD) |
                      DRF_DEF(_XPL, _PL_PAD_CTL_PRI_XPL_TXCLK_CG, _WAKEUP_DLY_CNT, __PROD));
    
    NVSWITCH_ENG_WR32(device, XPL,  , 0, _XPL, _PL_PAD_CTL_PRI_XPL_TXCLK_CG1,
                      DRF_DEF(_XPL, _PL_PAD_CTL_PRI_XPL_TXCLK_CG1, _MONITOR_CG_EN, __PROD) |
                      DRF_DEF(_XPL, _PL_PAD_CTL_PRI_XPL_TXCLK_CG1, _SLCG, __PROD));
    
    NVSWITCH_ENG_WR32(device, XPL,  , 0, _XPL, _PL_PAD_CTL_PRI_XPL_XCLK_CG,
                      DRF_DEF(_XPL, _PL_PAD_CTL_PRI_XPL_XCLK_CG, _IDLE_CG_DLY_CNT, __PROD) |
                      DRF_DEF(_XPL, _PL_PAD_CTL_PRI_XPL_XCLK_CG, _IDLE_CG_EN, __PROD) |
                      DRF_DEF(_XPL, _PL_PAD_CTL_PRI_XPL_XCLK_CG, _STALL_CG_EN, __PROD) |
                      DRF_DEF(_XPL, _PL_PAD_CTL_PRI_XPL_XCLK_CG, _WAKEUP_DLY_CNT, __PROD));
    
    NVSWITCH_ENG_WR32(device, XPL,  , 0, _XPL, _PL_PAD_CTL_PRI_XPL_XCLK_CG1,
                      DRF_DEF(_XPL, _PL_PAD_CTL_PRI_XPL_XCLK_CG1, _MONITOR_CG_EN, __PROD) |
                      DRF_DEF(_XPL, _PL_PAD_CTL_PRI_XPL_XCLK_CG1, _SLCG, __PROD));
    
    NVSWITCH_ENG_WR32(device, XPL,  , 0, _XPL, _XTLQ_PRI_XTL_Q_CG,
                      DRF_DEF(_XPL, _XTLQ_PRI_XTL_Q_CG, _IDLE_CG_DLY_CNT, __PROD) |
                      DRF_DEF(_XPL, _XTLQ_PRI_XTL_Q_CG, _IDLE_CG_EN, __PROD) |
                      DRF_DEF(_XPL, _XTLQ_PRI_XTL_Q_CG, _STALL_CG_EN, __PROD) |
                      DRF_DEF(_XPL, _XTLQ_PRI_XTL_Q_CG, _WAKEUP_DLY_CNT, __PROD));
    
    NVSWITCH_ENG_WR32(device, XPL,  , 0, _XPL, _XTLQ_PRI_XTL_Q_CG1,
                      DRF_DEF(_XPL, _XTLQ_PRI_XTL_Q_CG1, _MONITOR_CG_EN, __PROD) |
                      DRF_DEF(_XPL, _XTLQ_PRI_XTL_Q_CG1, _SLCG, __PROD));
    
    NVSWITCH_ENG_WR32(device, XTL,  , 0, _XTL, _EP_PRI_XTL_EP_CG,
                      DRF_DEF(_XTL, _EP_PRI_XTL_EP_CG, _IDLE_CG_DLY_CNT, __PROD) |
                      DRF_DEF(_XTL, _EP_PRI_XTL_EP_CG, _IDLE_CG_EN, __PROD) |
                      DRF_DEF(_XTL, _EP_PRI_XTL_EP_CG, _STALL_CG_EN, __PROD) |
                      DRF_DEF(_XTL, _EP_PRI_XTL_EP_CG, _WAKEUP_DLY_CNT, __PROD));
    
    NVSWITCH_ENG_WR32(device, XTL,  , 0, _XTL, _EP_PRI_XTL_EP_CG1,
                      DRF_DEF(_XTL, _EP_PRI_XTL_EP_CG1, _MONITOR_CG_EN, __PROD) |
                      DRF_DEF(_XTL, _EP_PRI_XTL_EP_CG1, _SLCG, __PROD));

    return NVL_SUCCESS;
}


/*
 * @Brief : Fill In
 *
 * @Description : Fill In
 *
 * @paramin : Fill In
 *
 */

NvlStatus
nvswitch_npg_init_ls10
(
    nvswitch_device *device
)
{
    NvU32 command;
    NvBool keepPolling;
    NVSWITCH_TIMEOUT timeout;

    // .Non-Routing initialzation of NPG 
    
    // .  Clear all the routing rams, use broadcast write
    
    // .. _Note_ : There are 6 new RAMs to initialize 
    
    NVSWITCH_ENG_WR32(device, NPORT, _BCAST, 0, _NPORT, _INITIALIZATION,
                      DRF_DEF(_NPORT, _INITIALIZATION, _EXTMCRIDINIT, _HWINIT) |
                      DRF_DEF(_NPORT, _INITIALIZATION, _LINKTABLEINIT, _HWINIT) |
                      DRF_DEF(_NPORT, _INITIALIZATION, _MCREDBUFINIT, _HWINIT) |
                      DRF_DEF(_NPORT, _INITIALIZATION, _MCREDSGTINIT, _HWINIT) |
                      DRF_DEF(_NPORT, _INITIALIZATION, _MCREMAPTABINIT, _HWINIT) |
                      DRF_DEF(_NPORT, _INITIALIZATION, _MCRIDINIT, _HWINIT) |
                      DRF_DEF(_NPORT, _INITIALIZATION, _MCTAGSTATEINIT, _HWINIT) |
                      DRF_DEF(_NPORT, _INITIALIZATION, _RDTAGSTATEINIT, _HWINIT) |
                      DRF_DEF(_NPORT, _INITIALIZATION, _REMAPTABINIT, _HWINIT) |
                      DRF_DEF(_NPORT, _INITIALIZATION, _RIDTABINIT, _HWINIT) |
                      DRF_DEF(_NPORT, _INITIALIZATION, _RLANTABINIT, _HWINIT) |
                      DRF_DEF(_NPORT, _INITIALIZATION, _TAGPOOLINIT_0, _HWINIT));
    
    // .  Ensure RAM initialization has completed, use broadcast read
    
    nvswitch_timeout_create(NVSWITCH_INTERVAL_1MSEC_IN_NS, &timeout);
    
    do 
    {
        keepPolling = (nvswitch_timeout_check(&timeout)) ? NV_FALSE : NV_TRUE;
        command = NVSWITCH_ENG_RD32(device, NPORT, _BCAST, 0, _NPORT, _INITIALIZATION);
    
        if ( FLD_TEST_DRF(_NPORT, _INITIALIZATION, _EXTMCRIDINIT, _HWINIT, command) &&
             FLD_TEST_DRF(_NPORT, _INITIALIZATION, _LINKTABLEINIT, _HWINIT, command) &&
             FLD_TEST_DRF(_NPORT, _INITIALIZATION, _MCREDBUFINIT, _HWINIT, command) &&
             FLD_TEST_DRF(_NPORT, _INITIALIZATION, _MCREDSGTINIT, _HWINIT, command) &&
             FLD_TEST_DRF(_NPORT, _INITIALIZATION, _MCREMAPTABINIT, _HWINIT, command) &&
             FLD_TEST_DRF(_NPORT, _INITIALIZATION, _MCRIDINIT, _HWINIT, command) &&
             FLD_TEST_DRF(_NPORT, _INITIALIZATION, _MCTAGSTATEINIT, _HWINIT, command) &&
             FLD_TEST_DRF(_NPORT, _INITIALIZATION, _RDTAGSTATEINIT, _HWINIT, command) &&
             FLD_TEST_DRF(_NPORT, _INITIALIZATION, _REMAPTABINIT, _HWINIT, command) &&
             FLD_TEST_DRF(_NPORT, _INITIALIZATION, _RIDTABINIT, _HWINIT, command) &&
             FLD_TEST_DRF(_NPORT, _INITIALIZATION, _RLANTABINIT, _HWINIT, command) &&
             FLD_TEST_DRF(_NPORT, _INITIALIZATION, _TAGPOOLINIT_0, _HWINIT, command) )
        {
            break;
        }
        if ( keepPolling == NV_FALSE )
        {
            NVSWITCH_PRINT(device, ERROR, "%s: -- Poll timeout for NPORT 0 _NPORT _INITIALIZATION --\n", __FUNCTION__);
            return -NVL_ERR_GENERIC;
        }
    }
    while (keepPolling);

    return NVL_SUCCESS;
}


/*
 * @Brief : Fill In
 *
 * @Description : Fill In
 *
 * @paramin : Fill In
 *
 */
#if 0
NvlStatus
nvswitch_npg_trunk_prod_ls10
(
    nvswitch_device *device
)
{
    

    // .NPG PROD value for Trunk Links
    
    // _NOTE_: Added 8/11/2021 
    
    
    //  *** Software needs to update this function support passing of instance as it is hardcoded to port 0
    
    NVSWITCH_ENG_WR32(device, NPORT,  , 0, _EGRESS, _CTRL,
                      DRF_DEF(_EGRESS, _CTRL, _CTO_ENB, __TPROD) |
                      DRF_DEF(_EGRESS, _CTRL, _ZERO_OUT_SWXATTR_DISABLE, _OFF));
    
    NVSWITCH_ENG_WR32(device, NPORT,  , 0, _EGRESS, _ERR_CONTAIN_EN_0,
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_0, _CREDIT_TIME_OUT_ERR, __TPROD) |
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_0, _EGRESSBUFERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_0, _HWRSPERR, __TPROD) |
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_0, _INVALIDVCSET_ERR, __TPROD) |
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_0, _NCISOCCREDITOVFL, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_0, _NCISOC_CREDIT_PARITY_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_0, _NXBAR_FLITTYPE_MISMATCH_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_0, _NXBAR_HDR_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_0, _NXBAR_HDR_ECC_LIMIT_ERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_0, _NXBAR_HDR_PARITY_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_0, _NXBAR_SIDEBAND_PD_PARITY_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_0, _PKTROUTEERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_0, _PRIVRSPERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_0, _RAM_OUT_HDR_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_0, _RAM_OUT_HDR_ECC_LIMIT_ERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_0, _REQTGTIDMISMATCHERR, __TPROD) |
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_0, _RFU, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_0, _RSPREQIDMISMATCHERR, __TPROD) |
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_0, _SEQIDERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_CONTAIN_EN_0, _URRSPERR, __TPROD));
    
    NVSWITCH_ENG_WR32(device, NPORT,  , 0, _EGRESS, _ERR_FATAL_REPORT_EN_0,
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_0, _CREDIT_TIME_OUT_ERR, __TPROD) |
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_0, _EGRESSBUFERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_0, _HWRSPERR, __TPROD) |
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_0, _INVALIDVCSET_ERR, __TPROD) |
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_0, _NCISOCCREDITOVFL, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_0, _NCISOC_CREDIT_PARITY_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_0, _NXBAR_FLITTYPE_MISMATCH_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_0, _NXBAR_HDR_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_0, _NXBAR_HDR_ECC_LIMIT_ERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_0, _NXBAR_HDR_PARITY_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_0, _NXBAR_SIDEBAND_PD_PARITY_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_0, _PKTROUTEERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_0, _PRIVRSPERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_0, _RAM_OUT_HDR_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_0, _RAM_OUT_HDR_ECC_LIMIT_ERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_0, _REQTGTIDMISMATCHERR, __TPROD) |
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_0, _RFU, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_0, _RSPREQIDMISMATCHERR, __TPROD) |
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_0, _SEQIDERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_FATAL_REPORT_EN_0, _URRSPERR, __TPROD));
    
    NVSWITCH_ENG_WR32(device, NPORT,  , 0, _EGRESS, _ERR_LOG_EN_0,
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_0, _CREDIT_TIME_OUT_ERR, __TPROD) |
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_0, _EGRESSBUFERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_0, _HWRSPERR, __TPROD) |
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_0, _INVALIDVCSET_ERR, __TPROD) |
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_0, _NCISOCCREDITOVFL, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_0, _NCISOC_CREDIT_PARITY_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_0, _NXBAR_FLITTYPE_MISMATCH_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_0, _NXBAR_HDR_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_0, _NXBAR_HDR_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_0, _NXBAR_HDR_PARITY_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_0, _NXBAR_SIDEBAND_PD_PARITY_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_0, _PKTROUTEERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_0, _PRIVRSPERR, __TPROD) |
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_0, _RAM_OUT_HDR_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_0, _RAM_OUT_HDR_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_0, _REQTGTIDMISMATCHERR, __TPROD) |
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_0, _RFU, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_0, _RSPREQIDMISMATCHERR, __TPROD) |
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_0, _SEQIDERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_LOG_EN_0, _URRSPERR, __TPROD));
    
    NVSWITCH_ENG_WR32(device, NPORT,  , 0, _EGRESS, _ERR_NON_FATAL_REPORT_EN_0,
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_0, _CREDIT_TIME_OUT_ERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_0, _EGRESSBUFERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_0, _HWRSPERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_0, _INVALIDVCSET_ERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_0, _NCISOCCREDITOVFL, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_0, _NCISOC_CREDIT_PARITY_ERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_0, _NXBAR_FLITTYPE_MISMATCH_ERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_0, _NXBAR_HDR_ECC_DBE_ERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_0, _NXBAR_HDR_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_0, _NXBAR_HDR_PARITY_ERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_0, _NXBAR_SIDEBAND_PD_PARITY_ERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_0, _PKTROUTEERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_0, _PRIVRSPERR, __TPROD) |
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_0, _RAM_OUT_HDR_ECC_DBE_ERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_0, _RAM_OUT_HDR_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_0, _REQTGTIDMISMATCHERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_0, _RFU, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_0, _RSPREQIDMISMATCHERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_0, _SEQIDERR, _DISABLE) |
                      DRF_DEF(_EGRESS, _ERR_NON_FATAL_REPORT_EN_0, _URRSPERR, _DISABLE));
    
    NVSWITCH_ENG_WR32(device, NPORT,  , 0, _INGRESS, _ERR_CONTAIN_EN_0,
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _ACLFAIL, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _ADDRBOUNDSERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _ADDRTYPEERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _CMDDECODEERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _EXTAREMAPTAB_ACLFAIL, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _EXTAREMAPTAB_ADDRBOUNDSERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _EXTAREMAPTAB_ECC_DBE_ERR, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _EXTAREMAPTAB_INDEX_ERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _EXTAREMAPTAB_REQCONTEXTMISMATCHERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _EXTBREMAPTAB_ACLFAIL, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _EXTBREMAPTAB_ADDRBOUNDSERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _EXTBREMAPTAB_ECC_DBE_ERR, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _EXTBREMAPTAB_INDEX_ERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _EXTBREMAPTAB_REQCONTEXTMISMATCHERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _INVALIDVCSET, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _MCREMAPTAB_ACLFAIL, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _MCREMAPTAB_ADDRBOUNDSERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _MCREMAPTAB_ECC_DBE_ERR, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _MCREMAPTAB_INDEX_ERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _MCREMAPTAB_REQCONTEXTMISMATCHERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _NCISOC_HDR_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _NCISOC_HDR_ECC_LIMIT_ERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _NCISOC_PARITY_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _REMAPTAB_ECC_DBE_ERR, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _REMAPTAB_ECC_LIMIT_ERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _REQCONTEXTMISMATCHERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _RIDTABCFGERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _RIDTAB_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _RIDTAB_ECC_LIMIT_ERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _RLANTABCFGERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _RLANTAB_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_CONTAIN_EN_0, _RLANTAB_ECC_LIMIT_ERR, _DISABLE));
    
    NVSWITCH_ENG_WR32(device, NPORT,  , 0, _INGRESS, _ERR_FATAL_REPORT_EN_0,
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _ACLFAIL, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _ADDRBOUNDSERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _ADDRTYPEERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _CMDDECODEERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _EXTAREMAPTAB_ACLFAIL, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _EXTAREMAPTAB_ADDRBOUNDSERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _EXTAREMAPTAB_ECC_DBE_ERR, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _EXTAREMAPTAB_INDEX_ERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _EXTAREMAPTAB_REQCONTEXTMISMATCHERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _EXTBREMAPTAB_ACLFAIL, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _EXTBREMAPTAB_ADDRBOUNDSERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _EXTBREMAPTAB_ECC_DBE_ERR, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _EXTBREMAPTAB_INDEX_ERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _EXTBREMAPTAB_REQCONTEXTMISMATCHERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _INVALIDVCSET, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _MCREMAPTAB_ACLFAIL, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _MCREMAPTAB_ADDRBOUNDSERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _MCREMAPTAB_ECC_DBE_ERR, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _MCREMAPTAB_INDEX_ERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _MCREMAPTAB_REQCONTEXTMISMATCHERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _NCISOC_HDR_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _NCISOC_HDR_ECC_LIMIT_ERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _NCISOC_PARITY_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _REMAPTAB_ECC_DBE_ERR, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _REMAPTAB_ECC_LIMIT_ERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _REQCONTEXTMISMATCHERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _RIDTABCFGERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _RIDTAB_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _RIDTAB_ECC_LIMIT_ERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _RLANTABCFGERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _RLANTAB_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_FATAL_REPORT_EN_0, _RLANTAB_ECC_LIMIT_ERR, _DISABLE));
    
    NVSWITCH_ENG_WR32(device, NPORT,  , 0, _INGRESS, _ERR_LOG_EN_0,
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _ACLFAIL, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _ADDRBOUNDSERR, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _ADDRTYPEERR, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _CMDDECODEERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _EXTAREMAPTAB_ACLFAIL, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _EXTAREMAPTAB_ADDRBOUNDSERR, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _EXTAREMAPTAB_ECC_DBE_ERR, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _EXTAREMAPTAB_INDEX_ERR, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _EXTAREMAPTAB_REQCONTEXTMISMATCHERR, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _EXTBREMAPTAB_ACLFAIL, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _EXTBREMAPTAB_ADDRBOUNDSERR, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _EXTBREMAPTAB_ECC_DBE_ERR, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _EXTBREMAPTAB_INDEX_ERR, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _EXTBREMAPTAB_REQCONTEXTMISMATCHERR, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _INVALIDVCSET, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _MCREMAPTAB_ACLFAIL, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _MCREMAPTAB_ADDRBOUNDSERR, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _MCREMAPTAB_ECC_DBE_ERR, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _MCREMAPTAB_INDEX_ERR, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _MCREMAPTAB_REQCONTEXTMISMATCHERR, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _NCISOC_HDR_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _NCISOC_HDR_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _NCISOC_PARITY_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _REMAPTAB_ECC_DBE_ERR, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _REMAPTAB_ECC_LIMIT_ERR, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _REQCONTEXTMISMATCHERR, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _RIDTABCFGERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _RIDTAB_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _RIDTAB_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _RLANTABCFGERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _RLANTAB_ECC_DBE_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_0, _RLANTAB_ECC_LIMIT_ERR, __PROD));
    
    NVSWITCH_ENG_WR32(device, NPORT,  , 0, _INGRESS, _ERR_LOG_EN_1,
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_1, _EXTAREMAPTAB_ADDRTYPEERR, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_1, _EXTAREMAPTAB_ECC_LIMIT_ERR, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_1, _EXTBREMAPTAB_ADDRTYPEERR, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_1, _EXTBREMAPTAB_ECC_LIMIT_ERR, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_1, _MCCMDTOUCADDRERR, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_1, _MCREMAPTAB_ADDRTYPEERR, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_1, _MCREMAPTAB_ECC_LIMIT_ERR, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_LOG_EN_1, _READMCREFLECTMEMERR, __TPROD));
    
    NVSWITCH_ENG_WR32(device, NPORT,  , 0, _INGRESS, _ERR_NON_FATAL_REPORT_EN_0,
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _ACLFAIL, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _ADDRBOUNDSERR, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _ADDRTYPEERR, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _CMDDECODEERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _EXTAREMAPTAB_ACLFAIL, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _EXTAREMAPTAB_ADDRBOUNDSERR, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _EXTAREMAPTAB_ECC_DBE_ERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _EXTAREMAPTAB_INDEX_ERR, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _EXTAREMAPTAB_REQCONTEXTMISMATCHERR, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _EXTBREMAPTAB_ACLFAIL, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _EXTBREMAPTAB_ADDRBOUNDSERR, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _EXTBREMAPTAB_ECC_DBE_ERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _EXTBREMAPTAB_INDEX_ERR, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _EXTBREMAPTAB_REQCONTEXTMISMATCHERR, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _INVALIDVCSET, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _MCREMAPTAB_ACLFAIL, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _MCREMAPTAB_ADDRBOUNDSERR, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _MCREMAPTAB_ECC_DBE_ERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _MCREMAPTAB_INDEX_ERR, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _MCREMAPTAB_REQCONTEXTMISMATCHERR, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _NCISOC_HDR_ECC_DBE_ERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _NCISOC_HDR_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _NCISOC_PARITY_ERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _REMAPTAB_ECC_DBE_ERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _REMAPTAB_ECC_LIMIT_ERR, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _REQCONTEXTMISMATCHERR, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _RIDTABCFGERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _RIDTAB_ECC_DBE_ERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _RIDTAB_ECC_LIMIT_ERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _RLANTABCFGERR, __PROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _RLANTAB_ECC_DBE_ERR, _DISABLE) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_0, _RLANTAB_ECC_LIMIT_ERR, __PROD));
    
    NVSWITCH_ENG_WR32(device, NPORT,  , 0, _INGRESS, _ERR_NON_FATAL_REPORT_EN_1,
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_1, _EXTAREMAPTAB_ADDRTYPEERR, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_1, _EXTAREMAPTAB_ECC_LIMIT_ERR, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_1, _EXTBREMAPTAB_ADDRTYPEERR, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_1, _EXTBREMAPTAB_ECC_LIMIT_ERR, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_1, _MCCMDTOUCADDRERR, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_1, _MCREMAPTAB_ADDRTYPEERR, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_1, _MCREMAPTAB_ECC_LIMIT_ERR, __TPROD) |
                      DRF_DEF(_INGRESS, _ERR_NON_FATAL_REPORT_EN_1, _READMCREFLECTMEMERR, __TPROD));
    
    NVSWITCH_ENG_WR32(device, NPORT,  , 0, _NPORT, _CTRL,
                      DRF_DEF(_NPORT, _CTRL, _EGDRAINENB, _DISABLE) |
                      DRF_DEF(_NPORT, _CTRL, _ENEGRESSDBI, _ENABLE) |
                      DRF_DEF(_NPORT, _CTRL, _ENROUTEDBI, _ENABLE) |
                      DRF_DEF(_NPORT, _CTRL, _RTDRAINENB, _DISABLE) |
                      DRF_DEF(_NPORT, _CTRL, _SPARE, _INIT) |
                      DRF_DEF(_NPORT, _CTRL, _TRUNKLINKENB, __TPROD));
    
    NVSWITCH_ENG_WR32(device, NPORT,  , 0, _SOURCETRACK, _ERR_CONTAIN_EN_0,
                      DRF_DEF(_SOURCETRACK, _ERR_CONTAIN_EN_0, _CREQ_TCEN0_CRUMBSTORE_ECC_DBE_ERR, __TPROD) |
                      DRF_DEF(_SOURCETRACK, _ERR_CONTAIN_EN_0, _CREQ_TCEN0_CRUMBSTORE_ECC_LIMIT_ERR, _DISABLE) |
                      DRF_DEF(_SOURCETRACK, _ERR_CONTAIN_EN_0, _DUP_CREQ_TCEN0_TAG_ERR, __TPROD) |
                      DRF_DEF(_SOURCETRACK, _ERR_CONTAIN_EN_0, _INVALID_TCEN0_RSP_ERR, __TPROD) |
                      DRF_DEF(_SOURCETRACK, _ERR_CONTAIN_EN_0, _INVALID_TCEN1_RSP_ERR, __TPROD) |
                      DRF_DEF(_SOURCETRACK, _ERR_CONTAIN_EN_0, _SOURCETRACK_TIME_OUT_ERR, __TPROD));
    
    NVSWITCH_ENG_WR32(device, NPORT,  , 0, _SOURCETRACK, _ERR_FATAL_REPORT_EN_0,
                      DRF_DEF(_SOURCETRACK, _ERR_FATAL_REPORT_EN_0, _CREQ_TCEN0_CRUMBSTORE_ECC_DBE_ERR, __TPROD) |
                      DRF_DEF(_SOURCETRACK, _ERR_FATAL_REPORT_EN_0, _CREQ_TCEN0_CRUMBSTORE_ECC_LIMIT_ERR, _DISABLE) |
                      DRF_DEF(_SOURCETRACK, _ERR_FATAL_REPORT_EN_0, _DUP_CREQ_TCEN0_TAG_ERR, __TPROD) |
                      DRF_DEF(_SOURCETRACK, _ERR_FATAL_REPORT_EN_0, _INVALID_TCEN0_RSP_ERR, __TPROD) |
                      DRF_DEF(_SOURCETRACK, _ERR_FATAL_REPORT_EN_0, _INVALID_TCEN1_RSP_ERR, __TPROD) |
                      DRF_DEF(_SOURCETRACK, _ERR_FATAL_REPORT_EN_0, _SOURCETRACK_TIME_OUT_ERR, __TPROD));
    
    NVSWITCH_ENG_WR32(device, NPORT,  , 0, _SOURCETRACK, _ERR_LOG_EN_0,
                      DRF_DEF(_SOURCETRACK, _ERR_LOG_EN_0, _CREQ_TCEN0_CRUMBSTORE_ECC_DBE_ERR, __TPROD) |
                      DRF_DEF(_SOURCETRACK, _ERR_LOG_EN_0, _CREQ_TCEN0_CRUMBSTORE_ECC_LIMIT_ERR, __TPROD) |
                      DRF_DEF(_SOURCETRACK, _ERR_LOG_EN_0, _DUP_CREQ_TCEN0_TAG_ERR, __TPROD) |
                      DRF_DEF(_SOURCETRACK, _ERR_LOG_EN_0, _INVALID_TCEN0_RSP_ERR, __TPROD) |
                      DRF_DEF(_SOURCETRACK, _ERR_LOG_EN_0, _INVALID_TCEN1_RSP_ERR, __TPROD) |
                      DRF_DEF(_SOURCETRACK, _ERR_LOG_EN_0, _SOURCETRACK_TIME_OUT_ERR, __TPROD));
    
    NVSWITCH_ENG_WR32(device, NPORT,  , 0, _SOURCETRACK, _ERR_NON_FATAL_REPORT_EN_0,
                      DRF_DEF(_SOURCETRACK, _ERR_NON_FATAL_REPORT_EN_0, _CREQ_TCEN0_CRUMBSTORE_ECC_DBE_ERR, _DISABLE) |
                      DRF_DEF(_SOURCETRACK, _ERR_NON_FATAL_REPORT_EN_0, _CREQ_TCEN0_CRUMBSTORE_ECC_LIMIT_ERR, __TPROD) |
                      DRF_DEF(_SOURCETRACK, _ERR_NON_FATAL_REPORT_EN_0, _DUP_CREQ_TCEN0_TAG_ERR, _DISABLE) |
                      DRF_DEF(_SOURCETRACK, _ERR_NON_FATAL_REPORT_EN_0, _INVALID_TCEN0_RSP_ERR, _DISABLE) |
                      DRF_DEF(_SOURCETRACK, _ERR_NON_FATAL_REPORT_EN_0, _INVALID_TCEN1_RSP_ERR, _DISABLE) |
                      DRF_DEF(_SOURCETRACK, _ERR_NON_FATAL_REPORT_EN_0, _SOURCETRACK_TIME_OUT_ERR, _DISABLE));

    return NVL_SUCCESS;
}
#endif

/*
 * @Brief : Fill In
 *
 * @Description : Fill In
 *
 * @paramin : Fill In
 *
 */

NvlStatus
nvswitch_npg_buffer_ready_ls10
(
    nvswitch_device *device
)
{
    NvU32 checked_data;

    // .NPG Buffer Ready
    
    // .  Enable Buffer_Ready for NPORT 
    
    //  *** Software needs to update this function support passing of instance as it is hardcoded to port 0
    
    NVSWITCH_ENG_WR32(device, NPORT,  , 0, _NPORT, _CTRL_BUFFER_READY,
                      DRF_DEF(_NPORT, _CTRL_BUFFER_READY, _BUFFERRDY, _ENABLE));
    
    // .  Read a Buffer_Ready register to confirm the writes completed.
    
    checked_data = NVSWITCH_ENG_RD32(device, NPORT,  , 0, _NPORT, _CTRL_BUFFER_READY);
    if ( !FLD_TEST_DRF(_NPORT, _CTRL_BUFFER_READY, _BUFFERRDY, _ENABLE, checked_data) )
    {
         NVSWITCH_PRINT(device, ERROR, "%s: _NPORT, _CTRL_BUFFER_READY, _BUFFERRDY != _ENABLE\n", __FUNCTION__);
    }

    return NVL_SUCCESS;
}


/*
 * @Brief : Fill In
 *
 * @Description : Fill In
 *
 * @paramin : Fill In
 *
 */

NvlStatus
nvswitch_nvlw_buffer_ready_ls10
(
    nvswitch_device *device
)
{
    NvU32 checked_data;
    NvU32 command;
    NvBool keepPolling;
    NVSWITCH_TIMEOUT timeout;

    // . NVLW Buffer Ready 
    
    // :: [SW] Enable buffer ready as the last step in initialization
    
    // . [SW] Enable Buffer_Ready for NLVW 
    
    //  *** Software needs to update this function support passing of instance as it is hardcoded to port 0
    
    NVSWITCH_ENG_WR32_IDX(device, MINION,  , 0, _MINION, _NVLINK_DL_CMD_DATA, 0,
                          DRF_NUM(_MINION, _NVLINK_DL_CMD_DATA, _DATA, 0x3));
    
    NVSWITCH_ENG_WR32_IDX(device, MINION,  , 0, _MINION, _NVLINK_DL_CMD, 0,
                          DRF_DEF(_MINION, _NVLINK_DL_CMD, _COMMAND, _SET_BUFFER_READY));
    
    nvswitch_timeout_create(NVSWITCH_INTERVAL_1MSEC_IN_NS, &timeout);
    
    do 
    {
        keepPolling = (nvswitch_timeout_check(&timeout)) ? NV_FALSE : NV_TRUE;
        command = NVSWITCH_ENG_RD32_IDX(device, MINION,  , 0, _MINION, _NVLINK_DL_CMD, 0);
    
        if ( FLD_TEST_DRF(_MINION, _NVLINK_DL_CMD, _READY, _TRUE, command) )
        {
            break;
        }
        if ( keepPolling == NV_FALSE )
        {
            NVSWITCH_PRINT(device, ERROR, "%s: -- Poll timeout for MINION 0 _MINION _NVLINK_DL_CMD --\n", __FUNCTION__);
            return -NVL_ERR_GENERIC;
        }
    }
    while (keepPolling);
    
    checked_data = NVSWITCH_ENG_RD32_IDX(device, MINION,  , 0, _MINION, _NVLINK_DL_CMD, 0);
    if ( !FLD_TEST_DRF(_MINION, _NVLINK_DL_CMD, _FAULT, _NOFAULT_NOCLEAR, checked_data) )
    {
         NVSWITCH_PRINT(device, ERROR, "%s: _MINION, _NVLINK_DL_CMD, _FAULT != _NOFAULT_NOCLEAR\n", __FUNCTION__);
    }
    
    checked_data = NVSWITCH_ENG_RD32(device, NVLTLC,  , 0, _NVLTLC, _RX_SYS_CTRL_BUFFER_READY);
    if ( !FLD_TEST_DRF(_NVLTLC, _RX_SYS_CTRL_BUFFER_READY, _BUFFERRDY, _ENABLE, checked_data) )
    {
         NVSWITCH_PRINT(device, ERROR, "%s: _NVLTLC, _RX_SYS_CTRL_BUFFER_READY, _BUFFERRDY != _ENABLE\n", __FUNCTION__);
    }
    
    checked_data = NVSWITCH_ENG_RD32(device, NVLTLC,  , 0, _NVLTLC, _TX_SYS_CTRL_BUFFER_READY);
    if ( !FLD_TEST_DRF(_NVLTLC, _TX_SYS_CTRL_BUFFER_READY, _BUFFERRDY, _ENABLE, checked_data) )
    {
         NVSWITCH_PRINT(device, ERROR, "%s: _NVLTLC, _TX_SYS_CTRL_BUFFER_READY, _BUFFERRDY != _ENABLE\n", __FUNCTION__);
    }

    return NVL_SUCCESS;
}

