/* SPDX-License-Identifier: GPL-2.0-only */

#include "msrtool.h"

int intel_core2_early_probe(const struct targetdef *target, const struct cpuid_t *id) {
	return ((VENDOR_INTEL == id->vendor) &&
		(0x6 == id->family) &&
		(0xf == id->model));
}

const struct msrdef intel_core2_early_msrs[] = {
	{0x17, MSRTYPE_RDWR, MSR2(0, 0), "IA32_PLATFORM_ID", "", {
		{ BITS_EOT }
	}},
	{0x2a, MSRTYPE_RDWR, MSR2(0, 0), "EBL_CR_POWERON", "", {
		{ BITS_EOT }
	}},
	{0x3f, MSRTYPE_RDWR, MSR2(0, 0), "IA32_TEMPERATURE_OFFSET", "", {
		{ BITS_EOT }
	}},
	{0xa8, MSRTYPE_RDWR, MSR2(0, 0), "EMTTM_CR_TABLE0", "", {
		{ BITS_EOT }
	}},
	{0xa9, MSRTYPE_RDWR, MSR2(0, 0), "EMTTM_CR_TABLE1", "", {
		{ BITS_EOT }
	}},
	{0xaa, MSRTYPE_RDWR, MSR2(0, 0), "EMTTM_CR_TABLE2", "", {
		{ BITS_EOT }
	}},
	{0xab, MSRTYPE_RDWR, MSR2(0, 0), "EMTTM_CR_TABLE3", "", {
		{ BITS_EOT }
	}},
	{0xac, MSRTYPE_RDWR, MSR2(0, 0), "EMTTM_CR_TABLE4", "", {
		{ BITS_EOT }
	}},
	{0xad, MSRTYPE_RDWR, MSR2(0, 0), "EMTTM_CR_TABLE5", "", {
		{ BITS_EOT }
	}},
	{0xcd, MSRTYPE_RDWR, MSR2(0, 0), "FSB_CLOCK_STS", "", {
		{ BITS_EOT }
	}},
	{0xe2, MSRTYPE_RDWR, MSR2(0, 0), "PMG_CST_CONFIG_CONTROL", "", {
		{ BITS_EOT }
	}},
	{0xe3, MSRTYPE_RDWR, MSR2(0, 0), "PMG_IO_BASE_ADDR", "", {
		{ BITS_EOT }
	}},
	{0xe4, MSRTYPE_RDWR, MSR2(0, 0), "PMG_IO_CAPTURE_ADDR", "", {
		{ BITS_EOT }
	}},
	{0xee, MSRTYPE_RDWR, MSR2(0, 0), "EXT_CONFIG", "", {
		{ BITS_EOT }
	}},
	{0x11e, MSRTYPE_RDWR, MSR2(0, 0), "BBL_CR_CTL3", "", {
		{ BITS_EOT }
	}},
	{0x194, MSRTYPE_RDWR, MSR2(0, 0), "CLOCK_FLEX_MAX", "", {
		{ BITS_EOT }
	}},
	{0x198, MSRTYPE_RDWR, MSR2(0, 0), "IA32_PERF_STATUS", "", {
		{ BITS_EOT }
	}},
	{0x1a0, MSRTYPE_RDWR, MSR2(0, 0), "IA32_MISC_ENABLES", "", {
		{ BITS_EOT }
	}},
	{0x1aa, MSRTYPE_RDWR, MSR2(0, 0), "PIC_SENS_CFG", "", {
		{ BITS_EOT }
	}},
	{0x400, MSRTYPE_RDWR, MSR2(0, 0), "IA32_MC0_CTL", "", {
		{ BITS_EOT }
	}},
	{0x401, MSRTYPE_RDWR, MSR2(0, 0), "IA32_MC0_STATUS", "", {
		{ BITS_EOT }
	}},
	{0x402, MSRTYPE_RDWR, MSR2(0, 0), "IA32_MC0_ADDR", "", {
		{ BITS_EOT }
	}},
	{0x40c, MSRTYPE_RDWR, MSR2(0, 0), "IA32_MC3_CTL", "", {
		{ BITS_EOT }
	}},
	{0x40d, MSRTYPE_RDWR, MSR2(0, 0), "IA32_MC3_STATUS", "", {
		{ BITS_EOT }
	}},
	{0x40e, MSRTYPE_RDWR, MSR2(0, 0), "IA32_MC3_ADDR", "", {
		{ BITS_EOT }
	}},
	{0x10, MSRTYPE_RDWR, MSR2(0, 0), "IA32_TIME_STAMP_COUNTER", "", {
		{ BITS_EOT }
	}},
	{0x1b, MSRTYPE_RDWR, MSR2(0, 0), "IA32_APIC_BASE", "", {
		{ BITS_EOT }
	}},
	{0x3a, MSRTYPE_RDWR, MSR2(0, 0), "IA32_FEATURE_CONTROL", "", {
		{ BITS_EOT }
	}},
	{0x8b, MSRTYPE_RDWR, MSR2(0, 0), "IA32_BIOS_SIGN_ID", "", {
		{ BITS_EOT }
	}},
	{0xe1, MSRTYPE_RDWR, MSR2(0, 0), "SMM_CST_MISC_INFO", "", {
		{ BITS_EOT }
	}},
	{0xe7, MSRTYPE_RDWR, MSR2(0, 0), "IA32_MPERF", "", {
		{ BITS_EOT }
	}},
	{0xe8, MSRTYPE_RDWR, MSR2(0, 0), "IA32_APERF", "", {
		{ BITS_EOT }
	}},
	{0xfe, MSRTYPE_RDWR, MSR2(0, 0), "IA32_MTRRCAP", "", {
		{ BITS_EOT }
	}},
	{0x179, MSRTYPE_RDWR, MSR2(0, 0), "IA32_MCG_CAP", "", {
		{ BITS_EOT }
	}},
	{0x17a, MSRTYPE_RDWR, MSR2(0, 0), "IA32_MCG_STATUS", "", {
		{ BITS_EOT }
	}},
	{0x199, MSRTYPE_RDWR, MSR2(0, 0), "IA32_PERF_CONTROL", "", {
		{ BITS_EOT }
	}},
	{0x19a, MSRTYPE_RDWR, MSR2(0, 0), "IA32_THERM_CTL", "", {
		{ BITS_EOT }
	}},
	{0x19b, MSRTYPE_RDWR, MSR2(0, 0), "IA32_THERM_INTERRUPT", "", {
		{ BITS_EOT }
	}},
	{0x19c, MSRTYPE_RDWR, MSR2(0, 0), "IA32_THERM_STATUS", "", {
		{ BITS_EOT }
	}},
	{0x19d, MSRTYPE_RDWR, MSR2(0, 0), "MSR_THERM2_CTL", "", {
		{ BITS_EOT }
	}},
	{0x1d9, MSRTYPE_RDWR, MSR2(0, 0), "IA32_DEBUGCTL", "", {
		{ BITS_EOT }
	}},
	{0x200, MSRTYPE_RDWR, MSR2(0, 0), "IA32_MTRR_PHYSBASE0", "", {
		{ BITS_EOT }
	}},
	{0x201, MSRTYPE_RDWR, MSR2(0, 0), "IA32_MTRR_PHYSMASK0", "", {
		{ BITS_EOT }
	}},
	{0x202, MSRTYPE_RDWR, MSR2(0, 0), "IA32_MTRR_PHYSBASE1", "", {
		{ BITS_EOT }
	}},
	{0x203, MSRTYPE_RDWR, MSR2(0, 0), "IA32_MTRR_PHYSMASK1", "", {
		{ BITS_EOT }
	}},
	{0x204, MSRTYPE_RDWR, MSR2(0, 0), "IA32_MTRR_PHYSBASE2", "", {
		{ BITS_EOT }
	}},
	{0x205, MSRTYPE_RDWR, MSR2(0, 0), "IA32_MTRR_PHYSMASK2", "", {
		{ BITS_EOT }
	}},
	{0x206, MSRTYPE_RDWR, MSR2(0, 0), "IA32_MTRR_PHYSBASE3", "", {
		{ BITS_EOT }
	}},
	{0x207, MSRTYPE_RDWR, MSR2(0, 0), "IA32_MTRR_PHYSMASK3", "", {
		{ BITS_EOT }
	}},
	{0x208, MSRTYPE_RDWR, MSR2(0, 0), "IA32_MTRR_PHYSBASE4", "", {
		{ BITS_EOT }
	}},
	{0x209, MSRTYPE_RDWR, MSR2(0, 0), "IA32_MTRR_PHYSMASK4", "", {
		{ BITS_EOT }
	}},
	{0x20a, MSRTYPE_RDWR, MSR2(0, 0), "IA32_MTRR_PHYSBASE5", "", {
		{ BITS_EOT }
	}},
	{0x20b, MSRTYPE_RDWR, MSR2(0, 0), "IA32_MTRR_PHYSMASK5", "", {
		{ BITS_EOT }
	}},
	{0x20c, MSRTYPE_RDWR, MSR2(0, 0), "IA32_MTRR_PHYSBASE6", "", {
		{ BITS_EOT }
	}},
	{0x20d, MSRTYPE_RDWR, MSR2(0, 0), "IA32_MTRR_PHYSMASK6", "", {
		{ BITS_EOT }
	}},
	{0x20e, MSRTYPE_RDWR, MSR2(0, 0), "IA32_MTRR_PHYSBASE7", "", {
		{ BITS_EOT }
	}},
	{0x20f, MSRTYPE_RDWR, MSR2(0, 0), "IA32_MTRR_PHYSMASK7", "", {
		{ BITS_EOT }
	}},
	{0x250, MSRTYPE_RDWR, MSR2(0, 0), "IA32_MTRR_FIX64K_00000", "", {
		{ BITS_EOT }
	}},
	{0x258, MSRTYPE_RDWR, MSR2(0, 0), "IA32_MTRR_FIX16K_80000", "", {
		{ BITS_EOT }
	}},
	{0x259, MSRTYPE_RDWR, MSR2(0, 0), "IA32_MTRR_FIX16K_A0000", "", {
		{ BITS_EOT }
	}},
	{0x268, MSRTYPE_RDWR, MSR2(0, 0), "IA32_MTRR_FIX4K_C0000", "", {
		{ BITS_EOT }
	}},
	{0x269, MSRTYPE_RDWR, MSR2(0, 0), "IA32_MTRR_FIX4K_C8000", "", {
		{ BITS_EOT }
	}},
	{0x26a, MSRTYPE_RDWR, MSR2(0, 0), "IA32_MTRR_FIX4K_D0000", "", {
		{ BITS_EOT }
	}},
	{0x26b, MSRTYPE_RDWR, MSR2(0, 0), "IA32_MTRR_FIX4K_D8000", "", {
		{ BITS_EOT }
	}},
	{0x26c, MSRTYPE_RDWR, MSR2(0, 0), "IA32_MTRR_FIX4K_E0000", "", {
		{ BITS_EOT }
	}},
	{0x26d, MSRTYPE_RDWR, MSR2(0, 0), "IA32_MTRR_FIX4K_E8000", "", {
		{ BITS_EOT }
	}},
	{0x26e, MSRTYPE_RDWR, MSR2(0, 0), "IA32_MTRR_FIX4K_F0000", "", {
		{ BITS_EOT }
	}},
	{0x26f, MSRTYPE_RDWR, MSR2(0, 0), "IA32_MTRR_FIX4K_F8000", "", {
		{ BITS_EOT }
	}},
	{0x2ff, MSRTYPE_RDWR, MSR2(0, 0), "IA32_MTRR_DEF_TYPE", "", {
		{ BITS_EOT }
	}},
	{ MSR_EOT }
};
