/* SPDX-License-Identifier: GPL-2.0-or-later */

#include <device/pci_ops.h>
#include <southbridge/intel/lynxpoint/hsio/hsio.h>
#include <southbridge/intel/lynxpoint/pch.h>
#include <types.h>

const struct hsio_table_row hsio_sata_shared_lpt_lp_bx[] = {
	{ 0xea008008, ~0xff000000, 0x1c000000 },
	{ 0xea002008, ~0xfffc6108, 0xea6c6108 },
	{ 0xea002208, ~0xfffc6108, 0xea6c6108 },
	{ 0xea002408, ~0xfffc6108, 0xea6c6108 },
	{ 0xea002608, ~0xfffc6108, 0xea6c6108 },
	{ 0xea002038, ~0x0000000f, 0x0000000d },
	{ 0xea002238, ~0x0000000f, 0x0000000d },
	{ 0xea002438, ~0x0000000f, 0x0000000d },
	{ 0xea002638, ~0x0000000f, 0x0000000d },
	{ 0xea00202c, ~0x00020f00, 0x00020100 },
	{ 0xea00222c, ~0x00020f00, 0x00020100 },
	{ 0xea00242c, ~0x00020f00, 0x00020100 },
	{ 0xea00262c, ~0x00020f00, 0x00020100 },
	{ 0xea002040, ~0x1f000000, 0x01000000 },
	{ 0xea002240, ~0x1f000000, 0x01000000 },
	{ 0xea002440, ~0x1f000000, 0x01000000 },
	{ 0xea002640, ~0x1f000000, 0x01000000 },
	{ 0xea002010, ~0xffff0000, 0x55510000 },
	{ 0xea002210, ~0xffff0000, 0x55510000 },
	{ 0xea002410, ~0xffff0000, 0x55510000 },
	{ 0xea002610, ~0xffff0000, 0x55510000 },
	{ 0xea002140, ~0x00ffffff, 0x00140718 },
	{ 0xea002340, ~0x00ffffff, 0x00140718 },
	{ 0xea002540, ~0x00ffffff, 0x00140718 },
	{ 0xea002740, ~0x00ffffff, 0x00140718 },
	{ 0xea002144, ~0x00ffffff, 0x00140998 },
	{ 0xea002344, ~0x00ffffff, 0x00140998 },
	{ 0xea002544, ~0x00ffffff, 0x00140998 },
	{ 0xea002744, ~0x00ffffff, 0x00140998 },
	{ 0xea002148, ~0x00ffffff, 0x00140998 },
	{ 0xea002348, ~0x00ffffff, 0x00140998 },
	{ 0xea002548, ~0x00ffffff, 0x00140998 },
	{ 0xea002748, ~0x00ffffff, 0x00140998 },
	{ 0xea00217c, ~0x03000000, 0x03000000 },
	{ 0xea00237c, ~0x03000000, 0x03000000 },
	{ 0xea00257c, ~0x03000000, 0x03000000 },
	{ 0xea00277c, ~0x03000000, 0x03000000 },
	{ 0xea00208c, ~0x00ff0000, 0x00800000 },
	{ 0xea00228c, ~0x00ff0000, 0x00800000 },
	{ 0xea00248c, ~0x00ff0000, 0x00800000 },
	{ 0xea00268c, ~0x00ff0000, 0x00800000 },
	{ 0xea0020a4, ~0x0030ff00, 0x00308300 },
	{ 0xea0022a4, ~0x0030ff00, 0x00308300 },
	{ 0xea0024a4, ~0x0030ff00, 0x00308300 },
	{ 0xea0026a4, ~0x0030ff00, 0x00308300 },
	{ 0xea0020ac, ~0x00000030, 0x00000020 },
	{ 0xea0022ac, ~0x00000030, 0x00000020 },
	{ 0xea0024ac, ~0x00000030, 0x00000020 },
	{ 0xea0026ac, ~0x00000030, 0x00000020 },
	{ 0xea002018, ~0xffff0300, 0x38250100 },
	{ 0xea002218, ~0xffff0300, 0x38250100 },
	{ 0xea002418, ~0xffff0300, 0x38250100 },
	{ 0xea002618, ~0xffff0300, 0x38250100 },
	{ 0xea002000, ~0xcf030000, 0xcf030000 },
	{ 0xea002200, ~0xcf030000, 0xcf030000 },
	{ 0xea002400, ~0xcf030000, 0xcf030000 },
	{ 0xea002600, ~0xcf030000, 0xcf030000 },
	{ 0xea002028, ~0xff1f0000, 0x580e0000 },
	{ 0xea002228, ~0xff1f0000, 0x580e0000 },
	{ 0xea002428, ~0xff1f0000, 0x580e0000 },
	{ 0xea002628, ~0xff1f0000, 0x580e0000 },
	{ 0xea00201c, ~0x00007c00, 0x00002400 },
	{ 0xea00221c, ~0x00007c00, 0x00002400 },
	{ 0xea00241c, ~0x00007c00, 0x00002400 },
	{ 0xea00261c, ~0x00007c00, 0x00002400 },
	{ 0xea002178, ~0x00001f00, 0x00001800 },
	{ 0xea002378, ~0x00001f00, 0x00001800 },
	{ 0xea002578, ~0x00001f00, 0x00001800 },
	{ 0xea002778, ~0x00001f00, 0x00001800 },
	{ 0xea00210c, ~0x0038000f, 0x00000005 },
	{ 0xea00230c, ~0x0038000f, 0x00000005 },
	{ 0xea00250c, ~0x0038000f, 0x00000005 },
	{ 0xea00270c, ~0x0038000f, 0x00000005 },
};

const struct hsio_table_row hsio_xhci_shared_lpt_lp_bx[] = {
	{ 0xe90025cc, ~0x00001407, 0x00001407 },
	{ 0xe90027cc, ~0x00001407, 0x00001407 },
	{ 0xe9002568, ~0x01000f3c, 0x00000a28 },
	{ 0xe9002768, ~0x01000f3c, 0x00000a28 },
	{ 0xe900242c, ~0x00000700, 0x00000100 },
	{ 0xe900262c, ~0x00000700, 0x00000100 },
	{ 0xe900256c, ~0x000000ff, 0x0000003f },
	{ 0xe900276c, ~0x000000ff, 0x0000003f },
	{ 0xe900254c, ~0x00ffff00, 0x00120500 },
	{ 0xe900274c, ~0x00ffff00, 0x00120500 },
	{ 0xe9002564, ~0x0000f000, 0x00005000 },
	{ 0xe9002764, ~0x0000f000, 0x00005000 },
	{ 0xe9002570, ~0x00000018, 0x00000000 },
	{ 0xe9002770, ~0x00000018, 0x00000000 },
	{ 0xe9002514, ~0x38000700, 0x00000100 },
	{ 0xe9002714, ~0x38000700, 0x00000100 },
	{ 0xe9002438, ~0x0000000f, 0x0000000b },
	{ 0xe9002638, ~0x0000000f, 0x0000000b },
	{ 0xe9002414, ~0x0000fe00, 0x00006600 },
	{ 0xe9002614, ~0x0000fe00, 0x00006600 },
	{ 0xe9002540, ~0x00800000, 0x00000000 },
	{ 0xe9002740, ~0x00800000, 0x00000000 },
};

const struct hsio_table_row hsio_xhci_lpt_lp_bx[] = {
	{ 0xe90021cc, ~0x00001407, 0x00001407 },
	{ 0xe90023cc, ~0x00001407, 0x00001407 },
	{ 0xe9002168, ~0x01000f3c, 0x00000a28 },
	{ 0xe9002368, ~0x01000f3c, 0x00000a28 },
	{ 0xe900216c, ~0x000000ff, 0x0000003f },
	{ 0xe900236c, ~0x000000ff, 0x0000003f },
	{ 0xe900214c, ~0x00ffff00, 0x00120500 },
	{ 0xe900234c, ~0x00ffff00, 0x00120500 },
	{ 0xe9002164, ~0x0000f000, 0x00005000 },
	{ 0xe9002364, ~0x0000f000, 0x00005000 },
	{ 0xe9002170, ~0x00000018, 0x00000000 },
	{ 0xe9002370, ~0x00000018, 0x00000000 },
	{ 0xe9002114, ~0x38000700, 0x00000100 },
	{ 0xe9002314, ~0x38000700, 0x00000100 },
	{ 0xe9002038, ~0x0000000f, 0x0000000b },
	{ 0xe9002238, ~0x0000000f, 0x0000000b },
	{ 0xe9002014, ~0x0000fe00, 0x00006600 },
	{ 0xe9002214, ~0x0000fe00, 0x00006600 },
	{ 0xe9002140, ~0x00800000, 0x00000000 },
	{ 0xe9002340, ~0x00800000, 0x00000000 },
};

void program_hsio_sata_lpt_lp_bx(const bool is_mobile)
{
	const struct hsio_table_row *pch_hsio_table;
	size_t len;

	pch_hsio_table = hsio_sata_shared_lpt_lp_bx;
	len = ARRAY_SIZE(hsio_sata_shared_lpt_lp_bx);
	for (size_t i = 0; i < len; i++)
		hsio_sata_shared_update_row(pch_hsio_table[i]);

	const uint32_t hsio_sata_value = is_mobile ? 0x00004c5a : 0x00003e67;

	hsio_sata_shared_update(0xea002090, ~0x0000ffff, hsio_sata_value);
	hsio_sata_shared_update(0xea002290, ~0x0000ffff, hsio_sata_value);
	hsio_sata_shared_update(0xea002490, ~0x0000ffff, hsio_sata_value);
	hsio_sata_shared_update(0xea002690, ~0x0000ffff, hsio_sata_value);
}

void program_hsio_xhci_lpt_lp_bx(void)
{
	const struct hsio_table_row *pch_hsio_table;
	size_t len;

	pch_hsio_table = hsio_xhci_lpt_lp_bx;
	len = ARRAY_SIZE(hsio_xhci_lpt_lp_bx);

	for (size_t i = 0; i < len; i++)
		hsio_update_row(pch_hsio_table[i]);

	pch_hsio_table = hsio_xhci_shared_lpt_lp_bx;
	len = ARRAY_SIZE(hsio_xhci_shared_lpt_lp_bx);

	for (size_t i = 0; i < len; i++)
		hsio_xhci_shared_update_row(pch_hsio_table[i]);
}

void program_hsio_igbe_lpt_lp_bx(void)
{
	const uint32_t strpfusecfg1 = pci_read_config32(PCH_PCIE_DEV(0), 0xfc);
	if (!(strpfusecfg1 & (1 << 19)))
		return;

	const uint8_t gbe_port = (strpfusecfg1 >> 16) & 0x7;
	if (gbe_port > 5)
		return;

	const uint32_t gbe_hsio_base = 0xe900 << 16 | (0x08 + 2 * gbe_port) << 8;
	hsio_update(gbe_hsio_base + 0x08, ~0xf0000100, 0xe0000100);
}
