/****
DIAMOND protein aligner
Copyright (C) 2020 Max Planck Society for the Advancement of Science e.V.

Code developed by Benjamin Buchfink <benjamin.buchfink@tue.mpg.de>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
****/

#include "../standard_matrix.h"

namespace Stats {

const StandardMatrix blosum50{

    13, 2,

	{ { (double)INT2_MAX, (double)INT2_MAX, (double)INT2_MAX, 0.2318, 0.112, 0.3362, 0.6895, -4.0, 0.609639, 5.388310, 5.388310 },
	{ 13, 3, (double)INT2_MAX, 0.212, 0.063, 0.19, 1.1, -16, 0.639287, 18.113800, 18.202800 },
	{ 12, 3, (double)INT2_MAX, 0.206, 0.055, 0.17, 1.2, -18, 0.644715, 22.654600, 22.777700 },
	{ 11, 3, (double)INT2_MAX, 0.197, 0.042, 0.14, 1.4, -25, 0.656327, 29.861100, 30.045700 },
	{ 10, 3, (double)INT2_MAX, 0.186, 0.031, 0.11, 1.7, -34, 0.671150, 42.393800, 42.674000 },
	{ 9, 3, (double)INT2_MAX, 0.172, 0.022, 0.082, 2.1, -48, 0.694326, 66.069600, 66.516400 },
	{ 16, 2, (double)INT2_MAX, 0.215, 0.066, 0.20, 1.05, -15, 0.633899, 17.951800, 18.092100 },
	{ 15, 2, (double)INT2_MAX, 0.210, 0.058, 0.17, 1.2, -20, 0.641985, 21.940100, 22.141800 },
	{ 14, 2, (double)INT2_MAX, 0.202, 0.045, 0.14, 1.4, -27, 0.650682, 28.681200, 28.961900 },
	{ 13, 2, (double)INT2_MAX, 0.193, 0.035, 0.12, 1.6, -32, 0.660984, 42.059500, 42.471600 },
	{ 12, 2, (double)INT2_MAX, 0.181, 0.025, 0.095, 1.9, -41, 0.678090, 63.747600, 64.397300 },
	{ 19, 1, (double)INT2_MAX, 0.212, 0.057, 0.18, 1.2, -21, 0.635714, 26.311200, 26.923300 },
	{ 18, 1, (double)INT2_MAX, 0.207, 0.050, 0.15, 1.4, -28, 0.643523, 34.903700, 35.734800 },
	{ 17, 1, (double)INT2_MAX, 0.198, 0.037, 0.12, 1.6, -33, 0.654504, 48.895800, 50.148600 },
	{ 16, 1, (double)INT2_MAX, 0.186, 0.025, 0.10, 1.9, -42, 0.667750, 76.469100, 78.443000 },
	{ 15, 1, (double)INT2_MAX, 0.171, 0.015, 0.063, 2.7, -76, 0.694575, 140.053000, 144.160000 }},

    {
	 /*       A,  R,  N,  D,  C,  Q,  E,  G,  H,  I,  L,  K,  M,
             F,  P,  S,  T,  W,  Y,  V,  B,  J,  Z,  X,  *        */ 
    /*A*/    5, -2, -1, -2, -1, -1, -1,  0, -2, -1, -2, -1, -1,
            -3, -1,  1,  0, -3, -2,  0, -2, -2, -1, -1, -5, -16,
    /*R*/   -2,  7, -1, -2, -4,  1,  0, -3,  0, -4, -3,  3, -2,
            -3, -3, -1, -1, -3, -1, -3, -1, -3,  0, -1, -5, -16,
    /*N*/   -1, -1,  7,  2, -2,  0,  0,  0,  1, -3, -4,  0, -2,
            -4, -2,  1,  0, -4, -2, -3,  5, -4,  0, -1, -5, -16,
    /*D*/   -2, -2,  2,  8, -4,  0,  2, -1, -1, -4, -4, -1, -4,
            -5, -1,  0, -1, -5, -3, -4,  6, -4,  1, -1, -5, -16,
    /*C*/   -1, -4, -2, -4, 13, -3, -3, -3, -3, -2, -2, -3, -2,
            -2, -4, -1, -1, -5, -3, -1, -3, -2, -3, -1, -5, -16,
    /*Q*/   -1,  1,  0,  0, -3,  7,  2, -2,  1, -3, -2,  2,  0,
            -4, -1,  0, -1, -1, -1, -3,  0, -3,  4, -1, -5, -16,
    /*E*/   -1,  0,  0,  2, -3,  2,  6, -3,  0, -4, -3,  1, -2,
            -3, -1, -1, -1, -3, -2, -3,  1, -3,  5, -1, -5, -16,
    /*G*/    0, -3,  0, -1, -3, -2, -3,  8, -2, -4, -4, -2, -3,
            -4, -2,  0, -2, -3, -3, -4, -1, -4, -2, -1, -5, -16,
    /*H*/   -2,  0,  1, -1, -3,  1,  0, -2, 10, -4, -3,  0, -1,
            -1, -2, -1, -2, -3,  2, -4,  0, -3,  0, -1, -5, -16,
    /*I*/   -1, -4, -3, -4, -2, -3, -4, -4, -4,  5,  2, -3,  2,
             0, -3, -3, -1, -3, -1,  4, -4,  4, -3, -1, -5, -16,
    /*L*/   -2, -3, -4, -4, -2, -2, -3, -4, -3,  2,  5, -3,  3,
             1, -4, -3, -1, -2, -1,  1, -4,  4, -3, -1, -5, -16,
    /*K*/   -1,  3,  0, -1, -3,  2,  1, -2,  0, -3, -3,  6, -2,
            -4, -1,  0, -1, -3, -2, -3,  0, -3,  1, -1, -5, -16,
    /*M*/   -1, -2, -2, -4, -2,  0, -2, -3, -1,  2,  3, -2,  7,
             0, -3, -2, -1, -1,  0,  1, -3,  2, -1, -1, -5, -16,
    /*F*/   -3, -3, -4, -5, -2, -4, -3, -4, -1,  0,  1, -4,  0,
             8, -4, -3, -2,  1,  4, -1, -4,  1, -4, -1, -5, -16,
    /*P*/   -1, -3, -2, -1, -4, -1, -1, -2, -2, -3, -4, -1, -3,
            -4, 10, -1, -1, -4, -3, -3, -2, -3, -1, -1, -5, -16,
    /*S*/    1, -1,  1,  0, -1,  0, -1,  0, -1, -3, -3,  0, -2,
            -3, -1,  5,  2, -4, -2, -2,  0, -3,  0, -1, -5, -16,
    /*T*/    0, -1,  0, -1, -1, -1, -1, -2, -2, -1, -1, -1, -1,
            -2, -1,  2,  5, -3, -2,  0,  0, -1, -1, -1, -5, -16,
    /*W*/   -3, -3, -4, -5, -5, -1, -3, -3, -3, -3, -2, -3, -1,
             1, -4, -4, -3, 15,  2, -3, -5, -2, -2, -1, -5, -16,
    /*Y*/   -2, -1, -2, -3, -3, -1, -2, -3,  2, -1, -1, -2,  0,
             4, -3, -2, -2,  2,  8, -1, -3, -1, -2, -1, -5, -16,
    /*V*/    0, -3, -3, -4, -1, -3, -3, -4, -4,  4,  1, -3,  1,
            -1, -3, -2,  0, -3, -1,  5, -3,  2, -3, -1, -5, -16,
    /*B*/   -2, -1,  5,  6, -3,  0,  1, -1,  0, -4, -4,  0, -3,
            -4, -2,  0,  0, -5, -3, -3,  6, -4,  1, -1, -5, -16,
    /*J*/   -2, -3, -4, -4, -2, -3, -3, -4, -3,  4,  4, -3,  2,
             1, -3, -3, -1, -2, -1,  2, -4,  4, -3, -1, -5, -16,
    /*Z*/   -1,  0,  0,  1, -3,  4,  5, -2,  0, -3, -3,  1, -1,
            -4, -1,  0, -1, -2, -2, -3,  1, -3,  5, -1, -5, -16,
    /*X*/   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
            -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -5, -16,
    /***/   -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,
            -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,  1, -16,
			-16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16,
			-16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16 },

{
  {1.9177376165900414e-02, 2.7240376714546557e-03, 2.4031492992281512e-03,
   2.5950400141435646e-03, 1.5161141503466080e-03, 2.1916331677173605e-03,
   3.4448278914639618e-03, 6.2251471153775524e-03, 1.2127849526349368e-03,
   3.5067963781079273e-03, 4.8064175187919377e-03, 3.3118156445774184e-03,
   1.5929928229676674e-03, 2.0111462534334831e-03, 2.2367690269707355e-03,
   6.2077372467778114e-03, 3.9182728585714704e-03, 4.8631739510959277e-04,
   1.5289255743243066e-03, 5.4421693501580945e-03},
  {2.7240376714546557e-03, 1.5249518561669190e-02, 1.9839339217171100e-03,
   1.8569646551144466e-03, 5.0841145558634812e-04, 2.5241992415035875e-03,
   2.9346714600391238e-03, 2.0330929248566329e-03, 1.2916661377324677e-03,
   1.4850904029213015e-03, 2.8200506536265085e-03, 6.3631786906688794e-03,
   8.8044244163237157e-04, 1.1827555704613821e-03, 1.1291633722052721e-03,
   2.5480707779992882e-03, 2.0755623893205866e-03, 3.8597740102525838e-04,
   1.2968650803478032e-03, 1.9767324973351923e-03},
  {2.4031492992281512e-03, 1.9839339217171100e-03, 1.0064274648985122e-02,
   3.4938528463521034e-03, 5.8526580393535813e-04, 1.5772225567522585e-03,
   2.2654955215314441e-03, 3.1227790949497000e-03, 1.5032392778514345e-03,
   1.2604525924282989e-03, 1.7212395367610532e-03, 2.6781179272946298e-03,
   6.5072987349609041e-04, 9.2077070726659231e-04, 1.0780835837505738e-03,
   3.1777703084905646e-03, 2.5607235691682607e-03, 2.2470939491808472e-04,
   9.0102455753719311e-04, 1.4642269583191670e-03},
  {2.5950400141435646e-03, 1.8569646551144466e-03, 3.4938528463521034e-03,
   1.6142284245400377e-02, 4.9055796014848500e-04, 1.7355972391605227e-03,
   4.8092932462930728e-03, 2.8256049847966923e-03, 1.1224039610689225e-03,
   1.2187267471037043e-03, 1.8320202151810498e-03, 2.6483031701007680e-03,
   5.4518900860208049e-04, 8.3372775443144032e-04, 1.4911089792375384e-03,
   2.8168184837142236e-03, 2.2443557004503045e-03, 2.1629521399451062e-04,
   8.6838200454238037e-04, 1.6071086977600263e-03},
  {1.5161141503466080e-03, 5.0841145558634812e-04, 5.8526580393535813e-04,
   4.9055796014848500e-04, 9.0790816399874165e-03, 3.7509694198458956e-04,
   5.7443167694834051e-04, 8.6416125741413223e-04, 2.8532822032727102e-04,
   8.3949095461630769e-04, 1.3866946702884293e-03, 5.9394346268641564e-04,
   3.7056882781629923e-04, 6.0643258121975913e-04, 3.6775301298071699e-04,
   1.1014893301583900e-03, 9.6593119839638185e-04, 9.5473415415687051e-05,
   4.0265275985100583e-04, 1.3071530803028910e-03},
  {2.1916331677173605e-03, 2.5241992415035875e-03, 1.5772225567522585e-03,
   1.7355972391605227e-03, 3.7509694198458956e-04, 5.7288780946700701e-03,
   3.2946407159359019e-03, 1.6542835961738131e-03, 1.0434512306085959e-03,
   1.1246276733803604e-03, 1.8792097500823605e-03, 2.8672107479796771e-03,
   8.1749695236423632e-04, 7.0039848968711364e-04, 1.0716022846036992e-03,
   2.2199500917807818e-03, 1.4976248429072652e-03, 3.4211307677156259e-04,
   8.6801232355735846e-04, 1.4099696811263587e-03},
  {3.4448278914639618e-03, 2.9346714600391238e-03, 2.2654955215314441e-03,
   4.8092932462930728e-03, 5.7443167694834051e-04, 3.2946407159359019e-03,
   1.4137738860962050e-02, 2.2506310350989874e-03, 1.2713631289270268e-03,
   1.5027392767795753e-03, 2.5813459827982222e-03, 4.3484287857007489e-03,
   8.3289745544177065e-04, 1.2381529956170115e-03, 1.9357892959573676e-03,
   2.9614835299989701e-03, 2.4465955340418752e-03, 4.2400226067181517e-04,
   1.2320532047293646e-03, 1.9587224017250621e-03},
  {6.2251471153775524e-03, 2.0330929248566329e-03, 3.1227790949497000e-03,
   2.8256049847966923e-03, 8.6416125741413223e-04, 1.6542835961738131e-03,
   2.2506310350989874e-03, 3.1590334199549770e-02, 1.0972793065146165e-03,
   1.7523277816042203e-03, 2.6606416500206632e-03, 2.7990435215878512e-03,
   9.3546770862675606e-04, 1.4703871152100261e-03, 1.8725532583338258e-03,
   4.3892726706643180e-03, 2.4867404596474229e-03, 5.1106914401047939e-04,
   1.1558215242534139e-03, 2.1542687026690753e-03},
  {1.2127849526349368e-03, 1.2916661377324677e-03, 1.5032392778514345e-03,
   1.1224039610689225e-03, 2.8532822032727102e-04, 1.0434512306085959e-03,
   1.2713631289270268e-03, 1.0972793065146165e-03, 6.3804882118271523e-03,
   6.5152626785360663e-04, 1.2931025418026663e-03, 1.3522962310675180e-03,
   4.5805146362189403e-04, 8.9702000483341665e-04, 5.8791282749163360e-04,
   1.2089586814863836e-03, 8.5349236685497410e-04, 1.6088475111162087e-04,
   1.2994388028749182e-03, 7.4034388655116329e-04},
  {3.5067963781079273e-03, 1.4850904029213015e-03, 1.2604525924282989e-03,
   1.2187267471037043e-03, 8.3949095461630769e-04, 1.1246276733803604e-03,
   1.5027392767795753e-03, 1.7523277816042203e-03, 6.5152626785360663e-04,
   1.3999757001274281e-02, 1.0390816757632199e-02, 1.7363767070665819e-03,
   2.2467399442463766e-03, 3.0498186875911964e-03, 1.3390359572833434e-03,
   2.0791955470136677e-03, 2.9182353019045755e-03, 4.5881135439627285e-04,
   1.7726237165460320e-03, 1.0732172589653342e-02},
  {4.8064175187919377e-03, 2.8200506536265085e-03, 1.7212395367610532e-03,
   1.8320202151810498e-03, 1.3866946702884293e-03, 1.8792097500823605e-03,
   2.5813459827982222e-03, 2.6606416500206632e-03, 1.2931025418026663e-03,
   1.0390816757632199e-02, 3.0409269773873687e-02, 2.6510115013545226e-03,
   4.1722701893507309e-03, 5.8008510370760203e-03, 1.7339408813938210e-03,
   2.9030148705129709e-03, 3.8403853123581615e-03, 7.8809411669902049e-04,
   2.7481481703784771e-03, 9.1689424893657400e-03},
  {3.3118156445774184e-03, 6.3631786906688794e-03, 2.6781179272946298e-03,
   2.6483031701007680e-03, 5.9394346268641564e-04, 2.8672107479796771e-03,
   4.3484287857007489e-03, 2.7990435215878512e-03, 1.3522962310675180e-03,
   1.7363767070665819e-03, 2.6510115013545226e-03, 1.2999587798271149e-02,
   9.6710745846319019e-04, 1.2387025901401758e-03, 1.8070838729286381e-03,
   3.0739875836290694e-03, 2.5875240617244397e-03, 3.6617320485888769e-04,
   1.2944286682925433e-03, 2.1916787299081464e-03},
  {1.5929928229676674e-03, 8.8044244163237157e-04, 6.5072987349609041e-04,
   5.4518900860208049e-04, 3.7056882781629923e-04, 8.1749695236423632e-04,
   8.3289745544177065e-04, 9.3546770862675606e-04, 4.5805146362189403e-04,
   2.2467399442463766e-03, 4.1722701893507309e-03, 9.6710745846319019e-04,
   2.8637130884961001e-03, 1.2334264856852042e-03, 5.4319510273222540e-04,
   9.8962843407290630e-04, 1.1386579188117374e-03, 2.5453642381012927e-04,
   7.4966082446689317e-04, 2.1431247883570799e-03},
  {2.0111462534334831e-03, 1.1827555704613821e-03, 9.2077070726659231e-04,
   8.3372775443144032e-04, 6.0643258121975913e-04, 7.0039848968711364e-04,
   1.2381529956170115e-03, 1.4703871152100261e-03, 8.9702000483341665e-04,
   3.0498186875911964e-03, 5.8008510370760203e-03, 1.2387025901401758e-03,
   1.2334264856852042e-03, 1.5352527520022995e-02, 7.3889079577318679e-04,
   1.5819841076161790e-03, 1.4517880681388670e-03, 8.8872966327839206e-04,
   3.9057132596179516e-03, 2.9949355095799514e-03},
  {2.2367690269707355e-03, 1.1291633722052721e-03, 1.0780835837505738e-03,
   1.4911089792375384e-03, 3.6775301298071699e-04, 1.0716022846036992e-03,
   1.9357892959573676e-03, 1.8725532583338258e-03, 5.8791282749163360e-04,
   1.3390359572833434e-03, 1.7339408813938210e-03, 1.8070838729286381e-03,
   5.4319510273222540e-04, 7.3889079577318679e-04, 1.7056411057608904e-02,
   1.8468214541146135e-03, 1.6196921560667427e-03, 2.3541955953234630e-04,
   6.4111850267928403e-04, 1.5531163167895289e-03},
  {6.2077372467778114e-03, 2.5480707779992882e-03, 3.1777703084905646e-03,
   2.8168184837142236e-03, 1.1014893301583900e-03, 2.2199500917807818e-03,
   2.9614835299989701e-03, 4.3892726706643180e-03, 1.2089586814863836e-03,
   2.0791955470136677e-03, 2.9030148705129709e-03, 3.0739875836290694e-03,
   9.8962843407290630e-04, 1.5819841076161790e-03, 1.8468214541146135e-03,
   1.1119087492164673e-02, 4.7130010640939217e-03, 3.1984588103465904e-04,
   1.2969411223575139e-03, 2.9238790831836834e-03},
  {3.9182728585714704e-03, 2.0755623893205866e-03, 2.5607235691682607e-03,
   2.2443557004503045e-03, 9.6593119839638185e-04, 1.4976248429072652e-03,
   2.4465955340418752e-03, 2.4867404596474229e-03, 8.5349236685497410e-04,
   2.9182353019045755e-03, 3.8403853123581615e-03, 2.5875240617244397e-03,
   1.1386579188117374e-03, 1.4517880681388670e-03, 1.6196921560667427e-03,
   4.7130010640939217e-03, 9.9511225720898735e-03, 3.6462369214353146e-04,
   1.2243502023766173e-03, 4.0630285182107874e-03},
  {4.8631739510959277e-04, 3.8597740102525838e-04, 2.2470939491808472e-04,
   2.1629521399451062e-04, 9.5473415415687051e-05, 3.4211307677156259e-04,
   4.2400226067181517e-04, 5.1106914401047939e-04, 1.6088475111162087e-04,
   4.5881135439627285e-04, 7.8809411669902049e-04, 3.6617320485888769e-04,
   2.5453642381012927e-04, 8.8872966327839206e-04, 2.3541955953234630e-04,
   3.1984588103465904e-04, 3.6462369214353146e-04, 5.8917653327232667e-03,
   8.1035438644761436e-04, 4.8135675107584730e-04},
  {1.5289255743243066e-03, 1.2968650803478032e-03, 9.0102455753719311e-04,
   8.6838200454238037e-04, 4.0265275985100583e-04, 8.6801232355735846e-04,
   1.2320532047293646e-03, 1.1558215242534139e-03, 1.2994388028749182e-03,
   1.7726237165460320e-03, 2.7481481703784771e-03, 1.2944286682925433e-03,
   7.4966082446689317e-04, 3.9057132596179516e-03, 6.4111850267928403e-04,
   1.2969411223575139e-03, 1.2243502023766173e-03, 8.1035438644761436e-04,
   7.7325651605433090e-03, 1.7646048865917325e-03},
  {5.4421693501580945e-03, 1.9767324973351923e-03, 1.4642269583191670e-03,
   1.6071086977600263e-03, 1.3071530803028910e-03, 1.4099696811263587e-03,
   1.9587224017250621e-03, 2.1542687026690753e-03, 7.4034388655116329e-04,
   1.0732172589653342e-02, 9.1689424893657400e-03, 2.1916787299081464e-03,
   2.1431247883570799e-03, 2.9949355095799514e-03, 1.5531163167895289e-03,
   2.9238790831836834e-03, 4.0630285182107874e-03, 4.8135675107584730e-04,
   1.7646048865917325e-03, 1.6356187478795130e-02}},

   { 7.6539470498057649e-02, 5.3250385307217402e-02, 4.3637061980733187e-02,
    5.1393635127596211e-02, 2.2316032400410832e-02, 3.4923218698747475e-02,
    5.6445304260661695e-02, 7.3850907051359951e-02, 2.4711032253042223e-02,
    6.4065361639403171e-02, 9.5587467619348249e-02, 5.7876000358301254e-02,
    2.4385897213061735e-02, 4.8098159196680347e-02, 4.0885461298433984e-02,
    5.9478937760864596e-02, 5.2921707787277797e-02, 1.3706552419028580e-02,
    3.3493684732315711e-02, 7.2433722397458003e-02 },

  { {0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
    0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
    0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
    0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
    0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
    0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
    0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00},
   {0.00000000e+00, 3.27354473e+00, 6.87168642e-01, 8.87624875e-01,
    6.59704230e-01, 7.97359654e-01, 5.46298170e-01, 1.10130683e+00,
    6.41220589e-01, 7.15157692e-01, 7.47622201e-01, 6.56954186e-01,
    8.53472686e-01, 7.19514908e-01, 7.14770771e-01, 8.19913708e-01,
    6.68351460e-01, 1.36359270e+00, 9.67331593e-01, 9.81625416e-01,
    4.63560176e-01, 7.50000000e-01, 5.96400452e-01, 8.05980349e-01,
    7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 6.80310043e-01},
   {0.00000000e+00, 6.87168642e-01, 3.67565906e+00, 5.07294595e-01,
    4.02052534e+00, 1.31892999e+00, 3.83849184e-01, 8.47577177e-01,
    1.11810068e+00, 4.07212168e-01, 9.68440788e-01, 3.91166888e-01,
    5.16058658e-01, 3.26949213e+00, 6.61247189e-01, 9.98204754e-01,
    7.59007679e-01, 1.06055276e+00, 9.55438618e-01, 4.46192804e-01,
    3.38571955e-01, 7.50000000e-01, 5.55905269e-01, 1.19634119e+00,
    7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 3.97605526e-01},
   {0.00000000e+00, 8.87624875e-01, 5.07294595e-01, 1.82308935e+01,
    4.27724382e-01, 4.56030174e-01, 5.64985221e-01, 5.24350848e-01,
    5.17412429e-01, 5.87186086e-01, 4.59864212e-01, 6.50074165e-01,
    6.80946766e-01, 6.01008569e-01, 4.03060607e-01, 4.81296027e-01,
    4.27834290e-01, 8.29850973e-01, 8.17890869e-01, 8.08665030e-01,
    3.12131245e-01, 7.50000000e-01, 5.38704705e-01, 4.65687383e-01,
    7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 6.24838486e-01},
   {0.00000000e+00, 6.59704230e-01, 4.02052534e+00, 4.27724382e-01,
    6.11147890e+00, 1.65784569e+00, 3.37276799e-01, 7.44468416e-01,
    8.83789762e-01, 3.70146565e-01, 8.90348134e-01, 3.72923686e-01,
    4.35009775e-01, 1.55790069e+00, 7.09628659e-01, 9.66997497e-01,
    6.78533894e-01, 9.21480865e-01, 8.25179634e-01, 4.31712984e-01,
    3.07050170e-01, 7.50000000e-01, 5.04473723e-01, 1.39378711e+00,
    7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 3.71809285e-01},
   {0.00000000e+00, 7.97359654e-01, 1.31892999e+00, 4.56030174e-01,
    1.65784569e+00, 4.43735647e+00, 4.56055858e-01, 5.39909105e-01,
    9.11487897e-01, 4.15558851e-01, 1.33108575e+00, 4.78428941e-01,
    6.05096970e-01, 9.19771370e-01, 8.38805682e-01, 1.67134451e+00,
    9.76357610e-01, 8.82100970e-01, 8.19031320e-01, 4.79075838e-01,
    5.48039829e-01, 7.50000000e-01, 6.51686488e-01, 3.38012103e+00,
    7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 4.53200481e-01},
   {0.00000000e+00, 5.46298170e-01, 3.83849184e-01, 5.64985221e-01,
    3.37276799e-01, 4.56055858e-01, 6.63625360e+00, 4.13949535e-01,
    7.54714659e-01, 9.89742646e-01, 4.44979578e-01, 1.26171801e+00,
    1.05158910e+00, 4.38699901e-01, 3.75736079e-01, 4.16967765e-01,
    4.61789222e-01, 5.52981315e-01, 5.70349305e-01, 8.59643167e-01,
    1.34807169e+00, 7.50000000e-01, 2.42442622e+00, 4.41115461e-01,
    7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 1.15257995e+00},
   {0.00000000e+00, 1.10130683e+00, 8.47577177e-01, 5.24350848e-01,
    7.44468416e-01, 5.39909105e-01, 4.13949535e-01, 5.79218671e+00,
    6.01271290e-01, 3.70370366e-01, 6.54870319e-01, 3.76903001e-01,
    5.19438610e-01, 9.69013722e-01, 6.20168128e-01, 6.41416113e-01,
    5.16985831e-01, 9.99248542e-01, 6.36269018e-01, 4.02720033e-01,
    5.04888636e-01, 7.50000000e-01, 4.67274430e-01, 5.78707493e-01,
    7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 3.74281590e-01},
   {0.00000000e+00, 6.41220589e-01, 1.11810068e+00, 5.17412429e-01,
    8.83789762e-01, 9.11487897e-01, 7.54714659e-01, 6.01271290e-01,
    1.04489376e+01, 4.11545408e-01, 9.45545516e-01, 5.47445792e-01,
    7.60124356e-01, 1.39406083e+00, 5.81906417e-01, 1.20911332e+00,
    9.81604707e-01, 8.22540644e-01, 6.52641826e-01, 4.13620259e-01,
    4.75002356e-01, 7.50000000e-01, 1.57000854e+00, 1.02524740e+00,
    7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 4.92911793e-01},
   {0.00000000e+00, 7.15157692e-01, 4.07212168e-01, 5.87186086e-01,
    3.70146565e-01, 4.15558851e-01, 9.89742646e-01, 3.70370366e-01,
    4.11545408e-01, 3.41093885e+00, 4.68297844e-01, 1.69677965e+00,
    1.43810563e+00, 4.50866254e-01, 5.11210841e-01, 5.02656404e-01,
    4.35318230e-01, 5.45643330e-01, 8.60722536e-01, 2.31272269e+00,
    5.22495607e-01, 7.50000000e-01, 8.26095669e-01, 4.48849604e-01,
    7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 2.38463611e+00},
   {0.00000000e+00, 7.47622201e-01, 9.68440788e-01, 4.59864212e-01,
    8.90348134e-01, 1.33108575e+00, 4.44979578e-01, 6.54870319e-01,
    9.45545516e-01, 4.68297844e-01, 3.88090096e+00, 4.79194854e-01,
    6.85231759e-01, 1.06041456e+00, 7.63679086e-01, 1.41855717e+00,
    2.06468049e+00, 8.92977250e-01, 8.44796364e-01, 5.22802406e-01,
    4.61593643e-01, 7.50000000e-01, 6.67754286e-01, 1.36451940e+00,
    7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 4.74822110e-01},
   {0.00000000e+00, 6.56954186e-01, 3.91166888e-01, 6.50074165e-01,
    3.72923686e-01, 4.78428941e-01, 1.26171801e+00, 3.76903001e-01,
    5.47445792e-01, 1.69677965e+00, 4.79194854e-01, 3.32815910e+00,
    1.78991633e+00, 4.12652855e-01, 4.43674459e-01, 5.62937315e-01,
    5.54029894e-01, 5.10605044e-01, 7.59171671e-01, 1.32427289e+00,
    6.01518374e-01, 7.50000000e-01, 8.58373419e-01, 5.10730048e-01,
    7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 2.67352044e+00},
   {0.00000000e+00, 8.53472686e-01, 5.16058658e-01, 6.80946766e-01,
    4.35009775e-01, 6.05096970e-01, 1.05158910e+00, 5.19438610e-01,
    7.60124356e-01, 1.43810563e+00, 6.85231759e-01, 1.78991633e+00,
    4.81561797e+00, 6.11514139e-01, 5.44813932e-01, 9.59915799e-01,
    6.78015272e-01, 6.82291911e-01, 8.82308943e-01, 1.21329921e+00,
    7.61522900e-01, 7.50000000e-01, 9.17831903e-01, 7.40717150e-01,
    7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 1.64874201e+00},
   {0.00000000e+00, 7.19514908e-01, 3.26949213e+00, 6.01008569e-01,
    1.55790069e+00, 9.19771370e-01, 4.38699901e-01, 9.69013722e-01,
    1.39406083e+00, 4.50866254e-01, 1.06041456e+00, 4.12652855e-01,
    6.11514139e-01, 5.28532229e+00, 6.04265819e-01, 1.03495916e+00,
    8.53785837e-01, 1.22434496e+00, 1.10885139e+00, 4.63246441e-01,
    3.75696800e-01, 7.50000000e-01, 6.16478872e-01, 9.63798879e-01,
    7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 4.27987098e-01},
   {0.00000000e+00, 7.14770771e-01, 6.61247189e-01, 4.03060607e-01,
    7.09628659e-01, 8.38805682e-01, 3.75736079e-01, 6.20168128e-01,
    5.81906417e-01, 5.11210841e-01, 7.63679086e-01, 4.43674459e-01,
    5.44813932e-01, 6.04265819e-01, 1.02035160e+01, 7.50499600e-01,
    5.18638945e-01, 7.59438841e-01, 7.48565360e-01, 5.24438149e-01,
    4.20092966e-01, 7.50000000e-01, 4.68173126e-01, 8.05053001e-01,
    7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 4.70775405e-01},
   {0.00000000e+00, 8.19913708e-01, 9.98204754e-01, 4.81296027e-01,
    9.66997497e-01, 1.67134451e+00, 4.16967765e-01, 6.41416113e-01,
    1.20911332e+00, 5.02656404e-01, 1.41855717e+00, 5.62937315e-01,
    9.59915799e-01, 1.03495916e+00, 7.50499600e-01, 4.69722165e+00,
    1.35733364e+00, 1.06872445e+00, 8.10316946e-01, 5.57384267e-01,
    7.14705591e-01, 7.50000000e-01, 7.42076535e-01, 2.82790659e+00,
    7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 5.38747839e-01},
   {0.00000000e+00, 6.68351460e-01, 7.59007679e-01, 4.27834290e-01,
    6.78533894e-01, 9.76357610e-01, 4.61789222e-01, 5.16985831e-01,
    9.81604707e-01, 4.35318230e-01, 2.06468049e+00, 5.54029894e-01,
    6.78015272e-01, 8.53785837e-01, 5.18638945e-01, 1.35733364e+00,
    5.37787401e+00, 8.04499038e-01, 7.36510915e-01, 5.12488758e-01,
    5.28823677e-01, 7.50000000e-01, 7.27125062e-01, 1.12197569e+00,
    7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 5.06393371e-01},
   {0.00000000e+00, 1.36359270e+00, 1.06055276e+00, 8.29850973e-01,
    9.21480865e-01, 8.82100970e-01, 5.52981315e-01, 9.99248542e-01,
    8.22540644e-01, 5.45643330e-01, 8.92977250e-01, 5.10605044e-01,
    6.82291911e-01, 1.22434496e+00, 7.59438841e-01, 1.06872445e+00,
    8.04499038e-01, 3.14298812e+00, 1.49727124e+00, 6.78664919e-01,
    3.92328021e-01, 7.50000000e-01, 6.51019697e-01, 9.53432893e-01,
    7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 5.24665180e-01},
   {0.00000000e+00, 9.67331593e-01, 9.55438618e-01, 8.17890869e-01,
    8.25179634e-01, 8.19031320e-01, 5.70349305e-01, 6.36269018e-01,
    6.52641826e-01, 8.60722536e-01, 8.44796364e-01, 7.59171671e-01,
    8.82308943e-01, 1.10885139e+00, 7.48565360e-01, 8.10316946e-01,
    7.36510915e-01, 1.49727124e+00, 3.55307500e+00, 1.05992520e+00,
    5.02669810e-01, 7.50000000e-01, 6.90730891e-01, 8.15700480e-01,
    7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 7.99921922e-01},
   {0.00000000e+00, 9.81625416e-01, 4.46192804e-01, 8.08665030e-01,
    4.31712984e-01, 4.79075838e-01, 8.59643167e-01, 4.02720033e-01,
    4.13620259e-01, 2.31272269e+00, 5.22802406e-01, 1.32427289e+00,
    1.21329921e+00, 4.63246441e-01, 5.24438149e-01, 5.57384267e-01,
    5.12488758e-01, 6.78664919e-01, 1.05992520e+00, 3.11745700e+00,
    4.84839541e-01, 7.50000000e-01, 7.27350506e-01, 5.09007179e-01,
    7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 1.72091725e+00},
   {0.00000000e+00, 4.63560176e-01, 3.38571955e-01, 3.12131245e-01,
    3.07050170e-01, 5.48039829e-01, 1.34807169e+00, 5.04888636e-01,
    4.75002356e-01, 5.22495607e-01, 4.61593643e-01, 6.01518374e-01,
    7.61522900e-01, 3.75696800e-01, 4.20092966e-01, 7.14705591e-01,
    5.28823677e-01, 3.92328021e-01, 5.02669810e-01, 4.84839541e-01,
    3.13609332e+01, 7.50000000e-01, 1.76515899e+00, 6.11743441e-01,
    7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 5.69808181e-01},
   {0.00000000e+00, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 7.50000000e-01},
   {0.00000000e+00, 5.96400452e-01, 5.55905269e-01, 5.38704705e-01,
    5.04473723e-01, 6.51686488e-01, 2.42442622e+00, 4.67274430e-01,
    1.57000854e+00, 8.26095669e-01, 6.67754286e-01, 8.58373419e-01,
    9.17831903e-01, 6.16478872e-01, 4.68173126e-01, 7.42076535e-01,
    7.27125062e-01, 6.51019697e-01, 6.90730891e-01, 7.27350506e-01,
    1.76515899e+00, 7.50000000e-01, 6.89283261e+00, 6.86235710e-01,
    7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 8.45421029e-01},
   {0.00000000e+00, 8.05980349e-01, 1.19634119e+00, 4.65687383e-01,
    1.39378711e+00, 3.38012103e+00, 4.41115461e-01, 5.78707493e-01,
    1.02524740e+00, 4.48849604e-01, 1.36451940e+00, 5.10730048e-01,
    7.40717150e-01, 9.63798879e-01, 8.05053001e-01, 2.82790659e+00,
    1.12197569e+00, 9.53432893e-01, 8.15700480e-01, 5.09007179e-01,
    6.11743441e-01, 7.50000000e-01, 6.86235710e-01, 3.16905156e+00,
    7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 4.85898712e-01},
   {0.00000000e+00, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 7.50000000e-01},
   {0.00000000e+00, 2.90000000e-01, 2.90000000e-01, 2.90000000e-01,
    2.90000000e-01, 2.90000000e-01, 2.90000000e-01, 2.90000000e-01,
    2.90000000e-01, 2.90000000e-01, 2.90000000e-01, 2.90000000e-01,
    2.90000000e-01, 2.90000000e-01, 2.90000000e-01, 2.90000000e-01,
    2.90000000e-01, 2.90000000e-01, 2.90000000e-01, 2.90000000e-01,
    2.90000000e-01, 2.90000000e-01, 2.90000000e-01, 2.90000000e-01,
    2.90000000e-01, 1.33300000e+00, 2.90000000e-01, 2.90000000e-01},
   {0.00000000e+00, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 7.50000000e-01},
   {0.00000000e+00, 6.80310043e-01, 3.97605526e-01, 6.24838486e-01,
    3.71809285e-01, 4.53200481e-01, 1.15257995e+00, 3.74281590e-01,
    4.92911793e-01, 2.38463611e+00, 4.74822110e-01, 2.67352044e+00,
    1.64874201e+00, 4.27987098e-01, 4.70775405e-01, 5.38747839e-01,
    5.06393371e-01, 5.24665180e-01, 7.99921922e-01, 1.72091725e+00,
    5.69808181e-01, 7.50000000e-01, 8.45421029e-01, 4.85898712e-01,
    7.50000000e-01, 2.90000000e-01, 7.50000000e-01, 2.55759716e+00} }

};

}