
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2025 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQCalendar.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QCalendar>
#include <QDate>
#include <QLocale>
#include "gsiQt.h"
#include "gsiQtCoreCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QCalendar

//  Constructor QCalendar::QCalendar()


static void _init_ctor_QCalendar_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QCalendar> ();
}

static void _call_ctor_QCalendar_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QCalendar *> (new QCalendar ());
}


//  Constructor QCalendar::QCalendar(QCalendar::System system)


static void _init_ctor_QCalendar_2072 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("system");
  decl->add_arg<const qt_gsi::Converter<QCalendar::System>::target_type & > (argspec_0);
  decl->set_return_new<QCalendar> ();
}

static void _call_ctor_QCalendar_2072 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCalendar::System>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QCalendar::System>::target_type & >() (args, heap);
  ret.write<QCalendar *> (new QCalendar (qt_gsi::QtToCppAdaptor<QCalendar::System>(arg1).cref()));
}


//  Constructor QCalendar::QCalendar(QCalendar::SystemId id)


static void _init_ctor_QCalendar_2245 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<QCalendar::SystemId > (argspec_0);
  decl->set_return_new<QCalendar> ();
}

static void _call_ctor_QCalendar_2245 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QCalendar::SystemId arg1 = gsi::arg_reader<QCalendar::SystemId >() (args, heap);
  ret.write<QCalendar *> (new QCalendar (arg1));
}


// QDate QCalendar::dateFromParts(int year, int month, int day)


static void _init_f_dateFromParts_c2085 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("year");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("month");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("day");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QDate > ();
}

static void _call_f_dateFromParts_c2085 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<QDate > ((QDate)((QCalendar *)cls)->dateFromParts (arg1, arg2, arg3));
}


// QDate QCalendar::dateFromParts(const QCalendar::YearMonthDay &parts)


static void _init_f_dateFromParts_c3509 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parts");
  decl->add_arg<const QCalendar::YearMonthDay & > (argspec_0);
  decl->set_return<QDate > ();
}

static void _call_f_dateFromParts_c3509 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QCalendar::YearMonthDay &arg1 = gsi::arg_reader<const QCalendar::YearMonthDay & >() (args, heap);
  ret.write<QDate > ((QDate)((QCalendar *)cls)->dateFromParts (arg1));
}


// int QCalendar::dayOfWeek(QDate date)


static void _init_f_dayOfWeek_c899 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("date");
  decl->add_arg<QDate > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_dayOfWeek_c899 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDate arg1 = gsi::arg_reader<QDate >() (args, heap);
  ret.write<int > ((int)((QCalendar *)cls)->dayOfWeek (arg1));
}


// int QCalendar::daysInMonth(int month, int year)


static void _init_f_daysInMonth_c1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("month");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("year", true, "QCalendar::Unspecified");
  decl->add_arg<int > (argspec_1);
  decl->set_return<int > ();
}

static void _call_f_daysInMonth_c1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (QCalendar::Unspecified, heap);
  ret.write<int > ((int)((QCalendar *)cls)->daysInMonth (arg1, arg2));
}


// int QCalendar::daysInYear(int year)


static void _init_f_daysInYear_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("year");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_daysInYear_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<int > ((int)((QCalendar *)cls)->daysInYear (arg1));
}


// bool QCalendar::hasYearZero()


static void _init_f_hasYearZero_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasYearZero_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QCalendar *)cls)->hasYearZero ());
}


// bool QCalendar::isDateValid(int year, int month, int day)


static void _init_f_isDateValid_c2085 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("year");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("month");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("day");
  decl->add_arg<int > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_isDateValid_c2085 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<bool > ((bool)((QCalendar *)cls)->isDateValid (arg1, arg2, arg3));
}


// bool QCalendar::isGregorian()


static void _init_f_isGregorian_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isGregorian_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QCalendar *)cls)->isGregorian ());
}


// bool QCalendar::isLeapYear(int year)


static void _init_f_isLeapYear_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("year");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isLeapYear_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<bool > ((bool)((QCalendar *)cls)->isLeapYear (arg1));
}


// bool QCalendar::isLunar()


static void _init_f_isLunar_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isLunar_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QCalendar *)cls)->isLunar ());
}


// bool QCalendar::isLuniSolar()


static void _init_f_isLuniSolar_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isLuniSolar_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QCalendar *)cls)->isLuniSolar ());
}


// bool QCalendar::isProleptic()


static void _init_f_isProleptic_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isProleptic_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QCalendar *)cls)->isProleptic ());
}


// bool QCalendar::isSolar()


static void _init_f_isSolar_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isSolar_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QCalendar *)cls)->isSolar ());
}


// bool QCalendar::isValid()


static void _init_f_isValid_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isValid_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QCalendar *)cls)->isValid ());
}


// int QCalendar::maximumDaysInMonth()


static void _init_f_maximumDaysInMonth_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_maximumDaysInMonth_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QCalendar *)cls)->maximumDaysInMonth ());
}


// int QCalendar::maximumMonthsInYear()


static void _init_f_maximumMonthsInYear_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_maximumMonthsInYear_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QCalendar *)cls)->maximumMonthsInYear ());
}


// int QCalendar::minimumDaysInMonth()


static void _init_f_minimumDaysInMonth_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_minimumDaysInMonth_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QCalendar *)cls)->minimumDaysInMonth ());
}


// QString QCalendar::monthName(const QLocale &locale, int month, int year, QLocale::FormatType format)


static void _init_f_monthName_c5456 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("locale");
  decl->add_arg<const QLocale & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("month");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("year", true, "QCalendar::Unspecified");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("format", true, "QLocale::LongFormat");
  decl->add_arg<const qt_gsi::Converter<QLocale::FormatType>::target_type & > (argspec_3);
  decl->set_return<QString > ();
}

static void _call_f_monthName_c5456 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QLocale &arg1 = gsi::arg_reader<const QLocale & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (QCalendar::Unspecified, heap);
  const qt_gsi::Converter<QLocale::FormatType>::target_type & arg4 = args ? gsi::arg_reader<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QLocale::FormatType>(heap, QLocale::LongFormat), heap);
  ret.write<QString > ((QString)((QCalendar *)cls)->monthName (arg1, arg2, arg3, qt_gsi::QtToCppAdaptor<QLocale::FormatType>(arg4).cref()));
}


// int QCalendar::monthsInYear(int year)


static void _init_f_monthsInYear_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("year");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_monthsInYear_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<int > ((int)((QCalendar *)cls)->monthsInYear (arg1));
}


// QString QCalendar::name()


static void _init_f_name_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_name_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QCalendar *)cls)->name ());
}


// QCalendar::YearMonthDay QCalendar::partsFromDate(QDate date)


static void _init_f_partsFromDate_c899 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("date");
  decl->add_arg<QDate > (argspec_0);
  decl->set_return<QCalendar::YearMonthDay > ();
}

static void _call_f_partsFromDate_c899 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDate arg1 = gsi::arg_reader<QDate >() (args, heap);
  ret.write<QCalendar::YearMonthDay > ((QCalendar::YearMonthDay)((QCalendar *)cls)->partsFromDate (arg1));
}


// QString QCalendar::standaloneMonthName(const QLocale &locale, int month, int year, QLocale::FormatType format)


static void _init_f_standaloneMonthName_c5456 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("locale");
  decl->add_arg<const QLocale & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("month");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("year", true, "QCalendar::Unspecified");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("format", true, "QLocale::LongFormat");
  decl->add_arg<const qt_gsi::Converter<QLocale::FormatType>::target_type & > (argspec_3);
  decl->set_return<QString > ();
}

static void _call_f_standaloneMonthName_c5456 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QLocale &arg1 = gsi::arg_reader<const QLocale & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (QCalendar::Unspecified, heap);
  const qt_gsi::Converter<QLocale::FormatType>::target_type & arg4 = args ? gsi::arg_reader<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QLocale::FormatType>(heap, QLocale::LongFormat), heap);
  ret.write<QString > ((QString)((QCalendar *)cls)->standaloneMonthName (arg1, arg2, arg3, qt_gsi::QtToCppAdaptor<QLocale::FormatType>(arg4).cref()));
}


// QString QCalendar::standaloneWeekDayName(const QLocale &locale, int day, QLocale::FormatType format)


static void _init_f_standaloneWeekDayName_c4797 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("locale");
  decl->add_arg<const QLocale & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("day");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("format", true, "QLocale::LongFormat");
  decl->add_arg<const qt_gsi::Converter<QLocale::FormatType>::target_type & > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_standaloneWeekDayName_c4797 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QLocale &arg1 = gsi::arg_reader<const QLocale & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const qt_gsi::Converter<QLocale::FormatType>::target_type & arg3 = args ? gsi::arg_reader<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QLocale::FormatType>(heap, QLocale::LongFormat), heap);
  ret.write<QString > ((QString)((QCalendar *)cls)->standaloneWeekDayName (arg1, arg2, qt_gsi::QtToCppAdaptor<QLocale::FormatType>(arg3).cref()));
}


// QString QCalendar::weekDayName(const QLocale &locale, int day, QLocale::FormatType format)


static void _init_f_weekDayName_c4797 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("locale");
  decl->add_arg<const QLocale & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("day");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("format", true, "QLocale::LongFormat");
  decl->add_arg<const qt_gsi::Converter<QLocale::FormatType>::target_type & > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_weekDayName_c4797 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QLocale &arg1 = gsi::arg_reader<const QLocale & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const qt_gsi::Converter<QLocale::FormatType>::target_type & arg3 = args ? gsi::arg_reader<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QLocale::FormatType>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QLocale::FormatType>(heap, QLocale::LongFormat), heap);
  ret.write<QString > ((QString)((QCalendar *)cls)->weekDayName (arg1, arg2, qt_gsi::QtToCppAdaptor<QLocale::FormatType>(arg3).cref()));
}


// static QStringList QCalendar::availableCalendars()


static void _init_f_availableCalendars_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_f_availableCalendars_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)QCalendar::availableCalendars ());
}



namespace gsi
{

static gsi::Methods methods_QCalendar () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QCalendar::QCalendar()\nThis method creates an object of class QCalendar.", &_init_ctor_QCalendar_0, &_call_ctor_QCalendar_0);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QCalendar::QCalendar(QCalendar::System system)\nThis method creates an object of class QCalendar.", &_init_ctor_QCalendar_2072, &_call_ctor_QCalendar_2072);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QCalendar::QCalendar(QCalendar::SystemId id)\nThis method creates an object of class QCalendar.", &_init_ctor_QCalendar_2245, &_call_ctor_QCalendar_2245);
  methods += new qt_gsi::GenericMethod ("dateFromParts", "@brief Method QDate QCalendar::dateFromParts(int year, int month, int day)\n", true, &_init_f_dateFromParts_c2085, &_call_f_dateFromParts_c2085);
  methods += new qt_gsi::GenericMethod ("dateFromParts", "@brief Method QDate QCalendar::dateFromParts(const QCalendar::YearMonthDay &parts)\n", true, &_init_f_dateFromParts_c3509, &_call_f_dateFromParts_c3509);
  methods += new qt_gsi::GenericMethod ("dayOfWeek", "@brief Method int QCalendar::dayOfWeek(QDate date)\n", true, &_init_f_dayOfWeek_c899, &_call_f_dayOfWeek_c899);
  methods += new qt_gsi::GenericMethod ("daysInMonth", "@brief Method int QCalendar::daysInMonth(int month, int year)\n", true, &_init_f_daysInMonth_c1426, &_call_f_daysInMonth_c1426);
  methods += new qt_gsi::GenericMethod ("daysInYear", "@brief Method int QCalendar::daysInYear(int year)\n", true, &_init_f_daysInYear_c767, &_call_f_daysInYear_c767);
  methods += new qt_gsi::GenericMethod ("hasYearZero", "@brief Method bool QCalendar::hasYearZero()\n", true, &_init_f_hasYearZero_c0, &_call_f_hasYearZero_c0);
  methods += new qt_gsi::GenericMethod ("isDateValid?", "@brief Method bool QCalendar::isDateValid(int year, int month, int day)\n", true, &_init_f_isDateValid_c2085, &_call_f_isDateValid_c2085);
  methods += new qt_gsi::GenericMethod ("isGregorian?", "@brief Method bool QCalendar::isGregorian()\n", true, &_init_f_isGregorian_c0, &_call_f_isGregorian_c0);
  methods += new qt_gsi::GenericMethod ("isLeapYear?", "@brief Method bool QCalendar::isLeapYear(int year)\n", true, &_init_f_isLeapYear_c767, &_call_f_isLeapYear_c767);
  methods += new qt_gsi::GenericMethod ("isLunar?", "@brief Method bool QCalendar::isLunar()\n", true, &_init_f_isLunar_c0, &_call_f_isLunar_c0);
  methods += new qt_gsi::GenericMethod ("isLuniSolar?", "@brief Method bool QCalendar::isLuniSolar()\n", true, &_init_f_isLuniSolar_c0, &_call_f_isLuniSolar_c0);
  methods += new qt_gsi::GenericMethod ("isProleptic?", "@brief Method bool QCalendar::isProleptic()\n", true, &_init_f_isProleptic_c0, &_call_f_isProleptic_c0);
  methods += new qt_gsi::GenericMethod ("isSolar?", "@brief Method bool QCalendar::isSolar()\n", true, &_init_f_isSolar_c0, &_call_f_isSolar_c0);
  methods += new qt_gsi::GenericMethod ("isValid?", "@brief Method bool QCalendar::isValid()\n", true, &_init_f_isValid_c0, &_call_f_isValid_c0);
  methods += new qt_gsi::GenericMethod ("maximumDaysInMonth", "@brief Method int QCalendar::maximumDaysInMonth()\n", true, &_init_f_maximumDaysInMonth_c0, &_call_f_maximumDaysInMonth_c0);
  methods += new qt_gsi::GenericMethod ("maximumMonthsInYear", "@brief Method int QCalendar::maximumMonthsInYear()\n", true, &_init_f_maximumMonthsInYear_c0, &_call_f_maximumMonthsInYear_c0);
  methods += new qt_gsi::GenericMethod ("minimumDaysInMonth", "@brief Method int QCalendar::minimumDaysInMonth()\n", true, &_init_f_minimumDaysInMonth_c0, &_call_f_minimumDaysInMonth_c0);
  methods += new qt_gsi::GenericMethod ("monthName", "@brief Method QString QCalendar::monthName(const QLocale &locale, int month, int year, QLocale::FormatType format)\n", true, &_init_f_monthName_c5456, &_call_f_monthName_c5456);
  methods += new qt_gsi::GenericMethod ("monthsInYear", "@brief Method int QCalendar::monthsInYear(int year)\n", true, &_init_f_monthsInYear_c767, &_call_f_monthsInYear_c767);
  methods += new qt_gsi::GenericMethod ("name", "@brief Method QString QCalendar::name()\n", true, &_init_f_name_c0, &_call_f_name_c0);
  methods += new qt_gsi::GenericMethod ("partsFromDate", "@brief Method QCalendar::YearMonthDay QCalendar::partsFromDate(QDate date)\n", true, &_init_f_partsFromDate_c899, &_call_f_partsFromDate_c899);
  methods += new qt_gsi::GenericMethod ("standaloneMonthName", "@brief Method QString QCalendar::standaloneMonthName(const QLocale &locale, int month, int year, QLocale::FormatType format)\n", true, &_init_f_standaloneMonthName_c5456, &_call_f_standaloneMonthName_c5456);
  methods += new qt_gsi::GenericMethod ("standaloneWeekDayName", "@brief Method QString QCalendar::standaloneWeekDayName(const QLocale &locale, int day, QLocale::FormatType format)\n", true, &_init_f_standaloneWeekDayName_c4797, &_call_f_standaloneWeekDayName_c4797);
  methods += new qt_gsi::GenericMethod ("weekDayName", "@brief Method QString QCalendar::weekDayName(const QLocale &locale, int day, QLocale::FormatType format)\n", true, &_init_f_weekDayName_c4797, &_call_f_weekDayName_c4797);
  methods += new qt_gsi::GenericStaticMethod ("availableCalendars", "@brief Static method QStringList QCalendar::availableCalendars()\nThis method is static and can be called without an instance.", &_init_f_availableCalendars_0, &_call_f_availableCalendars_0);
  return methods;
}

gsi::Class<QCalendar> decl_QCalendar ("QtCore", "QCalendar",
  methods_QCalendar (),
  "@qt\n@brief Binding of QCalendar");


GSI_QTCORE_PUBLIC gsi::Class<QCalendar> &qtdecl_QCalendar () { return decl_QCalendar; }

}


//  Implementation of the enum wrapper class for QCalendar::System
namespace qt_gsi
{

static gsi::Enum<QCalendar::System> decl_QCalendar_System_Enum ("QtCore", "QCalendar_System",
    gsi::enum_const ("Gregorian", QCalendar::System::Gregorian, "@brief Enum constant QCalendar::System::Gregorian") +
    gsi::enum_const ("Julian", QCalendar::System::Julian, "@brief Enum constant QCalendar::System::Julian") +
    gsi::enum_const ("Milankovic", QCalendar::System::Milankovic, "@brief Enum constant QCalendar::System::Milankovic") +
    gsi::enum_const ("Jalali", QCalendar::System::Jalali, "@brief Enum constant QCalendar::System::Jalali") +
    gsi::enum_const ("IslamicCivil", QCalendar::System::IslamicCivil, "@brief Enum constant QCalendar::System::IslamicCivil") +
    gsi::enum_const ("Last", QCalendar::System::Last, "@brief Enum constant QCalendar::System::Last") +
    gsi::enum_const ("User", QCalendar::System::User, "@brief Enum constant QCalendar::System::User"),
  "@qt\n@brief This class represents the QCalendar::System enum");

static gsi::QFlagsClass<QCalendar::System > decl_QCalendar_System_Enums ("QtCore", "QCalendar_QFlags_System",
  "@qt\n@brief This class represents the QFlags<QCalendar::System> flag set");

static gsi::ClassExt<QCalendar> decl_QCalendar_System_Enum_as_child (decl_QCalendar_System_Enum, "System");
static gsi::ClassExt<QCalendar> decl_QCalendar_System_Enums_as_child (decl_QCalendar_System_Enums, "QFlags_System");

}

