/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

//
//   Automatically generated!!!  Use 'make init' to rebuild.
//

#include "ExprGrammar.h"


static void SetShiftState(State &s, int next, const Symbol *sym)
{
    s.shift[sym] = next;
}

static void SetReduceRule(State &s, int rule, const Symbol *sym)
{
    s.reduce[sym] = rule;
}

static void InitState_0(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,   1, d.Get('-'));
    SetShiftState(s,   2, d.Get('('));
    SetShiftState(s,   3, d.Get('<'));
    SetShiftState(s,   4, d.Get('{'));
    SetShiftState(s,   5, d.Get(257));
    SetShiftState(s,   6, d.Get(258));
    SetShiftState(s,   7, d.Get(259));
    SetShiftState(s,   8, d.Get(260));
    SetShiftState(s,   9, d.Get(261));
    SetShiftState(s,  10, d.Get("Expr"));
    SetShiftState(s,  11, d.Get("Constant"));
    SetShiftState(s,  12, d.Get("Vector"));
    SetShiftState(s,  13, d.Get("Function"));
    SetShiftState(s,  14, d.Get("Variable"));
    SetShiftState(s,  15, d.Get("Database"));
}

static void InitState_1(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,   1, d.Get('-'));
    SetShiftState(s,   2, d.Get('('));
    SetShiftState(s,   3, d.Get('<'));
    SetShiftState(s,   4, d.Get('{'));
    SetShiftState(s,   5, d.Get(257));
    SetShiftState(s,   6, d.Get(258));
    SetShiftState(s,   7, d.Get(259));
    SetShiftState(s,   8, d.Get(260));
    SetShiftState(s,   9, d.Get(261));
    SetShiftState(s,  16, d.Get("Expr"));
    SetShiftState(s,  11, d.Get("Constant"));
    SetShiftState(s,  12, d.Get("Vector"));
    SetShiftState(s,  13, d.Get("Function"));
    SetShiftState(s,  14, d.Get("Variable"));
    SetShiftState(s,  15, d.Get("Database"));
}

static void InitState_2(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  17, d.Get('-'));
    SetShiftState(s,  18, d.Get('('));
    SetShiftState(s,  19, d.Get('<'));
    SetShiftState(s,  20, d.Get('{'));
    SetShiftState(s,  21, d.Get(257));
    SetShiftState(s,  22, d.Get(258));
    SetShiftState(s,  23, d.Get(259));
    SetShiftState(s,  24, d.Get(260));
    SetShiftState(s,  25, d.Get(261));
    SetShiftState(s,  26, d.Get("Expr"));
    SetShiftState(s,  27, d.Get("Constant"));
    SetShiftState(s,  28, d.Get("Vector"));
    SetShiftState(s,  29, d.Get("Function"));
    SetShiftState(s,  30, d.Get("Variable"));
    SetShiftState(s,  31, d.Get("Database"));
}

static void InitState_3(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  32, d.Get('/'));
    SetShiftState(s,  33, d.Get('\\'));
    SetShiftState(s,  34, d.Get('['));
    SetShiftState(s,  35, d.Get(257));
    SetShiftState(s,  36, d.Get("PathSpec"));
    SetShiftState(s,  37, d.Get("MultiSlash"));
    SetShiftState(s,  38, d.Get("DBSpec"));
    SetShiftState(s,  39, d.Get("TimeSpec"));
}

static void InitState_4(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  40, d.Get('-'));
    SetShiftState(s,  41, d.Get('('));
    SetShiftState(s,  42, d.Get('<'));
    SetShiftState(s,  43, d.Get('{'));
    SetShiftState(s,  44, d.Get(257));
    SetShiftState(s,  45, d.Get(258));
    SetShiftState(s,  46, d.Get(259));
    SetShiftState(s,  47, d.Get(260));
    SetShiftState(s,  48, d.Get(261));
    SetShiftState(s,  49, d.Get("Expr"));
    SetShiftState(s,  50, d.Get("Constant"));
    SetShiftState(s,  51, d.Get("Vector"));
    SetShiftState(s,  52, d.Get("Function"));
    SetShiftState(s,  53, d.Get("Variable"));
    SetShiftState(s,  54, d.Get("Database"));
}

static void InitState_5(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  55, d.Get('('));

    // reduce rule 42: Variable ==> Identifier 
    SetReduceRule(s,  42, d.Get(256));
    SetReduceRule(s,  42, d.Get('+'));
    SetReduceRule(s,  42, d.Get('*'));
    SetReduceRule(s,  42, d.Get('-'));
    SetReduceRule(s,  42, d.Get('/'));
    SetReduceRule(s,  42, d.Get('^'));
    SetReduceRule(s,  42, d.Get('%'));
    SetReduceRule(s,  42, d.Get('['));
    SetReduceRule(s,  42, d.Get('&'));
}

static void InitState_6(Dictionary &d, State &s)
{
    // reduce rule 16: Constant ==> Integer 
    SetReduceRule(s,  16, d.Get(256));
    SetReduceRule(s,  16, d.Get('+'));
    SetReduceRule(s,  16, d.Get('*'));
    SetReduceRule(s,  16, d.Get('-'));
    SetReduceRule(s,  16, d.Get('/'));
    SetReduceRule(s,  16, d.Get('^'));
    SetReduceRule(s,  16, d.Get('%'));
    SetReduceRule(s,  16, d.Get('['));
    SetReduceRule(s,  16, d.Get('&'));
}

static void InitState_7(Dictionary &d, State &s)
{
    // reduce rule 17: Constant ==> Float 
    SetReduceRule(s,  17, d.Get(256));
    SetReduceRule(s,  17, d.Get('+'));
    SetReduceRule(s,  17, d.Get('*'));
    SetReduceRule(s,  17, d.Get('-'));
    SetReduceRule(s,  17, d.Get('/'));
    SetReduceRule(s,  17, d.Get('^'));
    SetReduceRule(s,  17, d.Get('%'));
    SetReduceRule(s,  17, d.Get('['));
    SetReduceRule(s,  17, d.Get('&'));
}

static void InitState_8(Dictionary &d, State &s)
{
    // reduce rule 18: Constant ==> String 
    SetReduceRule(s,  18, d.Get(256));
    SetReduceRule(s,  18, d.Get('+'));
    SetReduceRule(s,  18, d.Get('*'));
    SetReduceRule(s,  18, d.Get('-'));
    SetReduceRule(s,  18, d.Get('/'));
    SetReduceRule(s,  18, d.Get('^'));
    SetReduceRule(s,  18, d.Get('%'));
    SetReduceRule(s,  18, d.Get('['));
    SetReduceRule(s,  18, d.Get('&'));
}

static void InitState_9(Dictionary &d, State &s)
{
    // reduce rule 19: Constant ==> Bool 
    SetReduceRule(s,  19, d.Get(256));
    SetReduceRule(s,  19, d.Get('+'));
    SetReduceRule(s,  19, d.Get('*'));
    SetReduceRule(s,  19, d.Get('-'));
    SetReduceRule(s,  19, d.Get('/'));
    SetReduceRule(s,  19, d.Get('^'));
    SetReduceRule(s,  19, d.Get('%'));
    SetReduceRule(s,  19, d.Get('['));
    SetReduceRule(s,  19, d.Get('&'));
}

static void InitState_10(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  56, d.Get('+'));
    SetShiftState(s,  57, d.Get('*'));
    SetShiftState(s,  58, d.Get('-'));
    SetShiftState(s,  59, d.Get('/'));
    SetShiftState(s,  60, d.Get('^'));
    SetShiftState(s,  61, d.Get('%'));
    SetShiftState(s,  62, d.Get('['));
    SetShiftState(s,  63, d.Get('&'));

    // reduce rule 0: START ==> Expr 
    SetReduceRule(s,   0, d.Get(256));
}

static void InitState_11(Dictionary &d, State &s)
{
    // reduce rule 11: Expr ==> Constant 
    SetReduceRule(s,  11, d.Get(256));
    SetReduceRule(s,  11, d.Get('+'));
    SetReduceRule(s,  11, d.Get('*'));
    SetReduceRule(s,  11, d.Get('-'));
    SetReduceRule(s,  11, d.Get('/'));
    SetReduceRule(s,  11, d.Get('^'));
    SetReduceRule(s,  11, d.Get('%'));
    SetReduceRule(s,  11, d.Get('['));
    SetReduceRule(s,  11, d.Get('&'));
}

static void InitState_12(Dictionary &d, State &s)
{
    // reduce rule 12: Expr ==> Vector 
    SetReduceRule(s,  12, d.Get(256));
    SetReduceRule(s,  12, d.Get('+'));
    SetReduceRule(s,  12, d.Get('*'));
    SetReduceRule(s,  12, d.Get('-'));
    SetReduceRule(s,  12, d.Get('/'));
    SetReduceRule(s,  12, d.Get('^'));
    SetReduceRule(s,  12, d.Get('%'));
    SetReduceRule(s,  12, d.Get('['));
    SetReduceRule(s,  12, d.Get('&'));
}

static void InitState_13(Dictionary &d, State &s)
{
    // reduce rule 13: Expr ==> Function 
    SetReduceRule(s,  13, d.Get(256));
    SetReduceRule(s,  13, d.Get('+'));
    SetReduceRule(s,  13, d.Get('*'));
    SetReduceRule(s,  13, d.Get('-'));
    SetReduceRule(s,  13, d.Get('/'));
    SetReduceRule(s,  13, d.Get('^'));
    SetReduceRule(s,  13, d.Get('%'));
    SetReduceRule(s,  13, d.Get('['));
    SetReduceRule(s,  13, d.Get('&'));
}

static void InitState_14(Dictionary &d, State &s)
{
    // reduce rule 14: Expr ==> Variable 
    SetReduceRule(s,  14, d.Get(256));
    SetReduceRule(s,  14, d.Get('+'));
    SetReduceRule(s,  14, d.Get('*'));
    SetReduceRule(s,  14, d.Get('-'));
    SetReduceRule(s,  14, d.Get('/'));
    SetReduceRule(s,  14, d.Get('^'));
    SetReduceRule(s,  14, d.Get('%'));
    SetReduceRule(s,  14, d.Get('['));
    SetReduceRule(s,  14, d.Get('&'));
}

static void InitState_15(Dictionary &d, State &s)
{
    // reduce rule 15: Expr ==> Database 
    SetReduceRule(s,  15, d.Get(256));
    SetReduceRule(s,  15, d.Get('+'));
    SetReduceRule(s,  15, d.Get('*'));
    SetReduceRule(s,  15, d.Get('-'));
    SetReduceRule(s,  15, d.Get('/'));
    SetReduceRule(s,  15, d.Get('^'));
    SetReduceRule(s,  15, d.Get('%'));
    SetReduceRule(s,  15, d.Get('['));
    SetReduceRule(s,  15, d.Get('&'));
}

static void InitState_16(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  62, d.Get('['));

    // reduce rule 9: Expr ==> - Expr 
    SetReduceRule(s,   9, d.Get(256));
    SetReduceRule(s,   9, d.Get('+'));
    SetReduceRule(s,   9, d.Get('*'));
    SetReduceRule(s,   9, d.Get('-'));
    SetReduceRule(s,   9, d.Get('/'));
    SetReduceRule(s,   9, d.Get('^'));
    SetReduceRule(s,   9, d.Get('%'));
    SetReduceRule(s,   9, d.Get('&'));
}

static void InitState_17(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  17, d.Get('-'));
    SetShiftState(s,  18, d.Get('('));
    SetShiftState(s,  19, d.Get('<'));
    SetShiftState(s,  20, d.Get('{'));
    SetShiftState(s,  21, d.Get(257));
    SetShiftState(s,  22, d.Get(258));
    SetShiftState(s,  23, d.Get(259));
    SetShiftState(s,  24, d.Get(260));
    SetShiftState(s,  25, d.Get(261));
    SetShiftState(s,  64, d.Get("Expr"));
    SetShiftState(s,  27, d.Get("Constant"));
    SetShiftState(s,  28, d.Get("Vector"));
    SetShiftState(s,  29, d.Get("Function"));
    SetShiftState(s,  30, d.Get("Variable"));
    SetShiftState(s,  31, d.Get("Database"));
}

static void InitState_18(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  17, d.Get('-'));
    SetShiftState(s,  18, d.Get('('));
    SetShiftState(s,  19, d.Get('<'));
    SetShiftState(s,  20, d.Get('{'));
    SetShiftState(s,  21, d.Get(257));
    SetShiftState(s,  22, d.Get(258));
    SetShiftState(s,  23, d.Get(259));
    SetShiftState(s,  24, d.Get(260));
    SetShiftState(s,  25, d.Get(261));
    SetShiftState(s,  65, d.Get("Expr"));
    SetShiftState(s,  27, d.Get("Constant"));
    SetShiftState(s,  28, d.Get("Vector"));
    SetShiftState(s,  29, d.Get("Function"));
    SetShiftState(s,  30, d.Get("Variable"));
    SetShiftState(s,  31, d.Get("Database"));
}

static void InitState_19(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  32, d.Get('/'));
    SetShiftState(s,  33, d.Get('\\'));
    SetShiftState(s,  34, d.Get('['));
    SetShiftState(s,  35, d.Get(257));
    SetShiftState(s,  66, d.Get("PathSpec"));
    SetShiftState(s,  37, d.Get("MultiSlash"));
    SetShiftState(s,  67, d.Get("DBSpec"));
    SetShiftState(s,  39, d.Get("TimeSpec"));
}

static void InitState_20(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  40, d.Get('-'));
    SetShiftState(s,  41, d.Get('('));
    SetShiftState(s,  42, d.Get('<'));
    SetShiftState(s,  43, d.Get('{'));
    SetShiftState(s,  44, d.Get(257));
    SetShiftState(s,  45, d.Get(258));
    SetShiftState(s,  46, d.Get(259));
    SetShiftState(s,  47, d.Get(260));
    SetShiftState(s,  48, d.Get(261));
    SetShiftState(s,  68, d.Get("Expr"));
    SetShiftState(s,  50, d.Get("Constant"));
    SetShiftState(s,  51, d.Get("Vector"));
    SetShiftState(s,  52, d.Get("Function"));
    SetShiftState(s,  53, d.Get("Variable"));
    SetShiftState(s,  54, d.Get("Database"));
}

static void InitState_21(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  69, d.Get('('));

    // reduce rule 42: Variable ==> Identifier 
    SetReduceRule(s,  42, d.Get('+'));
    SetReduceRule(s,  42, d.Get('*'));
    SetReduceRule(s,  42, d.Get('-'));
    SetReduceRule(s,  42, d.Get('/'));
    SetReduceRule(s,  42, d.Get('^'));
    SetReduceRule(s,  42, d.Get('%'));
    SetReduceRule(s,  42, d.Get('['));
    SetReduceRule(s,  42, d.Get(')'));
    SetReduceRule(s,  42, d.Get('&'));
}

static void InitState_22(Dictionary &d, State &s)
{
    // reduce rule 16: Constant ==> Integer 
    SetReduceRule(s,  16, d.Get('+'));
    SetReduceRule(s,  16, d.Get('*'));
    SetReduceRule(s,  16, d.Get('-'));
    SetReduceRule(s,  16, d.Get('/'));
    SetReduceRule(s,  16, d.Get('^'));
    SetReduceRule(s,  16, d.Get('%'));
    SetReduceRule(s,  16, d.Get('['));
    SetReduceRule(s,  16, d.Get(')'));
    SetReduceRule(s,  16, d.Get('&'));
}

static void InitState_23(Dictionary &d, State &s)
{
    // reduce rule 17: Constant ==> Float 
    SetReduceRule(s,  17, d.Get('+'));
    SetReduceRule(s,  17, d.Get('*'));
    SetReduceRule(s,  17, d.Get('-'));
    SetReduceRule(s,  17, d.Get('/'));
    SetReduceRule(s,  17, d.Get('^'));
    SetReduceRule(s,  17, d.Get('%'));
    SetReduceRule(s,  17, d.Get('['));
    SetReduceRule(s,  17, d.Get(')'));
    SetReduceRule(s,  17, d.Get('&'));
}

static void InitState_24(Dictionary &d, State &s)
{
    // reduce rule 18: Constant ==> String 
    SetReduceRule(s,  18, d.Get('+'));
    SetReduceRule(s,  18, d.Get('*'));
    SetReduceRule(s,  18, d.Get('-'));
    SetReduceRule(s,  18, d.Get('/'));
    SetReduceRule(s,  18, d.Get('^'));
    SetReduceRule(s,  18, d.Get('%'));
    SetReduceRule(s,  18, d.Get('['));
    SetReduceRule(s,  18, d.Get(')'));
    SetReduceRule(s,  18, d.Get('&'));
}

static void InitState_25(Dictionary &d, State &s)
{
    // reduce rule 19: Constant ==> Bool 
    SetReduceRule(s,  19, d.Get('+'));
    SetReduceRule(s,  19, d.Get('*'));
    SetReduceRule(s,  19, d.Get('-'));
    SetReduceRule(s,  19, d.Get('/'));
    SetReduceRule(s,  19, d.Get('^'));
    SetReduceRule(s,  19, d.Get('%'));
    SetReduceRule(s,  19, d.Get('['));
    SetReduceRule(s,  19, d.Get(')'));
    SetReduceRule(s,  19, d.Get('&'));
}

static void InitState_26(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  70, d.Get('+'));
    SetShiftState(s,  71, d.Get('*'));
    SetShiftState(s,  72, d.Get('-'));
    SetShiftState(s,  73, d.Get('/'));
    SetShiftState(s,  74, d.Get('^'));
    SetShiftState(s,  75, d.Get('%'));
    SetShiftState(s,  76, d.Get('['));
    SetShiftState(s,  77, d.Get(')'));
    SetShiftState(s,  78, d.Get('&'));
}

static void InitState_27(Dictionary &d, State &s)
{
    // reduce rule 11: Expr ==> Constant 
    SetReduceRule(s,  11, d.Get('+'));
    SetReduceRule(s,  11, d.Get('*'));
    SetReduceRule(s,  11, d.Get('-'));
    SetReduceRule(s,  11, d.Get('/'));
    SetReduceRule(s,  11, d.Get('^'));
    SetReduceRule(s,  11, d.Get('%'));
    SetReduceRule(s,  11, d.Get('['));
    SetReduceRule(s,  11, d.Get(')'));
    SetReduceRule(s,  11, d.Get('&'));
}

static void InitState_28(Dictionary &d, State &s)
{
    // reduce rule 12: Expr ==> Vector 
    SetReduceRule(s,  12, d.Get('+'));
    SetReduceRule(s,  12, d.Get('*'));
    SetReduceRule(s,  12, d.Get('-'));
    SetReduceRule(s,  12, d.Get('/'));
    SetReduceRule(s,  12, d.Get('^'));
    SetReduceRule(s,  12, d.Get('%'));
    SetReduceRule(s,  12, d.Get('['));
    SetReduceRule(s,  12, d.Get(')'));
    SetReduceRule(s,  12, d.Get('&'));
}

static void InitState_29(Dictionary &d, State &s)
{
    // reduce rule 13: Expr ==> Function 
    SetReduceRule(s,  13, d.Get('+'));
    SetReduceRule(s,  13, d.Get('*'));
    SetReduceRule(s,  13, d.Get('-'));
    SetReduceRule(s,  13, d.Get('/'));
    SetReduceRule(s,  13, d.Get('^'));
    SetReduceRule(s,  13, d.Get('%'));
    SetReduceRule(s,  13, d.Get('['));
    SetReduceRule(s,  13, d.Get(')'));
    SetReduceRule(s,  13, d.Get('&'));
}

static void InitState_30(Dictionary &d, State &s)
{
    // reduce rule 14: Expr ==> Variable 
    SetReduceRule(s,  14, d.Get('+'));
    SetReduceRule(s,  14, d.Get('*'));
    SetReduceRule(s,  14, d.Get('-'));
    SetReduceRule(s,  14, d.Get('/'));
    SetReduceRule(s,  14, d.Get('^'));
    SetReduceRule(s,  14, d.Get('%'));
    SetReduceRule(s,  14, d.Get('['));
    SetReduceRule(s,  14, d.Get(')'));
    SetReduceRule(s,  14, d.Get('&'));
}

static void InitState_31(Dictionary &d, State &s)
{
    // reduce rule 15: Expr ==> Database 
    SetReduceRule(s,  15, d.Get('+'));
    SetReduceRule(s,  15, d.Get('*'));
    SetReduceRule(s,  15, d.Get('-'));
    SetReduceRule(s,  15, d.Get('/'));
    SetReduceRule(s,  15, d.Get('^'));
    SetReduceRule(s,  15, d.Get('%'));
    SetReduceRule(s,  15, d.Get('['));
    SetReduceRule(s,  15, d.Get(')'));
    SetReduceRule(s,  15, d.Get('&'));
}

static void InitState_32(Dictionary &d, State &s)
{
    // reduce rule 39: MultiSlash ==> / 
    SetReduceRule(s,  39, d.Get('/'));
    SetReduceRule(s,  39, d.Get('\\'));
    SetReduceRule(s,  39, d.Get(257));
}

static void InitState_33(Dictionary &d, State &s)
{
    // reduce rule 41: MultiSlash ==> (backslash) 
    SetReduceRule(s,  41, d.Get('/'));
    SetReduceRule(s,  41, d.Get('\\'));
    SetReduceRule(s,  41, d.Get(257));
}

static void InitState_34(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  79, d.Get('-'));
    SetShiftState(s,  80, d.Get('('));
    SetShiftState(s,  81, d.Get('<'));
    SetShiftState(s,  82, d.Get('{'));
    SetShiftState(s,  83, d.Get('#'));
    SetShiftState(s,  84, d.Get(257));
    SetShiftState(s,  85, d.Get(258));
    SetShiftState(s,  86, d.Get(259));
    SetShiftState(s,  87, d.Get(260));
    SetShiftState(s,  88, d.Get(261));
    SetShiftState(s,  89, d.Get("Expr"));
    SetShiftState(s,  90, d.Get("Constant"));
    SetShiftState(s,  91, d.Get("Vector"));
    SetShiftState(s,  92, d.Get("ListElems"));
    SetShiftState(s,  93, d.Get("ListElem"));
    SetShiftState(s,  94, d.Get("Function"));
    SetShiftState(s,  95, d.Get("Variable"));
    SetShiftState(s,  96, d.Get("Database"));
}

static void InitState_35(Dictionary &d, State &s)
{
    // reduce rule 37: PathSpec ==> Identifier 
    SetReduceRule(s,  37, d.Get('/'));
    SetReduceRule(s,  37, d.Get('\\'));
    SetReduceRule(s,  37, d.Get('['));
    SetReduceRule(s,  37, d.Get('>'));
    SetReduceRule(s,  37, d.Get('@'));
    SetReduceRule(s,  37, d.Get(':'));
}

static void InitState_36(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  32, d.Get('/'));
    SetShiftState(s,  33, d.Get('\\'));
    SetShiftState(s,  34, d.Get('['));
    SetShiftState(s,  97, d.Get('>'));
    SetShiftState(s,  98, d.Get('@'));
    SetShiftState(s,  99, d.Get("MultiSlash"));
    SetShiftState(s, 100, d.Get("MachSpec"));
    SetShiftState(s, 101, d.Get("TimeSpec"));

    // reduce rule 46: DBSpec ==> PathSpec 
    SetReduceRule(s,  46, d.Get(':'));
}

static void InitState_37(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 102, d.Get('/'));
    SetShiftState(s, 103, d.Get('\\'));
    SetShiftState(s, 104, d.Get(257));
}

static void InitState_38(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 105, d.Get(':'));
}

static void InitState_39(Dictionary &d, State &s)
{
    // reduce rule 48: DBSpec ==> TimeSpec 
    SetReduceRule(s,  48, d.Get(':'));
}

static void InitState_40(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  40, d.Get('-'));
    SetShiftState(s,  41, d.Get('('));
    SetShiftState(s,  42, d.Get('<'));
    SetShiftState(s,  43, d.Get('{'));
    SetShiftState(s,  44, d.Get(257));
    SetShiftState(s,  45, d.Get(258));
    SetShiftState(s,  46, d.Get(259));
    SetShiftState(s,  47, d.Get(260));
    SetShiftState(s,  48, d.Get(261));
    SetShiftState(s, 106, d.Get("Expr"));
    SetShiftState(s,  50, d.Get("Constant"));
    SetShiftState(s,  51, d.Get("Vector"));
    SetShiftState(s,  52, d.Get("Function"));
    SetShiftState(s,  53, d.Get("Variable"));
    SetShiftState(s,  54, d.Get("Database"));
}

static void InitState_41(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  17, d.Get('-'));
    SetShiftState(s,  18, d.Get('('));
    SetShiftState(s,  19, d.Get('<'));
    SetShiftState(s,  20, d.Get('{'));
    SetShiftState(s,  21, d.Get(257));
    SetShiftState(s,  22, d.Get(258));
    SetShiftState(s,  23, d.Get(259));
    SetShiftState(s,  24, d.Get(260));
    SetShiftState(s,  25, d.Get(261));
    SetShiftState(s, 107, d.Get("Expr"));
    SetShiftState(s,  27, d.Get("Constant"));
    SetShiftState(s,  28, d.Get("Vector"));
    SetShiftState(s,  29, d.Get("Function"));
    SetShiftState(s,  30, d.Get("Variable"));
    SetShiftState(s,  31, d.Get("Database"));
}

static void InitState_42(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  32, d.Get('/'));
    SetShiftState(s,  33, d.Get('\\'));
    SetShiftState(s,  34, d.Get('['));
    SetShiftState(s,  35, d.Get(257));
    SetShiftState(s, 108, d.Get("PathSpec"));
    SetShiftState(s,  37, d.Get("MultiSlash"));
    SetShiftState(s, 109, d.Get("DBSpec"));
    SetShiftState(s,  39, d.Get("TimeSpec"));
}

static void InitState_43(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  40, d.Get('-'));
    SetShiftState(s,  41, d.Get('('));
    SetShiftState(s,  42, d.Get('<'));
    SetShiftState(s,  43, d.Get('{'));
    SetShiftState(s,  44, d.Get(257));
    SetShiftState(s,  45, d.Get(258));
    SetShiftState(s,  46, d.Get(259));
    SetShiftState(s,  47, d.Get(260));
    SetShiftState(s,  48, d.Get(261));
    SetShiftState(s, 110, d.Get("Expr"));
    SetShiftState(s,  50, d.Get("Constant"));
    SetShiftState(s,  51, d.Get("Vector"));
    SetShiftState(s,  52, d.Get("Function"));
    SetShiftState(s,  53, d.Get("Variable"));
    SetShiftState(s,  54, d.Get("Database"));
}

static void InitState_44(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 111, d.Get('('));

    // reduce rule 42: Variable ==> Identifier 
    SetReduceRule(s,  42, d.Get('+'));
    SetReduceRule(s,  42, d.Get('*'));
    SetReduceRule(s,  42, d.Get('-'));
    SetReduceRule(s,  42, d.Get('/'));
    SetReduceRule(s,  42, d.Get('^'));
    SetReduceRule(s,  42, d.Get('%'));
    SetReduceRule(s,  42, d.Get('['));
    SetReduceRule(s,  42, d.Get(','));
    SetReduceRule(s,  42, d.Get('&'));
}

static void InitState_45(Dictionary &d, State &s)
{
    // reduce rule 16: Constant ==> Integer 
    SetReduceRule(s,  16, d.Get('+'));
    SetReduceRule(s,  16, d.Get('*'));
    SetReduceRule(s,  16, d.Get('-'));
    SetReduceRule(s,  16, d.Get('/'));
    SetReduceRule(s,  16, d.Get('^'));
    SetReduceRule(s,  16, d.Get('%'));
    SetReduceRule(s,  16, d.Get('['));
    SetReduceRule(s,  16, d.Get(','));
    SetReduceRule(s,  16, d.Get('&'));
}

static void InitState_46(Dictionary &d, State &s)
{
    // reduce rule 17: Constant ==> Float 
    SetReduceRule(s,  17, d.Get('+'));
    SetReduceRule(s,  17, d.Get('*'));
    SetReduceRule(s,  17, d.Get('-'));
    SetReduceRule(s,  17, d.Get('/'));
    SetReduceRule(s,  17, d.Get('^'));
    SetReduceRule(s,  17, d.Get('%'));
    SetReduceRule(s,  17, d.Get('['));
    SetReduceRule(s,  17, d.Get(','));
    SetReduceRule(s,  17, d.Get('&'));
}

static void InitState_47(Dictionary &d, State &s)
{
    // reduce rule 18: Constant ==> String 
    SetReduceRule(s,  18, d.Get('+'));
    SetReduceRule(s,  18, d.Get('*'));
    SetReduceRule(s,  18, d.Get('-'));
    SetReduceRule(s,  18, d.Get('/'));
    SetReduceRule(s,  18, d.Get('^'));
    SetReduceRule(s,  18, d.Get('%'));
    SetReduceRule(s,  18, d.Get('['));
    SetReduceRule(s,  18, d.Get(','));
    SetReduceRule(s,  18, d.Get('&'));
}

static void InitState_48(Dictionary &d, State &s)
{
    // reduce rule 19: Constant ==> Bool 
    SetReduceRule(s,  19, d.Get('+'));
    SetReduceRule(s,  19, d.Get('*'));
    SetReduceRule(s,  19, d.Get('-'));
    SetReduceRule(s,  19, d.Get('/'));
    SetReduceRule(s,  19, d.Get('^'));
    SetReduceRule(s,  19, d.Get('%'));
    SetReduceRule(s,  19, d.Get('['));
    SetReduceRule(s,  19, d.Get(','));
    SetReduceRule(s,  19, d.Get('&'));
}

static void InitState_49(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 112, d.Get('+'));
    SetShiftState(s, 113, d.Get('*'));
    SetShiftState(s, 114, d.Get('-'));
    SetShiftState(s, 115, d.Get('/'));
    SetShiftState(s, 116, d.Get('^'));
    SetShiftState(s, 117, d.Get('%'));
    SetShiftState(s, 118, d.Get('['));
    SetShiftState(s, 119, d.Get(','));
    SetShiftState(s, 120, d.Get('&'));
}

static void InitState_50(Dictionary &d, State &s)
{
    // reduce rule 11: Expr ==> Constant 
    SetReduceRule(s,  11, d.Get('+'));
    SetReduceRule(s,  11, d.Get('*'));
    SetReduceRule(s,  11, d.Get('-'));
    SetReduceRule(s,  11, d.Get('/'));
    SetReduceRule(s,  11, d.Get('^'));
    SetReduceRule(s,  11, d.Get('%'));
    SetReduceRule(s,  11, d.Get('['));
    SetReduceRule(s,  11, d.Get(','));
    SetReduceRule(s,  11, d.Get('&'));
}

static void InitState_51(Dictionary &d, State &s)
{
    // reduce rule 12: Expr ==> Vector 
    SetReduceRule(s,  12, d.Get('+'));
    SetReduceRule(s,  12, d.Get('*'));
    SetReduceRule(s,  12, d.Get('-'));
    SetReduceRule(s,  12, d.Get('/'));
    SetReduceRule(s,  12, d.Get('^'));
    SetReduceRule(s,  12, d.Get('%'));
    SetReduceRule(s,  12, d.Get('['));
    SetReduceRule(s,  12, d.Get(','));
    SetReduceRule(s,  12, d.Get('&'));
}

static void InitState_52(Dictionary &d, State &s)
{
    // reduce rule 13: Expr ==> Function 
    SetReduceRule(s,  13, d.Get('+'));
    SetReduceRule(s,  13, d.Get('*'));
    SetReduceRule(s,  13, d.Get('-'));
    SetReduceRule(s,  13, d.Get('/'));
    SetReduceRule(s,  13, d.Get('^'));
    SetReduceRule(s,  13, d.Get('%'));
    SetReduceRule(s,  13, d.Get('['));
    SetReduceRule(s,  13, d.Get(','));
    SetReduceRule(s,  13, d.Get('&'));
}

static void InitState_53(Dictionary &d, State &s)
{
    // reduce rule 14: Expr ==> Variable 
    SetReduceRule(s,  14, d.Get('+'));
    SetReduceRule(s,  14, d.Get('*'));
    SetReduceRule(s,  14, d.Get('-'));
    SetReduceRule(s,  14, d.Get('/'));
    SetReduceRule(s,  14, d.Get('^'));
    SetReduceRule(s,  14, d.Get('%'));
    SetReduceRule(s,  14, d.Get('['));
    SetReduceRule(s,  14, d.Get(','));
    SetReduceRule(s,  14, d.Get('&'));
}

static void InitState_54(Dictionary &d, State &s)
{
    // reduce rule 15: Expr ==> Database 
    SetReduceRule(s,  15, d.Get('+'));
    SetReduceRule(s,  15, d.Get('*'));
    SetReduceRule(s,  15, d.Get('-'));
    SetReduceRule(s,  15, d.Get('/'));
    SetReduceRule(s,  15, d.Get('^'));
    SetReduceRule(s,  15, d.Get('%'));
    SetReduceRule(s,  15, d.Get('['));
    SetReduceRule(s,  15, d.Get(','));
    SetReduceRule(s,  15, d.Get('&'));
}

static void InitState_55(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 121, d.Get('-'));
    SetShiftState(s, 122, d.Get('['));
    SetShiftState(s, 123, d.Get('('));
    SetShiftState(s, 124, d.Get(')'));
    SetShiftState(s, 125, d.Get('<'));
    SetShiftState(s, 126, d.Get('{'));
    SetShiftState(s, 127, d.Get(257));
    SetShiftState(s, 128, d.Get(258));
    SetShiftState(s, 129, d.Get(259));
    SetShiftState(s, 130, d.Get(260));
    SetShiftState(s, 131, d.Get(261));
    SetShiftState(s, 132, d.Get("Expr"));
    SetShiftState(s, 133, d.Get("Constant"));
    SetShiftState(s, 134, d.Get("Vector"));
    SetShiftState(s, 135, d.Get("List"));
    SetShiftState(s, 136, d.Get("Function"));
    SetShiftState(s, 137, d.Get("Args"));
    SetShiftState(s, 138, d.Get("Arg"));
    SetShiftState(s, 139, d.Get("Variable"));
    SetShiftState(s, 140, d.Get("Database"));
}

static void InitState_56(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,   1, d.Get('-'));
    SetShiftState(s,   2, d.Get('('));
    SetShiftState(s,   3, d.Get('<'));
    SetShiftState(s,   4, d.Get('{'));
    SetShiftState(s,   5, d.Get(257));
    SetShiftState(s,   6, d.Get(258));
    SetShiftState(s,   7, d.Get(259));
    SetShiftState(s,   8, d.Get(260));
    SetShiftState(s,   9, d.Get(261));
    SetShiftState(s, 141, d.Get("Expr"));
    SetShiftState(s,  11, d.Get("Constant"));
    SetShiftState(s,  12, d.Get("Vector"));
    SetShiftState(s,  13, d.Get("Function"));
    SetShiftState(s,  14, d.Get("Variable"));
    SetShiftState(s,  15, d.Get("Database"));
}

static void InitState_57(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,   1, d.Get('-'));
    SetShiftState(s,   2, d.Get('('));
    SetShiftState(s,   3, d.Get('<'));
    SetShiftState(s,   4, d.Get('{'));
    SetShiftState(s,   5, d.Get(257));
    SetShiftState(s,   6, d.Get(258));
    SetShiftState(s,   7, d.Get(259));
    SetShiftState(s,   8, d.Get(260));
    SetShiftState(s,   9, d.Get(261));
    SetShiftState(s, 142, d.Get("Expr"));
    SetShiftState(s,  11, d.Get("Constant"));
    SetShiftState(s,  12, d.Get("Vector"));
    SetShiftState(s,  13, d.Get("Function"));
    SetShiftState(s,  14, d.Get("Variable"));
    SetShiftState(s,  15, d.Get("Database"));
}

static void InitState_58(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,   1, d.Get('-'));
    SetShiftState(s,   2, d.Get('('));
    SetShiftState(s,   3, d.Get('<'));
    SetShiftState(s,   4, d.Get('{'));
    SetShiftState(s,   5, d.Get(257));
    SetShiftState(s,   6, d.Get(258));
    SetShiftState(s,   7, d.Get(259));
    SetShiftState(s,   8, d.Get(260));
    SetShiftState(s,   9, d.Get(261));
    SetShiftState(s, 143, d.Get("Expr"));
    SetShiftState(s,  11, d.Get("Constant"));
    SetShiftState(s,  12, d.Get("Vector"));
    SetShiftState(s,  13, d.Get("Function"));
    SetShiftState(s,  14, d.Get("Variable"));
    SetShiftState(s,  15, d.Get("Database"));
}

static void InitState_59(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,   1, d.Get('-'));
    SetShiftState(s,   2, d.Get('('));
    SetShiftState(s,   3, d.Get('<'));
    SetShiftState(s,   4, d.Get('{'));
    SetShiftState(s,   5, d.Get(257));
    SetShiftState(s,   6, d.Get(258));
    SetShiftState(s,   7, d.Get(259));
    SetShiftState(s,   8, d.Get(260));
    SetShiftState(s,   9, d.Get(261));
    SetShiftState(s, 144, d.Get("Expr"));
    SetShiftState(s,  11, d.Get("Constant"));
    SetShiftState(s,  12, d.Get("Vector"));
    SetShiftState(s,  13, d.Get("Function"));
    SetShiftState(s,  14, d.Get("Variable"));
    SetShiftState(s,  15, d.Get("Database"));
}

static void InitState_60(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,   1, d.Get('-'));
    SetShiftState(s,   2, d.Get('('));
    SetShiftState(s,   3, d.Get('<'));
    SetShiftState(s,   4, d.Get('{'));
    SetShiftState(s,   5, d.Get(257));
    SetShiftState(s,   6, d.Get(258));
    SetShiftState(s,   7, d.Get(259));
    SetShiftState(s,   8, d.Get(260));
    SetShiftState(s,   9, d.Get(261));
    SetShiftState(s, 145, d.Get("Expr"));
    SetShiftState(s,  11, d.Get("Constant"));
    SetShiftState(s,  12, d.Get("Vector"));
    SetShiftState(s,  13, d.Get("Function"));
    SetShiftState(s,  14, d.Get("Variable"));
    SetShiftState(s,  15, d.Get("Database"));
}

static void InitState_61(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,   1, d.Get('-'));
    SetShiftState(s,   2, d.Get('('));
    SetShiftState(s,   3, d.Get('<'));
    SetShiftState(s,   4, d.Get('{'));
    SetShiftState(s,   5, d.Get(257));
    SetShiftState(s,   6, d.Get(258));
    SetShiftState(s,   7, d.Get(259));
    SetShiftState(s,   8, d.Get(260));
    SetShiftState(s,   9, d.Get(261));
    SetShiftState(s, 146, d.Get("Expr"));
    SetShiftState(s,  11, d.Get("Constant"));
    SetShiftState(s,  12, d.Get("Vector"));
    SetShiftState(s,  13, d.Get("Function"));
    SetShiftState(s,  14, d.Get("Variable"));
    SetShiftState(s,  15, d.Get("Database"));
}

static void InitState_62(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 147, d.Get(258));
}

static void InitState_63(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,   1, d.Get('-'));
    SetShiftState(s,   2, d.Get('('));
    SetShiftState(s,   3, d.Get('<'));
    SetShiftState(s,   4, d.Get('{'));
    SetShiftState(s,   5, d.Get(257));
    SetShiftState(s,   6, d.Get(258));
    SetShiftState(s,   7, d.Get(259));
    SetShiftState(s,   8, d.Get(260));
    SetShiftState(s,   9, d.Get(261));
    SetShiftState(s, 148, d.Get("Expr"));
    SetShiftState(s,  11, d.Get("Constant"));
    SetShiftState(s,  12, d.Get("Vector"));
    SetShiftState(s,  13, d.Get("Function"));
    SetShiftState(s,  14, d.Get("Variable"));
    SetShiftState(s,  15, d.Get("Database"));
}

static void InitState_64(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  76, d.Get('['));

    // reduce rule 9: Expr ==> - Expr 
    SetReduceRule(s,   9, d.Get('+'));
    SetReduceRule(s,   9, d.Get('*'));
    SetReduceRule(s,   9, d.Get('-'));
    SetReduceRule(s,   9, d.Get('/'));
    SetReduceRule(s,   9, d.Get('^'));
    SetReduceRule(s,   9, d.Get('%'));
    SetReduceRule(s,   9, d.Get(')'));
    SetReduceRule(s,   9, d.Get('&'));
}

static void InitState_65(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  70, d.Get('+'));
    SetShiftState(s,  71, d.Get('*'));
    SetShiftState(s,  72, d.Get('-'));
    SetShiftState(s,  73, d.Get('/'));
    SetShiftState(s,  74, d.Get('^'));
    SetShiftState(s,  75, d.Get('%'));
    SetShiftState(s,  76, d.Get('['));
    SetShiftState(s, 149, d.Get(')'));
    SetShiftState(s,  78, d.Get('&'));
}

static void InitState_66(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  32, d.Get('/'));
    SetShiftState(s,  33, d.Get('\\'));
    SetShiftState(s,  34, d.Get('['));
    SetShiftState(s, 150, d.Get('>'));
    SetShiftState(s,  98, d.Get('@'));
    SetShiftState(s,  99, d.Get("MultiSlash"));
    SetShiftState(s, 100, d.Get("MachSpec"));
    SetShiftState(s, 101, d.Get("TimeSpec"));

    // reduce rule 46: DBSpec ==> PathSpec 
    SetReduceRule(s,  46, d.Get(':'));
}

static void InitState_67(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 151, d.Get(':'));
}

static void InitState_68(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 112, d.Get('+'));
    SetShiftState(s, 113, d.Get('*'));
    SetShiftState(s, 114, d.Get('-'));
    SetShiftState(s, 115, d.Get('/'));
    SetShiftState(s, 116, d.Get('^'));
    SetShiftState(s, 117, d.Get('%'));
    SetShiftState(s, 118, d.Get('['));
    SetShiftState(s, 152, d.Get(','));
    SetShiftState(s, 120, d.Get('&'));
}

static void InitState_69(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 121, d.Get('-'));
    SetShiftState(s, 122, d.Get('['));
    SetShiftState(s, 123, d.Get('('));
    SetShiftState(s, 153, d.Get(')'));
    SetShiftState(s, 125, d.Get('<'));
    SetShiftState(s, 126, d.Get('{'));
    SetShiftState(s, 127, d.Get(257));
    SetShiftState(s, 128, d.Get(258));
    SetShiftState(s, 129, d.Get(259));
    SetShiftState(s, 130, d.Get(260));
    SetShiftState(s, 131, d.Get(261));
    SetShiftState(s, 132, d.Get("Expr"));
    SetShiftState(s, 133, d.Get("Constant"));
    SetShiftState(s, 134, d.Get("Vector"));
    SetShiftState(s, 135, d.Get("List"));
    SetShiftState(s, 136, d.Get("Function"));
    SetShiftState(s, 154, d.Get("Args"));
    SetShiftState(s, 138, d.Get("Arg"));
    SetShiftState(s, 139, d.Get("Variable"));
    SetShiftState(s, 140, d.Get("Database"));
}

static void InitState_70(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  17, d.Get('-'));
    SetShiftState(s,  18, d.Get('('));
    SetShiftState(s,  19, d.Get('<'));
    SetShiftState(s,  20, d.Get('{'));
    SetShiftState(s,  21, d.Get(257));
    SetShiftState(s,  22, d.Get(258));
    SetShiftState(s,  23, d.Get(259));
    SetShiftState(s,  24, d.Get(260));
    SetShiftState(s,  25, d.Get(261));
    SetShiftState(s, 155, d.Get("Expr"));
    SetShiftState(s,  27, d.Get("Constant"));
    SetShiftState(s,  28, d.Get("Vector"));
    SetShiftState(s,  29, d.Get("Function"));
    SetShiftState(s,  30, d.Get("Variable"));
    SetShiftState(s,  31, d.Get("Database"));
}

static void InitState_71(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  17, d.Get('-'));
    SetShiftState(s,  18, d.Get('('));
    SetShiftState(s,  19, d.Get('<'));
    SetShiftState(s,  20, d.Get('{'));
    SetShiftState(s,  21, d.Get(257));
    SetShiftState(s,  22, d.Get(258));
    SetShiftState(s,  23, d.Get(259));
    SetShiftState(s,  24, d.Get(260));
    SetShiftState(s,  25, d.Get(261));
    SetShiftState(s, 156, d.Get("Expr"));
    SetShiftState(s,  27, d.Get("Constant"));
    SetShiftState(s,  28, d.Get("Vector"));
    SetShiftState(s,  29, d.Get("Function"));
    SetShiftState(s,  30, d.Get("Variable"));
    SetShiftState(s,  31, d.Get("Database"));
}

static void InitState_72(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  17, d.Get('-'));
    SetShiftState(s,  18, d.Get('('));
    SetShiftState(s,  19, d.Get('<'));
    SetShiftState(s,  20, d.Get('{'));
    SetShiftState(s,  21, d.Get(257));
    SetShiftState(s,  22, d.Get(258));
    SetShiftState(s,  23, d.Get(259));
    SetShiftState(s,  24, d.Get(260));
    SetShiftState(s,  25, d.Get(261));
    SetShiftState(s, 157, d.Get("Expr"));
    SetShiftState(s,  27, d.Get("Constant"));
    SetShiftState(s,  28, d.Get("Vector"));
    SetShiftState(s,  29, d.Get("Function"));
    SetShiftState(s,  30, d.Get("Variable"));
    SetShiftState(s,  31, d.Get("Database"));
}

static void InitState_73(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  17, d.Get('-'));
    SetShiftState(s,  18, d.Get('('));
    SetShiftState(s,  19, d.Get('<'));
    SetShiftState(s,  20, d.Get('{'));
    SetShiftState(s,  21, d.Get(257));
    SetShiftState(s,  22, d.Get(258));
    SetShiftState(s,  23, d.Get(259));
    SetShiftState(s,  24, d.Get(260));
    SetShiftState(s,  25, d.Get(261));
    SetShiftState(s, 158, d.Get("Expr"));
    SetShiftState(s,  27, d.Get("Constant"));
    SetShiftState(s,  28, d.Get("Vector"));
    SetShiftState(s,  29, d.Get("Function"));
    SetShiftState(s,  30, d.Get("Variable"));
    SetShiftState(s,  31, d.Get("Database"));
}

static void InitState_74(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  17, d.Get('-'));
    SetShiftState(s,  18, d.Get('('));
    SetShiftState(s,  19, d.Get('<'));
    SetShiftState(s,  20, d.Get('{'));
    SetShiftState(s,  21, d.Get(257));
    SetShiftState(s,  22, d.Get(258));
    SetShiftState(s,  23, d.Get(259));
    SetShiftState(s,  24, d.Get(260));
    SetShiftState(s,  25, d.Get(261));
    SetShiftState(s, 159, d.Get("Expr"));
    SetShiftState(s,  27, d.Get("Constant"));
    SetShiftState(s,  28, d.Get("Vector"));
    SetShiftState(s,  29, d.Get("Function"));
    SetShiftState(s,  30, d.Get("Variable"));
    SetShiftState(s,  31, d.Get("Database"));
}

static void InitState_75(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  17, d.Get('-'));
    SetShiftState(s,  18, d.Get('('));
    SetShiftState(s,  19, d.Get('<'));
    SetShiftState(s,  20, d.Get('{'));
    SetShiftState(s,  21, d.Get(257));
    SetShiftState(s,  22, d.Get(258));
    SetShiftState(s,  23, d.Get(259));
    SetShiftState(s,  24, d.Get(260));
    SetShiftState(s,  25, d.Get(261));
    SetShiftState(s, 160, d.Get("Expr"));
    SetShiftState(s,  27, d.Get("Constant"));
    SetShiftState(s,  28, d.Get("Vector"));
    SetShiftState(s,  29, d.Get("Function"));
    SetShiftState(s,  30, d.Get("Variable"));
    SetShiftState(s,  31, d.Get("Database"));
}

static void InitState_76(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 161, d.Get(258));
}

static void InitState_77(Dictionary &d, State &s)
{
    // reduce rule 10: Expr ==> ( Expr ) 
    SetReduceRule(s,  10, d.Get(256));
    SetReduceRule(s,  10, d.Get('+'));
    SetReduceRule(s,  10, d.Get('*'));
    SetReduceRule(s,  10, d.Get('-'));
    SetReduceRule(s,  10, d.Get('/'));
    SetReduceRule(s,  10, d.Get('^'));
    SetReduceRule(s,  10, d.Get('%'));
    SetReduceRule(s,  10, d.Get('['));
    SetReduceRule(s,  10, d.Get('&'));
}

static void InitState_78(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  17, d.Get('-'));
    SetShiftState(s,  18, d.Get('('));
    SetShiftState(s,  19, d.Get('<'));
    SetShiftState(s,  20, d.Get('{'));
    SetShiftState(s,  21, d.Get(257));
    SetShiftState(s,  22, d.Get(258));
    SetShiftState(s,  23, d.Get(259));
    SetShiftState(s,  24, d.Get(260));
    SetShiftState(s,  25, d.Get(261));
    SetShiftState(s, 162, d.Get("Expr"));
    SetShiftState(s,  27, d.Get("Constant"));
    SetShiftState(s,  28, d.Get("Vector"));
    SetShiftState(s,  29, d.Get("Function"));
    SetShiftState(s,  30, d.Get("Variable"));
    SetShiftState(s,  31, d.Get("Database"));
}

static void InitState_79(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  79, d.Get('-'));
    SetShiftState(s,  80, d.Get('('));
    SetShiftState(s,  81, d.Get('<'));
    SetShiftState(s,  82, d.Get('{'));
    SetShiftState(s,  84, d.Get(257));
    SetShiftState(s,  85, d.Get(258));
    SetShiftState(s,  86, d.Get(259));
    SetShiftState(s,  87, d.Get(260));
    SetShiftState(s,  88, d.Get(261));
    SetShiftState(s, 163, d.Get("Expr"));
    SetShiftState(s,  90, d.Get("Constant"));
    SetShiftState(s,  91, d.Get("Vector"));
    SetShiftState(s,  94, d.Get("Function"));
    SetShiftState(s,  95, d.Get("Variable"));
    SetShiftState(s,  96, d.Get("Database"));
}

static void InitState_80(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  17, d.Get('-'));
    SetShiftState(s,  18, d.Get('('));
    SetShiftState(s,  19, d.Get('<'));
    SetShiftState(s,  20, d.Get('{'));
    SetShiftState(s,  21, d.Get(257));
    SetShiftState(s,  22, d.Get(258));
    SetShiftState(s,  23, d.Get(259));
    SetShiftState(s,  24, d.Get(260));
    SetShiftState(s,  25, d.Get(261));
    SetShiftState(s, 164, d.Get("Expr"));
    SetShiftState(s,  27, d.Get("Constant"));
    SetShiftState(s,  28, d.Get("Vector"));
    SetShiftState(s,  29, d.Get("Function"));
    SetShiftState(s,  30, d.Get("Variable"));
    SetShiftState(s,  31, d.Get("Database"));
}

static void InitState_81(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  32, d.Get('/'));
    SetShiftState(s,  33, d.Get('\\'));
    SetShiftState(s,  34, d.Get('['));
    SetShiftState(s,  35, d.Get(257));
    SetShiftState(s, 165, d.Get("PathSpec"));
    SetShiftState(s,  37, d.Get("MultiSlash"));
    SetShiftState(s, 166, d.Get("DBSpec"));
    SetShiftState(s,  39, d.Get("TimeSpec"));
}

static void InitState_82(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  40, d.Get('-'));
    SetShiftState(s,  41, d.Get('('));
    SetShiftState(s,  42, d.Get('<'));
    SetShiftState(s,  43, d.Get('{'));
    SetShiftState(s,  44, d.Get(257));
    SetShiftState(s,  45, d.Get(258));
    SetShiftState(s,  46, d.Get(259));
    SetShiftState(s,  47, d.Get(260));
    SetShiftState(s,  48, d.Get(261));
    SetShiftState(s, 167, d.Get("Expr"));
    SetShiftState(s,  50, d.Get("Constant"));
    SetShiftState(s,  51, d.Get("Vector"));
    SetShiftState(s,  52, d.Get("Function"));
    SetShiftState(s,  53, d.Get("Variable"));
    SetShiftState(s,  54, d.Get("Database"));
}

static void InitState_83(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  79, d.Get('-'));
    SetShiftState(s,  80, d.Get('('));
    SetShiftState(s,  81, d.Get('<'));
    SetShiftState(s,  82, d.Get('{'));
    SetShiftState(s,  84, d.Get(257));
    SetShiftState(s,  85, d.Get(258));
    SetShiftState(s,  86, d.Get(259));
    SetShiftState(s,  87, d.Get(260));
    SetShiftState(s,  88, d.Get(261));
    SetShiftState(s,  89, d.Get("Expr"));
    SetShiftState(s,  90, d.Get("Constant"));
    SetShiftState(s,  91, d.Get("Vector"));
    SetShiftState(s, 168, d.Get("ListElems"));
    SetShiftState(s,  93, d.Get("ListElem"));
    SetShiftState(s,  94, d.Get("Function"));
    SetShiftState(s,  95, d.Get("Variable"));
    SetShiftState(s,  96, d.Get("Database"));
}

static void InitState_84(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 169, d.Get('('));

    // reduce rule 42: Variable ==> Identifier 
    SetReduceRule(s,  42, d.Get('+'));
    SetReduceRule(s,  42, d.Get('*'));
    SetReduceRule(s,  42, d.Get('-'));
    SetReduceRule(s,  42, d.Get('/'));
    SetReduceRule(s,  42, d.Get('^'));
    SetReduceRule(s,  42, d.Get('%'));
    SetReduceRule(s,  42, d.Get('['));
    SetReduceRule(s,  42, d.Get(']'));
    SetReduceRule(s,  42, d.Get(','));
    SetReduceRule(s,  42, d.Get(':'));
    SetReduceRule(s,  42, d.Get('&'));
}

static void InitState_85(Dictionary &d, State &s)
{
    // reduce rule 16: Constant ==> Integer 
    SetReduceRule(s,  16, d.Get('+'));
    SetReduceRule(s,  16, d.Get('*'));
    SetReduceRule(s,  16, d.Get('-'));
    SetReduceRule(s,  16, d.Get('/'));
    SetReduceRule(s,  16, d.Get('^'));
    SetReduceRule(s,  16, d.Get('%'));
    SetReduceRule(s,  16, d.Get('['));
    SetReduceRule(s,  16, d.Get(']'));
    SetReduceRule(s,  16, d.Get(','));
    SetReduceRule(s,  16, d.Get(':'));
    SetReduceRule(s,  16, d.Get('&'));
}

static void InitState_86(Dictionary &d, State &s)
{
    // reduce rule 17: Constant ==> Float 
    SetReduceRule(s,  17, d.Get('+'));
    SetReduceRule(s,  17, d.Get('*'));
    SetReduceRule(s,  17, d.Get('-'));
    SetReduceRule(s,  17, d.Get('/'));
    SetReduceRule(s,  17, d.Get('^'));
    SetReduceRule(s,  17, d.Get('%'));
    SetReduceRule(s,  17, d.Get('['));
    SetReduceRule(s,  17, d.Get(']'));
    SetReduceRule(s,  17, d.Get(','));
    SetReduceRule(s,  17, d.Get(':'));
    SetReduceRule(s,  17, d.Get('&'));
}

static void InitState_87(Dictionary &d, State &s)
{
    // reduce rule 18: Constant ==> String 
    SetReduceRule(s,  18, d.Get('+'));
    SetReduceRule(s,  18, d.Get('*'));
    SetReduceRule(s,  18, d.Get('-'));
    SetReduceRule(s,  18, d.Get('/'));
    SetReduceRule(s,  18, d.Get('^'));
    SetReduceRule(s,  18, d.Get('%'));
    SetReduceRule(s,  18, d.Get('['));
    SetReduceRule(s,  18, d.Get(']'));
    SetReduceRule(s,  18, d.Get(','));
    SetReduceRule(s,  18, d.Get(':'));
    SetReduceRule(s,  18, d.Get('&'));
}

static void InitState_88(Dictionary &d, State &s)
{
    // reduce rule 19: Constant ==> Bool 
    SetReduceRule(s,  19, d.Get('+'));
    SetReduceRule(s,  19, d.Get('*'));
    SetReduceRule(s,  19, d.Get('-'));
    SetReduceRule(s,  19, d.Get('/'));
    SetReduceRule(s,  19, d.Get('^'));
    SetReduceRule(s,  19, d.Get('%'));
    SetReduceRule(s,  19, d.Get('['));
    SetReduceRule(s,  19, d.Get(']'));
    SetReduceRule(s,  19, d.Get(','));
    SetReduceRule(s,  19, d.Get(':'));
    SetReduceRule(s,  19, d.Get('&'));
}

static void InitState_89(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 170, d.Get('+'));
    SetShiftState(s, 171, d.Get('*'));
    SetShiftState(s, 172, d.Get('-'));
    SetShiftState(s, 173, d.Get('/'));
    SetShiftState(s, 174, d.Get('^'));
    SetShiftState(s, 175, d.Get('%'));
    SetShiftState(s, 176, d.Get('['));
    SetShiftState(s, 177, d.Get(':'));
    SetShiftState(s, 178, d.Get('&'));

    // reduce rule 25: ListElem ==> Expr 
    SetReduceRule(s,  25, d.Get(']'));
    SetReduceRule(s,  25, d.Get(','));
}

static void InitState_90(Dictionary &d, State &s)
{
    // reduce rule 11: Expr ==> Constant 
    SetReduceRule(s,  11, d.Get('+'));
    SetReduceRule(s,  11, d.Get('*'));
    SetReduceRule(s,  11, d.Get('-'));
    SetReduceRule(s,  11, d.Get('/'));
    SetReduceRule(s,  11, d.Get('^'));
    SetReduceRule(s,  11, d.Get('%'));
    SetReduceRule(s,  11, d.Get('['));
    SetReduceRule(s,  11, d.Get(']'));
    SetReduceRule(s,  11, d.Get(','));
    SetReduceRule(s,  11, d.Get(':'));
    SetReduceRule(s,  11, d.Get('&'));
}

static void InitState_91(Dictionary &d, State &s)
{
    // reduce rule 12: Expr ==> Vector 
    SetReduceRule(s,  12, d.Get('+'));
    SetReduceRule(s,  12, d.Get('*'));
    SetReduceRule(s,  12, d.Get('-'));
    SetReduceRule(s,  12, d.Get('/'));
    SetReduceRule(s,  12, d.Get('^'));
    SetReduceRule(s,  12, d.Get('%'));
    SetReduceRule(s,  12, d.Get('['));
    SetReduceRule(s,  12, d.Get(']'));
    SetReduceRule(s,  12, d.Get(','));
    SetReduceRule(s,  12, d.Get(':'));
    SetReduceRule(s,  12, d.Get('&'));
}

static void InitState_92(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 179, d.Get(']'));
    SetShiftState(s, 180, d.Get(','));
}

static void InitState_93(Dictionary &d, State &s)
{
    // reduce rule 24: ListElems ==> ListElem 
    SetReduceRule(s,  24, d.Get(']'));
    SetReduceRule(s,  24, d.Get(','));
}

static void InitState_94(Dictionary &d, State &s)
{
    // reduce rule 13: Expr ==> Function 
    SetReduceRule(s,  13, d.Get('+'));
    SetReduceRule(s,  13, d.Get('*'));
    SetReduceRule(s,  13, d.Get('-'));
    SetReduceRule(s,  13, d.Get('/'));
    SetReduceRule(s,  13, d.Get('^'));
    SetReduceRule(s,  13, d.Get('%'));
    SetReduceRule(s,  13, d.Get('['));
    SetReduceRule(s,  13, d.Get(']'));
    SetReduceRule(s,  13, d.Get(','));
    SetReduceRule(s,  13, d.Get(':'));
    SetReduceRule(s,  13, d.Get('&'));
}

static void InitState_95(Dictionary &d, State &s)
{
    // reduce rule 14: Expr ==> Variable 
    SetReduceRule(s,  14, d.Get('+'));
    SetReduceRule(s,  14, d.Get('*'));
    SetReduceRule(s,  14, d.Get('-'));
    SetReduceRule(s,  14, d.Get('/'));
    SetReduceRule(s,  14, d.Get('^'));
    SetReduceRule(s,  14, d.Get('%'));
    SetReduceRule(s,  14, d.Get('['));
    SetReduceRule(s,  14, d.Get(']'));
    SetReduceRule(s,  14, d.Get(','));
    SetReduceRule(s,  14, d.Get(':'));
    SetReduceRule(s,  14, d.Get('&'));
}

static void InitState_96(Dictionary &d, State &s)
{
    // reduce rule 15: Expr ==> Database 
    SetReduceRule(s,  15, d.Get('+'));
    SetReduceRule(s,  15, d.Get('*'));
    SetReduceRule(s,  15, d.Get('-'));
    SetReduceRule(s,  15, d.Get('/'));
    SetReduceRule(s,  15, d.Get('^'));
    SetReduceRule(s,  15, d.Get('%'));
    SetReduceRule(s,  15, d.Get('['));
    SetReduceRule(s,  15, d.Get(']'));
    SetReduceRule(s,  15, d.Get(','));
    SetReduceRule(s,  15, d.Get(':'));
    SetReduceRule(s,  15, d.Get('&'));
}

static void InitState_97(Dictionary &d, State &s)
{
    // reduce rule 43: Variable ==> < PathSpec > 
    SetReduceRule(s,  43, d.Get(256));
    SetReduceRule(s,  43, d.Get('+'));
    SetReduceRule(s,  43, d.Get('*'));
    SetReduceRule(s,  43, d.Get('-'));
    SetReduceRule(s,  43, d.Get('/'));
    SetReduceRule(s,  43, d.Get('^'));
    SetReduceRule(s,  43, d.Get('%'));
    SetReduceRule(s,  43, d.Get('['));
    SetReduceRule(s,  43, d.Get('&'));
}

static void InitState_98(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 181, d.Get(257));
}

static void InitState_99(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 102, d.Get('/'));
    SetShiftState(s, 103, d.Get('\\'));
    SetShiftState(s, 182, d.Get(257));
}

static void InitState_100(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  34, d.Get('['));
    SetShiftState(s, 183, d.Get("TimeSpec"));

    // reduce rule 47: DBSpec ==> PathSpec MachSpec 
    SetReduceRule(s,  47, d.Get(':'));
}

static void InitState_101(Dictionary &d, State &s)
{
    // reduce rule 49: DBSpec ==> PathSpec TimeSpec 
    SetReduceRule(s,  49, d.Get(':'));
}

static void InitState_102(Dictionary &d, State &s)
{
    // reduce rule 38: MultiSlash ==> MultiSlash / 
    SetReduceRule(s,  38, d.Get('/'));
    SetReduceRule(s,  38, d.Get('\\'));
    SetReduceRule(s,  38, d.Get(257));
}

static void InitState_103(Dictionary &d, State &s)
{
    // reduce rule 40: MultiSlash ==> MultiSlash (backslash) 
    SetReduceRule(s,  40, d.Get('/'));
    SetReduceRule(s,  40, d.Get('\\'));
    SetReduceRule(s,  40, d.Get(257));
}

static void InitState_104(Dictionary &d, State &s)
{
    // reduce rule 36: PathSpec ==> MultiSlash Identifier 
    SetReduceRule(s,  36, d.Get('/'));
    SetReduceRule(s,  36, d.Get('\\'));
    SetReduceRule(s,  36, d.Get('['));
    SetReduceRule(s,  36, d.Get('>'));
    SetReduceRule(s,  36, d.Get('@'));
    SetReduceRule(s,  36, d.Get(':'));
}

static void InitState_105(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  32, d.Get('/'));
    SetShiftState(s,  33, d.Get('\\'));
    SetShiftState(s, 184, d.Get('>'));
    SetShiftState(s, 185, d.Get(257));
    SetShiftState(s, 186, d.Get("PathSpec"));
    SetShiftState(s, 187, d.Get("MultiSlash"));
}

static void InitState_106(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 118, d.Get('['));

    // reduce rule 9: Expr ==> - Expr 
    SetReduceRule(s,   9, d.Get('+'));
    SetReduceRule(s,   9, d.Get('*'));
    SetReduceRule(s,   9, d.Get('-'));
    SetReduceRule(s,   9, d.Get('/'));
    SetReduceRule(s,   9, d.Get('^'));
    SetReduceRule(s,   9, d.Get('%'));
    SetReduceRule(s,   9, d.Get(','));
    SetReduceRule(s,   9, d.Get('&'));
}

static void InitState_107(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  70, d.Get('+'));
    SetShiftState(s,  71, d.Get('*'));
    SetShiftState(s,  72, d.Get('-'));
    SetShiftState(s,  73, d.Get('/'));
    SetShiftState(s,  74, d.Get('^'));
    SetShiftState(s,  75, d.Get('%'));
    SetShiftState(s,  76, d.Get('['));
    SetShiftState(s, 188, d.Get(')'));
    SetShiftState(s,  78, d.Get('&'));
}

static void InitState_108(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  32, d.Get('/'));
    SetShiftState(s,  33, d.Get('\\'));
    SetShiftState(s,  34, d.Get('['));
    SetShiftState(s, 189, d.Get('>'));
    SetShiftState(s,  98, d.Get('@'));
    SetShiftState(s,  99, d.Get("MultiSlash"));
    SetShiftState(s, 100, d.Get("MachSpec"));
    SetShiftState(s, 101, d.Get("TimeSpec"));

    // reduce rule 46: DBSpec ==> PathSpec 
    SetReduceRule(s,  46, d.Get(':'));
}

static void InitState_109(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 190, d.Get(':'));
}

static void InitState_110(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 112, d.Get('+'));
    SetShiftState(s, 113, d.Get('*'));
    SetShiftState(s, 114, d.Get('-'));
    SetShiftState(s, 115, d.Get('/'));
    SetShiftState(s, 116, d.Get('^'));
    SetShiftState(s, 117, d.Get('%'));
    SetShiftState(s, 118, d.Get('['));
    SetShiftState(s, 191, d.Get(','));
    SetShiftState(s, 120, d.Get('&'));
}

static void InitState_111(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 121, d.Get('-'));
    SetShiftState(s, 122, d.Get('['));
    SetShiftState(s, 123, d.Get('('));
    SetShiftState(s, 192, d.Get(')'));
    SetShiftState(s, 125, d.Get('<'));
    SetShiftState(s, 126, d.Get('{'));
    SetShiftState(s, 127, d.Get(257));
    SetShiftState(s, 128, d.Get(258));
    SetShiftState(s, 129, d.Get(259));
    SetShiftState(s, 130, d.Get(260));
    SetShiftState(s, 131, d.Get(261));
    SetShiftState(s, 132, d.Get("Expr"));
    SetShiftState(s, 133, d.Get("Constant"));
    SetShiftState(s, 134, d.Get("Vector"));
    SetShiftState(s, 135, d.Get("List"));
    SetShiftState(s, 136, d.Get("Function"));
    SetShiftState(s, 193, d.Get("Args"));
    SetShiftState(s, 138, d.Get("Arg"));
    SetShiftState(s, 139, d.Get("Variable"));
    SetShiftState(s, 140, d.Get("Database"));
}

static void InitState_112(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  40, d.Get('-'));
    SetShiftState(s,  41, d.Get('('));
    SetShiftState(s,  42, d.Get('<'));
    SetShiftState(s,  43, d.Get('{'));
    SetShiftState(s,  44, d.Get(257));
    SetShiftState(s,  45, d.Get(258));
    SetShiftState(s,  46, d.Get(259));
    SetShiftState(s,  47, d.Get(260));
    SetShiftState(s,  48, d.Get(261));
    SetShiftState(s, 194, d.Get("Expr"));
    SetShiftState(s,  50, d.Get("Constant"));
    SetShiftState(s,  51, d.Get("Vector"));
    SetShiftState(s,  52, d.Get("Function"));
    SetShiftState(s,  53, d.Get("Variable"));
    SetShiftState(s,  54, d.Get("Database"));
}

static void InitState_113(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  40, d.Get('-'));
    SetShiftState(s,  41, d.Get('('));
    SetShiftState(s,  42, d.Get('<'));
    SetShiftState(s,  43, d.Get('{'));
    SetShiftState(s,  44, d.Get(257));
    SetShiftState(s,  45, d.Get(258));
    SetShiftState(s,  46, d.Get(259));
    SetShiftState(s,  47, d.Get(260));
    SetShiftState(s,  48, d.Get(261));
    SetShiftState(s, 195, d.Get("Expr"));
    SetShiftState(s,  50, d.Get("Constant"));
    SetShiftState(s,  51, d.Get("Vector"));
    SetShiftState(s,  52, d.Get("Function"));
    SetShiftState(s,  53, d.Get("Variable"));
    SetShiftState(s,  54, d.Get("Database"));
}

static void InitState_114(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  40, d.Get('-'));
    SetShiftState(s,  41, d.Get('('));
    SetShiftState(s,  42, d.Get('<'));
    SetShiftState(s,  43, d.Get('{'));
    SetShiftState(s,  44, d.Get(257));
    SetShiftState(s,  45, d.Get(258));
    SetShiftState(s,  46, d.Get(259));
    SetShiftState(s,  47, d.Get(260));
    SetShiftState(s,  48, d.Get(261));
    SetShiftState(s, 196, d.Get("Expr"));
    SetShiftState(s,  50, d.Get("Constant"));
    SetShiftState(s,  51, d.Get("Vector"));
    SetShiftState(s,  52, d.Get("Function"));
    SetShiftState(s,  53, d.Get("Variable"));
    SetShiftState(s,  54, d.Get("Database"));
}

static void InitState_115(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  40, d.Get('-'));
    SetShiftState(s,  41, d.Get('('));
    SetShiftState(s,  42, d.Get('<'));
    SetShiftState(s,  43, d.Get('{'));
    SetShiftState(s,  44, d.Get(257));
    SetShiftState(s,  45, d.Get(258));
    SetShiftState(s,  46, d.Get(259));
    SetShiftState(s,  47, d.Get(260));
    SetShiftState(s,  48, d.Get(261));
    SetShiftState(s, 197, d.Get("Expr"));
    SetShiftState(s,  50, d.Get("Constant"));
    SetShiftState(s,  51, d.Get("Vector"));
    SetShiftState(s,  52, d.Get("Function"));
    SetShiftState(s,  53, d.Get("Variable"));
    SetShiftState(s,  54, d.Get("Database"));
}

static void InitState_116(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  40, d.Get('-'));
    SetShiftState(s,  41, d.Get('('));
    SetShiftState(s,  42, d.Get('<'));
    SetShiftState(s,  43, d.Get('{'));
    SetShiftState(s,  44, d.Get(257));
    SetShiftState(s,  45, d.Get(258));
    SetShiftState(s,  46, d.Get(259));
    SetShiftState(s,  47, d.Get(260));
    SetShiftState(s,  48, d.Get(261));
    SetShiftState(s, 198, d.Get("Expr"));
    SetShiftState(s,  50, d.Get("Constant"));
    SetShiftState(s,  51, d.Get("Vector"));
    SetShiftState(s,  52, d.Get("Function"));
    SetShiftState(s,  53, d.Get("Variable"));
    SetShiftState(s,  54, d.Get("Database"));
}

static void InitState_117(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  40, d.Get('-'));
    SetShiftState(s,  41, d.Get('('));
    SetShiftState(s,  42, d.Get('<'));
    SetShiftState(s,  43, d.Get('{'));
    SetShiftState(s,  44, d.Get(257));
    SetShiftState(s,  45, d.Get(258));
    SetShiftState(s,  46, d.Get(259));
    SetShiftState(s,  47, d.Get(260));
    SetShiftState(s,  48, d.Get(261));
    SetShiftState(s, 199, d.Get("Expr"));
    SetShiftState(s,  50, d.Get("Constant"));
    SetShiftState(s,  51, d.Get("Vector"));
    SetShiftState(s,  52, d.Get("Function"));
    SetShiftState(s,  53, d.Get("Variable"));
    SetShiftState(s,  54, d.Get("Database"));
}

static void InitState_118(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 200, d.Get(258));
}

static void InitState_119(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 201, d.Get('-'));
    SetShiftState(s, 202, d.Get('('));
    SetShiftState(s, 203, d.Get('<'));
    SetShiftState(s, 204, d.Get('{'));
    SetShiftState(s, 205, d.Get(257));
    SetShiftState(s, 206, d.Get(258));
    SetShiftState(s, 207, d.Get(259));
    SetShiftState(s, 208, d.Get(260));
    SetShiftState(s, 209, d.Get(261));
    SetShiftState(s, 210, d.Get("Expr"));
    SetShiftState(s, 211, d.Get("Constant"));
    SetShiftState(s, 212, d.Get("Vector"));
    SetShiftState(s, 213, d.Get("Function"));
    SetShiftState(s, 214, d.Get("Variable"));
    SetShiftState(s, 215, d.Get("Database"));
}

static void InitState_120(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  40, d.Get('-'));
    SetShiftState(s,  41, d.Get('('));
    SetShiftState(s,  42, d.Get('<'));
    SetShiftState(s,  43, d.Get('{'));
    SetShiftState(s,  44, d.Get(257));
    SetShiftState(s,  45, d.Get(258));
    SetShiftState(s,  46, d.Get(259));
    SetShiftState(s,  47, d.Get(260));
    SetShiftState(s,  48, d.Get(261));
    SetShiftState(s, 216, d.Get("Expr"));
    SetShiftState(s,  50, d.Get("Constant"));
    SetShiftState(s,  51, d.Get("Vector"));
    SetShiftState(s,  52, d.Get("Function"));
    SetShiftState(s,  53, d.Get("Variable"));
    SetShiftState(s,  54, d.Get("Database"));
}

static void InitState_121(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 121, d.Get('-'));
    SetShiftState(s, 123, d.Get('('));
    SetShiftState(s, 125, d.Get('<'));
    SetShiftState(s, 126, d.Get('{'));
    SetShiftState(s, 217, d.Get(257));
    SetShiftState(s, 128, d.Get(258));
    SetShiftState(s, 129, d.Get(259));
    SetShiftState(s, 130, d.Get(260));
    SetShiftState(s, 131, d.Get(261));
    SetShiftState(s, 218, d.Get("Expr"));
    SetShiftState(s, 133, d.Get("Constant"));
    SetShiftState(s, 134, d.Get("Vector"));
    SetShiftState(s, 136, d.Get("Function"));
    SetShiftState(s, 139, d.Get("Variable"));
    SetShiftState(s, 140, d.Get("Database"));
}

static void InitState_122(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  79, d.Get('-'));
    SetShiftState(s,  80, d.Get('('));
    SetShiftState(s,  81, d.Get('<'));
    SetShiftState(s,  82, d.Get('{'));
    SetShiftState(s,  84, d.Get(257));
    SetShiftState(s,  85, d.Get(258));
    SetShiftState(s,  86, d.Get(259));
    SetShiftState(s,  87, d.Get(260));
    SetShiftState(s,  88, d.Get(261));
    SetShiftState(s,  89, d.Get("Expr"));
    SetShiftState(s,  90, d.Get("Constant"));
    SetShiftState(s,  91, d.Get("Vector"));
    SetShiftState(s, 219, d.Get("ListElems"));
    SetShiftState(s,  93, d.Get("ListElem"));
    SetShiftState(s,  94, d.Get("Function"));
    SetShiftState(s,  95, d.Get("Variable"));
    SetShiftState(s,  96, d.Get("Database"));
}

static void InitState_123(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  17, d.Get('-'));
    SetShiftState(s,  18, d.Get('('));
    SetShiftState(s,  19, d.Get('<'));
    SetShiftState(s,  20, d.Get('{'));
    SetShiftState(s,  21, d.Get(257));
    SetShiftState(s,  22, d.Get(258));
    SetShiftState(s,  23, d.Get(259));
    SetShiftState(s,  24, d.Get(260));
    SetShiftState(s,  25, d.Get(261));
    SetShiftState(s, 220, d.Get("Expr"));
    SetShiftState(s,  27, d.Get("Constant"));
    SetShiftState(s,  28, d.Get("Vector"));
    SetShiftState(s,  29, d.Get("Function"));
    SetShiftState(s,  30, d.Get("Variable"));
    SetShiftState(s,  31, d.Get("Database"));
}

static void InitState_124(Dictionary &d, State &s)
{
    // reduce rule 28: Function ==> Identifier ( ) 
    SetReduceRule(s,  28, d.Get(256));
    SetReduceRule(s,  28, d.Get('+'));
    SetReduceRule(s,  28, d.Get('*'));
    SetReduceRule(s,  28, d.Get('-'));
    SetReduceRule(s,  28, d.Get('/'));
    SetReduceRule(s,  28, d.Get('^'));
    SetReduceRule(s,  28, d.Get('%'));
    SetReduceRule(s,  28, d.Get('['));
    SetReduceRule(s,  28, d.Get('&'));
}

static void InitState_125(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  32, d.Get('/'));
    SetShiftState(s,  33, d.Get('\\'));
    SetShiftState(s,  34, d.Get('['));
    SetShiftState(s,  35, d.Get(257));
    SetShiftState(s, 221, d.Get("PathSpec"));
    SetShiftState(s,  37, d.Get("MultiSlash"));
    SetShiftState(s, 222, d.Get("DBSpec"));
    SetShiftState(s,  39, d.Get("TimeSpec"));
}

static void InitState_126(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  40, d.Get('-'));
    SetShiftState(s,  41, d.Get('('));
    SetShiftState(s,  42, d.Get('<'));
    SetShiftState(s,  43, d.Get('{'));
    SetShiftState(s,  44, d.Get(257));
    SetShiftState(s,  45, d.Get(258));
    SetShiftState(s,  46, d.Get(259));
    SetShiftState(s,  47, d.Get(260));
    SetShiftState(s,  48, d.Get(261));
    SetShiftState(s, 223, d.Get("Expr"));
    SetShiftState(s,  50, d.Get("Constant"));
    SetShiftState(s,  51, d.Get("Vector"));
    SetShiftState(s,  52, d.Get("Function"));
    SetShiftState(s,  53, d.Get("Variable"));
    SetShiftState(s,  54, d.Get("Database"));
}

static void InitState_127(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 224, d.Get('('));
    SetShiftState(s, 225, d.Get('='));

    // reduce rule 42: Variable ==> Identifier 
    SetReduceRule(s,  42, d.Get('+'));
    SetReduceRule(s,  42, d.Get('*'));
    SetReduceRule(s,  42, d.Get('-'));
    SetReduceRule(s,  42, d.Get('/'));
    SetReduceRule(s,  42, d.Get('^'));
    SetReduceRule(s,  42, d.Get('%'));
    SetReduceRule(s,  42, d.Get('['));
    SetReduceRule(s,  42, d.Get(')'));
    SetReduceRule(s,  42, d.Get(','));
    SetReduceRule(s,  42, d.Get('&'));
}

static void InitState_128(Dictionary &d, State &s)
{
    // reduce rule 16: Constant ==> Integer 
    SetReduceRule(s,  16, d.Get('+'));
    SetReduceRule(s,  16, d.Get('*'));
    SetReduceRule(s,  16, d.Get('-'));
    SetReduceRule(s,  16, d.Get('/'));
    SetReduceRule(s,  16, d.Get('^'));
    SetReduceRule(s,  16, d.Get('%'));
    SetReduceRule(s,  16, d.Get('['));
    SetReduceRule(s,  16, d.Get(')'));
    SetReduceRule(s,  16, d.Get(','));
    SetReduceRule(s,  16, d.Get('&'));
}

static void InitState_129(Dictionary &d, State &s)
{
    // reduce rule 17: Constant ==> Float 
    SetReduceRule(s,  17, d.Get('+'));
    SetReduceRule(s,  17, d.Get('*'));
    SetReduceRule(s,  17, d.Get('-'));
    SetReduceRule(s,  17, d.Get('/'));
    SetReduceRule(s,  17, d.Get('^'));
    SetReduceRule(s,  17, d.Get('%'));
    SetReduceRule(s,  17, d.Get('['));
    SetReduceRule(s,  17, d.Get(')'));
    SetReduceRule(s,  17, d.Get(','));
    SetReduceRule(s,  17, d.Get('&'));
}

static void InitState_130(Dictionary &d, State &s)
{
    // reduce rule 18: Constant ==> String 
    SetReduceRule(s,  18, d.Get('+'));
    SetReduceRule(s,  18, d.Get('*'));
    SetReduceRule(s,  18, d.Get('-'));
    SetReduceRule(s,  18, d.Get('/'));
    SetReduceRule(s,  18, d.Get('^'));
    SetReduceRule(s,  18, d.Get('%'));
    SetReduceRule(s,  18, d.Get('['));
    SetReduceRule(s,  18, d.Get(')'));
    SetReduceRule(s,  18, d.Get(','));
    SetReduceRule(s,  18, d.Get('&'));
}

static void InitState_131(Dictionary &d, State &s)
{
    // reduce rule 19: Constant ==> Bool 
    SetReduceRule(s,  19, d.Get('+'));
    SetReduceRule(s,  19, d.Get('*'));
    SetReduceRule(s,  19, d.Get('-'));
    SetReduceRule(s,  19, d.Get('/'));
    SetReduceRule(s,  19, d.Get('^'));
    SetReduceRule(s,  19, d.Get('%'));
    SetReduceRule(s,  19, d.Get('['));
    SetReduceRule(s,  19, d.Get(')'));
    SetReduceRule(s,  19, d.Get(','));
    SetReduceRule(s,  19, d.Get('&'));
}

static void InitState_132(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 226, d.Get('+'));
    SetShiftState(s, 227, d.Get('*'));
    SetShiftState(s, 228, d.Get('-'));
    SetShiftState(s, 229, d.Get('/'));
    SetShiftState(s, 230, d.Get('^'));
    SetShiftState(s, 231, d.Get('%'));
    SetShiftState(s, 232, d.Get('['));
    SetShiftState(s, 233, d.Get('&'));

    // reduce rule 32: Arg ==> Expr 
    SetReduceRule(s,  32, d.Get(')'));
    SetReduceRule(s,  32, d.Get(','));
}

static void InitState_133(Dictionary &d, State &s)
{
    // reduce rule 11: Expr ==> Constant 
    SetReduceRule(s,  11, d.Get('+'));
    SetReduceRule(s,  11, d.Get('*'));
    SetReduceRule(s,  11, d.Get('-'));
    SetReduceRule(s,  11, d.Get('/'));
    SetReduceRule(s,  11, d.Get('^'));
    SetReduceRule(s,  11, d.Get('%'));
    SetReduceRule(s,  11, d.Get('['));
    SetReduceRule(s,  11, d.Get(')'));
    SetReduceRule(s,  11, d.Get(','));
    SetReduceRule(s,  11, d.Get('&'));
}

static void InitState_134(Dictionary &d, State &s)
{
    // reduce rule 12: Expr ==> Vector 
    SetReduceRule(s,  12, d.Get('+'));
    SetReduceRule(s,  12, d.Get('*'));
    SetReduceRule(s,  12, d.Get('-'));
    SetReduceRule(s,  12, d.Get('/'));
    SetReduceRule(s,  12, d.Get('^'));
    SetReduceRule(s,  12, d.Get('%'));
    SetReduceRule(s,  12, d.Get('['));
    SetReduceRule(s,  12, d.Get(')'));
    SetReduceRule(s,  12, d.Get(','));
    SetReduceRule(s,  12, d.Get('&'));
}

static void InitState_135(Dictionary &d, State &s)
{
    // reduce rule 34: Arg ==> List 
    SetReduceRule(s,  34, d.Get(')'));
    SetReduceRule(s,  34, d.Get(','));
}

static void InitState_136(Dictionary &d, State &s)
{
    // reduce rule 13: Expr ==> Function 
    SetReduceRule(s,  13, d.Get('+'));
    SetReduceRule(s,  13, d.Get('*'));
    SetReduceRule(s,  13, d.Get('-'));
    SetReduceRule(s,  13, d.Get('/'));
    SetReduceRule(s,  13, d.Get('^'));
    SetReduceRule(s,  13, d.Get('%'));
    SetReduceRule(s,  13, d.Get('['));
    SetReduceRule(s,  13, d.Get(')'));
    SetReduceRule(s,  13, d.Get(','));
    SetReduceRule(s,  13, d.Get('&'));
}

static void InitState_137(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 234, d.Get(')'));
    SetShiftState(s, 235, d.Get(','));
}

static void InitState_138(Dictionary &d, State &s)
{
    // reduce rule 31: Args ==> Arg 
    SetReduceRule(s,  31, d.Get(')'));
    SetReduceRule(s,  31, d.Get(','));
}

static void InitState_139(Dictionary &d, State &s)
{
    // reduce rule 14: Expr ==> Variable 
    SetReduceRule(s,  14, d.Get('+'));
    SetReduceRule(s,  14, d.Get('*'));
    SetReduceRule(s,  14, d.Get('-'));
    SetReduceRule(s,  14, d.Get('/'));
    SetReduceRule(s,  14, d.Get('^'));
    SetReduceRule(s,  14, d.Get('%'));
    SetReduceRule(s,  14, d.Get('['));
    SetReduceRule(s,  14, d.Get(')'));
    SetReduceRule(s,  14, d.Get(','));
    SetReduceRule(s,  14, d.Get('&'));
}

static void InitState_140(Dictionary &d, State &s)
{
    // reduce rule 15: Expr ==> Database 
    SetReduceRule(s,  15, d.Get('+'));
    SetReduceRule(s,  15, d.Get('*'));
    SetReduceRule(s,  15, d.Get('-'));
    SetReduceRule(s,  15, d.Get('/'));
    SetReduceRule(s,  15, d.Get('^'));
    SetReduceRule(s,  15, d.Get('%'));
    SetReduceRule(s,  15, d.Get('['));
    SetReduceRule(s,  15, d.Get(')'));
    SetReduceRule(s,  15, d.Get(','));
    SetReduceRule(s,  15, d.Get('&'));
}

static void InitState_141(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  57, d.Get('*'));
    SetShiftState(s,  59, d.Get('/'));
    SetShiftState(s,  60, d.Get('^'));
    SetShiftState(s,  62, d.Get('['));
    SetShiftState(s,  63, d.Get('&'));

    // reduce rule 1: Expr ==> Expr + Expr 
    SetReduceRule(s,   1, d.Get(256));
    SetReduceRule(s,   1, d.Get('+'));
    SetReduceRule(s,   1, d.Get('-'));
    SetReduceRule(s,   1, d.Get('%'));
}

static void InitState_142(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  60, d.Get('^'));
    SetShiftState(s,  62, d.Get('['));
    SetShiftState(s,  63, d.Get('&'));

    // reduce rule 3: Expr ==> Expr * Expr 
    SetReduceRule(s,   3, d.Get(256));
    SetReduceRule(s,   3, d.Get('+'));
    SetReduceRule(s,   3, d.Get('*'));
    SetReduceRule(s,   3, d.Get('-'));
    SetReduceRule(s,   3, d.Get('/'));
    SetReduceRule(s,   3, d.Get('%'));
}

static void InitState_143(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  57, d.Get('*'));
    SetShiftState(s,  59, d.Get('/'));
    SetShiftState(s,  60, d.Get('^'));
    SetShiftState(s,  62, d.Get('['));
    SetShiftState(s,  63, d.Get('&'));

    // reduce rule 2: Expr ==> Expr - Expr 
    SetReduceRule(s,   2, d.Get(256));
    SetReduceRule(s,   2, d.Get('+'));
    SetReduceRule(s,   2, d.Get('-'));
    SetReduceRule(s,   2, d.Get('%'));
}

static void InitState_144(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  60, d.Get('^'));
    SetShiftState(s,  62, d.Get('['));
    SetShiftState(s,  63, d.Get('&'));

    // reduce rule 4: Expr ==> Expr / Expr 
    SetReduceRule(s,   4, d.Get(256));
    SetReduceRule(s,   4, d.Get('+'));
    SetReduceRule(s,   4, d.Get('*'));
    SetReduceRule(s,   4, d.Get('-'));
    SetReduceRule(s,   4, d.Get('/'));
    SetReduceRule(s,   4, d.Get('%'));
}

static void InitState_145(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  60, d.Get('^'));
    SetShiftState(s,  62, d.Get('['));

    // reduce rule 5: Expr ==> Expr ^ Expr 
    SetReduceRule(s,   5, d.Get(256));
    SetReduceRule(s,   5, d.Get('+'));
    SetReduceRule(s,   5, d.Get('*'));
    SetReduceRule(s,   5, d.Get('-'));
    SetReduceRule(s,   5, d.Get('/'));
    SetReduceRule(s,   5, d.Get('%'));
}

static void InitState_146(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  56, d.Get('+'));
    SetShiftState(s,  57, d.Get('*'));
    SetShiftState(s,  58, d.Get('-'));
    SetShiftState(s,  59, d.Get('/'));
    SetShiftState(s,  60, d.Get('^'));
    SetShiftState(s,  62, d.Get('['));
    SetShiftState(s,  63, d.Get('&'));

    // reduce rule 6: Expr ==> Expr % Expr 
    SetReduceRule(s,   6, d.Get(256));
}

static void InitState_147(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 236, d.Get(']'));
}

static void InitState_148(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  60, d.Get('^'));
    SetShiftState(s,  62, d.Get('['));

    // reduce rule 7: Expr ==> Expr & Expr 
    SetReduceRule(s,   7, d.Get(256));
    SetReduceRule(s,   7, d.Get('+'));
    SetReduceRule(s,   7, d.Get('*'));
    SetReduceRule(s,   7, d.Get('-'));
    SetReduceRule(s,   7, d.Get('/'));
    SetReduceRule(s,   7, d.Get('%'));
}

static void InitState_149(Dictionary &d, State &s)
{
    // reduce rule 10: Expr ==> ( Expr ) 
    SetReduceRule(s,  10, d.Get('+'));
    SetReduceRule(s,  10, d.Get('*'));
    SetReduceRule(s,  10, d.Get('-'));
    SetReduceRule(s,  10, d.Get('/'));
    SetReduceRule(s,  10, d.Get('^'));
    SetReduceRule(s,  10, d.Get('%'));
    SetReduceRule(s,  10, d.Get('['));
    SetReduceRule(s,  10, d.Get(')'));
    SetReduceRule(s,  10, d.Get('&'));
}

static void InitState_150(Dictionary &d, State &s)
{
    // reduce rule 43: Variable ==> < PathSpec > 
    SetReduceRule(s,  43, d.Get('+'));
    SetReduceRule(s,  43, d.Get('*'));
    SetReduceRule(s,  43, d.Get('-'));
    SetReduceRule(s,  43, d.Get('/'));
    SetReduceRule(s,  43, d.Get('^'));
    SetReduceRule(s,  43, d.Get('%'));
    SetReduceRule(s,  43, d.Get('['));
    SetReduceRule(s,  43, d.Get(')'));
    SetReduceRule(s,  43, d.Get('&'));
}

static void InitState_151(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  32, d.Get('/'));
    SetShiftState(s,  33, d.Get('\\'));
    SetShiftState(s, 237, d.Get('>'));
    SetShiftState(s, 185, d.Get(257));
    SetShiftState(s, 238, d.Get("PathSpec"));
    SetShiftState(s, 187, d.Get("MultiSlash"));
}

static void InitState_152(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 201, d.Get('-'));
    SetShiftState(s, 202, d.Get('('));
    SetShiftState(s, 203, d.Get('<'));
    SetShiftState(s, 204, d.Get('{'));
    SetShiftState(s, 205, d.Get(257));
    SetShiftState(s, 206, d.Get(258));
    SetShiftState(s, 207, d.Get(259));
    SetShiftState(s, 208, d.Get(260));
    SetShiftState(s, 209, d.Get(261));
    SetShiftState(s, 239, d.Get("Expr"));
    SetShiftState(s, 211, d.Get("Constant"));
    SetShiftState(s, 212, d.Get("Vector"));
    SetShiftState(s, 213, d.Get("Function"));
    SetShiftState(s, 214, d.Get("Variable"));
    SetShiftState(s, 215, d.Get("Database"));
}

static void InitState_153(Dictionary &d, State &s)
{
    // reduce rule 28: Function ==> Identifier ( ) 
    SetReduceRule(s,  28, d.Get('+'));
    SetReduceRule(s,  28, d.Get('*'));
    SetReduceRule(s,  28, d.Get('-'));
    SetReduceRule(s,  28, d.Get('/'));
    SetReduceRule(s,  28, d.Get('^'));
    SetReduceRule(s,  28, d.Get('%'));
    SetReduceRule(s,  28, d.Get('['));
    SetReduceRule(s,  28, d.Get(')'));
    SetReduceRule(s,  28, d.Get('&'));
}

static void InitState_154(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 240, d.Get(')'));
    SetShiftState(s, 235, d.Get(','));
}

static void InitState_155(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  71, d.Get('*'));
    SetShiftState(s,  73, d.Get('/'));
    SetShiftState(s,  74, d.Get('^'));
    SetShiftState(s,  76, d.Get('['));
    SetShiftState(s,  78, d.Get('&'));

    // reduce rule 1: Expr ==> Expr + Expr 
    SetReduceRule(s,   1, d.Get('+'));
    SetReduceRule(s,   1, d.Get('-'));
    SetReduceRule(s,   1, d.Get('%'));
    SetReduceRule(s,   1, d.Get(')'));
}

static void InitState_156(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  74, d.Get('^'));
    SetShiftState(s,  76, d.Get('['));
    SetShiftState(s,  78, d.Get('&'));

    // reduce rule 3: Expr ==> Expr * Expr 
    SetReduceRule(s,   3, d.Get('+'));
    SetReduceRule(s,   3, d.Get('*'));
    SetReduceRule(s,   3, d.Get('-'));
    SetReduceRule(s,   3, d.Get('/'));
    SetReduceRule(s,   3, d.Get('%'));
    SetReduceRule(s,   3, d.Get(')'));
}

static void InitState_157(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  71, d.Get('*'));
    SetShiftState(s,  73, d.Get('/'));
    SetShiftState(s,  74, d.Get('^'));
    SetShiftState(s,  76, d.Get('['));
    SetShiftState(s,  78, d.Get('&'));

    // reduce rule 2: Expr ==> Expr - Expr 
    SetReduceRule(s,   2, d.Get('+'));
    SetReduceRule(s,   2, d.Get('-'));
    SetReduceRule(s,   2, d.Get('%'));
    SetReduceRule(s,   2, d.Get(')'));
}

static void InitState_158(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  74, d.Get('^'));
    SetShiftState(s,  76, d.Get('['));
    SetShiftState(s,  78, d.Get('&'));

    // reduce rule 4: Expr ==> Expr / Expr 
    SetReduceRule(s,   4, d.Get('+'));
    SetReduceRule(s,   4, d.Get('*'));
    SetReduceRule(s,   4, d.Get('-'));
    SetReduceRule(s,   4, d.Get('/'));
    SetReduceRule(s,   4, d.Get('%'));
    SetReduceRule(s,   4, d.Get(')'));
}

static void InitState_159(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  74, d.Get('^'));
    SetShiftState(s,  76, d.Get('['));

    // reduce rule 5: Expr ==> Expr ^ Expr 
    SetReduceRule(s,   5, d.Get('+'));
    SetReduceRule(s,   5, d.Get('*'));
    SetReduceRule(s,   5, d.Get('-'));
    SetReduceRule(s,   5, d.Get('/'));
    SetReduceRule(s,   5, d.Get('%'));
    SetReduceRule(s,   5, d.Get(')'));
}

static void InitState_160(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  70, d.Get('+'));
    SetShiftState(s,  71, d.Get('*'));
    SetShiftState(s,  72, d.Get('-'));
    SetShiftState(s,  73, d.Get('/'));
    SetShiftState(s,  74, d.Get('^'));
    SetShiftState(s,  76, d.Get('['));
    SetShiftState(s,  78, d.Get('&'));

    // reduce rule 6: Expr ==> Expr % Expr 
    SetReduceRule(s,   6, d.Get(')'));
}

static void InitState_161(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 241, d.Get(']'));
}

static void InitState_162(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  74, d.Get('^'));
    SetShiftState(s,  76, d.Get('['));

    // reduce rule 7: Expr ==> Expr & Expr 
    SetReduceRule(s,   7, d.Get('+'));
    SetReduceRule(s,   7, d.Get('*'));
    SetReduceRule(s,   7, d.Get('-'));
    SetReduceRule(s,   7, d.Get('/'));
    SetReduceRule(s,   7, d.Get('%'));
    SetReduceRule(s,   7, d.Get(')'));
}

static void InitState_163(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 176, d.Get('['));

    // reduce rule 9: Expr ==> - Expr 
    SetReduceRule(s,   9, d.Get('+'));
    SetReduceRule(s,   9, d.Get('*'));
    SetReduceRule(s,   9, d.Get('-'));
    SetReduceRule(s,   9, d.Get('/'));
    SetReduceRule(s,   9, d.Get('^'));
    SetReduceRule(s,   9, d.Get('%'));
    SetReduceRule(s,   9, d.Get(']'));
    SetReduceRule(s,   9, d.Get(','));
    SetReduceRule(s,   9, d.Get(':'));
    SetReduceRule(s,   9, d.Get('&'));
}

static void InitState_164(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  70, d.Get('+'));
    SetShiftState(s,  71, d.Get('*'));
    SetShiftState(s,  72, d.Get('-'));
    SetShiftState(s,  73, d.Get('/'));
    SetShiftState(s,  74, d.Get('^'));
    SetShiftState(s,  75, d.Get('%'));
    SetShiftState(s,  76, d.Get('['));
    SetShiftState(s, 242, d.Get(')'));
    SetShiftState(s,  78, d.Get('&'));
}

static void InitState_165(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  32, d.Get('/'));
    SetShiftState(s,  33, d.Get('\\'));
    SetShiftState(s,  34, d.Get('['));
    SetShiftState(s, 243, d.Get('>'));
    SetShiftState(s,  98, d.Get('@'));
    SetShiftState(s,  99, d.Get("MultiSlash"));
    SetShiftState(s, 100, d.Get("MachSpec"));
    SetShiftState(s, 101, d.Get("TimeSpec"));

    // reduce rule 46: DBSpec ==> PathSpec 
    SetReduceRule(s,  46, d.Get(':'));
}

static void InitState_166(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 244, d.Get(':'));
}

static void InitState_167(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 112, d.Get('+'));
    SetShiftState(s, 113, d.Get('*'));
    SetShiftState(s, 114, d.Get('-'));
    SetShiftState(s, 115, d.Get('/'));
    SetShiftState(s, 116, d.Get('^'));
    SetShiftState(s, 117, d.Get('%'));
    SetShiftState(s, 118, d.Get('['));
    SetShiftState(s, 245, d.Get(','));
    SetShiftState(s, 120, d.Get('&'));
}

static void InitState_168(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 246, d.Get(']'));
    SetShiftState(s, 180, d.Get(','));
}

static void InitState_169(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 121, d.Get('-'));
    SetShiftState(s, 122, d.Get('['));
    SetShiftState(s, 123, d.Get('('));
    SetShiftState(s, 247, d.Get(')'));
    SetShiftState(s, 125, d.Get('<'));
    SetShiftState(s, 126, d.Get('{'));
    SetShiftState(s, 127, d.Get(257));
    SetShiftState(s, 128, d.Get(258));
    SetShiftState(s, 129, d.Get(259));
    SetShiftState(s, 130, d.Get(260));
    SetShiftState(s, 131, d.Get(261));
    SetShiftState(s, 132, d.Get("Expr"));
    SetShiftState(s, 133, d.Get("Constant"));
    SetShiftState(s, 134, d.Get("Vector"));
    SetShiftState(s, 135, d.Get("List"));
    SetShiftState(s, 136, d.Get("Function"));
    SetShiftState(s, 248, d.Get("Args"));
    SetShiftState(s, 138, d.Get("Arg"));
    SetShiftState(s, 139, d.Get("Variable"));
    SetShiftState(s, 140, d.Get("Database"));
}

static void InitState_170(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  79, d.Get('-'));
    SetShiftState(s,  80, d.Get('('));
    SetShiftState(s,  81, d.Get('<'));
    SetShiftState(s,  82, d.Get('{'));
    SetShiftState(s,  84, d.Get(257));
    SetShiftState(s,  85, d.Get(258));
    SetShiftState(s,  86, d.Get(259));
    SetShiftState(s,  87, d.Get(260));
    SetShiftState(s,  88, d.Get(261));
    SetShiftState(s, 249, d.Get("Expr"));
    SetShiftState(s,  90, d.Get("Constant"));
    SetShiftState(s,  91, d.Get("Vector"));
    SetShiftState(s,  94, d.Get("Function"));
    SetShiftState(s,  95, d.Get("Variable"));
    SetShiftState(s,  96, d.Get("Database"));
}

static void InitState_171(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  79, d.Get('-'));
    SetShiftState(s,  80, d.Get('('));
    SetShiftState(s,  81, d.Get('<'));
    SetShiftState(s,  82, d.Get('{'));
    SetShiftState(s,  84, d.Get(257));
    SetShiftState(s,  85, d.Get(258));
    SetShiftState(s,  86, d.Get(259));
    SetShiftState(s,  87, d.Get(260));
    SetShiftState(s,  88, d.Get(261));
    SetShiftState(s, 250, d.Get("Expr"));
    SetShiftState(s,  90, d.Get("Constant"));
    SetShiftState(s,  91, d.Get("Vector"));
    SetShiftState(s,  94, d.Get("Function"));
    SetShiftState(s,  95, d.Get("Variable"));
    SetShiftState(s,  96, d.Get("Database"));
}

static void InitState_172(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  79, d.Get('-'));
    SetShiftState(s,  80, d.Get('('));
    SetShiftState(s,  81, d.Get('<'));
    SetShiftState(s,  82, d.Get('{'));
    SetShiftState(s,  84, d.Get(257));
    SetShiftState(s,  85, d.Get(258));
    SetShiftState(s,  86, d.Get(259));
    SetShiftState(s,  87, d.Get(260));
    SetShiftState(s,  88, d.Get(261));
    SetShiftState(s, 251, d.Get("Expr"));
    SetShiftState(s,  90, d.Get("Constant"));
    SetShiftState(s,  91, d.Get("Vector"));
    SetShiftState(s,  94, d.Get("Function"));
    SetShiftState(s,  95, d.Get("Variable"));
    SetShiftState(s,  96, d.Get("Database"));
}

static void InitState_173(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  79, d.Get('-'));
    SetShiftState(s,  80, d.Get('('));
    SetShiftState(s,  81, d.Get('<'));
    SetShiftState(s,  82, d.Get('{'));
    SetShiftState(s,  84, d.Get(257));
    SetShiftState(s,  85, d.Get(258));
    SetShiftState(s,  86, d.Get(259));
    SetShiftState(s,  87, d.Get(260));
    SetShiftState(s,  88, d.Get(261));
    SetShiftState(s, 252, d.Get("Expr"));
    SetShiftState(s,  90, d.Get("Constant"));
    SetShiftState(s,  91, d.Get("Vector"));
    SetShiftState(s,  94, d.Get("Function"));
    SetShiftState(s,  95, d.Get("Variable"));
    SetShiftState(s,  96, d.Get("Database"));
}

static void InitState_174(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  79, d.Get('-'));
    SetShiftState(s,  80, d.Get('('));
    SetShiftState(s,  81, d.Get('<'));
    SetShiftState(s,  82, d.Get('{'));
    SetShiftState(s,  84, d.Get(257));
    SetShiftState(s,  85, d.Get(258));
    SetShiftState(s,  86, d.Get(259));
    SetShiftState(s,  87, d.Get(260));
    SetShiftState(s,  88, d.Get(261));
    SetShiftState(s, 253, d.Get("Expr"));
    SetShiftState(s,  90, d.Get("Constant"));
    SetShiftState(s,  91, d.Get("Vector"));
    SetShiftState(s,  94, d.Get("Function"));
    SetShiftState(s,  95, d.Get("Variable"));
    SetShiftState(s,  96, d.Get("Database"));
}

static void InitState_175(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  79, d.Get('-'));
    SetShiftState(s,  80, d.Get('('));
    SetShiftState(s,  81, d.Get('<'));
    SetShiftState(s,  82, d.Get('{'));
    SetShiftState(s,  84, d.Get(257));
    SetShiftState(s,  85, d.Get(258));
    SetShiftState(s,  86, d.Get(259));
    SetShiftState(s,  87, d.Get(260));
    SetShiftState(s,  88, d.Get(261));
    SetShiftState(s, 254, d.Get("Expr"));
    SetShiftState(s,  90, d.Get("Constant"));
    SetShiftState(s,  91, d.Get("Vector"));
    SetShiftState(s,  94, d.Get("Function"));
    SetShiftState(s,  95, d.Get("Variable"));
    SetShiftState(s,  96, d.Get("Database"));
}

static void InitState_176(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 255, d.Get(258));
}

static void InitState_177(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  79, d.Get('-'));
    SetShiftState(s,  80, d.Get('('));
    SetShiftState(s,  81, d.Get('<'));
    SetShiftState(s,  82, d.Get('{'));
    SetShiftState(s,  84, d.Get(257));
    SetShiftState(s,  85, d.Get(258));
    SetShiftState(s,  86, d.Get(259));
    SetShiftState(s,  87, d.Get(260));
    SetShiftState(s,  88, d.Get(261));
    SetShiftState(s, 256, d.Get("Expr"));
    SetShiftState(s,  90, d.Get("Constant"));
    SetShiftState(s,  91, d.Get("Vector"));
    SetShiftState(s,  94, d.Get("Function"));
    SetShiftState(s,  95, d.Get("Variable"));
    SetShiftState(s,  96, d.Get("Database"));
}

static void InitState_178(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  79, d.Get('-'));
    SetShiftState(s,  80, d.Get('('));
    SetShiftState(s,  81, d.Get('<'));
    SetShiftState(s,  82, d.Get('{'));
    SetShiftState(s,  84, d.Get(257));
    SetShiftState(s,  85, d.Get(258));
    SetShiftState(s,  86, d.Get(259));
    SetShiftState(s,  87, d.Get(260));
    SetShiftState(s,  88, d.Get(261));
    SetShiftState(s, 257, d.Get("Expr"));
    SetShiftState(s,  90, d.Get("Constant"));
    SetShiftState(s,  91, d.Get("Vector"));
    SetShiftState(s,  94, d.Get("Function"));
    SetShiftState(s,  95, d.Get("Variable"));
    SetShiftState(s,  96, d.Get("Database"));
}

static void InitState_179(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 258, d.Get(257));

    // reduce rule 53: TimeSpec ==> [ ListElems ] 
    SetReduceRule(s,  53, d.Get(':'));
}

static void InitState_180(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  79, d.Get('-'));
    SetShiftState(s,  80, d.Get('('));
    SetShiftState(s,  81, d.Get('<'));
    SetShiftState(s,  82, d.Get('{'));
    SetShiftState(s,  84, d.Get(257));
    SetShiftState(s,  85, d.Get(258));
    SetShiftState(s,  86, d.Get(259));
    SetShiftState(s,  87, d.Get(260));
    SetShiftState(s,  88, d.Get(261));
    SetShiftState(s,  89, d.Get("Expr"));
    SetShiftState(s,  90, d.Get("Constant"));
    SetShiftState(s,  91, d.Get("Vector"));
    SetShiftState(s, 259, d.Get("ListElem"));
    SetShiftState(s,  94, d.Get("Function"));
    SetShiftState(s,  95, d.Get("Variable"));
    SetShiftState(s,  96, d.Get("Database"));
}

static void InitState_181(Dictionary &d, State &s)
{
    // reduce rule 51: MachSpec ==> @ Identifier 
    SetReduceRule(s,  51, d.Get('['));
    SetReduceRule(s,  51, d.Get(':'));
}

static void InitState_182(Dictionary &d, State &s)
{
    // reduce rule 35: PathSpec ==> PathSpec MultiSlash Identifier 
    SetReduceRule(s,  35, d.Get('/'));
    SetReduceRule(s,  35, d.Get('\\'));
    SetReduceRule(s,  35, d.Get('['));
    SetReduceRule(s,  35, d.Get('>'));
    SetReduceRule(s,  35, d.Get('@'));
    SetReduceRule(s,  35, d.Get(':'));
}

static void InitState_183(Dictionary &d, State &s)
{
    // reduce rule 50: DBSpec ==> PathSpec MachSpec TimeSpec 
    SetReduceRule(s,  50, d.Get(':'));
}

static void InitState_184(Dictionary &d, State &s)
{
    // reduce rule 45: Database ==> < DBSpec : > 
    SetReduceRule(s,  45, d.Get(256));
    SetReduceRule(s,  45, d.Get('+'));
    SetReduceRule(s,  45, d.Get('*'));
    SetReduceRule(s,  45, d.Get('-'));
    SetReduceRule(s,  45, d.Get('/'));
    SetReduceRule(s,  45, d.Get('^'));
    SetReduceRule(s,  45, d.Get('%'));
    SetReduceRule(s,  45, d.Get('['));
    SetReduceRule(s,  45, d.Get('&'));
}

static void InitState_185(Dictionary &d, State &s)
{
    // reduce rule 37: PathSpec ==> Identifier 
    SetReduceRule(s,  37, d.Get('/'));
    SetReduceRule(s,  37, d.Get('\\'));
    SetReduceRule(s,  37, d.Get('>'));
}

static void InitState_186(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  32, d.Get('/'));
    SetShiftState(s,  33, d.Get('\\'));
    SetShiftState(s, 260, d.Get('>'));
    SetShiftState(s, 261, d.Get("MultiSlash"));
}

static void InitState_187(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 102, d.Get('/'));
    SetShiftState(s, 103, d.Get('\\'));
    SetShiftState(s, 262, d.Get(257));
}

static void InitState_188(Dictionary &d, State &s)
{
    // reduce rule 10: Expr ==> ( Expr ) 
    SetReduceRule(s,  10, d.Get('+'));
    SetReduceRule(s,  10, d.Get('*'));
    SetReduceRule(s,  10, d.Get('-'));
    SetReduceRule(s,  10, d.Get('/'));
    SetReduceRule(s,  10, d.Get('^'));
    SetReduceRule(s,  10, d.Get('%'));
    SetReduceRule(s,  10, d.Get('['));
    SetReduceRule(s,  10, d.Get(','));
    SetReduceRule(s,  10, d.Get('&'));
}

static void InitState_189(Dictionary &d, State &s)
{
    // reduce rule 43: Variable ==> < PathSpec > 
    SetReduceRule(s,  43, d.Get('+'));
    SetReduceRule(s,  43, d.Get('*'));
    SetReduceRule(s,  43, d.Get('-'));
    SetReduceRule(s,  43, d.Get('/'));
    SetReduceRule(s,  43, d.Get('^'));
    SetReduceRule(s,  43, d.Get('%'));
    SetReduceRule(s,  43, d.Get('['));
    SetReduceRule(s,  43, d.Get(','));
    SetReduceRule(s,  43, d.Get('&'));
}

static void InitState_190(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  32, d.Get('/'));
    SetShiftState(s,  33, d.Get('\\'));
    SetShiftState(s, 263, d.Get('>'));
    SetShiftState(s, 185, d.Get(257));
    SetShiftState(s, 264, d.Get("PathSpec"));
    SetShiftState(s, 187, d.Get("MultiSlash"));
}

static void InitState_191(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 201, d.Get('-'));
    SetShiftState(s, 202, d.Get('('));
    SetShiftState(s, 203, d.Get('<'));
    SetShiftState(s, 204, d.Get('{'));
    SetShiftState(s, 205, d.Get(257));
    SetShiftState(s, 206, d.Get(258));
    SetShiftState(s, 207, d.Get(259));
    SetShiftState(s, 208, d.Get(260));
    SetShiftState(s, 209, d.Get(261));
    SetShiftState(s, 265, d.Get("Expr"));
    SetShiftState(s, 211, d.Get("Constant"));
    SetShiftState(s, 212, d.Get("Vector"));
    SetShiftState(s, 213, d.Get("Function"));
    SetShiftState(s, 214, d.Get("Variable"));
    SetShiftState(s, 215, d.Get("Database"));
}

static void InitState_192(Dictionary &d, State &s)
{
    // reduce rule 28: Function ==> Identifier ( ) 
    SetReduceRule(s,  28, d.Get('+'));
    SetReduceRule(s,  28, d.Get('*'));
    SetReduceRule(s,  28, d.Get('-'));
    SetReduceRule(s,  28, d.Get('/'));
    SetReduceRule(s,  28, d.Get('^'));
    SetReduceRule(s,  28, d.Get('%'));
    SetReduceRule(s,  28, d.Get('['));
    SetReduceRule(s,  28, d.Get(','));
    SetReduceRule(s,  28, d.Get('&'));
}

static void InitState_193(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 266, d.Get(')'));
    SetShiftState(s, 235, d.Get(','));
}

static void InitState_194(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 113, d.Get('*'));
    SetShiftState(s, 115, d.Get('/'));
    SetShiftState(s, 116, d.Get('^'));
    SetShiftState(s, 118, d.Get('['));
    SetShiftState(s, 120, d.Get('&'));

    // reduce rule 1: Expr ==> Expr + Expr 
    SetReduceRule(s,   1, d.Get('+'));
    SetReduceRule(s,   1, d.Get('-'));
    SetReduceRule(s,   1, d.Get('%'));
    SetReduceRule(s,   1, d.Get(','));
}

static void InitState_195(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 116, d.Get('^'));
    SetShiftState(s, 118, d.Get('['));
    SetShiftState(s, 120, d.Get('&'));

    // reduce rule 3: Expr ==> Expr * Expr 
    SetReduceRule(s,   3, d.Get('+'));
    SetReduceRule(s,   3, d.Get('*'));
    SetReduceRule(s,   3, d.Get('-'));
    SetReduceRule(s,   3, d.Get('/'));
    SetReduceRule(s,   3, d.Get('%'));
    SetReduceRule(s,   3, d.Get(','));
}

static void InitState_196(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 113, d.Get('*'));
    SetShiftState(s, 115, d.Get('/'));
    SetShiftState(s, 116, d.Get('^'));
    SetShiftState(s, 118, d.Get('['));
    SetShiftState(s, 120, d.Get('&'));

    // reduce rule 2: Expr ==> Expr - Expr 
    SetReduceRule(s,   2, d.Get('+'));
    SetReduceRule(s,   2, d.Get('-'));
    SetReduceRule(s,   2, d.Get('%'));
    SetReduceRule(s,   2, d.Get(','));
}

static void InitState_197(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 116, d.Get('^'));
    SetShiftState(s, 118, d.Get('['));
    SetShiftState(s, 120, d.Get('&'));

    // reduce rule 4: Expr ==> Expr / Expr 
    SetReduceRule(s,   4, d.Get('+'));
    SetReduceRule(s,   4, d.Get('*'));
    SetReduceRule(s,   4, d.Get('-'));
    SetReduceRule(s,   4, d.Get('/'));
    SetReduceRule(s,   4, d.Get('%'));
    SetReduceRule(s,   4, d.Get(','));
}

static void InitState_198(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 116, d.Get('^'));
    SetShiftState(s, 118, d.Get('['));

    // reduce rule 5: Expr ==> Expr ^ Expr 
    SetReduceRule(s,   5, d.Get('+'));
    SetReduceRule(s,   5, d.Get('*'));
    SetReduceRule(s,   5, d.Get('-'));
    SetReduceRule(s,   5, d.Get('/'));
    SetReduceRule(s,   5, d.Get('%'));
    SetReduceRule(s,   5, d.Get(','));
}

static void InitState_199(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 112, d.Get('+'));
    SetShiftState(s, 113, d.Get('*'));
    SetShiftState(s, 114, d.Get('-'));
    SetShiftState(s, 115, d.Get('/'));
    SetShiftState(s, 116, d.Get('^'));
    SetShiftState(s, 118, d.Get('['));
    SetShiftState(s, 120, d.Get('&'));

    // reduce rule 6: Expr ==> Expr % Expr 
    SetReduceRule(s,   6, d.Get(','));
}

static void InitState_200(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 267, d.Get(']'));
}

static void InitState_201(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 201, d.Get('-'));
    SetShiftState(s, 202, d.Get('('));
    SetShiftState(s, 203, d.Get('<'));
    SetShiftState(s, 204, d.Get('{'));
    SetShiftState(s, 205, d.Get(257));
    SetShiftState(s, 206, d.Get(258));
    SetShiftState(s, 207, d.Get(259));
    SetShiftState(s, 208, d.Get(260));
    SetShiftState(s, 209, d.Get(261));
    SetShiftState(s, 268, d.Get("Expr"));
    SetShiftState(s, 211, d.Get("Constant"));
    SetShiftState(s, 212, d.Get("Vector"));
    SetShiftState(s, 213, d.Get("Function"));
    SetShiftState(s, 214, d.Get("Variable"));
    SetShiftState(s, 215, d.Get("Database"));
}

static void InitState_202(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  17, d.Get('-'));
    SetShiftState(s,  18, d.Get('('));
    SetShiftState(s,  19, d.Get('<'));
    SetShiftState(s,  20, d.Get('{'));
    SetShiftState(s,  21, d.Get(257));
    SetShiftState(s,  22, d.Get(258));
    SetShiftState(s,  23, d.Get(259));
    SetShiftState(s,  24, d.Get(260));
    SetShiftState(s,  25, d.Get(261));
    SetShiftState(s, 269, d.Get("Expr"));
    SetShiftState(s,  27, d.Get("Constant"));
    SetShiftState(s,  28, d.Get("Vector"));
    SetShiftState(s,  29, d.Get("Function"));
    SetShiftState(s,  30, d.Get("Variable"));
    SetShiftState(s,  31, d.Get("Database"));
}

static void InitState_203(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  32, d.Get('/'));
    SetShiftState(s,  33, d.Get('\\'));
    SetShiftState(s,  34, d.Get('['));
    SetShiftState(s,  35, d.Get(257));
    SetShiftState(s, 270, d.Get("PathSpec"));
    SetShiftState(s,  37, d.Get("MultiSlash"));
    SetShiftState(s, 271, d.Get("DBSpec"));
    SetShiftState(s,  39, d.Get("TimeSpec"));
}

static void InitState_204(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  40, d.Get('-'));
    SetShiftState(s,  41, d.Get('('));
    SetShiftState(s,  42, d.Get('<'));
    SetShiftState(s,  43, d.Get('{'));
    SetShiftState(s,  44, d.Get(257));
    SetShiftState(s,  45, d.Get(258));
    SetShiftState(s,  46, d.Get(259));
    SetShiftState(s,  47, d.Get(260));
    SetShiftState(s,  48, d.Get(261));
    SetShiftState(s, 272, d.Get("Expr"));
    SetShiftState(s,  50, d.Get("Constant"));
    SetShiftState(s,  51, d.Get("Vector"));
    SetShiftState(s,  52, d.Get("Function"));
    SetShiftState(s,  53, d.Get("Variable"));
    SetShiftState(s,  54, d.Get("Database"));
}

static void InitState_205(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 273, d.Get('('));

    // reduce rule 42: Variable ==> Identifier 
    SetReduceRule(s,  42, d.Get('+'));
    SetReduceRule(s,  42, d.Get('*'));
    SetReduceRule(s,  42, d.Get('-'));
    SetReduceRule(s,  42, d.Get('/'));
    SetReduceRule(s,  42, d.Get('^'));
    SetReduceRule(s,  42, d.Get('%'));
    SetReduceRule(s,  42, d.Get('['));
    SetReduceRule(s,  42, d.Get('}'));
    SetReduceRule(s,  42, d.Get(','));
    SetReduceRule(s,  42, d.Get('&'));
}

static void InitState_206(Dictionary &d, State &s)
{
    // reduce rule 16: Constant ==> Integer 
    SetReduceRule(s,  16, d.Get('+'));
    SetReduceRule(s,  16, d.Get('*'));
    SetReduceRule(s,  16, d.Get('-'));
    SetReduceRule(s,  16, d.Get('/'));
    SetReduceRule(s,  16, d.Get('^'));
    SetReduceRule(s,  16, d.Get('%'));
    SetReduceRule(s,  16, d.Get('['));
    SetReduceRule(s,  16, d.Get('}'));
    SetReduceRule(s,  16, d.Get(','));
    SetReduceRule(s,  16, d.Get('&'));
}

static void InitState_207(Dictionary &d, State &s)
{
    // reduce rule 17: Constant ==> Float 
    SetReduceRule(s,  17, d.Get('+'));
    SetReduceRule(s,  17, d.Get('*'));
    SetReduceRule(s,  17, d.Get('-'));
    SetReduceRule(s,  17, d.Get('/'));
    SetReduceRule(s,  17, d.Get('^'));
    SetReduceRule(s,  17, d.Get('%'));
    SetReduceRule(s,  17, d.Get('['));
    SetReduceRule(s,  17, d.Get('}'));
    SetReduceRule(s,  17, d.Get(','));
    SetReduceRule(s,  17, d.Get('&'));
}

static void InitState_208(Dictionary &d, State &s)
{
    // reduce rule 18: Constant ==> String 
    SetReduceRule(s,  18, d.Get('+'));
    SetReduceRule(s,  18, d.Get('*'));
    SetReduceRule(s,  18, d.Get('-'));
    SetReduceRule(s,  18, d.Get('/'));
    SetReduceRule(s,  18, d.Get('^'));
    SetReduceRule(s,  18, d.Get('%'));
    SetReduceRule(s,  18, d.Get('['));
    SetReduceRule(s,  18, d.Get('}'));
    SetReduceRule(s,  18, d.Get(','));
    SetReduceRule(s,  18, d.Get('&'));
}

static void InitState_209(Dictionary &d, State &s)
{
    // reduce rule 19: Constant ==> Bool 
    SetReduceRule(s,  19, d.Get('+'));
    SetReduceRule(s,  19, d.Get('*'));
    SetReduceRule(s,  19, d.Get('-'));
    SetReduceRule(s,  19, d.Get('/'));
    SetReduceRule(s,  19, d.Get('^'));
    SetReduceRule(s,  19, d.Get('%'));
    SetReduceRule(s,  19, d.Get('['));
    SetReduceRule(s,  19, d.Get('}'));
    SetReduceRule(s,  19, d.Get(','));
    SetReduceRule(s,  19, d.Get('&'));
}

static void InitState_210(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 274, d.Get('+'));
    SetShiftState(s, 275, d.Get('*'));
    SetShiftState(s, 276, d.Get('-'));
    SetShiftState(s, 277, d.Get('/'));
    SetShiftState(s, 278, d.Get('^'));
    SetShiftState(s, 279, d.Get('%'));
    SetShiftState(s, 280, d.Get('['));
    SetShiftState(s, 281, d.Get('}'));
    SetShiftState(s, 282, d.Get(','));
    SetShiftState(s, 283, d.Get('&'));
}

static void InitState_211(Dictionary &d, State &s)
{
    // reduce rule 11: Expr ==> Constant 
    SetReduceRule(s,  11, d.Get('+'));
    SetReduceRule(s,  11, d.Get('*'));
    SetReduceRule(s,  11, d.Get('-'));
    SetReduceRule(s,  11, d.Get('/'));
    SetReduceRule(s,  11, d.Get('^'));
    SetReduceRule(s,  11, d.Get('%'));
    SetReduceRule(s,  11, d.Get('['));
    SetReduceRule(s,  11, d.Get('}'));
    SetReduceRule(s,  11, d.Get(','));
    SetReduceRule(s,  11, d.Get('&'));
}

static void InitState_212(Dictionary &d, State &s)
{
    // reduce rule 12: Expr ==> Vector 
    SetReduceRule(s,  12, d.Get('+'));
    SetReduceRule(s,  12, d.Get('*'));
    SetReduceRule(s,  12, d.Get('-'));
    SetReduceRule(s,  12, d.Get('/'));
    SetReduceRule(s,  12, d.Get('^'));
    SetReduceRule(s,  12, d.Get('%'));
    SetReduceRule(s,  12, d.Get('['));
    SetReduceRule(s,  12, d.Get('}'));
    SetReduceRule(s,  12, d.Get(','));
    SetReduceRule(s,  12, d.Get('&'));
}

static void InitState_213(Dictionary &d, State &s)
{
    // reduce rule 13: Expr ==> Function 
    SetReduceRule(s,  13, d.Get('+'));
    SetReduceRule(s,  13, d.Get('*'));
    SetReduceRule(s,  13, d.Get('-'));
    SetReduceRule(s,  13, d.Get('/'));
    SetReduceRule(s,  13, d.Get('^'));
    SetReduceRule(s,  13, d.Get('%'));
    SetReduceRule(s,  13, d.Get('['));
    SetReduceRule(s,  13, d.Get('}'));
    SetReduceRule(s,  13, d.Get(','));
    SetReduceRule(s,  13, d.Get('&'));
}

static void InitState_214(Dictionary &d, State &s)
{
    // reduce rule 14: Expr ==> Variable 
    SetReduceRule(s,  14, d.Get('+'));
    SetReduceRule(s,  14, d.Get('*'));
    SetReduceRule(s,  14, d.Get('-'));
    SetReduceRule(s,  14, d.Get('/'));
    SetReduceRule(s,  14, d.Get('^'));
    SetReduceRule(s,  14, d.Get('%'));
    SetReduceRule(s,  14, d.Get('['));
    SetReduceRule(s,  14, d.Get('}'));
    SetReduceRule(s,  14, d.Get(','));
    SetReduceRule(s,  14, d.Get('&'));
}

static void InitState_215(Dictionary &d, State &s)
{
    // reduce rule 15: Expr ==> Database 
    SetReduceRule(s,  15, d.Get('+'));
    SetReduceRule(s,  15, d.Get('*'));
    SetReduceRule(s,  15, d.Get('-'));
    SetReduceRule(s,  15, d.Get('/'));
    SetReduceRule(s,  15, d.Get('^'));
    SetReduceRule(s,  15, d.Get('%'));
    SetReduceRule(s,  15, d.Get('['));
    SetReduceRule(s,  15, d.Get('}'));
    SetReduceRule(s,  15, d.Get(','));
    SetReduceRule(s,  15, d.Get('&'));
}

static void InitState_216(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 116, d.Get('^'));
    SetShiftState(s, 118, d.Get('['));

    // reduce rule 7: Expr ==> Expr & Expr 
    SetReduceRule(s,   7, d.Get('+'));
    SetReduceRule(s,   7, d.Get('*'));
    SetReduceRule(s,   7, d.Get('-'));
    SetReduceRule(s,   7, d.Get('/'));
    SetReduceRule(s,   7, d.Get('%'));
    SetReduceRule(s,   7, d.Get(','));
}

static void InitState_217(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 224, d.Get('('));

    // reduce rule 42: Variable ==> Identifier 
    SetReduceRule(s,  42, d.Get('+'));
    SetReduceRule(s,  42, d.Get('*'));
    SetReduceRule(s,  42, d.Get('-'));
    SetReduceRule(s,  42, d.Get('/'));
    SetReduceRule(s,  42, d.Get('^'));
    SetReduceRule(s,  42, d.Get('%'));
    SetReduceRule(s,  42, d.Get('['));
    SetReduceRule(s,  42, d.Get(')'));
    SetReduceRule(s,  42, d.Get(','));
    SetReduceRule(s,  42, d.Get('&'));
}

static void InitState_218(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 232, d.Get('['));

    // reduce rule 9: Expr ==> - Expr 
    SetReduceRule(s,   9, d.Get('+'));
    SetReduceRule(s,   9, d.Get('*'));
    SetReduceRule(s,   9, d.Get('-'));
    SetReduceRule(s,   9, d.Get('/'));
    SetReduceRule(s,   9, d.Get('^'));
    SetReduceRule(s,   9, d.Get('%'));
    SetReduceRule(s,   9, d.Get(')'));
    SetReduceRule(s,   9, d.Get(','));
    SetReduceRule(s,   9, d.Get('&'));
}

static void InitState_219(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 284, d.Get(']'));
    SetShiftState(s, 180, d.Get(','));
}

static void InitState_220(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  70, d.Get('+'));
    SetShiftState(s,  71, d.Get('*'));
    SetShiftState(s,  72, d.Get('-'));
    SetShiftState(s,  73, d.Get('/'));
    SetShiftState(s,  74, d.Get('^'));
    SetShiftState(s,  75, d.Get('%'));
    SetShiftState(s,  76, d.Get('['));
    SetShiftState(s, 285, d.Get(')'));
    SetShiftState(s,  78, d.Get('&'));
}

static void InitState_221(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  32, d.Get('/'));
    SetShiftState(s,  33, d.Get('\\'));
    SetShiftState(s,  34, d.Get('['));
    SetShiftState(s, 286, d.Get('>'));
    SetShiftState(s,  98, d.Get('@'));
    SetShiftState(s,  99, d.Get("MultiSlash"));
    SetShiftState(s, 100, d.Get("MachSpec"));
    SetShiftState(s, 101, d.Get("TimeSpec"));

    // reduce rule 46: DBSpec ==> PathSpec 
    SetReduceRule(s,  46, d.Get(':'));
}

static void InitState_222(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 287, d.Get(':'));
}

static void InitState_223(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 112, d.Get('+'));
    SetShiftState(s, 113, d.Get('*'));
    SetShiftState(s, 114, d.Get('-'));
    SetShiftState(s, 115, d.Get('/'));
    SetShiftState(s, 116, d.Get('^'));
    SetShiftState(s, 117, d.Get('%'));
    SetShiftState(s, 118, d.Get('['));
    SetShiftState(s, 288, d.Get(','));
    SetShiftState(s, 120, d.Get('&'));
}

static void InitState_224(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 121, d.Get('-'));
    SetShiftState(s, 122, d.Get('['));
    SetShiftState(s, 123, d.Get('('));
    SetShiftState(s, 289, d.Get(')'));
    SetShiftState(s, 125, d.Get('<'));
    SetShiftState(s, 126, d.Get('{'));
    SetShiftState(s, 127, d.Get(257));
    SetShiftState(s, 128, d.Get(258));
    SetShiftState(s, 129, d.Get(259));
    SetShiftState(s, 130, d.Get(260));
    SetShiftState(s, 131, d.Get(261));
    SetShiftState(s, 132, d.Get("Expr"));
    SetShiftState(s, 133, d.Get("Constant"));
    SetShiftState(s, 134, d.Get("Vector"));
    SetShiftState(s, 135, d.Get("List"));
    SetShiftState(s, 136, d.Get("Function"));
    SetShiftState(s, 290, d.Get("Args"));
    SetShiftState(s, 138, d.Get("Arg"));
    SetShiftState(s, 139, d.Get("Variable"));
    SetShiftState(s, 140, d.Get("Database"));
}

static void InitState_225(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 121, d.Get('-'));
    SetShiftState(s, 123, d.Get('('));
    SetShiftState(s, 125, d.Get('<'));
    SetShiftState(s, 126, d.Get('{'));
    SetShiftState(s, 217, d.Get(257));
    SetShiftState(s, 128, d.Get(258));
    SetShiftState(s, 129, d.Get(259));
    SetShiftState(s, 130, d.Get(260));
    SetShiftState(s, 131, d.Get(261));
    SetShiftState(s, 291, d.Get("Expr"));
    SetShiftState(s, 133, d.Get("Constant"));
    SetShiftState(s, 134, d.Get("Vector"));
    SetShiftState(s, 136, d.Get("Function"));
    SetShiftState(s, 139, d.Get("Variable"));
    SetShiftState(s, 140, d.Get("Database"));
}

static void InitState_226(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 121, d.Get('-'));
    SetShiftState(s, 123, d.Get('('));
    SetShiftState(s, 125, d.Get('<'));
    SetShiftState(s, 126, d.Get('{'));
    SetShiftState(s, 217, d.Get(257));
    SetShiftState(s, 128, d.Get(258));
    SetShiftState(s, 129, d.Get(259));
    SetShiftState(s, 130, d.Get(260));
    SetShiftState(s, 131, d.Get(261));
    SetShiftState(s, 292, d.Get("Expr"));
    SetShiftState(s, 133, d.Get("Constant"));
    SetShiftState(s, 134, d.Get("Vector"));
    SetShiftState(s, 136, d.Get("Function"));
    SetShiftState(s, 139, d.Get("Variable"));
    SetShiftState(s, 140, d.Get("Database"));
}

static void InitState_227(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 121, d.Get('-'));
    SetShiftState(s, 123, d.Get('('));
    SetShiftState(s, 125, d.Get('<'));
    SetShiftState(s, 126, d.Get('{'));
    SetShiftState(s, 217, d.Get(257));
    SetShiftState(s, 128, d.Get(258));
    SetShiftState(s, 129, d.Get(259));
    SetShiftState(s, 130, d.Get(260));
    SetShiftState(s, 131, d.Get(261));
    SetShiftState(s, 293, d.Get("Expr"));
    SetShiftState(s, 133, d.Get("Constant"));
    SetShiftState(s, 134, d.Get("Vector"));
    SetShiftState(s, 136, d.Get("Function"));
    SetShiftState(s, 139, d.Get("Variable"));
    SetShiftState(s, 140, d.Get("Database"));
}

static void InitState_228(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 121, d.Get('-'));
    SetShiftState(s, 123, d.Get('('));
    SetShiftState(s, 125, d.Get('<'));
    SetShiftState(s, 126, d.Get('{'));
    SetShiftState(s, 217, d.Get(257));
    SetShiftState(s, 128, d.Get(258));
    SetShiftState(s, 129, d.Get(259));
    SetShiftState(s, 130, d.Get(260));
    SetShiftState(s, 131, d.Get(261));
    SetShiftState(s, 294, d.Get("Expr"));
    SetShiftState(s, 133, d.Get("Constant"));
    SetShiftState(s, 134, d.Get("Vector"));
    SetShiftState(s, 136, d.Get("Function"));
    SetShiftState(s, 139, d.Get("Variable"));
    SetShiftState(s, 140, d.Get("Database"));
}

static void InitState_229(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 121, d.Get('-'));
    SetShiftState(s, 123, d.Get('('));
    SetShiftState(s, 125, d.Get('<'));
    SetShiftState(s, 126, d.Get('{'));
    SetShiftState(s, 217, d.Get(257));
    SetShiftState(s, 128, d.Get(258));
    SetShiftState(s, 129, d.Get(259));
    SetShiftState(s, 130, d.Get(260));
    SetShiftState(s, 131, d.Get(261));
    SetShiftState(s, 295, d.Get("Expr"));
    SetShiftState(s, 133, d.Get("Constant"));
    SetShiftState(s, 134, d.Get("Vector"));
    SetShiftState(s, 136, d.Get("Function"));
    SetShiftState(s, 139, d.Get("Variable"));
    SetShiftState(s, 140, d.Get("Database"));
}

static void InitState_230(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 121, d.Get('-'));
    SetShiftState(s, 123, d.Get('('));
    SetShiftState(s, 125, d.Get('<'));
    SetShiftState(s, 126, d.Get('{'));
    SetShiftState(s, 217, d.Get(257));
    SetShiftState(s, 128, d.Get(258));
    SetShiftState(s, 129, d.Get(259));
    SetShiftState(s, 130, d.Get(260));
    SetShiftState(s, 131, d.Get(261));
    SetShiftState(s, 296, d.Get("Expr"));
    SetShiftState(s, 133, d.Get("Constant"));
    SetShiftState(s, 134, d.Get("Vector"));
    SetShiftState(s, 136, d.Get("Function"));
    SetShiftState(s, 139, d.Get("Variable"));
    SetShiftState(s, 140, d.Get("Database"));
}

static void InitState_231(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 121, d.Get('-'));
    SetShiftState(s, 123, d.Get('('));
    SetShiftState(s, 125, d.Get('<'));
    SetShiftState(s, 126, d.Get('{'));
    SetShiftState(s, 217, d.Get(257));
    SetShiftState(s, 128, d.Get(258));
    SetShiftState(s, 129, d.Get(259));
    SetShiftState(s, 130, d.Get(260));
    SetShiftState(s, 131, d.Get(261));
    SetShiftState(s, 297, d.Get("Expr"));
    SetShiftState(s, 133, d.Get("Constant"));
    SetShiftState(s, 134, d.Get("Vector"));
    SetShiftState(s, 136, d.Get("Function"));
    SetShiftState(s, 139, d.Get("Variable"));
    SetShiftState(s, 140, d.Get("Database"));
}

static void InitState_232(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 298, d.Get(258));
}

static void InitState_233(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 121, d.Get('-'));
    SetShiftState(s, 123, d.Get('('));
    SetShiftState(s, 125, d.Get('<'));
    SetShiftState(s, 126, d.Get('{'));
    SetShiftState(s, 217, d.Get(257));
    SetShiftState(s, 128, d.Get(258));
    SetShiftState(s, 129, d.Get(259));
    SetShiftState(s, 130, d.Get(260));
    SetShiftState(s, 131, d.Get(261));
    SetShiftState(s, 299, d.Get("Expr"));
    SetShiftState(s, 133, d.Get("Constant"));
    SetShiftState(s, 134, d.Get("Vector"));
    SetShiftState(s, 136, d.Get("Function"));
    SetShiftState(s, 139, d.Get("Variable"));
    SetShiftState(s, 140, d.Get("Database"));
}

static void InitState_234(Dictionary &d, State &s)
{
    // reduce rule 29: Function ==> Identifier ( Args ) 
    SetReduceRule(s,  29, d.Get(256));
    SetReduceRule(s,  29, d.Get('+'));
    SetReduceRule(s,  29, d.Get('*'));
    SetReduceRule(s,  29, d.Get('-'));
    SetReduceRule(s,  29, d.Get('/'));
    SetReduceRule(s,  29, d.Get('^'));
    SetReduceRule(s,  29, d.Get('%'));
    SetReduceRule(s,  29, d.Get('['));
    SetReduceRule(s,  29, d.Get('&'));
}

static void InitState_235(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 121, d.Get('-'));
    SetShiftState(s, 122, d.Get('['));
    SetShiftState(s, 123, d.Get('('));
    SetShiftState(s, 125, d.Get('<'));
    SetShiftState(s, 126, d.Get('{'));
    SetShiftState(s, 127, d.Get(257));
    SetShiftState(s, 128, d.Get(258));
    SetShiftState(s, 129, d.Get(259));
    SetShiftState(s, 130, d.Get(260));
    SetShiftState(s, 131, d.Get(261));
    SetShiftState(s, 132, d.Get("Expr"));
    SetShiftState(s, 133, d.Get("Constant"));
    SetShiftState(s, 134, d.Get("Vector"));
    SetShiftState(s, 135, d.Get("List"));
    SetShiftState(s, 136, d.Get("Function"));
    SetShiftState(s, 300, d.Get("Arg"));
    SetShiftState(s, 139, d.Get("Variable"));
    SetShiftState(s, 140, d.Get("Database"));
}

static void InitState_236(Dictionary &d, State &s)
{
    // reduce rule 8: Expr ==> Expr [ Integer ] 
    SetReduceRule(s,   8, d.Get(256));
    SetReduceRule(s,   8, d.Get('+'));
    SetReduceRule(s,   8, d.Get('*'));
    SetReduceRule(s,   8, d.Get('-'));
    SetReduceRule(s,   8, d.Get('/'));
    SetReduceRule(s,   8, d.Get('^'));
    SetReduceRule(s,   8, d.Get('%'));
    SetReduceRule(s,   8, d.Get('['));
    SetReduceRule(s,   8, d.Get('&'));
}

static void InitState_237(Dictionary &d, State &s)
{
    // reduce rule 45: Database ==> < DBSpec : > 
    SetReduceRule(s,  45, d.Get('+'));
    SetReduceRule(s,  45, d.Get('*'));
    SetReduceRule(s,  45, d.Get('-'));
    SetReduceRule(s,  45, d.Get('/'));
    SetReduceRule(s,  45, d.Get('^'));
    SetReduceRule(s,  45, d.Get('%'));
    SetReduceRule(s,  45, d.Get('['));
    SetReduceRule(s,  45, d.Get(')'));
    SetReduceRule(s,  45, d.Get('&'));
}

static void InitState_238(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  32, d.Get('/'));
    SetShiftState(s,  33, d.Get('\\'));
    SetShiftState(s, 301, d.Get('>'));
    SetShiftState(s, 261, d.Get("MultiSlash"));
}

static void InitState_239(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 274, d.Get('+'));
    SetShiftState(s, 275, d.Get('*'));
    SetShiftState(s, 276, d.Get('-'));
    SetShiftState(s, 277, d.Get('/'));
    SetShiftState(s, 278, d.Get('^'));
    SetShiftState(s, 279, d.Get('%'));
    SetShiftState(s, 280, d.Get('['));
    SetShiftState(s, 302, d.Get('}'));
    SetShiftState(s, 303, d.Get(','));
    SetShiftState(s, 283, d.Get('&'));
}

static void InitState_240(Dictionary &d, State &s)
{
    // reduce rule 29: Function ==> Identifier ( Args ) 
    SetReduceRule(s,  29, d.Get('+'));
    SetReduceRule(s,  29, d.Get('*'));
    SetReduceRule(s,  29, d.Get('-'));
    SetReduceRule(s,  29, d.Get('/'));
    SetReduceRule(s,  29, d.Get('^'));
    SetReduceRule(s,  29, d.Get('%'));
    SetReduceRule(s,  29, d.Get('['));
    SetReduceRule(s,  29, d.Get(')'));
    SetReduceRule(s,  29, d.Get('&'));
}

static void InitState_241(Dictionary &d, State &s)
{
    // reduce rule 8: Expr ==> Expr [ Integer ] 
    SetReduceRule(s,   8, d.Get('+'));
    SetReduceRule(s,   8, d.Get('*'));
    SetReduceRule(s,   8, d.Get('-'));
    SetReduceRule(s,   8, d.Get('/'));
    SetReduceRule(s,   8, d.Get('^'));
    SetReduceRule(s,   8, d.Get('%'));
    SetReduceRule(s,   8, d.Get('['));
    SetReduceRule(s,   8, d.Get(')'));
    SetReduceRule(s,   8, d.Get('&'));
}

static void InitState_242(Dictionary &d, State &s)
{
    // reduce rule 10: Expr ==> ( Expr ) 
    SetReduceRule(s,  10, d.Get('+'));
    SetReduceRule(s,  10, d.Get('*'));
    SetReduceRule(s,  10, d.Get('-'));
    SetReduceRule(s,  10, d.Get('/'));
    SetReduceRule(s,  10, d.Get('^'));
    SetReduceRule(s,  10, d.Get('%'));
    SetReduceRule(s,  10, d.Get('['));
    SetReduceRule(s,  10, d.Get(']'));
    SetReduceRule(s,  10, d.Get(','));
    SetReduceRule(s,  10, d.Get(':'));
    SetReduceRule(s,  10, d.Get('&'));
}

static void InitState_243(Dictionary &d, State &s)
{
    // reduce rule 43: Variable ==> < PathSpec > 
    SetReduceRule(s,  43, d.Get('+'));
    SetReduceRule(s,  43, d.Get('*'));
    SetReduceRule(s,  43, d.Get('-'));
    SetReduceRule(s,  43, d.Get('/'));
    SetReduceRule(s,  43, d.Get('^'));
    SetReduceRule(s,  43, d.Get('%'));
    SetReduceRule(s,  43, d.Get('['));
    SetReduceRule(s,  43, d.Get(']'));
    SetReduceRule(s,  43, d.Get(','));
    SetReduceRule(s,  43, d.Get(':'));
    SetReduceRule(s,  43, d.Get('&'));
}

static void InitState_244(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  32, d.Get('/'));
    SetShiftState(s,  33, d.Get('\\'));
    SetShiftState(s, 304, d.Get('>'));
    SetShiftState(s, 185, d.Get(257));
    SetShiftState(s, 305, d.Get("PathSpec"));
    SetShiftState(s, 187, d.Get("MultiSlash"));
}

static void InitState_245(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 201, d.Get('-'));
    SetShiftState(s, 202, d.Get('('));
    SetShiftState(s, 203, d.Get('<'));
    SetShiftState(s, 204, d.Get('{'));
    SetShiftState(s, 205, d.Get(257));
    SetShiftState(s, 206, d.Get(258));
    SetShiftState(s, 207, d.Get(259));
    SetShiftState(s, 208, d.Get(260));
    SetShiftState(s, 209, d.Get(261));
    SetShiftState(s, 306, d.Get("Expr"));
    SetShiftState(s, 211, d.Get("Constant"));
    SetShiftState(s, 212, d.Get("Vector"));
    SetShiftState(s, 213, d.Get("Function"));
    SetShiftState(s, 214, d.Get("Variable"));
    SetShiftState(s, 215, d.Get("Database"));
}

static void InitState_246(Dictionary &d, State &s)
{
    // reduce rule 54: TimeSpec ==> [ # ListElems ] 
    SetReduceRule(s,  54, d.Get(':'));
}

static void InitState_247(Dictionary &d, State &s)
{
    // reduce rule 28: Function ==> Identifier ( ) 
    SetReduceRule(s,  28, d.Get('+'));
    SetReduceRule(s,  28, d.Get('*'));
    SetReduceRule(s,  28, d.Get('-'));
    SetReduceRule(s,  28, d.Get('/'));
    SetReduceRule(s,  28, d.Get('^'));
    SetReduceRule(s,  28, d.Get('%'));
    SetReduceRule(s,  28, d.Get('['));
    SetReduceRule(s,  28, d.Get(']'));
    SetReduceRule(s,  28, d.Get(','));
    SetReduceRule(s,  28, d.Get(':'));
    SetReduceRule(s,  28, d.Get('&'));
}

static void InitState_248(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 307, d.Get(')'));
    SetShiftState(s, 235, d.Get(','));
}

static void InitState_249(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 171, d.Get('*'));
    SetShiftState(s, 173, d.Get('/'));
    SetShiftState(s, 174, d.Get('^'));
    SetShiftState(s, 176, d.Get('['));
    SetShiftState(s, 178, d.Get('&'));

    // reduce rule 1: Expr ==> Expr + Expr 
    SetReduceRule(s,   1, d.Get('+'));
    SetReduceRule(s,   1, d.Get('-'));
    SetReduceRule(s,   1, d.Get('%'));
    SetReduceRule(s,   1, d.Get(']'));
    SetReduceRule(s,   1, d.Get(','));
    SetReduceRule(s,   1, d.Get(':'));
}

static void InitState_250(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 174, d.Get('^'));
    SetShiftState(s, 176, d.Get('['));
    SetShiftState(s, 178, d.Get('&'));

    // reduce rule 3: Expr ==> Expr * Expr 
    SetReduceRule(s,   3, d.Get('+'));
    SetReduceRule(s,   3, d.Get('*'));
    SetReduceRule(s,   3, d.Get('-'));
    SetReduceRule(s,   3, d.Get('/'));
    SetReduceRule(s,   3, d.Get('%'));
    SetReduceRule(s,   3, d.Get(']'));
    SetReduceRule(s,   3, d.Get(','));
    SetReduceRule(s,   3, d.Get(':'));
}

static void InitState_251(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 171, d.Get('*'));
    SetShiftState(s, 173, d.Get('/'));
    SetShiftState(s, 174, d.Get('^'));
    SetShiftState(s, 176, d.Get('['));
    SetShiftState(s, 178, d.Get('&'));

    // reduce rule 2: Expr ==> Expr - Expr 
    SetReduceRule(s,   2, d.Get('+'));
    SetReduceRule(s,   2, d.Get('-'));
    SetReduceRule(s,   2, d.Get('%'));
    SetReduceRule(s,   2, d.Get(']'));
    SetReduceRule(s,   2, d.Get(','));
    SetReduceRule(s,   2, d.Get(':'));
}

static void InitState_252(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 174, d.Get('^'));
    SetShiftState(s, 176, d.Get('['));
    SetShiftState(s, 178, d.Get('&'));

    // reduce rule 4: Expr ==> Expr / Expr 
    SetReduceRule(s,   4, d.Get('+'));
    SetReduceRule(s,   4, d.Get('*'));
    SetReduceRule(s,   4, d.Get('-'));
    SetReduceRule(s,   4, d.Get('/'));
    SetReduceRule(s,   4, d.Get('%'));
    SetReduceRule(s,   4, d.Get(']'));
    SetReduceRule(s,   4, d.Get(','));
    SetReduceRule(s,   4, d.Get(':'));
}

static void InitState_253(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 174, d.Get('^'));
    SetShiftState(s, 176, d.Get('['));

    // reduce rule 5: Expr ==> Expr ^ Expr 
    SetReduceRule(s,   5, d.Get('+'));
    SetReduceRule(s,   5, d.Get('*'));
    SetReduceRule(s,   5, d.Get('-'));
    SetReduceRule(s,   5, d.Get('/'));
    SetReduceRule(s,   5, d.Get('%'));
    SetReduceRule(s,   5, d.Get(']'));
    SetReduceRule(s,   5, d.Get(','));
    SetReduceRule(s,   5, d.Get(':'));
}

static void InitState_254(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 170, d.Get('+'));
    SetShiftState(s, 171, d.Get('*'));
    SetShiftState(s, 172, d.Get('-'));
    SetShiftState(s, 173, d.Get('/'));
    SetShiftState(s, 174, d.Get('^'));
    SetShiftState(s, 176, d.Get('['));
    SetShiftState(s, 178, d.Get('&'));

    // reduce rule 6: Expr ==> Expr % Expr 
    SetReduceRule(s,   6, d.Get(']'));
    SetReduceRule(s,   6, d.Get(','));
    SetReduceRule(s,   6, d.Get(':'));
}

static void InitState_255(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 308, d.Get(']'));
}

static void InitState_256(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 170, d.Get('+'));
    SetShiftState(s, 171, d.Get('*'));
    SetShiftState(s, 172, d.Get('-'));
    SetShiftState(s, 173, d.Get('/'));
    SetShiftState(s, 174, d.Get('^'));
    SetShiftState(s, 175, d.Get('%'));
    SetShiftState(s, 176, d.Get('['));
    SetShiftState(s, 309, d.Get(':'));
    SetShiftState(s, 178, d.Get('&'));

    // reduce rule 26: ListElem ==> Expr : Expr 
    SetReduceRule(s,  26, d.Get(']'));
    SetReduceRule(s,  26, d.Get(','));
}

static void InitState_257(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 174, d.Get('^'));
    SetShiftState(s, 176, d.Get('['));

    // reduce rule 7: Expr ==> Expr & Expr 
    SetReduceRule(s,   7, d.Get('+'));
    SetReduceRule(s,   7, d.Get('*'));
    SetReduceRule(s,   7, d.Get('-'));
    SetReduceRule(s,   7, d.Get('/'));
    SetReduceRule(s,   7, d.Get('%'));
    SetReduceRule(s,   7, d.Get(']'));
    SetReduceRule(s,   7, d.Get(','));
    SetReduceRule(s,   7, d.Get(':'));
}

static void InitState_258(Dictionary &d, State &s)
{
    // reduce rule 52: TimeSpec ==> [ ListElems ] Identifier 
    SetReduceRule(s,  52, d.Get(':'));
}

static void InitState_259(Dictionary &d, State &s)
{
    // reduce rule 23: ListElems ==> ListElems , ListElem 
    SetReduceRule(s,  23, d.Get(']'));
    SetReduceRule(s,  23, d.Get(','));
}

static void InitState_260(Dictionary &d, State &s)
{
    // reduce rule 44: Variable ==> < DBSpec : PathSpec > 
    SetReduceRule(s,  44, d.Get(256));
    SetReduceRule(s,  44, d.Get('+'));
    SetReduceRule(s,  44, d.Get('*'));
    SetReduceRule(s,  44, d.Get('-'));
    SetReduceRule(s,  44, d.Get('/'));
    SetReduceRule(s,  44, d.Get('^'));
    SetReduceRule(s,  44, d.Get('%'));
    SetReduceRule(s,  44, d.Get('['));
    SetReduceRule(s,  44, d.Get('&'));
}

static void InitState_261(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 102, d.Get('/'));
    SetShiftState(s, 103, d.Get('\\'));
    SetShiftState(s, 310, d.Get(257));
}

static void InitState_262(Dictionary &d, State &s)
{
    // reduce rule 36: PathSpec ==> MultiSlash Identifier 
    SetReduceRule(s,  36, d.Get('/'));
    SetReduceRule(s,  36, d.Get('\\'));
    SetReduceRule(s,  36, d.Get('>'));
}

static void InitState_263(Dictionary &d, State &s)
{
    // reduce rule 45: Database ==> < DBSpec : > 
    SetReduceRule(s,  45, d.Get('+'));
    SetReduceRule(s,  45, d.Get('*'));
    SetReduceRule(s,  45, d.Get('-'));
    SetReduceRule(s,  45, d.Get('/'));
    SetReduceRule(s,  45, d.Get('^'));
    SetReduceRule(s,  45, d.Get('%'));
    SetReduceRule(s,  45, d.Get('['));
    SetReduceRule(s,  45, d.Get(','));
    SetReduceRule(s,  45, d.Get('&'));
}

static void InitState_264(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  32, d.Get('/'));
    SetShiftState(s,  33, d.Get('\\'));
    SetShiftState(s, 311, d.Get('>'));
    SetShiftState(s, 261, d.Get("MultiSlash"));
}

static void InitState_265(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 274, d.Get('+'));
    SetShiftState(s, 275, d.Get('*'));
    SetShiftState(s, 276, d.Get('-'));
    SetShiftState(s, 277, d.Get('/'));
    SetShiftState(s, 278, d.Get('^'));
    SetShiftState(s, 279, d.Get('%'));
    SetShiftState(s, 280, d.Get('['));
    SetShiftState(s, 312, d.Get('}'));
    SetShiftState(s, 313, d.Get(','));
    SetShiftState(s, 283, d.Get('&'));
}

static void InitState_266(Dictionary &d, State &s)
{
    // reduce rule 29: Function ==> Identifier ( Args ) 
    SetReduceRule(s,  29, d.Get('+'));
    SetReduceRule(s,  29, d.Get('*'));
    SetReduceRule(s,  29, d.Get('-'));
    SetReduceRule(s,  29, d.Get('/'));
    SetReduceRule(s,  29, d.Get('^'));
    SetReduceRule(s,  29, d.Get('%'));
    SetReduceRule(s,  29, d.Get('['));
    SetReduceRule(s,  29, d.Get(','));
    SetReduceRule(s,  29, d.Get('&'));
}

static void InitState_267(Dictionary &d, State &s)
{
    // reduce rule 8: Expr ==> Expr [ Integer ] 
    SetReduceRule(s,   8, d.Get('+'));
    SetReduceRule(s,   8, d.Get('*'));
    SetReduceRule(s,   8, d.Get('-'));
    SetReduceRule(s,   8, d.Get('/'));
    SetReduceRule(s,   8, d.Get('^'));
    SetReduceRule(s,   8, d.Get('%'));
    SetReduceRule(s,   8, d.Get('['));
    SetReduceRule(s,   8, d.Get(','));
    SetReduceRule(s,   8, d.Get('&'));
}

static void InitState_268(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 280, d.Get('['));

    // reduce rule 9: Expr ==> - Expr 
    SetReduceRule(s,   9, d.Get('+'));
    SetReduceRule(s,   9, d.Get('*'));
    SetReduceRule(s,   9, d.Get('-'));
    SetReduceRule(s,   9, d.Get('/'));
    SetReduceRule(s,   9, d.Get('^'));
    SetReduceRule(s,   9, d.Get('%'));
    SetReduceRule(s,   9, d.Get('}'));
    SetReduceRule(s,   9, d.Get(','));
    SetReduceRule(s,   9, d.Get('&'));
}

static void InitState_269(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  70, d.Get('+'));
    SetShiftState(s,  71, d.Get('*'));
    SetShiftState(s,  72, d.Get('-'));
    SetShiftState(s,  73, d.Get('/'));
    SetShiftState(s,  74, d.Get('^'));
    SetShiftState(s,  75, d.Get('%'));
    SetShiftState(s,  76, d.Get('['));
    SetShiftState(s, 314, d.Get(')'));
    SetShiftState(s,  78, d.Get('&'));
}

static void InitState_270(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  32, d.Get('/'));
    SetShiftState(s,  33, d.Get('\\'));
    SetShiftState(s,  34, d.Get('['));
    SetShiftState(s, 315, d.Get('>'));
    SetShiftState(s,  98, d.Get('@'));
    SetShiftState(s,  99, d.Get("MultiSlash"));
    SetShiftState(s, 100, d.Get("MachSpec"));
    SetShiftState(s, 101, d.Get("TimeSpec"));

    // reduce rule 46: DBSpec ==> PathSpec 
    SetReduceRule(s,  46, d.Get(':'));
}

static void InitState_271(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 316, d.Get(':'));
}

static void InitState_272(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 112, d.Get('+'));
    SetShiftState(s, 113, d.Get('*'));
    SetShiftState(s, 114, d.Get('-'));
    SetShiftState(s, 115, d.Get('/'));
    SetShiftState(s, 116, d.Get('^'));
    SetShiftState(s, 117, d.Get('%'));
    SetShiftState(s, 118, d.Get('['));
    SetShiftState(s, 317, d.Get(','));
    SetShiftState(s, 120, d.Get('&'));
}

static void InitState_273(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 121, d.Get('-'));
    SetShiftState(s, 122, d.Get('['));
    SetShiftState(s, 123, d.Get('('));
    SetShiftState(s, 318, d.Get(')'));
    SetShiftState(s, 125, d.Get('<'));
    SetShiftState(s, 126, d.Get('{'));
    SetShiftState(s, 127, d.Get(257));
    SetShiftState(s, 128, d.Get(258));
    SetShiftState(s, 129, d.Get(259));
    SetShiftState(s, 130, d.Get(260));
    SetShiftState(s, 131, d.Get(261));
    SetShiftState(s, 132, d.Get("Expr"));
    SetShiftState(s, 133, d.Get("Constant"));
    SetShiftState(s, 134, d.Get("Vector"));
    SetShiftState(s, 135, d.Get("List"));
    SetShiftState(s, 136, d.Get("Function"));
    SetShiftState(s, 319, d.Get("Args"));
    SetShiftState(s, 138, d.Get("Arg"));
    SetShiftState(s, 139, d.Get("Variable"));
    SetShiftState(s, 140, d.Get("Database"));
}

static void InitState_274(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 201, d.Get('-'));
    SetShiftState(s, 202, d.Get('('));
    SetShiftState(s, 203, d.Get('<'));
    SetShiftState(s, 204, d.Get('{'));
    SetShiftState(s, 205, d.Get(257));
    SetShiftState(s, 206, d.Get(258));
    SetShiftState(s, 207, d.Get(259));
    SetShiftState(s, 208, d.Get(260));
    SetShiftState(s, 209, d.Get(261));
    SetShiftState(s, 320, d.Get("Expr"));
    SetShiftState(s, 211, d.Get("Constant"));
    SetShiftState(s, 212, d.Get("Vector"));
    SetShiftState(s, 213, d.Get("Function"));
    SetShiftState(s, 214, d.Get("Variable"));
    SetShiftState(s, 215, d.Get("Database"));
}

static void InitState_275(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 201, d.Get('-'));
    SetShiftState(s, 202, d.Get('('));
    SetShiftState(s, 203, d.Get('<'));
    SetShiftState(s, 204, d.Get('{'));
    SetShiftState(s, 205, d.Get(257));
    SetShiftState(s, 206, d.Get(258));
    SetShiftState(s, 207, d.Get(259));
    SetShiftState(s, 208, d.Get(260));
    SetShiftState(s, 209, d.Get(261));
    SetShiftState(s, 321, d.Get("Expr"));
    SetShiftState(s, 211, d.Get("Constant"));
    SetShiftState(s, 212, d.Get("Vector"));
    SetShiftState(s, 213, d.Get("Function"));
    SetShiftState(s, 214, d.Get("Variable"));
    SetShiftState(s, 215, d.Get("Database"));
}

static void InitState_276(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 201, d.Get('-'));
    SetShiftState(s, 202, d.Get('('));
    SetShiftState(s, 203, d.Get('<'));
    SetShiftState(s, 204, d.Get('{'));
    SetShiftState(s, 205, d.Get(257));
    SetShiftState(s, 206, d.Get(258));
    SetShiftState(s, 207, d.Get(259));
    SetShiftState(s, 208, d.Get(260));
    SetShiftState(s, 209, d.Get(261));
    SetShiftState(s, 322, d.Get("Expr"));
    SetShiftState(s, 211, d.Get("Constant"));
    SetShiftState(s, 212, d.Get("Vector"));
    SetShiftState(s, 213, d.Get("Function"));
    SetShiftState(s, 214, d.Get("Variable"));
    SetShiftState(s, 215, d.Get("Database"));
}

static void InitState_277(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 201, d.Get('-'));
    SetShiftState(s, 202, d.Get('('));
    SetShiftState(s, 203, d.Get('<'));
    SetShiftState(s, 204, d.Get('{'));
    SetShiftState(s, 205, d.Get(257));
    SetShiftState(s, 206, d.Get(258));
    SetShiftState(s, 207, d.Get(259));
    SetShiftState(s, 208, d.Get(260));
    SetShiftState(s, 209, d.Get(261));
    SetShiftState(s, 323, d.Get("Expr"));
    SetShiftState(s, 211, d.Get("Constant"));
    SetShiftState(s, 212, d.Get("Vector"));
    SetShiftState(s, 213, d.Get("Function"));
    SetShiftState(s, 214, d.Get("Variable"));
    SetShiftState(s, 215, d.Get("Database"));
}

static void InitState_278(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 201, d.Get('-'));
    SetShiftState(s, 202, d.Get('('));
    SetShiftState(s, 203, d.Get('<'));
    SetShiftState(s, 204, d.Get('{'));
    SetShiftState(s, 205, d.Get(257));
    SetShiftState(s, 206, d.Get(258));
    SetShiftState(s, 207, d.Get(259));
    SetShiftState(s, 208, d.Get(260));
    SetShiftState(s, 209, d.Get(261));
    SetShiftState(s, 324, d.Get("Expr"));
    SetShiftState(s, 211, d.Get("Constant"));
    SetShiftState(s, 212, d.Get("Vector"));
    SetShiftState(s, 213, d.Get("Function"));
    SetShiftState(s, 214, d.Get("Variable"));
    SetShiftState(s, 215, d.Get("Database"));
}

static void InitState_279(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 201, d.Get('-'));
    SetShiftState(s, 202, d.Get('('));
    SetShiftState(s, 203, d.Get('<'));
    SetShiftState(s, 204, d.Get('{'));
    SetShiftState(s, 205, d.Get(257));
    SetShiftState(s, 206, d.Get(258));
    SetShiftState(s, 207, d.Get(259));
    SetShiftState(s, 208, d.Get(260));
    SetShiftState(s, 209, d.Get(261));
    SetShiftState(s, 325, d.Get("Expr"));
    SetShiftState(s, 211, d.Get("Constant"));
    SetShiftState(s, 212, d.Get("Vector"));
    SetShiftState(s, 213, d.Get("Function"));
    SetShiftState(s, 214, d.Get("Variable"));
    SetShiftState(s, 215, d.Get("Database"));
}

static void InitState_280(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 326, d.Get(258));
}

static void InitState_281(Dictionary &d, State &s)
{
    // reduce rule 20: Vector ==> { Expr , Expr } 
    SetReduceRule(s,  20, d.Get(256));
    SetReduceRule(s,  20, d.Get('+'));
    SetReduceRule(s,  20, d.Get('*'));
    SetReduceRule(s,  20, d.Get('-'));
    SetReduceRule(s,  20, d.Get('/'));
    SetReduceRule(s,  20, d.Get('^'));
    SetReduceRule(s,  20, d.Get('%'));
    SetReduceRule(s,  20, d.Get('['));
    SetReduceRule(s,  20, d.Get('&'));
}

static void InitState_282(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 327, d.Get('-'));
    SetShiftState(s, 328, d.Get('('));
    SetShiftState(s, 329, d.Get('<'));
    SetShiftState(s, 330, d.Get('{'));
    SetShiftState(s, 331, d.Get(257));
    SetShiftState(s, 332, d.Get(258));
    SetShiftState(s, 333, d.Get(259));
    SetShiftState(s, 334, d.Get(260));
    SetShiftState(s, 335, d.Get(261));
    SetShiftState(s, 336, d.Get("Expr"));
    SetShiftState(s, 337, d.Get("Constant"));
    SetShiftState(s, 338, d.Get("Vector"));
    SetShiftState(s, 339, d.Get("Function"));
    SetShiftState(s, 340, d.Get("Variable"));
    SetShiftState(s, 341, d.Get("Database"));
}

static void InitState_283(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 201, d.Get('-'));
    SetShiftState(s, 202, d.Get('('));
    SetShiftState(s, 203, d.Get('<'));
    SetShiftState(s, 204, d.Get('{'));
    SetShiftState(s, 205, d.Get(257));
    SetShiftState(s, 206, d.Get(258));
    SetShiftState(s, 207, d.Get(259));
    SetShiftState(s, 208, d.Get(260));
    SetShiftState(s, 209, d.Get(261));
    SetShiftState(s, 342, d.Get("Expr"));
    SetShiftState(s, 211, d.Get("Constant"));
    SetShiftState(s, 212, d.Get("Vector"));
    SetShiftState(s, 213, d.Get("Function"));
    SetShiftState(s, 214, d.Get("Variable"));
    SetShiftState(s, 215, d.Get("Database"));
}

static void InitState_284(Dictionary &d, State &s)
{
    // reduce rule 22: List ==> [ ListElems ] 
    SetReduceRule(s,  22, d.Get(')'));
    SetReduceRule(s,  22, d.Get(','));
}

static void InitState_285(Dictionary &d, State &s)
{
    // reduce rule 10: Expr ==> ( Expr ) 
    SetReduceRule(s,  10, d.Get('+'));
    SetReduceRule(s,  10, d.Get('*'));
    SetReduceRule(s,  10, d.Get('-'));
    SetReduceRule(s,  10, d.Get('/'));
    SetReduceRule(s,  10, d.Get('^'));
    SetReduceRule(s,  10, d.Get('%'));
    SetReduceRule(s,  10, d.Get('['));
    SetReduceRule(s,  10, d.Get(')'));
    SetReduceRule(s,  10, d.Get(','));
    SetReduceRule(s,  10, d.Get('&'));
}

static void InitState_286(Dictionary &d, State &s)
{
    // reduce rule 43: Variable ==> < PathSpec > 
    SetReduceRule(s,  43, d.Get('+'));
    SetReduceRule(s,  43, d.Get('*'));
    SetReduceRule(s,  43, d.Get('-'));
    SetReduceRule(s,  43, d.Get('/'));
    SetReduceRule(s,  43, d.Get('^'));
    SetReduceRule(s,  43, d.Get('%'));
    SetReduceRule(s,  43, d.Get('['));
    SetReduceRule(s,  43, d.Get(')'));
    SetReduceRule(s,  43, d.Get(','));
    SetReduceRule(s,  43, d.Get('&'));
}

static void InitState_287(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  32, d.Get('/'));
    SetShiftState(s,  33, d.Get('\\'));
    SetShiftState(s, 343, d.Get('>'));
    SetShiftState(s, 185, d.Get(257));
    SetShiftState(s, 344, d.Get("PathSpec"));
    SetShiftState(s, 187, d.Get("MultiSlash"));
}

static void InitState_288(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 201, d.Get('-'));
    SetShiftState(s, 202, d.Get('('));
    SetShiftState(s, 203, d.Get('<'));
    SetShiftState(s, 204, d.Get('{'));
    SetShiftState(s, 205, d.Get(257));
    SetShiftState(s, 206, d.Get(258));
    SetShiftState(s, 207, d.Get(259));
    SetShiftState(s, 208, d.Get(260));
    SetShiftState(s, 209, d.Get(261));
    SetShiftState(s, 345, d.Get("Expr"));
    SetShiftState(s, 211, d.Get("Constant"));
    SetShiftState(s, 212, d.Get("Vector"));
    SetShiftState(s, 213, d.Get("Function"));
    SetShiftState(s, 214, d.Get("Variable"));
    SetShiftState(s, 215, d.Get("Database"));
}

static void InitState_289(Dictionary &d, State &s)
{
    // reduce rule 28: Function ==> Identifier ( ) 
    SetReduceRule(s,  28, d.Get('+'));
    SetReduceRule(s,  28, d.Get('*'));
    SetReduceRule(s,  28, d.Get('-'));
    SetReduceRule(s,  28, d.Get('/'));
    SetReduceRule(s,  28, d.Get('^'));
    SetReduceRule(s,  28, d.Get('%'));
    SetReduceRule(s,  28, d.Get('['));
    SetReduceRule(s,  28, d.Get(')'));
    SetReduceRule(s,  28, d.Get(','));
    SetReduceRule(s,  28, d.Get('&'));
}

static void InitState_290(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 346, d.Get(')'));
    SetShiftState(s, 235, d.Get(','));
}

static void InitState_291(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 226, d.Get('+'));
    SetShiftState(s, 227, d.Get('*'));
    SetShiftState(s, 228, d.Get('-'));
    SetShiftState(s, 229, d.Get('/'));
    SetShiftState(s, 230, d.Get('^'));
    SetShiftState(s, 231, d.Get('%'));
    SetShiftState(s, 232, d.Get('['));
    SetShiftState(s, 233, d.Get('&'));

    // reduce rule 33: Arg ==> Identifier = Expr 
    SetReduceRule(s,  33, d.Get(')'));
    SetReduceRule(s,  33, d.Get(','));
}

static void InitState_292(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 227, d.Get('*'));
    SetShiftState(s, 229, d.Get('/'));
    SetShiftState(s, 230, d.Get('^'));
    SetShiftState(s, 232, d.Get('['));
    SetShiftState(s, 233, d.Get('&'));

    // reduce rule 1: Expr ==> Expr + Expr 
    SetReduceRule(s,   1, d.Get('+'));
    SetReduceRule(s,   1, d.Get('-'));
    SetReduceRule(s,   1, d.Get('%'));
    SetReduceRule(s,   1, d.Get(')'));
    SetReduceRule(s,   1, d.Get(','));
}

static void InitState_293(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 230, d.Get('^'));
    SetShiftState(s, 232, d.Get('['));
    SetShiftState(s, 233, d.Get('&'));

    // reduce rule 3: Expr ==> Expr * Expr 
    SetReduceRule(s,   3, d.Get('+'));
    SetReduceRule(s,   3, d.Get('*'));
    SetReduceRule(s,   3, d.Get('-'));
    SetReduceRule(s,   3, d.Get('/'));
    SetReduceRule(s,   3, d.Get('%'));
    SetReduceRule(s,   3, d.Get(')'));
    SetReduceRule(s,   3, d.Get(','));
}

static void InitState_294(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 227, d.Get('*'));
    SetShiftState(s, 229, d.Get('/'));
    SetShiftState(s, 230, d.Get('^'));
    SetShiftState(s, 232, d.Get('['));
    SetShiftState(s, 233, d.Get('&'));

    // reduce rule 2: Expr ==> Expr - Expr 
    SetReduceRule(s,   2, d.Get('+'));
    SetReduceRule(s,   2, d.Get('-'));
    SetReduceRule(s,   2, d.Get('%'));
    SetReduceRule(s,   2, d.Get(')'));
    SetReduceRule(s,   2, d.Get(','));
}

static void InitState_295(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 230, d.Get('^'));
    SetShiftState(s, 232, d.Get('['));
    SetShiftState(s, 233, d.Get('&'));

    // reduce rule 4: Expr ==> Expr / Expr 
    SetReduceRule(s,   4, d.Get('+'));
    SetReduceRule(s,   4, d.Get('*'));
    SetReduceRule(s,   4, d.Get('-'));
    SetReduceRule(s,   4, d.Get('/'));
    SetReduceRule(s,   4, d.Get('%'));
    SetReduceRule(s,   4, d.Get(')'));
    SetReduceRule(s,   4, d.Get(','));
}

static void InitState_296(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 230, d.Get('^'));
    SetShiftState(s, 232, d.Get('['));

    // reduce rule 5: Expr ==> Expr ^ Expr 
    SetReduceRule(s,   5, d.Get('+'));
    SetReduceRule(s,   5, d.Get('*'));
    SetReduceRule(s,   5, d.Get('-'));
    SetReduceRule(s,   5, d.Get('/'));
    SetReduceRule(s,   5, d.Get('%'));
    SetReduceRule(s,   5, d.Get(')'));
    SetReduceRule(s,   5, d.Get(','));
}

static void InitState_297(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 226, d.Get('+'));
    SetShiftState(s, 227, d.Get('*'));
    SetShiftState(s, 228, d.Get('-'));
    SetShiftState(s, 229, d.Get('/'));
    SetShiftState(s, 230, d.Get('^'));
    SetShiftState(s, 232, d.Get('['));
    SetShiftState(s, 233, d.Get('&'));

    // reduce rule 6: Expr ==> Expr % Expr 
    SetReduceRule(s,   6, d.Get(')'));
    SetReduceRule(s,   6, d.Get(','));
}

static void InitState_298(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 347, d.Get(']'));
}

static void InitState_299(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 230, d.Get('^'));
    SetShiftState(s, 232, d.Get('['));

    // reduce rule 7: Expr ==> Expr & Expr 
    SetReduceRule(s,   7, d.Get('+'));
    SetReduceRule(s,   7, d.Get('*'));
    SetReduceRule(s,   7, d.Get('-'));
    SetReduceRule(s,   7, d.Get('/'));
    SetReduceRule(s,   7, d.Get('%'));
    SetReduceRule(s,   7, d.Get(')'));
    SetReduceRule(s,   7, d.Get(','));
}

static void InitState_300(Dictionary &d, State &s)
{
    // reduce rule 30: Args ==> Args , Arg 
    SetReduceRule(s,  30, d.Get(')'));
    SetReduceRule(s,  30, d.Get(','));
}

static void InitState_301(Dictionary &d, State &s)
{
    // reduce rule 44: Variable ==> < DBSpec : PathSpec > 
    SetReduceRule(s,  44, d.Get('+'));
    SetReduceRule(s,  44, d.Get('*'));
    SetReduceRule(s,  44, d.Get('-'));
    SetReduceRule(s,  44, d.Get('/'));
    SetReduceRule(s,  44, d.Get('^'));
    SetReduceRule(s,  44, d.Get('%'));
    SetReduceRule(s,  44, d.Get('['));
    SetReduceRule(s,  44, d.Get(')'));
    SetReduceRule(s,  44, d.Get('&'));
}

static void InitState_302(Dictionary &d, State &s)
{
    // reduce rule 20: Vector ==> { Expr , Expr } 
    SetReduceRule(s,  20, d.Get('+'));
    SetReduceRule(s,  20, d.Get('*'));
    SetReduceRule(s,  20, d.Get('-'));
    SetReduceRule(s,  20, d.Get('/'));
    SetReduceRule(s,  20, d.Get('^'));
    SetReduceRule(s,  20, d.Get('%'));
    SetReduceRule(s,  20, d.Get('['));
    SetReduceRule(s,  20, d.Get(')'));
    SetReduceRule(s,  20, d.Get('&'));
}

static void InitState_303(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 327, d.Get('-'));
    SetShiftState(s, 328, d.Get('('));
    SetShiftState(s, 329, d.Get('<'));
    SetShiftState(s, 330, d.Get('{'));
    SetShiftState(s, 331, d.Get(257));
    SetShiftState(s, 332, d.Get(258));
    SetShiftState(s, 333, d.Get(259));
    SetShiftState(s, 334, d.Get(260));
    SetShiftState(s, 335, d.Get(261));
    SetShiftState(s, 348, d.Get("Expr"));
    SetShiftState(s, 337, d.Get("Constant"));
    SetShiftState(s, 338, d.Get("Vector"));
    SetShiftState(s, 339, d.Get("Function"));
    SetShiftState(s, 340, d.Get("Variable"));
    SetShiftState(s, 341, d.Get("Database"));
}

static void InitState_304(Dictionary &d, State &s)
{
    // reduce rule 45: Database ==> < DBSpec : > 
    SetReduceRule(s,  45, d.Get('+'));
    SetReduceRule(s,  45, d.Get('*'));
    SetReduceRule(s,  45, d.Get('-'));
    SetReduceRule(s,  45, d.Get('/'));
    SetReduceRule(s,  45, d.Get('^'));
    SetReduceRule(s,  45, d.Get('%'));
    SetReduceRule(s,  45, d.Get('['));
    SetReduceRule(s,  45, d.Get(']'));
    SetReduceRule(s,  45, d.Get(','));
    SetReduceRule(s,  45, d.Get(':'));
    SetReduceRule(s,  45, d.Get('&'));
}

static void InitState_305(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  32, d.Get('/'));
    SetShiftState(s,  33, d.Get('\\'));
    SetShiftState(s, 349, d.Get('>'));
    SetShiftState(s, 261, d.Get("MultiSlash"));
}

static void InitState_306(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 274, d.Get('+'));
    SetShiftState(s, 275, d.Get('*'));
    SetShiftState(s, 276, d.Get('-'));
    SetShiftState(s, 277, d.Get('/'));
    SetShiftState(s, 278, d.Get('^'));
    SetShiftState(s, 279, d.Get('%'));
    SetShiftState(s, 280, d.Get('['));
    SetShiftState(s, 350, d.Get('}'));
    SetShiftState(s, 351, d.Get(','));
    SetShiftState(s, 283, d.Get('&'));
}

static void InitState_307(Dictionary &d, State &s)
{
    // reduce rule 29: Function ==> Identifier ( Args ) 
    SetReduceRule(s,  29, d.Get('+'));
    SetReduceRule(s,  29, d.Get('*'));
    SetReduceRule(s,  29, d.Get('-'));
    SetReduceRule(s,  29, d.Get('/'));
    SetReduceRule(s,  29, d.Get('^'));
    SetReduceRule(s,  29, d.Get('%'));
    SetReduceRule(s,  29, d.Get('['));
    SetReduceRule(s,  29, d.Get(']'));
    SetReduceRule(s,  29, d.Get(','));
    SetReduceRule(s,  29, d.Get(':'));
    SetReduceRule(s,  29, d.Get('&'));
}

static void InitState_308(Dictionary &d, State &s)
{
    // reduce rule 8: Expr ==> Expr [ Integer ] 
    SetReduceRule(s,   8, d.Get('+'));
    SetReduceRule(s,   8, d.Get('*'));
    SetReduceRule(s,   8, d.Get('-'));
    SetReduceRule(s,   8, d.Get('/'));
    SetReduceRule(s,   8, d.Get('^'));
    SetReduceRule(s,   8, d.Get('%'));
    SetReduceRule(s,   8, d.Get('['));
    SetReduceRule(s,   8, d.Get(']'));
    SetReduceRule(s,   8, d.Get(','));
    SetReduceRule(s,   8, d.Get(':'));
    SetReduceRule(s,   8, d.Get('&'));
}

static void InitState_309(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 352, d.Get('-'));
    SetShiftState(s, 353, d.Get('('));
    SetShiftState(s, 354, d.Get('<'));
    SetShiftState(s, 355, d.Get('{'));
    SetShiftState(s, 356, d.Get(257));
    SetShiftState(s, 357, d.Get(258));
    SetShiftState(s, 358, d.Get(259));
    SetShiftState(s, 359, d.Get(260));
    SetShiftState(s, 360, d.Get(261));
    SetShiftState(s, 361, d.Get("Expr"));
    SetShiftState(s, 362, d.Get("Constant"));
    SetShiftState(s, 363, d.Get("Vector"));
    SetShiftState(s, 364, d.Get("Function"));
    SetShiftState(s, 365, d.Get("Variable"));
    SetShiftState(s, 366, d.Get("Database"));
}

static void InitState_310(Dictionary &d, State &s)
{
    // reduce rule 35: PathSpec ==> PathSpec MultiSlash Identifier 
    SetReduceRule(s,  35, d.Get('/'));
    SetReduceRule(s,  35, d.Get('\\'));
    SetReduceRule(s,  35, d.Get('>'));
}

static void InitState_311(Dictionary &d, State &s)
{
    // reduce rule 44: Variable ==> < DBSpec : PathSpec > 
    SetReduceRule(s,  44, d.Get('+'));
    SetReduceRule(s,  44, d.Get('*'));
    SetReduceRule(s,  44, d.Get('-'));
    SetReduceRule(s,  44, d.Get('/'));
    SetReduceRule(s,  44, d.Get('^'));
    SetReduceRule(s,  44, d.Get('%'));
    SetReduceRule(s,  44, d.Get('['));
    SetReduceRule(s,  44, d.Get(','));
    SetReduceRule(s,  44, d.Get('&'));
}

static void InitState_312(Dictionary &d, State &s)
{
    // reduce rule 20: Vector ==> { Expr , Expr } 
    SetReduceRule(s,  20, d.Get('+'));
    SetReduceRule(s,  20, d.Get('*'));
    SetReduceRule(s,  20, d.Get('-'));
    SetReduceRule(s,  20, d.Get('/'));
    SetReduceRule(s,  20, d.Get('^'));
    SetReduceRule(s,  20, d.Get('%'));
    SetReduceRule(s,  20, d.Get('['));
    SetReduceRule(s,  20, d.Get(','));
    SetReduceRule(s,  20, d.Get('&'));
}

static void InitState_313(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 327, d.Get('-'));
    SetShiftState(s, 328, d.Get('('));
    SetShiftState(s, 329, d.Get('<'));
    SetShiftState(s, 330, d.Get('{'));
    SetShiftState(s, 331, d.Get(257));
    SetShiftState(s, 332, d.Get(258));
    SetShiftState(s, 333, d.Get(259));
    SetShiftState(s, 334, d.Get(260));
    SetShiftState(s, 335, d.Get(261));
    SetShiftState(s, 367, d.Get("Expr"));
    SetShiftState(s, 337, d.Get("Constant"));
    SetShiftState(s, 338, d.Get("Vector"));
    SetShiftState(s, 339, d.Get("Function"));
    SetShiftState(s, 340, d.Get("Variable"));
    SetShiftState(s, 341, d.Get("Database"));
}

static void InitState_314(Dictionary &d, State &s)
{
    // reduce rule 10: Expr ==> ( Expr ) 
    SetReduceRule(s,  10, d.Get('+'));
    SetReduceRule(s,  10, d.Get('*'));
    SetReduceRule(s,  10, d.Get('-'));
    SetReduceRule(s,  10, d.Get('/'));
    SetReduceRule(s,  10, d.Get('^'));
    SetReduceRule(s,  10, d.Get('%'));
    SetReduceRule(s,  10, d.Get('['));
    SetReduceRule(s,  10, d.Get('}'));
    SetReduceRule(s,  10, d.Get(','));
    SetReduceRule(s,  10, d.Get('&'));
}

static void InitState_315(Dictionary &d, State &s)
{
    // reduce rule 43: Variable ==> < PathSpec > 
    SetReduceRule(s,  43, d.Get('+'));
    SetReduceRule(s,  43, d.Get('*'));
    SetReduceRule(s,  43, d.Get('-'));
    SetReduceRule(s,  43, d.Get('/'));
    SetReduceRule(s,  43, d.Get('^'));
    SetReduceRule(s,  43, d.Get('%'));
    SetReduceRule(s,  43, d.Get('['));
    SetReduceRule(s,  43, d.Get('}'));
    SetReduceRule(s,  43, d.Get(','));
    SetReduceRule(s,  43, d.Get('&'));
}

static void InitState_316(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  32, d.Get('/'));
    SetShiftState(s,  33, d.Get('\\'));
    SetShiftState(s, 368, d.Get('>'));
    SetShiftState(s, 185, d.Get(257));
    SetShiftState(s, 369, d.Get("PathSpec"));
    SetShiftState(s, 187, d.Get("MultiSlash"));
}

static void InitState_317(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 201, d.Get('-'));
    SetShiftState(s, 202, d.Get('('));
    SetShiftState(s, 203, d.Get('<'));
    SetShiftState(s, 204, d.Get('{'));
    SetShiftState(s, 205, d.Get(257));
    SetShiftState(s, 206, d.Get(258));
    SetShiftState(s, 207, d.Get(259));
    SetShiftState(s, 208, d.Get(260));
    SetShiftState(s, 209, d.Get(261));
    SetShiftState(s, 370, d.Get("Expr"));
    SetShiftState(s, 211, d.Get("Constant"));
    SetShiftState(s, 212, d.Get("Vector"));
    SetShiftState(s, 213, d.Get("Function"));
    SetShiftState(s, 214, d.Get("Variable"));
    SetShiftState(s, 215, d.Get("Database"));
}

static void InitState_318(Dictionary &d, State &s)
{
    // reduce rule 28: Function ==> Identifier ( ) 
    SetReduceRule(s,  28, d.Get('+'));
    SetReduceRule(s,  28, d.Get('*'));
    SetReduceRule(s,  28, d.Get('-'));
    SetReduceRule(s,  28, d.Get('/'));
    SetReduceRule(s,  28, d.Get('^'));
    SetReduceRule(s,  28, d.Get('%'));
    SetReduceRule(s,  28, d.Get('['));
    SetReduceRule(s,  28, d.Get('}'));
    SetReduceRule(s,  28, d.Get(','));
    SetReduceRule(s,  28, d.Get('&'));
}

static void InitState_319(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 371, d.Get(')'));
    SetShiftState(s, 235, d.Get(','));
}

static void InitState_320(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 275, d.Get('*'));
    SetShiftState(s, 277, d.Get('/'));
    SetShiftState(s, 278, d.Get('^'));
    SetShiftState(s, 280, d.Get('['));
    SetShiftState(s, 283, d.Get('&'));

    // reduce rule 1: Expr ==> Expr + Expr 
    SetReduceRule(s,   1, d.Get('+'));
    SetReduceRule(s,   1, d.Get('-'));
    SetReduceRule(s,   1, d.Get('%'));
    SetReduceRule(s,   1, d.Get('}'));
    SetReduceRule(s,   1, d.Get(','));
}

static void InitState_321(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 278, d.Get('^'));
    SetShiftState(s, 280, d.Get('['));
    SetShiftState(s, 283, d.Get('&'));

    // reduce rule 3: Expr ==> Expr * Expr 
    SetReduceRule(s,   3, d.Get('+'));
    SetReduceRule(s,   3, d.Get('*'));
    SetReduceRule(s,   3, d.Get('-'));
    SetReduceRule(s,   3, d.Get('/'));
    SetReduceRule(s,   3, d.Get('%'));
    SetReduceRule(s,   3, d.Get('}'));
    SetReduceRule(s,   3, d.Get(','));
}

static void InitState_322(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 275, d.Get('*'));
    SetShiftState(s, 277, d.Get('/'));
    SetShiftState(s, 278, d.Get('^'));
    SetShiftState(s, 280, d.Get('['));
    SetShiftState(s, 283, d.Get('&'));

    // reduce rule 2: Expr ==> Expr - Expr 
    SetReduceRule(s,   2, d.Get('+'));
    SetReduceRule(s,   2, d.Get('-'));
    SetReduceRule(s,   2, d.Get('%'));
    SetReduceRule(s,   2, d.Get('}'));
    SetReduceRule(s,   2, d.Get(','));
}

static void InitState_323(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 278, d.Get('^'));
    SetShiftState(s, 280, d.Get('['));
    SetShiftState(s, 283, d.Get('&'));

    // reduce rule 4: Expr ==> Expr / Expr 
    SetReduceRule(s,   4, d.Get('+'));
    SetReduceRule(s,   4, d.Get('*'));
    SetReduceRule(s,   4, d.Get('-'));
    SetReduceRule(s,   4, d.Get('/'));
    SetReduceRule(s,   4, d.Get('%'));
    SetReduceRule(s,   4, d.Get('}'));
    SetReduceRule(s,   4, d.Get(','));
}

static void InitState_324(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 278, d.Get('^'));
    SetShiftState(s, 280, d.Get('['));

    // reduce rule 5: Expr ==> Expr ^ Expr 
    SetReduceRule(s,   5, d.Get('+'));
    SetReduceRule(s,   5, d.Get('*'));
    SetReduceRule(s,   5, d.Get('-'));
    SetReduceRule(s,   5, d.Get('/'));
    SetReduceRule(s,   5, d.Get('%'));
    SetReduceRule(s,   5, d.Get('}'));
    SetReduceRule(s,   5, d.Get(','));
}

static void InitState_325(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 274, d.Get('+'));
    SetShiftState(s, 275, d.Get('*'));
    SetShiftState(s, 276, d.Get('-'));
    SetShiftState(s, 277, d.Get('/'));
    SetShiftState(s, 278, d.Get('^'));
    SetShiftState(s, 280, d.Get('['));
    SetShiftState(s, 283, d.Get('&'));

    // reduce rule 6: Expr ==> Expr % Expr 
    SetReduceRule(s,   6, d.Get('}'));
    SetReduceRule(s,   6, d.Get(','));
}

static void InitState_326(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 372, d.Get(']'));
}

static void InitState_327(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 327, d.Get('-'));
    SetShiftState(s, 328, d.Get('('));
    SetShiftState(s, 329, d.Get('<'));
    SetShiftState(s, 330, d.Get('{'));
    SetShiftState(s, 331, d.Get(257));
    SetShiftState(s, 332, d.Get(258));
    SetShiftState(s, 333, d.Get(259));
    SetShiftState(s, 334, d.Get(260));
    SetShiftState(s, 335, d.Get(261));
    SetShiftState(s, 373, d.Get("Expr"));
    SetShiftState(s, 337, d.Get("Constant"));
    SetShiftState(s, 338, d.Get("Vector"));
    SetShiftState(s, 339, d.Get("Function"));
    SetShiftState(s, 340, d.Get("Variable"));
    SetShiftState(s, 341, d.Get("Database"));
}

static void InitState_328(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  17, d.Get('-'));
    SetShiftState(s,  18, d.Get('('));
    SetShiftState(s,  19, d.Get('<'));
    SetShiftState(s,  20, d.Get('{'));
    SetShiftState(s,  21, d.Get(257));
    SetShiftState(s,  22, d.Get(258));
    SetShiftState(s,  23, d.Get(259));
    SetShiftState(s,  24, d.Get(260));
    SetShiftState(s,  25, d.Get(261));
    SetShiftState(s, 374, d.Get("Expr"));
    SetShiftState(s,  27, d.Get("Constant"));
    SetShiftState(s,  28, d.Get("Vector"));
    SetShiftState(s,  29, d.Get("Function"));
    SetShiftState(s,  30, d.Get("Variable"));
    SetShiftState(s,  31, d.Get("Database"));
}

static void InitState_329(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  32, d.Get('/'));
    SetShiftState(s,  33, d.Get('\\'));
    SetShiftState(s,  34, d.Get('['));
    SetShiftState(s,  35, d.Get(257));
    SetShiftState(s, 375, d.Get("PathSpec"));
    SetShiftState(s,  37, d.Get("MultiSlash"));
    SetShiftState(s, 376, d.Get("DBSpec"));
    SetShiftState(s,  39, d.Get("TimeSpec"));
}

static void InitState_330(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  40, d.Get('-'));
    SetShiftState(s,  41, d.Get('('));
    SetShiftState(s,  42, d.Get('<'));
    SetShiftState(s,  43, d.Get('{'));
    SetShiftState(s,  44, d.Get(257));
    SetShiftState(s,  45, d.Get(258));
    SetShiftState(s,  46, d.Get(259));
    SetShiftState(s,  47, d.Get(260));
    SetShiftState(s,  48, d.Get(261));
    SetShiftState(s, 377, d.Get("Expr"));
    SetShiftState(s,  50, d.Get("Constant"));
    SetShiftState(s,  51, d.Get("Vector"));
    SetShiftState(s,  52, d.Get("Function"));
    SetShiftState(s,  53, d.Get("Variable"));
    SetShiftState(s,  54, d.Get("Database"));
}

static void InitState_331(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 378, d.Get('('));

    // reduce rule 42: Variable ==> Identifier 
    SetReduceRule(s,  42, d.Get('+'));
    SetReduceRule(s,  42, d.Get('*'));
    SetReduceRule(s,  42, d.Get('-'));
    SetReduceRule(s,  42, d.Get('/'));
    SetReduceRule(s,  42, d.Get('^'));
    SetReduceRule(s,  42, d.Get('%'));
    SetReduceRule(s,  42, d.Get('['));
    SetReduceRule(s,  42, d.Get('}'));
    SetReduceRule(s,  42, d.Get('&'));
}

static void InitState_332(Dictionary &d, State &s)
{
    // reduce rule 16: Constant ==> Integer 
    SetReduceRule(s,  16, d.Get('+'));
    SetReduceRule(s,  16, d.Get('*'));
    SetReduceRule(s,  16, d.Get('-'));
    SetReduceRule(s,  16, d.Get('/'));
    SetReduceRule(s,  16, d.Get('^'));
    SetReduceRule(s,  16, d.Get('%'));
    SetReduceRule(s,  16, d.Get('['));
    SetReduceRule(s,  16, d.Get('}'));
    SetReduceRule(s,  16, d.Get('&'));
}

static void InitState_333(Dictionary &d, State &s)
{
    // reduce rule 17: Constant ==> Float 
    SetReduceRule(s,  17, d.Get('+'));
    SetReduceRule(s,  17, d.Get('*'));
    SetReduceRule(s,  17, d.Get('-'));
    SetReduceRule(s,  17, d.Get('/'));
    SetReduceRule(s,  17, d.Get('^'));
    SetReduceRule(s,  17, d.Get('%'));
    SetReduceRule(s,  17, d.Get('['));
    SetReduceRule(s,  17, d.Get('}'));
    SetReduceRule(s,  17, d.Get('&'));
}

static void InitState_334(Dictionary &d, State &s)
{
    // reduce rule 18: Constant ==> String 
    SetReduceRule(s,  18, d.Get('+'));
    SetReduceRule(s,  18, d.Get('*'));
    SetReduceRule(s,  18, d.Get('-'));
    SetReduceRule(s,  18, d.Get('/'));
    SetReduceRule(s,  18, d.Get('^'));
    SetReduceRule(s,  18, d.Get('%'));
    SetReduceRule(s,  18, d.Get('['));
    SetReduceRule(s,  18, d.Get('}'));
    SetReduceRule(s,  18, d.Get('&'));
}

static void InitState_335(Dictionary &d, State &s)
{
    // reduce rule 19: Constant ==> Bool 
    SetReduceRule(s,  19, d.Get('+'));
    SetReduceRule(s,  19, d.Get('*'));
    SetReduceRule(s,  19, d.Get('-'));
    SetReduceRule(s,  19, d.Get('/'));
    SetReduceRule(s,  19, d.Get('^'));
    SetReduceRule(s,  19, d.Get('%'));
    SetReduceRule(s,  19, d.Get('['));
    SetReduceRule(s,  19, d.Get('}'));
    SetReduceRule(s,  19, d.Get('&'));
}

static void InitState_336(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 379, d.Get('+'));
    SetShiftState(s, 380, d.Get('*'));
    SetShiftState(s, 381, d.Get('-'));
    SetShiftState(s, 382, d.Get('/'));
    SetShiftState(s, 383, d.Get('^'));
    SetShiftState(s, 384, d.Get('%'));
    SetShiftState(s, 385, d.Get('['));
    SetShiftState(s, 386, d.Get('}'));
    SetShiftState(s, 387, d.Get('&'));
}

static void InitState_337(Dictionary &d, State &s)
{
    // reduce rule 11: Expr ==> Constant 
    SetReduceRule(s,  11, d.Get('+'));
    SetReduceRule(s,  11, d.Get('*'));
    SetReduceRule(s,  11, d.Get('-'));
    SetReduceRule(s,  11, d.Get('/'));
    SetReduceRule(s,  11, d.Get('^'));
    SetReduceRule(s,  11, d.Get('%'));
    SetReduceRule(s,  11, d.Get('['));
    SetReduceRule(s,  11, d.Get('}'));
    SetReduceRule(s,  11, d.Get('&'));
}

static void InitState_338(Dictionary &d, State &s)
{
    // reduce rule 12: Expr ==> Vector 
    SetReduceRule(s,  12, d.Get('+'));
    SetReduceRule(s,  12, d.Get('*'));
    SetReduceRule(s,  12, d.Get('-'));
    SetReduceRule(s,  12, d.Get('/'));
    SetReduceRule(s,  12, d.Get('^'));
    SetReduceRule(s,  12, d.Get('%'));
    SetReduceRule(s,  12, d.Get('['));
    SetReduceRule(s,  12, d.Get('}'));
    SetReduceRule(s,  12, d.Get('&'));
}

static void InitState_339(Dictionary &d, State &s)
{
    // reduce rule 13: Expr ==> Function 
    SetReduceRule(s,  13, d.Get('+'));
    SetReduceRule(s,  13, d.Get('*'));
    SetReduceRule(s,  13, d.Get('-'));
    SetReduceRule(s,  13, d.Get('/'));
    SetReduceRule(s,  13, d.Get('^'));
    SetReduceRule(s,  13, d.Get('%'));
    SetReduceRule(s,  13, d.Get('['));
    SetReduceRule(s,  13, d.Get('}'));
    SetReduceRule(s,  13, d.Get('&'));
}

static void InitState_340(Dictionary &d, State &s)
{
    // reduce rule 14: Expr ==> Variable 
    SetReduceRule(s,  14, d.Get('+'));
    SetReduceRule(s,  14, d.Get('*'));
    SetReduceRule(s,  14, d.Get('-'));
    SetReduceRule(s,  14, d.Get('/'));
    SetReduceRule(s,  14, d.Get('^'));
    SetReduceRule(s,  14, d.Get('%'));
    SetReduceRule(s,  14, d.Get('['));
    SetReduceRule(s,  14, d.Get('}'));
    SetReduceRule(s,  14, d.Get('&'));
}

static void InitState_341(Dictionary &d, State &s)
{
    // reduce rule 15: Expr ==> Database 
    SetReduceRule(s,  15, d.Get('+'));
    SetReduceRule(s,  15, d.Get('*'));
    SetReduceRule(s,  15, d.Get('-'));
    SetReduceRule(s,  15, d.Get('/'));
    SetReduceRule(s,  15, d.Get('^'));
    SetReduceRule(s,  15, d.Get('%'));
    SetReduceRule(s,  15, d.Get('['));
    SetReduceRule(s,  15, d.Get('}'));
    SetReduceRule(s,  15, d.Get('&'));
}

static void InitState_342(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 278, d.Get('^'));
    SetShiftState(s, 280, d.Get('['));

    // reduce rule 7: Expr ==> Expr & Expr 
    SetReduceRule(s,   7, d.Get('+'));
    SetReduceRule(s,   7, d.Get('*'));
    SetReduceRule(s,   7, d.Get('-'));
    SetReduceRule(s,   7, d.Get('/'));
    SetReduceRule(s,   7, d.Get('%'));
    SetReduceRule(s,   7, d.Get('}'));
    SetReduceRule(s,   7, d.Get(','));
}

static void InitState_343(Dictionary &d, State &s)
{
    // reduce rule 45: Database ==> < DBSpec : > 
    SetReduceRule(s,  45, d.Get('+'));
    SetReduceRule(s,  45, d.Get('*'));
    SetReduceRule(s,  45, d.Get('-'));
    SetReduceRule(s,  45, d.Get('/'));
    SetReduceRule(s,  45, d.Get('^'));
    SetReduceRule(s,  45, d.Get('%'));
    SetReduceRule(s,  45, d.Get('['));
    SetReduceRule(s,  45, d.Get(')'));
    SetReduceRule(s,  45, d.Get(','));
    SetReduceRule(s,  45, d.Get('&'));
}

static void InitState_344(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  32, d.Get('/'));
    SetShiftState(s,  33, d.Get('\\'));
    SetShiftState(s, 388, d.Get('>'));
    SetShiftState(s, 261, d.Get("MultiSlash"));
}

static void InitState_345(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 274, d.Get('+'));
    SetShiftState(s, 275, d.Get('*'));
    SetShiftState(s, 276, d.Get('-'));
    SetShiftState(s, 277, d.Get('/'));
    SetShiftState(s, 278, d.Get('^'));
    SetShiftState(s, 279, d.Get('%'));
    SetShiftState(s, 280, d.Get('['));
    SetShiftState(s, 389, d.Get('}'));
    SetShiftState(s, 390, d.Get(','));
    SetShiftState(s, 283, d.Get('&'));
}

static void InitState_346(Dictionary &d, State &s)
{
    // reduce rule 29: Function ==> Identifier ( Args ) 
    SetReduceRule(s,  29, d.Get('+'));
    SetReduceRule(s,  29, d.Get('*'));
    SetReduceRule(s,  29, d.Get('-'));
    SetReduceRule(s,  29, d.Get('/'));
    SetReduceRule(s,  29, d.Get('^'));
    SetReduceRule(s,  29, d.Get('%'));
    SetReduceRule(s,  29, d.Get('['));
    SetReduceRule(s,  29, d.Get(')'));
    SetReduceRule(s,  29, d.Get(','));
    SetReduceRule(s,  29, d.Get('&'));
}

static void InitState_347(Dictionary &d, State &s)
{
    // reduce rule 8: Expr ==> Expr [ Integer ] 
    SetReduceRule(s,   8, d.Get('+'));
    SetReduceRule(s,   8, d.Get('*'));
    SetReduceRule(s,   8, d.Get('-'));
    SetReduceRule(s,   8, d.Get('/'));
    SetReduceRule(s,   8, d.Get('^'));
    SetReduceRule(s,   8, d.Get('%'));
    SetReduceRule(s,   8, d.Get('['));
    SetReduceRule(s,   8, d.Get(')'));
    SetReduceRule(s,   8, d.Get(','));
    SetReduceRule(s,   8, d.Get('&'));
}

static void InitState_348(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 379, d.Get('+'));
    SetShiftState(s, 380, d.Get('*'));
    SetShiftState(s, 381, d.Get('-'));
    SetShiftState(s, 382, d.Get('/'));
    SetShiftState(s, 383, d.Get('^'));
    SetShiftState(s, 384, d.Get('%'));
    SetShiftState(s, 385, d.Get('['));
    SetShiftState(s, 391, d.Get('}'));
    SetShiftState(s, 387, d.Get('&'));
}

static void InitState_349(Dictionary &d, State &s)
{
    // reduce rule 44: Variable ==> < DBSpec : PathSpec > 
    SetReduceRule(s,  44, d.Get('+'));
    SetReduceRule(s,  44, d.Get('*'));
    SetReduceRule(s,  44, d.Get('-'));
    SetReduceRule(s,  44, d.Get('/'));
    SetReduceRule(s,  44, d.Get('^'));
    SetReduceRule(s,  44, d.Get('%'));
    SetReduceRule(s,  44, d.Get('['));
    SetReduceRule(s,  44, d.Get(']'));
    SetReduceRule(s,  44, d.Get(','));
    SetReduceRule(s,  44, d.Get(':'));
    SetReduceRule(s,  44, d.Get('&'));
}

static void InitState_350(Dictionary &d, State &s)
{
    // reduce rule 20: Vector ==> { Expr , Expr } 
    SetReduceRule(s,  20, d.Get('+'));
    SetReduceRule(s,  20, d.Get('*'));
    SetReduceRule(s,  20, d.Get('-'));
    SetReduceRule(s,  20, d.Get('/'));
    SetReduceRule(s,  20, d.Get('^'));
    SetReduceRule(s,  20, d.Get('%'));
    SetReduceRule(s,  20, d.Get('['));
    SetReduceRule(s,  20, d.Get(']'));
    SetReduceRule(s,  20, d.Get(','));
    SetReduceRule(s,  20, d.Get(':'));
    SetReduceRule(s,  20, d.Get('&'));
}

static void InitState_351(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 327, d.Get('-'));
    SetShiftState(s, 328, d.Get('('));
    SetShiftState(s, 329, d.Get('<'));
    SetShiftState(s, 330, d.Get('{'));
    SetShiftState(s, 331, d.Get(257));
    SetShiftState(s, 332, d.Get(258));
    SetShiftState(s, 333, d.Get(259));
    SetShiftState(s, 334, d.Get(260));
    SetShiftState(s, 335, d.Get(261));
    SetShiftState(s, 392, d.Get("Expr"));
    SetShiftState(s, 337, d.Get("Constant"));
    SetShiftState(s, 338, d.Get("Vector"));
    SetShiftState(s, 339, d.Get("Function"));
    SetShiftState(s, 340, d.Get("Variable"));
    SetShiftState(s, 341, d.Get("Database"));
}

static void InitState_352(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 352, d.Get('-'));
    SetShiftState(s, 353, d.Get('('));
    SetShiftState(s, 354, d.Get('<'));
    SetShiftState(s, 355, d.Get('{'));
    SetShiftState(s, 356, d.Get(257));
    SetShiftState(s, 357, d.Get(258));
    SetShiftState(s, 358, d.Get(259));
    SetShiftState(s, 359, d.Get(260));
    SetShiftState(s, 360, d.Get(261));
    SetShiftState(s, 393, d.Get("Expr"));
    SetShiftState(s, 362, d.Get("Constant"));
    SetShiftState(s, 363, d.Get("Vector"));
    SetShiftState(s, 364, d.Get("Function"));
    SetShiftState(s, 365, d.Get("Variable"));
    SetShiftState(s, 366, d.Get("Database"));
}

static void InitState_353(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  17, d.Get('-'));
    SetShiftState(s,  18, d.Get('('));
    SetShiftState(s,  19, d.Get('<'));
    SetShiftState(s,  20, d.Get('{'));
    SetShiftState(s,  21, d.Get(257));
    SetShiftState(s,  22, d.Get(258));
    SetShiftState(s,  23, d.Get(259));
    SetShiftState(s,  24, d.Get(260));
    SetShiftState(s,  25, d.Get(261));
    SetShiftState(s, 394, d.Get("Expr"));
    SetShiftState(s,  27, d.Get("Constant"));
    SetShiftState(s,  28, d.Get("Vector"));
    SetShiftState(s,  29, d.Get("Function"));
    SetShiftState(s,  30, d.Get("Variable"));
    SetShiftState(s,  31, d.Get("Database"));
}

static void InitState_354(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  32, d.Get('/'));
    SetShiftState(s,  33, d.Get('\\'));
    SetShiftState(s,  34, d.Get('['));
    SetShiftState(s,  35, d.Get(257));
    SetShiftState(s, 395, d.Get("PathSpec"));
    SetShiftState(s,  37, d.Get("MultiSlash"));
    SetShiftState(s, 396, d.Get("DBSpec"));
    SetShiftState(s,  39, d.Get("TimeSpec"));
}

static void InitState_355(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  40, d.Get('-'));
    SetShiftState(s,  41, d.Get('('));
    SetShiftState(s,  42, d.Get('<'));
    SetShiftState(s,  43, d.Get('{'));
    SetShiftState(s,  44, d.Get(257));
    SetShiftState(s,  45, d.Get(258));
    SetShiftState(s,  46, d.Get(259));
    SetShiftState(s,  47, d.Get(260));
    SetShiftState(s,  48, d.Get(261));
    SetShiftState(s, 397, d.Get("Expr"));
    SetShiftState(s,  50, d.Get("Constant"));
    SetShiftState(s,  51, d.Get("Vector"));
    SetShiftState(s,  52, d.Get("Function"));
    SetShiftState(s,  53, d.Get("Variable"));
    SetShiftState(s,  54, d.Get("Database"));
}

static void InitState_356(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 398, d.Get('('));

    // reduce rule 42: Variable ==> Identifier 
    SetReduceRule(s,  42, d.Get('+'));
    SetReduceRule(s,  42, d.Get('*'));
    SetReduceRule(s,  42, d.Get('-'));
    SetReduceRule(s,  42, d.Get('/'));
    SetReduceRule(s,  42, d.Get('^'));
    SetReduceRule(s,  42, d.Get('%'));
    SetReduceRule(s,  42, d.Get('['));
    SetReduceRule(s,  42, d.Get(']'));
    SetReduceRule(s,  42, d.Get(','));
    SetReduceRule(s,  42, d.Get('&'));
}

static void InitState_357(Dictionary &d, State &s)
{
    // reduce rule 16: Constant ==> Integer 
    SetReduceRule(s,  16, d.Get('+'));
    SetReduceRule(s,  16, d.Get('*'));
    SetReduceRule(s,  16, d.Get('-'));
    SetReduceRule(s,  16, d.Get('/'));
    SetReduceRule(s,  16, d.Get('^'));
    SetReduceRule(s,  16, d.Get('%'));
    SetReduceRule(s,  16, d.Get('['));
    SetReduceRule(s,  16, d.Get(']'));
    SetReduceRule(s,  16, d.Get(','));
    SetReduceRule(s,  16, d.Get('&'));
}

static void InitState_358(Dictionary &d, State &s)
{
    // reduce rule 17: Constant ==> Float 
    SetReduceRule(s,  17, d.Get('+'));
    SetReduceRule(s,  17, d.Get('*'));
    SetReduceRule(s,  17, d.Get('-'));
    SetReduceRule(s,  17, d.Get('/'));
    SetReduceRule(s,  17, d.Get('^'));
    SetReduceRule(s,  17, d.Get('%'));
    SetReduceRule(s,  17, d.Get('['));
    SetReduceRule(s,  17, d.Get(']'));
    SetReduceRule(s,  17, d.Get(','));
    SetReduceRule(s,  17, d.Get('&'));
}

static void InitState_359(Dictionary &d, State &s)
{
    // reduce rule 18: Constant ==> String 
    SetReduceRule(s,  18, d.Get('+'));
    SetReduceRule(s,  18, d.Get('*'));
    SetReduceRule(s,  18, d.Get('-'));
    SetReduceRule(s,  18, d.Get('/'));
    SetReduceRule(s,  18, d.Get('^'));
    SetReduceRule(s,  18, d.Get('%'));
    SetReduceRule(s,  18, d.Get('['));
    SetReduceRule(s,  18, d.Get(']'));
    SetReduceRule(s,  18, d.Get(','));
    SetReduceRule(s,  18, d.Get('&'));
}

static void InitState_360(Dictionary &d, State &s)
{
    // reduce rule 19: Constant ==> Bool 
    SetReduceRule(s,  19, d.Get('+'));
    SetReduceRule(s,  19, d.Get('*'));
    SetReduceRule(s,  19, d.Get('-'));
    SetReduceRule(s,  19, d.Get('/'));
    SetReduceRule(s,  19, d.Get('^'));
    SetReduceRule(s,  19, d.Get('%'));
    SetReduceRule(s,  19, d.Get('['));
    SetReduceRule(s,  19, d.Get(']'));
    SetReduceRule(s,  19, d.Get(','));
    SetReduceRule(s,  19, d.Get('&'));
}

static void InitState_361(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 399, d.Get('+'));
    SetShiftState(s, 400, d.Get('*'));
    SetShiftState(s, 401, d.Get('-'));
    SetShiftState(s, 402, d.Get('/'));
    SetShiftState(s, 403, d.Get('^'));
    SetShiftState(s, 404, d.Get('%'));
    SetShiftState(s, 405, d.Get('['));
    SetShiftState(s, 406, d.Get('&'));

    // reduce rule 27: ListElem ==> Expr : Expr : Expr 
    SetReduceRule(s,  27, d.Get(']'));
    SetReduceRule(s,  27, d.Get(','));
}

static void InitState_362(Dictionary &d, State &s)
{
    // reduce rule 11: Expr ==> Constant 
    SetReduceRule(s,  11, d.Get('+'));
    SetReduceRule(s,  11, d.Get('*'));
    SetReduceRule(s,  11, d.Get('-'));
    SetReduceRule(s,  11, d.Get('/'));
    SetReduceRule(s,  11, d.Get('^'));
    SetReduceRule(s,  11, d.Get('%'));
    SetReduceRule(s,  11, d.Get('['));
    SetReduceRule(s,  11, d.Get(']'));
    SetReduceRule(s,  11, d.Get(','));
    SetReduceRule(s,  11, d.Get('&'));
}

static void InitState_363(Dictionary &d, State &s)
{
    // reduce rule 12: Expr ==> Vector 
    SetReduceRule(s,  12, d.Get('+'));
    SetReduceRule(s,  12, d.Get('*'));
    SetReduceRule(s,  12, d.Get('-'));
    SetReduceRule(s,  12, d.Get('/'));
    SetReduceRule(s,  12, d.Get('^'));
    SetReduceRule(s,  12, d.Get('%'));
    SetReduceRule(s,  12, d.Get('['));
    SetReduceRule(s,  12, d.Get(']'));
    SetReduceRule(s,  12, d.Get(','));
    SetReduceRule(s,  12, d.Get('&'));
}

static void InitState_364(Dictionary &d, State &s)
{
    // reduce rule 13: Expr ==> Function 
    SetReduceRule(s,  13, d.Get('+'));
    SetReduceRule(s,  13, d.Get('*'));
    SetReduceRule(s,  13, d.Get('-'));
    SetReduceRule(s,  13, d.Get('/'));
    SetReduceRule(s,  13, d.Get('^'));
    SetReduceRule(s,  13, d.Get('%'));
    SetReduceRule(s,  13, d.Get('['));
    SetReduceRule(s,  13, d.Get(']'));
    SetReduceRule(s,  13, d.Get(','));
    SetReduceRule(s,  13, d.Get('&'));
}

static void InitState_365(Dictionary &d, State &s)
{
    // reduce rule 14: Expr ==> Variable 
    SetReduceRule(s,  14, d.Get('+'));
    SetReduceRule(s,  14, d.Get('*'));
    SetReduceRule(s,  14, d.Get('-'));
    SetReduceRule(s,  14, d.Get('/'));
    SetReduceRule(s,  14, d.Get('^'));
    SetReduceRule(s,  14, d.Get('%'));
    SetReduceRule(s,  14, d.Get('['));
    SetReduceRule(s,  14, d.Get(']'));
    SetReduceRule(s,  14, d.Get(','));
    SetReduceRule(s,  14, d.Get('&'));
}

static void InitState_366(Dictionary &d, State &s)
{
    // reduce rule 15: Expr ==> Database 
    SetReduceRule(s,  15, d.Get('+'));
    SetReduceRule(s,  15, d.Get('*'));
    SetReduceRule(s,  15, d.Get('-'));
    SetReduceRule(s,  15, d.Get('/'));
    SetReduceRule(s,  15, d.Get('^'));
    SetReduceRule(s,  15, d.Get('%'));
    SetReduceRule(s,  15, d.Get('['));
    SetReduceRule(s,  15, d.Get(']'));
    SetReduceRule(s,  15, d.Get(','));
    SetReduceRule(s,  15, d.Get('&'));
}

static void InitState_367(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 379, d.Get('+'));
    SetShiftState(s, 380, d.Get('*'));
    SetShiftState(s, 381, d.Get('-'));
    SetShiftState(s, 382, d.Get('/'));
    SetShiftState(s, 383, d.Get('^'));
    SetShiftState(s, 384, d.Get('%'));
    SetShiftState(s, 385, d.Get('['));
    SetShiftState(s, 407, d.Get('}'));
    SetShiftState(s, 387, d.Get('&'));
}

static void InitState_368(Dictionary &d, State &s)
{
    // reduce rule 45: Database ==> < DBSpec : > 
    SetReduceRule(s,  45, d.Get('+'));
    SetReduceRule(s,  45, d.Get('*'));
    SetReduceRule(s,  45, d.Get('-'));
    SetReduceRule(s,  45, d.Get('/'));
    SetReduceRule(s,  45, d.Get('^'));
    SetReduceRule(s,  45, d.Get('%'));
    SetReduceRule(s,  45, d.Get('['));
    SetReduceRule(s,  45, d.Get('}'));
    SetReduceRule(s,  45, d.Get(','));
    SetReduceRule(s,  45, d.Get('&'));
}

static void InitState_369(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  32, d.Get('/'));
    SetShiftState(s,  33, d.Get('\\'));
    SetShiftState(s, 408, d.Get('>'));
    SetShiftState(s, 261, d.Get("MultiSlash"));
}

static void InitState_370(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 274, d.Get('+'));
    SetShiftState(s, 275, d.Get('*'));
    SetShiftState(s, 276, d.Get('-'));
    SetShiftState(s, 277, d.Get('/'));
    SetShiftState(s, 278, d.Get('^'));
    SetShiftState(s, 279, d.Get('%'));
    SetShiftState(s, 280, d.Get('['));
    SetShiftState(s, 409, d.Get('}'));
    SetShiftState(s, 410, d.Get(','));
    SetShiftState(s, 283, d.Get('&'));
}

static void InitState_371(Dictionary &d, State &s)
{
    // reduce rule 29: Function ==> Identifier ( Args ) 
    SetReduceRule(s,  29, d.Get('+'));
    SetReduceRule(s,  29, d.Get('*'));
    SetReduceRule(s,  29, d.Get('-'));
    SetReduceRule(s,  29, d.Get('/'));
    SetReduceRule(s,  29, d.Get('^'));
    SetReduceRule(s,  29, d.Get('%'));
    SetReduceRule(s,  29, d.Get('['));
    SetReduceRule(s,  29, d.Get('}'));
    SetReduceRule(s,  29, d.Get(','));
    SetReduceRule(s,  29, d.Get('&'));
}

static void InitState_372(Dictionary &d, State &s)
{
    // reduce rule 8: Expr ==> Expr [ Integer ] 
    SetReduceRule(s,   8, d.Get('+'));
    SetReduceRule(s,   8, d.Get('*'));
    SetReduceRule(s,   8, d.Get('-'));
    SetReduceRule(s,   8, d.Get('/'));
    SetReduceRule(s,   8, d.Get('^'));
    SetReduceRule(s,   8, d.Get('%'));
    SetReduceRule(s,   8, d.Get('['));
    SetReduceRule(s,   8, d.Get('}'));
    SetReduceRule(s,   8, d.Get(','));
    SetReduceRule(s,   8, d.Get('&'));
}

static void InitState_373(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 385, d.Get('['));

    // reduce rule 9: Expr ==> - Expr 
    SetReduceRule(s,   9, d.Get('+'));
    SetReduceRule(s,   9, d.Get('*'));
    SetReduceRule(s,   9, d.Get('-'));
    SetReduceRule(s,   9, d.Get('/'));
    SetReduceRule(s,   9, d.Get('^'));
    SetReduceRule(s,   9, d.Get('%'));
    SetReduceRule(s,   9, d.Get('}'));
    SetReduceRule(s,   9, d.Get('&'));
}

static void InitState_374(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  70, d.Get('+'));
    SetShiftState(s,  71, d.Get('*'));
    SetShiftState(s,  72, d.Get('-'));
    SetShiftState(s,  73, d.Get('/'));
    SetShiftState(s,  74, d.Get('^'));
    SetShiftState(s,  75, d.Get('%'));
    SetShiftState(s,  76, d.Get('['));
    SetShiftState(s, 411, d.Get(')'));
    SetShiftState(s,  78, d.Get('&'));
}

static void InitState_375(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  32, d.Get('/'));
    SetShiftState(s,  33, d.Get('\\'));
    SetShiftState(s,  34, d.Get('['));
    SetShiftState(s, 412, d.Get('>'));
    SetShiftState(s,  98, d.Get('@'));
    SetShiftState(s,  99, d.Get("MultiSlash"));
    SetShiftState(s, 100, d.Get("MachSpec"));
    SetShiftState(s, 101, d.Get("TimeSpec"));

    // reduce rule 46: DBSpec ==> PathSpec 
    SetReduceRule(s,  46, d.Get(':'));
}

static void InitState_376(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 413, d.Get(':'));
}

static void InitState_377(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 112, d.Get('+'));
    SetShiftState(s, 113, d.Get('*'));
    SetShiftState(s, 114, d.Get('-'));
    SetShiftState(s, 115, d.Get('/'));
    SetShiftState(s, 116, d.Get('^'));
    SetShiftState(s, 117, d.Get('%'));
    SetShiftState(s, 118, d.Get('['));
    SetShiftState(s, 414, d.Get(','));
    SetShiftState(s, 120, d.Get('&'));
}

static void InitState_378(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 121, d.Get('-'));
    SetShiftState(s, 122, d.Get('['));
    SetShiftState(s, 123, d.Get('('));
    SetShiftState(s, 415, d.Get(')'));
    SetShiftState(s, 125, d.Get('<'));
    SetShiftState(s, 126, d.Get('{'));
    SetShiftState(s, 127, d.Get(257));
    SetShiftState(s, 128, d.Get(258));
    SetShiftState(s, 129, d.Get(259));
    SetShiftState(s, 130, d.Get(260));
    SetShiftState(s, 131, d.Get(261));
    SetShiftState(s, 132, d.Get("Expr"));
    SetShiftState(s, 133, d.Get("Constant"));
    SetShiftState(s, 134, d.Get("Vector"));
    SetShiftState(s, 135, d.Get("List"));
    SetShiftState(s, 136, d.Get("Function"));
    SetShiftState(s, 416, d.Get("Args"));
    SetShiftState(s, 138, d.Get("Arg"));
    SetShiftState(s, 139, d.Get("Variable"));
    SetShiftState(s, 140, d.Get("Database"));
}

static void InitState_379(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 327, d.Get('-'));
    SetShiftState(s, 328, d.Get('('));
    SetShiftState(s, 329, d.Get('<'));
    SetShiftState(s, 330, d.Get('{'));
    SetShiftState(s, 331, d.Get(257));
    SetShiftState(s, 332, d.Get(258));
    SetShiftState(s, 333, d.Get(259));
    SetShiftState(s, 334, d.Get(260));
    SetShiftState(s, 335, d.Get(261));
    SetShiftState(s, 417, d.Get("Expr"));
    SetShiftState(s, 337, d.Get("Constant"));
    SetShiftState(s, 338, d.Get("Vector"));
    SetShiftState(s, 339, d.Get("Function"));
    SetShiftState(s, 340, d.Get("Variable"));
    SetShiftState(s, 341, d.Get("Database"));
}

static void InitState_380(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 327, d.Get('-'));
    SetShiftState(s, 328, d.Get('('));
    SetShiftState(s, 329, d.Get('<'));
    SetShiftState(s, 330, d.Get('{'));
    SetShiftState(s, 331, d.Get(257));
    SetShiftState(s, 332, d.Get(258));
    SetShiftState(s, 333, d.Get(259));
    SetShiftState(s, 334, d.Get(260));
    SetShiftState(s, 335, d.Get(261));
    SetShiftState(s, 418, d.Get("Expr"));
    SetShiftState(s, 337, d.Get("Constant"));
    SetShiftState(s, 338, d.Get("Vector"));
    SetShiftState(s, 339, d.Get("Function"));
    SetShiftState(s, 340, d.Get("Variable"));
    SetShiftState(s, 341, d.Get("Database"));
}

static void InitState_381(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 327, d.Get('-'));
    SetShiftState(s, 328, d.Get('('));
    SetShiftState(s, 329, d.Get('<'));
    SetShiftState(s, 330, d.Get('{'));
    SetShiftState(s, 331, d.Get(257));
    SetShiftState(s, 332, d.Get(258));
    SetShiftState(s, 333, d.Get(259));
    SetShiftState(s, 334, d.Get(260));
    SetShiftState(s, 335, d.Get(261));
    SetShiftState(s, 419, d.Get("Expr"));
    SetShiftState(s, 337, d.Get("Constant"));
    SetShiftState(s, 338, d.Get("Vector"));
    SetShiftState(s, 339, d.Get("Function"));
    SetShiftState(s, 340, d.Get("Variable"));
    SetShiftState(s, 341, d.Get("Database"));
}

static void InitState_382(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 327, d.Get('-'));
    SetShiftState(s, 328, d.Get('('));
    SetShiftState(s, 329, d.Get('<'));
    SetShiftState(s, 330, d.Get('{'));
    SetShiftState(s, 331, d.Get(257));
    SetShiftState(s, 332, d.Get(258));
    SetShiftState(s, 333, d.Get(259));
    SetShiftState(s, 334, d.Get(260));
    SetShiftState(s, 335, d.Get(261));
    SetShiftState(s, 420, d.Get("Expr"));
    SetShiftState(s, 337, d.Get("Constant"));
    SetShiftState(s, 338, d.Get("Vector"));
    SetShiftState(s, 339, d.Get("Function"));
    SetShiftState(s, 340, d.Get("Variable"));
    SetShiftState(s, 341, d.Get("Database"));
}

static void InitState_383(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 327, d.Get('-'));
    SetShiftState(s, 328, d.Get('('));
    SetShiftState(s, 329, d.Get('<'));
    SetShiftState(s, 330, d.Get('{'));
    SetShiftState(s, 331, d.Get(257));
    SetShiftState(s, 332, d.Get(258));
    SetShiftState(s, 333, d.Get(259));
    SetShiftState(s, 334, d.Get(260));
    SetShiftState(s, 335, d.Get(261));
    SetShiftState(s, 421, d.Get("Expr"));
    SetShiftState(s, 337, d.Get("Constant"));
    SetShiftState(s, 338, d.Get("Vector"));
    SetShiftState(s, 339, d.Get("Function"));
    SetShiftState(s, 340, d.Get("Variable"));
    SetShiftState(s, 341, d.Get("Database"));
}

static void InitState_384(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 327, d.Get('-'));
    SetShiftState(s, 328, d.Get('('));
    SetShiftState(s, 329, d.Get('<'));
    SetShiftState(s, 330, d.Get('{'));
    SetShiftState(s, 331, d.Get(257));
    SetShiftState(s, 332, d.Get(258));
    SetShiftState(s, 333, d.Get(259));
    SetShiftState(s, 334, d.Get(260));
    SetShiftState(s, 335, d.Get(261));
    SetShiftState(s, 422, d.Get("Expr"));
    SetShiftState(s, 337, d.Get("Constant"));
    SetShiftState(s, 338, d.Get("Vector"));
    SetShiftState(s, 339, d.Get("Function"));
    SetShiftState(s, 340, d.Get("Variable"));
    SetShiftState(s, 341, d.Get("Database"));
}

static void InitState_385(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 423, d.Get(258));
}

static void InitState_386(Dictionary &d, State &s)
{
    // reduce rule 21: Vector ==> { Expr , Expr , Expr } 
    SetReduceRule(s,  21, d.Get(256));
    SetReduceRule(s,  21, d.Get('+'));
    SetReduceRule(s,  21, d.Get('*'));
    SetReduceRule(s,  21, d.Get('-'));
    SetReduceRule(s,  21, d.Get('/'));
    SetReduceRule(s,  21, d.Get('^'));
    SetReduceRule(s,  21, d.Get('%'));
    SetReduceRule(s,  21, d.Get('['));
    SetReduceRule(s,  21, d.Get('&'));
}

static void InitState_387(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 327, d.Get('-'));
    SetShiftState(s, 328, d.Get('('));
    SetShiftState(s, 329, d.Get('<'));
    SetShiftState(s, 330, d.Get('{'));
    SetShiftState(s, 331, d.Get(257));
    SetShiftState(s, 332, d.Get(258));
    SetShiftState(s, 333, d.Get(259));
    SetShiftState(s, 334, d.Get(260));
    SetShiftState(s, 335, d.Get(261));
    SetShiftState(s, 424, d.Get("Expr"));
    SetShiftState(s, 337, d.Get("Constant"));
    SetShiftState(s, 338, d.Get("Vector"));
    SetShiftState(s, 339, d.Get("Function"));
    SetShiftState(s, 340, d.Get("Variable"));
    SetShiftState(s, 341, d.Get("Database"));
}

static void InitState_388(Dictionary &d, State &s)
{
    // reduce rule 44: Variable ==> < DBSpec : PathSpec > 
    SetReduceRule(s,  44, d.Get('+'));
    SetReduceRule(s,  44, d.Get('*'));
    SetReduceRule(s,  44, d.Get('-'));
    SetReduceRule(s,  44, d.Get('/'));
    SetReduceRule(s,  44, d.Get('^'));
    SetReduceRule(s,  44, d.Get('%'));
    SetReduceRule(s,  44, d.Get('['));
    SetReduceRule(s,  44, d.Get(')'));
    SetReduceRule(s,  44, d.Get(','));
    SetReduceRule(s,  44, d.Get('&'));
}

static void InitState_389(Dictionary &d, State &s)
{
    // reduce rule 20: Vector ==> { Expr , Expr } 
    SetReduceRule(s,  20, d.Get('+'));
    SetReduceRule(s,  20, d.Get('*'));
    SetReduceRule(s,  20, d.Get('-'));
    SetReduceRule(s,  20, d.Get('/'));
    SetReduceRule(s,  20, d.Get('^'));
    SetReduceRule(s,  20, d.Get('%'));
    SetReduceRule(s,  20, d.Get('['));
    SetReduceRule(s,  20, d.Get(')'));
    SetReduceRule(s,  20, d.Get(','));
    SetReduceRule(s,  20, d.Get('&'));
}

static void InitState_390(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 327, d.Get('-'));
    SetShiftState(s, 328, d.Get('('));
    SetShiftState(s, 329, d.Get('<'));
    SetShiftState(s, 330, d.Get('{'));
    SetShiftState(s, 331, d.Get(257));
    SetShiftState(s, 332, d.Get(258));
    SetShiftState(s, 333, d.Get(259));
    SetShiftState(s, 334, d.Get(260));
    SetShiftState(s, 335, d.Get(261));
    SetShiftState(s, 425, d.Get("Expr"));
    SetShiftState(s, 337, d.Get("Constant"));
    SetShiftState(s, 338, d.Get("Vector"));
    SetShiftState(s, 339, d.Get("Function"));
    SetShiftState(s, 340, d.Get("Variable"));
    SetShiftState(s, 341, d.Get("Database"));
}

static void InitState_391(Dictionary &d, State &s)
{
    // reduce rule 21: Vector ==> { Expr , Expr , Expr } 
    SetReduceRule(s,  21, d.Get('+'));
    SetReduceRule(s,  21, d.Get('*'));
    SetReduceRule(s,  21, d.Get('-'));
    SetReduceRule(s,  21, d.Get('/'));
    SetReduceRule(s,  21, d.Get('^'));
    SetReduceRule(s,  21, d.Get('%'));
    SetReduceRule(s,  21, d.Get('['));
    SetReduceRule(s,  21, d.Get(')'));
    SetReduceRule(s,  21, d.Get('&'));
}

static void InitState_392(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 379, d.Get('+'));
    SetShiftState(s, 380, d.Get('*'));
    SetShiftState(s, 381, d.Get('-'));
    SetShiftState(s, 382, d.Get('/'));
    SetShiftState(s, 383, d.Get('^'));
    SetShiftState(s, 384, d.Get('%'));
    SetShiftState(s, 385, d.Get('['));
    SetShiftState(s, 426, d.Get('}'));
    SetShiftState(s, 387, d.Get('&'));
}

static void InitState_393(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 405, d.Get('['));

    // reduce rule 9: Expr ==> - Expr 
    SetReduceRule(s,   9, d.Get('+'));
    SetReduceRule(s,   9, d.Get('*'));
    SetReduceRule(s,   9, d.Get('-'));
    SetReduceRule(s,   9, d.Get('/'));
    SetReduceRule(s,   9, d.Get('^'));
    SetReduceRule(s,   9, d.Get('%'));
    SetReduceRule(s,   9, d.Get(']'));
    SetReduceRule(s,   9, d.Get(','));
    SetReduceRule(s,   9, d.Get('&'));
}

static void InitState_394(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  70, d.Get('+'));
    SetShiftState(s,  71, d.Get('*'));
    SetShiftState(s,  72, d.Get('-'));
    SetShiftState(s,  73, d.Get('/'));
    SetShiftState(s,  74, d.Get('^'));
    SetShiftState(s,  75, d.Get('%'));
    SetShiftState(s,  76, d.Get('['));
    SetShiftState(s, 427, d.Get(')'));
    SetShiftState(s,  78, d.Get('&'));
}

static void InitState_395(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  32, d.Get('/'));
    SetShiftState(s,  33, d.Get('\\'));
    SetShiftState(s,  34, d.Get('['));
    SetShiftState(s, 428, d.Get('>'));
    SetShiftState(s,  98, d.Get('@'));
    SetShiftState(s,  99, d.Get("MultiSlash"));
    SetShiftState(s, 100, d.Get("MachSpec"));
    SetShiftState(s, 101, d.Get("TimeSpec"));

    // reduce rule 46: DBSpec ==> PathSpec 
    SetReduceRule(s,  46, d.Get(':'));
}

static void InitState_396(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 429, d.Get(':'));
}

static void InitState_397(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 112, d.Get('+'));
    SetShiftState(s, 113, d.Get('*'));
    SetShiftState(s, 114, d.Get('-'));
    SetShiftState(s, 115, d.Get('/'));
    SetShiftState(s, 116, d.Get('^'));
    SetShiftState(s, 117, d.Get('%'));
    SetShiftState(s, 118, d.Get('['));
    SetShiftState(s, 430, d.Get(','));
    SetShiftState(s, 120, d.Get('&'));
}

static void InitState_398(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 121, d.Get('-'));
    SetShiftState(s, 122, d.Get('['));
    SetShiftState(s, 123, d.Get('('));
    SetShiftState(s, 431, d.Get(')'));
    SetShiftState(s, 125, d.Get('<'));
    SetShiftState(s, 126, d.Get('{'));
    SetShiftState(s, 127, d.Get(257));
    SetShiftState(s, 128, d.Get(258));
    SetShiftState(s, 129, d.Get(259));
    SetShiftState(s, 130, d.Get(260));
    SetShiftState(s, 131, d.Get(261));
    SetShiftState(s, 132, d.Get("Expr"));
    SetShiftState(s, 133, d.Get("Constant"));
    SetShiftState(s, 134, d.Get("Vector"));
    SetShiftState(s, 135, d.Get("List"));
    SetShiftState(s, 136, d.Get("Function"));
    SetShiftState(s, 432, d.Get("Args"));
    SetShiftState(s, 138, d.Get("Arg"));
    SetShiftState(s, 139, d.Get("Variable"));
    SetShiftState(s, 140, d.Get("Database"));
}

static void InitState_399(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 352, d.Get('-'));
    SetShiftState(s, 353, d.Get('('));
    SetShiftState(s, 354, d.Get('<'));
    SetShiftState(s, 355, d.Get('{'));
    SetShiftState(s, 356, d.Get(257));
    SetShiftState(s, 357, d.Get(258));
    SetShiftState(s, 358, d.Get(259));
    SetShiftState(s, 359, d.Get(260));
    SetShiftState(s, 360, d.Get(261));
    SetShiftState(s, 433, d.Get("Expr"));
    SetShiftState(s, 362, d.Get("Constant"));
    SetShiftState(s, 363, d.Get("Vector"));
    SetShiftState(s, 364, d.Get("Function"));
    SetShiftState(s, 365, d.Get("Variable"));
    SetShiftState(s, 366, d.Get("Database"));
}

static void InitState_400(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 352, d.Get('-'));
    SetShiftState(s, 353, d.Get('('));
    SetShiftState(s, 354, d.Get('<'));
    SetShiftState(s, 355, d.Get('{'));
    SetShiftState(s, 356, d.Get(257));
    SetShiftState(s, 357, d.Get(258));
    SetShiftState(s, 358, d.Get(259));
    SetShiftState(s, 359, d.Get(260));
    SetShiftState(s, 360, d.Get(261));
    SetShiftState(s, 434, d.Get("Expr"));
    SetShiftState(s, 362, d.Get("Constant"));
    SetShiftState(s, 363, d.Get("Vector"));
    SetShiftState(s, 364, d.Get("Function"));
    SetShiftState(s, 365, d.Get("Variable"));
    SetShiftState(s, 366, d.Get("Database"));
}

static void InitState_401(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 352, d.Get('-'));
    SetShiftState(s, 353, d.Get('('));
    SetShiftState(s, 354, d.Get('<'));
    SetShiftState(s, 355, d.Get('{'));
    SetShiftState(s, 356, d.Get(257));
    SetShiftState(s, 357, d.Get(258));
    SetShiftState(s, 358, d.Get(259));
    SetShiftState(s, 359, d.Get(260));
    SetShiftState(s, 360, d.Get(261));
    SetShiftState(s, 435, d.Get("Expr"));
    SetShiftState(s, 362, d.Get("Constant"));
    SetShiftState(s, 363, d.Get("Vector"));
    SetShiftState(s, 364, d.Get("Function"));
    SetShiftState(s, 365, d.Get("Variable"));
    SetShiftState(s, 366, d.Get("Database"));
}

static void InitState_402(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 352, d.Get('-'));
    SetShiftState(s, 353, d.Get('('));
    SetShiftState(s, 354, d.Get('<'));
    SetShiftState(s, 355, d.Get('{'));
    SetShiftState(s, 356, d.Get(257));
    SetShiftState(s, 357, d.Get(258));
    SetShiftState(s, 358, d.Get(259));
    SetShiftState(s, 359, d.Get(260));
    SetShiftState(s, 360, d.Get(261));
    SetShiftState(s, 436, d.Get("Expr"));
    SetShiftState(s, 362, d.Get("Constant"));
    SetShiftState(s, 363, d.Get("Vector"));
    SetShiftState(s, 364, d.Get("Function"));
    SetShiftState(s, 365, d.Get("Variable"));
    SetShiftState(s, 366, d.Get("Database"));
}

static void InitState_403(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 352, d.Get('-'));
    SetShiftState(s, 353, d.Get('('));
    SetShiftState(s, 354, d.Get('<'));
    SetShiftState(s, 355, d.Get('{'));
    SetShiftState(s, 356, d.Get(257));
    SetShiftState(s, 357, d.Get(258));
    SetShiftState(s, 358, d.Get(259));
    SetShiftState(s, 359, d.Get(260));
    SetShiftState(s, 360, d.Get(261));
    SetShiftState(s, 437, d.Get("Expr"));
    SetShiftState(s, 362, d.Get("Constant"));
    SetShiftState(s, 363, d.Get("Vector"));
    SetShiftState(s, 364, d.Get("Function"));
    SetShiftState(s, 365, d.Get("Variable"));
    SetShiftState(s, 366, d.Get("Database"));
}

static void InitState_404(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 352, d.Get('-'));
    SetShiftState(s, 353, d.Get('('));
    SetShiftState(s, 354, d.Get('<'));
    SetShiftState(s, 355, d.Get('{'));
    SetShiftState(s, 356, d.Get(257));
    SetShiftState(s, 357, d.Get(258));
    SetShiftState(s, 358, d.Get(259));
    SetShiftState(s, 359, d.Get(260));
    SetShiftState(s, 360, d.Get(261));
    SetShiftState(s, 438, d.Get("Expr"));
    SetShiftState(s, 362, d.Get("Constant"));
    SetShiftState(s, 363, d.Get("Vector"));
    SetShiftState(s, 364, d.Get("Function"));
    SetShiftState(s, 365, d.Get("Variable"));
    SetShiftState(s, 366, d.Get("Database"));
}

static void InitState_405(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 439, d.Get(258));
}

static void InitState_406(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 352, d.Get('-'));
    SetShiftState(s, 353, d.Get('('));
    SetShiftState(s, 354, d.Get('<'));
    SetShiftState(s, 355, d.Get('{'));
    SetShiftState(s, 356, d.Get(257));
    SetShiftState(s, 357, d.Get(258));
    SetShiftState(s, 358, d.Get(259));
    SetShiftState(s, 359, d.Get(260));
    SetShiftState(s, 360, d.Get(261));
    SetShiftState(s, 440, d.Get("Expr"));
    SetShiftState(s, 362, d.Get("Constant"));
    SetShiftState(s, 363, d.Get("Vector"));
    SetShiftState(s, 364, d.Get("Function"));
    SetShiftState(s, 365, d.Get("Variable"));
    SetShiftState(s, 366, d.Get("Database"));
}

static void InitState_407(Dictionary &d, State &s)
{
    // reduce rule 21: Vector ==> { Expr , Expr , Expr } 
    SetReduceRule(s,  21, d.Get('+'));
    SetReduceRule(s,  21, d.Get('*'));
    SetReduceRule(s,  21, d.Get('-'));
    SetReduceRule(s,  21, d.Get('/'));
    SetReduceRule(s,  21, d.Get('^'));
    SetReduceRule(s,  21, d.Get('%'));
    SetReduceRule(s,  21, d.Get('['));
    SetReduceRule(s,  21, d.Get(','));
    SetReduceRule(s,  21, d.Get('&'));
}

static void InitState_408(Dictionary &d, State &s)
{
    // reduce rule 44: Variable ==> < DBSpec : PathSpec > 
    SetReduceRule(s,  44, d.Get('+'));
    SetReduceRule(s,  44, d.Get('*'));
    SetReduceRule(s,  44, d.Get('-'));
    SetReduceRule(s,  44, d.Get('/'));
    SetReduceRule(s,  44, d.Get('^'));
    SetReduceRule(s,  44, d.Get('%'));
    SetReduceRule(s,  44, d.Get('['));
    SetReduceRule(s,  44, d.Get('}'));
    SetReduceRule(s,  44, d.Get(','));
    SetReduceRule(s,  44, d.Get('&'));
}

static void InitState_409(Dictionary &d, State &s)
{
    // reduce rule 20: Vector ==> { Expr , Expr } 
    SetReduceRule(s,  20, d.Get('+'));
    SetReduceRule(s,  20, d.Get('*'));
    SetReduceRule(s,  20, d.Get('-'));
    SetReduceRule(s,  20, d.Get('/'));
    SetReduceRule(s,  20, d.Get('^'));
    SetReduceRule(s,  20, d.Get('%'));
    SetReduceRule(s,  20, d.Get('['));
    SetReduceRule(s,  20, d.Get('}'));
    SetReduceRule(s,  20, d.Get(','));
    SetReduceRule(s,  20, d.Get('&'));
}

static void InitState_410(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 327, d.Get('-'));
    SetShiftState(s, 328, d.Get('('));
    SetShiftState(s, 329, d.Get('<'));
    SetShiftState(s, 330, d.Get('{'));
    SetShiftState(s, 331, d.Get(257));
    SetShiftState(s, 332, d.Get(258));
    SetShiftState(s, 333, d.Get(259));
    SetShiftState(s, 334, d.Get(260));
    SetShiftState(s, 335, d.Get(261));
    SetShiftState(s, 441, d.Get("Expr"));
    SetShiftState(s, 337, d.Get("Constant"));
    SetShiftState(s, 338, d.Get("Vector"));
    SetShiftState(s, 339, d.Get("Function"));
    SetShiftState(s, 340, d.Get("Variable"));
    SetShiftState(s, 341, d.Get("Database"));
}

static void InitState_411(Dictionary &d, State &s)
{
    // reduce rule 10: Expr ==> ( Expr ) 
    SetReduceRule(s,  10, d.Get('+'));
    SetReduceRule(s,  10, d.Get('*'));
    SetReduceRule(s,  10, d.Get('-'));
    SetReduceRule(s,  10, d.Get('/'));
    SetReduceRule(s,  10, d.Get('^'));
    SetReduceRule(s,  10, d.Get('%'));
    SetReduceRule(s,  10, d.Get('['));
    SetReduceRule(s,  10, d.Get('}'));
    SetReduceRule(s,  10, d.Get('&'));
}

static void InitState_412(Dictionary &d, State &s)
{
    // reduce rule 43: Variable ==> < PathSpec > 
    SetReduceRule(s,  43, d.Get('+'));
    SetReduceRule(s,  43, d.Get('*'));
    SetReduceRule(s,  43, d.Get('-'));
    SetReduceRule(s,  43, d.Get('/'));
    SetReduceRule(s,  43, d.Get('^'));
    SetReduceRule(s,  43, d.Get('%'));
    SetReduceRule(s,  43, d.Get('['));
    SetReduceRule(s,  43, d.Get('}'));
    SetReduceRule(s,  43, d.Get('&'));
}

static void InitState_413(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  32, d.Get('/'));
    SetShiftState(s,  33, d.Get('\\'));
    SetShiftState(s, 442, d.Get('>'));
    SetShiftState(s, 185, d.Get(257));
    SetShiftState(s, 443, d.Get("PathSpec"));
    SetShiftState(s, 187, d.Get("MultiSlash"));
}

static void InitState_414(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 201, d.Get('-'));
    SetShiftState(s, 202, d.Get('('));
    SetShiftState(s, 203, d.Get('<'));
    SetShiftState(s, 204, d.Get('{'));
    SetShiftState(s, 205, d.Get(257));
    SetShiftState(s, 206, d.Get(258));
    SetShiftState(s, 207, d.Get(259));
    SetShiftState(s, 208, d.Get(260));
    SetShiftState(s, 209, d.Get(261));
    SetShiftState(s, 444, d.Get("Expr"));
    SetShiftState(s, 211, d.Get("Constant"));
    SetShiftState(s, 212, d.Get("Vector"));
    SetShiftState(s, 213, d.Get("Function"));
    SetShiftState(s, 214, d.Get("Variable"));
    SetShiftState(s, 215, d.Get("Database"));
}

static void InitState_415(Dictionary &d, State &s)
{
    // reduce rule 28: Function ==> Identifier ( ) 
    SetReduceRule(s,  28, d.Get('+'));
    SetReduceRule(s,  28, d.Get('*'));
    SetReduceRule(s,  28, d.Get('-'));
    SetReduceRule(s,  28, d.Get('/'));
    SetReduceRule(s,  28, d.Get('^'));
    SetReduceRule(s,  28, d.Get('%'));
    SetReduceRule(s,  28, d.Get('['));
    SetReduceRule(s,  28, d.Get('}'));
    SetReduceRule(s,  28, d.Get('&'));
}

static void InitState_416(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 445, d.Get(')'));
    SetShiftState(s, 235, d.Get(','));
}

static void InitState_417(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 380, d.Get('*'));
    SetShiftState(s, 382, d.Get('/'));
    SetShiftState(s, 383, d.Get('^'));
    SetShiftState(s, 385, d.Get('['));
    SetShiftState(s, 387, d.Get('&'));

    // reduce rule 1: Expr ==> Expr + Expr 
    SetReduceRule(s,   1, d.Get('+'));
    SetReduceRule(s,   1, d.Get('-'));
    SetReduceRule(s,   1, d.Get('%'));
    SetReduceRule(s,   1, d.Get('}'));
}

static void InitState_418(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 383, d.Get('^'));
    SetShiftState(s, 385, d.Get('['));
    SetShiftState(s, 387, d.Get('&'));

    // reduce rule 3: Expr ==> Expr * Expr 
    SetReduceRule(s,   3, d.Get('+'));
    SetReduceRule(s,   3, d.Get('*'));
    SetReduceRule(s,   3, d.Get('-'));
    SetReduceRule(s,   3, d.Get('/'));
    SetReduceRule(s,   3, d.Get('%'));
    SetReduceRule(s,   3, d.Get('}'));
}

static void InitState_419(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 380, d.Get('*'));
    SetShiftState(s, 382, d.Get('/'));
    SetShiftState(s, 383, d.Get('^'));
    SetShiftState(s, 385, d.Get('['));
    SetShiftState(s, 387, d.Get('&'));

    // reduce rule 2: Expr ==> Expr - Expr 
    SetReduceRule(s,   2, d.Get('+'));
    SetReduceRule(s,   2, d.Get('-'));
    SetReduceRule(s,   2, d.Get('%'));
    SetReduceRule(s,   2, d.Get('}'));
}

static void InitState_420(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 383, d.Get('^'));
    SetShiftState(s, 385, d.Get('['));
    SetShiftState(s, 387, d.Get('&'));

    // reduce rule 4: Expr ==> Expr / Expr 
    SetReduceRule(s,   4, d.Get('+'));
    SetReduceRule(s,   4, d.Get('*'));
    SetReduceRule(s,   4, d.Get('-'));
    SetReduceRule(s,   4, d.Get('/'));
    SetReduceRule(s,   4, d.Get('%'));
    SetReduceRule(s,   4, d.Get('}'));
}

static void InitState_421(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 383, d.Get('^'));
    SetShiftState(s, 385, d.Get('['));

    // reduce rule 5: Expr ==> Expr ^ Expr 
    SetReduceRule(s,   5, d.Get('+'));
    SetReduceRule(s,   5, d.Get('*'));
    SetReduceRule(s,   5, d.Get('-'));
    SetReduceRule(s,   5, d.Get('/'));
    SetReduceRule(s,   5, d.Get('%'));
    SetReduceRule(s,   5, d.Get('}'));
}

static void InitState_422(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 379, d.Get('+'));
    SetShiftState(s, 380, d.Get('*'));
    SetShiftState(s, 381, d.Get('-'));
    SetShiftState(s, 382, d.Get('/'));
    SetShiftState(s, 383, d.Get('^'));
    SetShiftState(s, 385, d.Get('['));
    SetShiftState(s, 387, d.Get('&'));

    // reduce rule 6: Expr ==> Expr % Expr 
    SetReduceRule(s,   6, d.Get('}'));
}

static void InitState_423(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 446, d.Get(']'));
}

static void InitState_424(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 383, d.Get('^'));
    SetShiftState(s, 385, d.Get('['));

    // reduce rule 7: Expr ==> Expr & Expr 
    SetReduceRule(s,   7, d.Get('+'));
    SetReduceRule(s,   7, d.Get('*'));
    SetReduceRule(s,   7, d.Get('-'));
    SetReduceRule(s,   7, d.Get('/'));
    SetReduceRule(s,   7, d.Get('%'));
    SetReduceRule(s,   7, d.Get('}'));
}

static void InitState_425(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 379, d.Get('+'));
    SetShiftState(s, 380, d.Get('*'));
    SetShiftState(s, 381, d.Get('-'));
    SetShiftState(s, 382, d.Get('/'));
    SetShiftState(s, 383, d.Get('^'));
    SetShiftState(s, 384, d.Get('%'));
    SetShiftState(s, 385, d.Get('['));
    SetShiftState(s, 447, d.Get('}'));
    SetShiftState(s, 387, d.Get('&'));
}

static void InitState_426(Dictionary &d, State &s)
{
    // reduce rule 21: Vector ==> { Expr , Expr , Expr } 
    SetReduceRule(s,  21, d.Get('+'));
    SetReduceRule(s,  21, d.Get('*'));
    SetReduceRule(s,  21, d.Get('-'));
    SetReduceRule(s,  21, d.Get('/'));
    SetReduceRule(s,  21, d.Get('^'));
    SetReduceRule(s,  21, d.Get('%'));
    SetReduceRule(s,  21, d.Get('['));
    SetReduceRule(s,  21, d.Get(']'));
    SetReduceRule(s,  21, d.Get(','));
    SetReduceRule(s,  21, d.Get(':'));
    SetReduceRule(s,  21, d.Get('&'));
}

static void InitState_427(Dictionary &d, State &s)
{
    // reduce rule 10: Expr ==> ( Expr ) 
    SetReduceRule(s,  10, d.Get('+'));
    SetReduceRule(s,  10, d.Get('*'));
    SetReduceRule(s,  10, d.Get('-'));
    SetReduceRule(s,  10, d.Get('/'));
    SetReduceRule(s,  10, d.Get('^'));
    SetReduceRule(s,  10, d.Get('%'));
    SetReduceRule(s,  10, d.Get('['));
    SetReduceRule(s,  10, d.Get(']'));
    SetReduceRule(s,  10, d.Get(','));
    SetReduceRule(s,  10, d.Get('&'));
}

static void InitState_428(Dictionary &d, State &s)
{
    // reduce rule 43: Variable ==> < PathSpec > 
    SetReduceRule(s,  43, d.Get('+'));
    SetReduceRule(s,  43, d.Get('*'));
    SetReduceRule(s,  43, d.Get('-'));
    SetReduceRule(s,  43, d.Get('/'));
    SetReduceRule(s,  43, d.Get('^'));
    SetReduceRule(s,  43, d.Get('%'));
    SetReduceRule(s,  43, d.Get('['));
    SetReduceRule(s,  43, d.Get(']'));
    SetReduceRule(s,  43, d.Get(','));
    SetReduceRule(s,  43, d.Get('&'));
}

static void InitState_429(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  32, d.Get('/'));
    SetShiftState(s,  33, d.Get('\\'));
    SetShiftState(s, 448, d.Get('>'));
    SetShiftState(s, 185, d.Get(257));
    SetShiftState(s, 449, d.Get("PathSpec"));
    SetShiftState(s, 187, d.Get("MultiSlash"));
}

static void InitState_430(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 201, d.Get('-'));
    SetShiftState(s, 202, d.Get('('));
    SetShiftState(s, 203, d.Get('<'));
    SetShiftState(s, 204, d.Get('{'));
    SetShiftState(s, 205, d.Get(257));
    SetShiftState(s, 206, d.Get(258));
    SetShiftState(s, 207, d.Get(259));
    SetShiftState(s, 208, d.Get(260));
    SetShiftState(s, 209, d.Get(261));
    SetShiftState(s, 450, d.Get("Expr"));
    SetShiftState(s, 211, d.Get("Constant"));
    SetShiftState(s, 212, d.Get("Vector"));
    SetShiftState(s, 213, d.Get("Function"));
    SetShiftState(s, 214, d.Get("Variable"));
    SetShiftState(s, 215, d.Get("Database"));
}

static void InitState_431(Dictionary &d, State &s)
{
    // reduce rule 28: Function ==> Identifier ( ) 
    SetReduceRule(s,  28, d.Get('+'));
    SetReduceRule(s,  28, d.Get('*'));
    SetReduceRule(s,  28, d.Get('-'));
    SetReduceRule(s,  28, d.Get('/'));
    SetReduceRule(s,  28, d.Get('^'));
    SetReduceRule(s,  28, d.Get('%'));
    SetReduceRule(s,  28, d.Get('['));
    SetReduceRule(s,  28, d.Get(']'));
    SetReduceRule(s,  28, d.Get(','));
    SetReduceRule(s,  28, d.Get('&'));
}

static void InitState_432(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 451, d.Get(')'));
    SetShiftState(s, 235, d.Get(','));
}

static void InitState_433(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 400, d.Get('*'));
    SetShiftState(s, 402, d.Get('/'));
    SetShiftState(s, 403, d.Get('^'));
    SetShiftState(s, 405, d.Get('['));
    SetShiftState(s, 406, d.Get('&'));

    // reduce rule 1: Expr ==> Expr + Expr 
    SetReduceRule(s,   1, d.Get('+'));
    SetReduceRule(s,   1, d.Get('-'));
    SetReduceRule(s,   1, d.Get('%'));
    SetReduceRule(s,   1, d.Get(']'));
    SetReduceRule(s,   1, d.Get(','));
}

static void InitState_434(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 403, d.Get('^'));
    SetShiftState(s, 405, d.Get('['));
    SetShiftState(s, 406, d.Get('&'));

    // reduce rule 3: Expr ==> Expr * Expr 
    SetReduceRule(s,   3, d.Get('+'));
    SetReduceRule(s,   3, d.Get('*'));
    SetReduceRule(s,   3, d.Get('-'));
    SetReduceRule(s,   3, d.Get('/'));
    SetReduceRule(s,   3, d.Get('%'));
    SetReduceRule(s,   3, d.Get(']'));
    SetReduceRule(s,   3, d.Get(','));
}

static void InitState_435(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 400, d.Get('*'));
    SetShiftState(s, 402, d.Get('/'));
    SetShiftState(s, 403, d.Get('^'));
    SetShiftState(s, 405, d.Get('['));
    SetShiftState(s, 406, d.Get('&'));

    // reduce rule 2: Expr ==> Expr - Expr 
    SetReduceRule(s,   2, d.Get('+'));
    SetReduceRule(s,   2, d.Get('-'));
    SetReduceRule(s,   2, d.Get('%'));
    SetReduceRule(s,   2, d.Get(']'));
    SetReduceRule(s,   2, d.Get(','));
}

static void InitState_436(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 403, d.Get('^'));
    SetShiftState(s, 405, d.Get('['));
    SetShiftState(s, 406, d.Get('&'));

    // reduce rule 4: Expr ==> Expr / Expr 
    SetReduceRule(s,   4, d.Get('+'));
    SetReduceRule(s,   4, d.Get('*'));
    SetReduceRule(s,   4, d.Get('-'));
    SetReduceRule(s,   4, d.Get('/'));
    SetReduceRule(s,   4, d.Get('%'));
    SetReduceRule(s,   4, d.Get(']'));
    SetReduceRule(s,   4, d.Get(','));
}

static void InitState_437(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 403, d.Get('^'));
    SetShiftState(s, 405, d.Get('['));

    // reduce rule 5: Expr ==> Expr ^ Expr 
    SetReduceRule(s,   5, d.Get('+'));
    SetReduceRule(s,   5, d.Get('*'));
    SetReduceRule(s,   5, d.Get('-'));
    SetReduceRule(s,   5, d.Get('/'));
    SetReduceRule(s,   5, d.Get('%'));
    SetReduceRule(s,   5, d.Get(']'));
    SetReduceRule(s,   5, d.Get(','));
}

static void InitState_438(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 399, d.Get('+'));
    SetShiftState(s, 400, d.Get('*'));
    SetShiftState(s, 401, d.Get('-'));
    SetShiftState(s, 402, d.Get('/'));
    SetShiftState(s, 403, d.Get('^'));
    SetShiftState(s, 405, d.Get('['));
    SetShiftState(s, 406, d.Get('&'));

    // reduce rule 6: Expr ==> Expr % Expr 
    SetReduceRule(s,   6, d.Get(']'));
    SetReduceRule(s,   6, d.Get(','));
}

static void InitState_439(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 452, d.Get(']'));
}

static void InitState_440(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 403, d.Get('^'));
    SetShiftState(s, 405, d.Get('['));

    // reduce rule 7: Expr ==> Expr & Expr 
    SetReduceRule(s,   7, d.Get('+'));
    SetReduceRule(s,   7, d.Get('*'));
    SetReduceRule(s,   7, d.Get('-'));
    SetReduceRule(s,   7, d.Get('/'));
    SetReduceRule(s,   7, d.Get('%'));
    SetReduceRule(s,   7, d.Get(']'));
    SetReduceRule(s,   7, d.Get(','));
}

static void InitState_441(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 379, d.Get('+'));
    SetShiftState(s, 380, d.Get('*'));
    SetShiftState(s, 381, d.Get('-'));
    SetShiftState(s, 382, d.Get('/'));
    SetShiftState(s, 383, d.Get('^'));
    SetShiftState(s, 384, d.Get('%'));
    SetShiftState(s, 385, d.Get('['));
    SetShiftState(s, 453, d.Get('}'));
    SetShiftState(s, 387, d.Get('&'));
}

static void InitState_442(Dictionary &d, State &s)
{
    // reduce rule 45: Database ==> < DBSpec : > 
    SetReduceRule(s,  45, d.Get('+'));
    SetReduceRule(s,  45, d.Get('*'));
    SetReduceRule(s,  45, d.Get('-'));
    SetReduceRule(s,  45, d.Get('/'));
    SetReduceRule(s,  45, d.Get('^'));
    SetReduceRule(s,  45, d.Get('%'));
    SetReduceRule(s,  45, d.Get('['));
    SetReduceRule(s,  45, d.Get('}'));
    SetReduceRule(s,  45, d.Get('&'));
}

static void InitState_443(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  32, d.Get('/'));
    SetShiftState(s,  33, d.Get('\\'));
    SetShiftState(s, 454, d.Get('>'));
    SetShiftState(s, 261, d.Get("MultiSlash"));
}

static void InitState_444(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 274, d.Get('+'));
    SetShiftState(s, 275, d.Get('*'));
    SetShiftState(s, 276, d.Get('-'));
    SetShiftState(s, 277, d.Get('/'));
    SetShiftState(s, 278, d.Get('^'));
    SetShiftState(s, 279, d.Get('%'));
    SetShiftState(s, 280, d.Get('['));
    SetShiftState(s, 455, d.Get('}'));
    SetShiftState(s, 456, d.Get(','));
    SetShiftState(s, 283, d.Get('&'));
}

static void InitState_445(Dictionary &d, State &s)
{
    // reduce rule 29: Function ==> Identifier ( Args ) 
    SetReduceRule(s,  29, d.Get('+'));
    SetReduceRule(s,  29, d.Get('*'));
    SetReduceRule(s,  29, d.Get('-'));
    SetReduceRule(s,  29, d.Get('/'));
    SetReduceRule(s,  29, d.Get('^'));
    SetReduceRule(s,  29, d.Get('%'));
    SetReduceRule(s,  29, d.Get('['));
    SetReduceRule(s,  29, d.Get('}'));
    SetReduceRule(s,  29, d.Get('&'));
}

static void InitState_446(Dictionary &d, State &s)
{
    // reduce rule 8: Expr ==> Expr [ Integer ] 
    SetReduceRule(s,   8, d.Get('+'));
    SetReduceRule(s,   8, d.Get('*'));
    SetReduceRule(s,   8, d.Get('-'));
    SetReduceRule(s,   8, d.Get('/'));
    SetReduceRule(s,   8, d.Get('^'));
    SetReduceRule(s,   8, d.Get('%'));
    SetReduceRule(s,   8, d.Get('['));
    SetReduceRule(s,   8, d.Get('}'));
    SetReduceRule(s,   8, d.Get('&'));
}

static void InitState_447(Dictionary &d, State &s)
{
    // reduce rule 21: Vector ==> { Expr , Expr , Expr } 
    SetReduceRule(s,  21, d.Get('+'));
    SetReduceRule(s,  21, d.Get('*'));
    SetReduceRule(s,  21, d.Get('-'));
    SetReduceRule(s,  21, d.Get('/'));
    SetReduceRule(s,  21, d.Get('^'));
    SetReduceRule(s,  21, d.Get('%'));
    SetReduceRule(s,  21, d.Get('['));
    SetReduceRule(s,  21, d.Get(')'));
    SetReduceRule(s,  21, d.Get(','));
    SetReduceRule(s,  21, d.Get('&'));
}

static void InitState_448(Dictionary &d, State &s)
{
    // reduce rule 45: Database ==> < DBSpec : > 
    SetReduceRule(s,  45, d.Get('+'));
    SetReduceRule(s,  45, d.Get('*'));
    SetReduceRule(s,  45, d.Get('-'));
    SetReduceRule(s,  45, d.Get('/'));
    SetReduceRule(s,  45, d.Get('^'));
    SetReduceRule(s,  45, d.Get('%'));
    SetReduceRule(s,  45, d.Get('['));
    SetReduceRule(s,  45, d.Get(']'));
    SetReduceRule(s,  45, d.Get(','));
    SetReduceRule(s,  45, d.Get('&'));
}

static void InitState_449(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s,  32, d.Get('/'));
    SetShiftState(s,  33, d.Get('\\'));
    SetShiftState(s, 457, d.Get('>'));
    SetShiftState(s, 261, d.Get("MultiSlash"));
}

static void InitState_450(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 274, d.Get('+'));
    SetShiftState(s, 275, d.Get('*'));
    SetShiftState(s, 276, d.Get('-'));
    SetShiftState(s, 277, d.Get('/'));
    SetShiftState(s, 278, d.Get('^'));
    SetShiftState(s, 279, d.Get('%'));
    SetShiftState(s, 280, d.Get('['));
    SetShiftState(s, 458, d.Get('}'));
    SetShiftState(s, 459, d.Get(','));
    SetShiftState(s, 283, d.Get('&'));
}

static void InitState_451(Dictionary &d, State &s)
{
    // reduce rule 29: Function ==> Identifier ( Args ) 
    SetReduceRule(s,  29, d.Get('+'));
    SetReduceRule(s,  29, d.Get('*'));
    SetReduceRule(s,  29, d.Get('-'));
    SetReduceRule(s,  29, d.Get('/'));
    SetReduceRule(s,  29, d.Get('^'));
    SetReduceRule(s,  29, d.Get('%'));
    SetReduceRule(s,  29, d.Get('['));
    SetReduceRule(s,  29, d.Get(']'));
    SetReduceRule(s,  29, d.Get(','));
    SetReduceRule(s,  29, d.Get('&'));
}

static void InitState_452(Dictionary &d, State &s)
{
    // reduce rule 8: Expr ==> Expr [ Integer ] 
    SetReduceRule(s,   8, d.Get('+'));
    SetReduceRule(s,   8, d.Get('*'));
    SetReduceRule(s,   8, d.Get('-'));
    SetReduceRule(s,   8, d.Get('/'));
    SetReduceRule(s,   8, d.Get('^'));
    SetReduceRule(s,   8, d.Get('%'));
    SetReduceRule(s,   8, d.Get('['));
    SetReduceRule(s,   8, d.Get(']'));
    SetReduceRule(s,   8, d.Get(','));
    SetReduceRule(s,   8, d.Get('&'));
}

static void InitState_453(Dictionary &d, State &s)
{
    // reduce rule 21: Vector ==> { Expr , Expr , Expr } 
    SetReduceRule(s,  21, d.Get('+'));
    SetReduceRule(s,  21, d.Get('*'));
    SetReduceRule(s,  21, d.Get('-'));
    SetReduceRule(s,  21, d.Get('/'));
    SetReduceRule(s,  21, d.Get('^'));
    SetReduceRule(s,  21, d.Get('%'));
    SetReduceRule(s,  21, d.Get('['));
    SetReduceRule(s,  21, d.Get('}'));
    SetReduceRule(s,  21, d.Get(','));
    SetReduceRule(s,  21, d.Get('&'));
}

static void InitState_454(Dictionary &d, State &s)
{
    // reduce rule 44: Variable ==> < DBSpec : PathSpec > 
    SetReduceRule(s,  44, d.Get('+'));
    SetReduceRule(s,  44, d.Get('*'));
    SetReduceRule(s,  44, d.Get('-'));
    SetReduceRule(s,  44, d.Get('/'));
    SetReduceRule(s,  44, d.Get('^'));
    SetReduceRule(s,  44, d.Get('%'));
    SetReduceRule(s,  44, d.Get('['));
    SetReduceRule(s,  44, d.Get('}'));
    SetReduceRule(s,  44, d.Get('&'));
}

static void InitState_455(Dictionary &d, State &s)
{
    // reduce rule 20: Vector ==> { Expr , Expr } 
    SetReduceRule(s,  20, d.Get('+'));
    SetReduceRule(s,  20, d.Get('*'));
    SetReduceRule(s,  20, d.Get('-'));
    SetReduceRule(s,  20, d.Get('/'));
    SetReduceRule(s,  20, d.Get('^'));
    SetReduceRule(s,  20, d.Get('%'));
    SetReduceRule(s,  20, d.Get('['));
    SetReduceRule(s,  20, d.Get('}'));
    SetReduceRule(s,  20, d.Get('&'));
}

static void InitState_456(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 327, d.Get('-'));
    SetShiftState(s, 328, d.Get('('));
    SetShiftState(s, 329, d.Get('<'));
    SetShiftState(s, 330, d.Get('{'));
    SetShiftState(s, 331, d.Get(257));
    SetShiftState(s, 332, d.Get(258));
    SetShiftState(s, 333, d.Get(259));
    SetShiftState(s, 334, d.Get(260));
    SetShiftState(s, 335, d.Get(261));
    SetShiftState(s, 460, d.Get("Expr"));
    SetShiftState(s, 337, d.Get("Constant"));
    SetShiftState(s, 338, d.Get("Vector"));
    SetShiftState(s, 339, d.Get("Function"));
    SetShiftState(s, 340, d.Get("Variable"));
    SetShiftState(s, 341, d.Get("Database"));
}

static void InitState_457(Dictionary &d, State &s)
{
    // reduce rule 44: Variable ==> < DBSpec : PathSpec > 
    SetReduceRule(s,  44, d.Get('+'));
    SetReduceRule(s,  44, d.Get('*'));
    SetReduceRule(s,  44, d.Get('-'));
    SetReduceRule(s,  44, d.Get('/'));
    SetReduceRule(s,  44, d.Get('^'));
    SetReduceRule(s,  44, d.Get('%'));
    SetReduceRule(s,  44, d.Get('['));
    SetReduceRule(s,  44, d.Get(']'));
    SetReduceRule(s,  44, d.Get(','));
    SetReduceRule(s,  44, d.Get('&'));
}

static void InitState_458(Dictionary &d, State &s)
{
    // reduce rule 20: Vector ==> { Expr , Expr } 
    SetReduceRule(s,  20, d.Get('+'));
    SetReduceRule(s,  20, d.Get('*'));
    SetReduceRule(s,  20, d.Get('-'));
    SetReduceRule(s,  20, d.Get('/'));
    SetReduceRule(s,  20, d.Get('^'));
    SetReduceRule(s,  20, d.Get('%'));
    SetReduceRule(s,  20, d.Get('['));
    SetReduceRule(s,  20, d.Get(']'));
    SetReduceRule(s,  20, d.Get(','));
    SetReduceRule(s,  20, d.Get('&'));
}

static void InitState_459(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 327, d.Get('-'));
    SetShiftState(s, 328, d.Get('('));
    SetShiftState(s, 329, d.Get('<'));
    SetShiftState(s, 330, d.Get('{'));
    SetShiftState(s, 331, d.Get(257));
    SetShiftState(s, 332, d.Get(258));
    SetShiftState(s, 333, d.Get(259));
    SetShiftState(s, 334, d.Get(260));
    SetShiftState(s, 335, d.Get(261));
    SetShiftState(s, 461, d.Get("Expr"));
    SetShiftState(s, 337, d.Get("Constant"));
    SetShiftState(s, 338, d.Get("Vector"));
    SetShiftState(s, 339, d.Get("Function"));
    SetShiftState(s, 340, d.Get("Variable"));
    SetShiftState(s, 341, d.Get("Database"));
}

static void InitState_460(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 379, d.Get('+'));
    SetShiftState(s, 380, d.Get('*'));
    SetShiftState(s, 381, d.Get('-'));
    SetShiftState(s, 382, d.Get('/'));
    SetShiftState(s, 383, d.Get('^'));
    SetShiftState(s, 384, d.Get('%'));
    SetShiftState(s, 385, d.Get('['));
    SetShiftState(s, 462, d.Get('}'));
    SetShiftState(s, 387, d.Get('&'));
}

static void InitState_461(Dictionary &d, State &s)
{
    // shift transitions
    SetShiftState(s, 379, d.Get('+'));
    SetShiftState(s, 380, d.Get('*'));
    SetShiftState(s, 381, d.Get('-'));
    SetShiftState(s, 382, d.Get('/'));
    SetShiftState(s, 383, d.Get('^'));
    SetShiftState(s, 384, d.Get('%'));
    SetShiftState(s, 385, d.Get('['));
    SetShiftState(s, 463, d.Get('}'));
    SetShiftState(s, 387, d.Get('&'));
}

static void InitState_462(Dictionary &d, State &s)
{
    // reduce rule 21: Vector ==> { Expr , Expr , Expr } 
    SetReduceRule(s,  21, d.Get('+'));
    SetReduceRule(s,  21, d.Get('*'));
    SetReduceRule(s,  21, d.Get('-'));
    SetReduceRule(s,  21, d.Get('/'));
    SetReduceRule(s,  21, d.Get('^'));
    SetReduceRule(s,  21, d.Get('%'));
    SetReduceRule(s,  21, d.Get('['));
    SetReduceRule(s,  21, d.Get('}'));
    SetReduceRule(s,  21, d.Get('&'));
}

static void InitState_463(Dictionary &d, State &s)
{
    // reduce rule 21: Vector ==> { Expr , Expr , Expr } 
    SetReduceRule(s,  21, d.Get('+'));
    SetReduceRule(s,  21, d.Get('*'));
    SetReduceRule(s,  21, d.Get('-'));
    SetReduceRule(s,  21, d.Get('/'));
    SetReduceRule(s,  21, d.Get('^'));
    SetReduceRule(s,  21, d.Get('%'));
    SetReduceRule(s,  21, d.Get('['));
    SetReduceRule(s,  21, d.Get(']'));
    SetReduceRule(s,  21, d.Get(','));
    SetReduceRule(s,  21, d.Get('&'));
}

bool ExprGrammar::Initialize()
{
    states.resize(464);

    InitState_0(dictionary, states[0]);
    InitState_1(dictionary, states[1]);
    InitState_2(dictionary, states[2]);
    InitState_3(dictionary, states[3]);
    InitState_4(dictionary, states[4]);
    InitState_5(dictionary, states[5]);
    InitState_6(dictionary, states[6]);
    InitState_7(dictionary, states[7]);
    InitState_8(dictionary, states[8]);
    InitState_9(dictionary, states[9]);
    InitState_10(dictionary, states[10]);
    InitState_11(dictionary, states[11]);
    InitState_12(dictionary, states[12]);
    InitState_13(dictionary, states[13]);
    InitState_14(dictionary, states[14]);
    InitState_15(dictionary, states[15]);
    InitState_16(dictionary, states[16]);
    InitState_17(dictionary, states[17]);
    InitState_18(dictionary, states[18]);
    InitState_19(dictionary, states[19]);
    InitState_20(dictionary, states[20]);
    InitState_21(dictionary, states[21]);
    InitState_22(dictionary, states[22]);
    InitState_23(dictionary, states[23]);
    InitState_24(dictionary, states[24]);
    InitState_25(dictionary, states[25]);
    InitState_26(dictionary, states[26]);
    InitState_27(dictionary, states[27]);
    InitState_28(dictionary, states[28]);
    InitState_29(dictionary, states[29]);
    InitState_30(dictionary, states[30]);
    InitState_31(dictionary, states[31]);
    InitState_32(dictionary, states[32]);
    InitState_33(dictionary, states[33]);
    InitState_34(dictionary, states[34]);
    InitState_35(dictionary, states[35]);
    InitState_36(dictionary, states[36]);
    InitState_37(dictionary, states[37]);
    InitState_38(dictionary, states[38]);
    InitState_39(dictionary, states[39]);
    InitState_40(dictionary, states[40]);
    InitState_41(dictionary, states[41]);
    InitState_42(dictionary, states[42]);
    InitState_43(dictionary, states[43]);
    InitState_44(dictionary, states[44]);
    InitState_45(dictionary, states[45]);
    InitState_46(dictionary, states[46]);
    InitState_47(dictionary, states[47]);
    InitState_48(dictionary, states[48]);
    InitState_49(dictionary, states[49]);
    InitState_50(dictionary, states[50]);
    InitState_51(dictionary, states[51]);
    InitState_52(dictionary, states[52]);
    InitState_53(dictionary, states[53]);
    InitState_54(dictionary, states[54]);
    InitState_55(dictionary, states[55]);
    InitState_56(dictionary, states[56]);
    InitState_57(dictionary, states[57]);
    InitState_58(dictionary, states[58]);
    InitState_59(dictionary, states[59]);
    InitState_60(dictionary, states[60]);
    InitState_61(dictionary, states[61]);
    InitState_62(dictionary, states[62]);
    InitState_63(dictionary, states[63]);
    InitState_64(dictionary, states[64]);
    InitState_65(dictionary, states[65]);
    InitState_66(dictionary, states[66]);
    InitState_67(dictionary, states[67]);
    InitState_68(dictionary, states[68]);
    InitState_69(dictionary, states[69]);
    InitState_70(dictionary, states[70]);
    InitState_71(dictionary, states[71]);
    InitState_72(dictionary, states[72]);
    InitState_73(dictionary, states[73]);
    InitState_74(dictionary, states[74]);
    InitState_75(dictionary, states[75]);
    InitState_76(dictionary, states[76]);
    InitState_77(dictionary, states[77]);
    InitState_78(dictionary, states[78]);
    InitState_79(dictionary, states[79]);
    InitState_80(dictionary, states[80]);
    InitState_81(dictionary, states[81]);
    InitState_82(dictionary, states[82]);
    InitState_83(dictionary, states[83]);
    InitState_84(dictionary, states[84]);
    InitState_85(dictionary, states[85]);
    InitState_86(dictionary, states[86]);
    InitState_87(dictionary, states[87]);
    InitState_88(dictionary, states[88]);
    InitState_89(dictionary, states[89]);
    InitState_90(dictionary, states[90]);
    InitState_91(dictionary, states[91]);
    InitState_92(dictionary, states[92]);
    InitState_93(dictionary, states[93]);
    InitState_94(dictionary, states[94]);
    InitState_95(dictionary, states[95]);
    InitState_96(dictionary, states[96]);
    InitState_97(dictionary, states[97]);
    InitState_98(dictionary, states[98]);
    InitState_99(dictionary, states[99]);
    InitState_100(dictionary, states[100]);
    InitState_101(dictionary, states[101]);
    InitState_102(dictionary, states[102]);
    InitState_103(dictionary, states[103]);
    InitState_104(dictionary, states[104]);
    InitState_105(dictionary, states[105]);
    InitState_106(dictionary, states[106]);
    InitState_107(dictionary, states[107]);
    InitState_108(dictionary, states[108]);
    InitState_109(dictionary, states[109]);
    InitState_110(dictionary, states[110]);
    InitState_111(dictionary, states[111]);
    InitState_112(dictionary, states[112]);
    InitState_113(dictionary, states[113]);
    InitState_114(dictionary, states[114]);
    InitState_115(dictionary, states[115]);
    InitState_116(dictionary, states[116]);
    InitState_117(dictionary, states[117]);
    InitState_118(dictionary, states[118]);
    InitState_119(dictionary, states[119]);
    InitState_120(dictionary, states[120]);
    InitState_121(dictionary, states[121]);
    InitState_122(dictionary, states[122]);
    InitState_123(dictionary, states[123]);
    InitState_124(dictionary, states[124]);
    InitState_125(dictionary, states[125]);
    InitState_126(dictionary, states[126]);
    InitState_127(dictionary, states[127]);
    InitState_128(dictionary, states[128]);
    InitState_129(dictionary, states[129]);
    InitState_130(dictionary, states[130]);
    InitState_131(dictionary, states[131]);
    InitState_132(dictionary, states[132]);
    InitState_133(dictionary, states[133]);
    InitState_134(dictionary, states[134]);
    InitState_135(dictionary, states[135]);
    InitState_136(dictionary, states[136]);
    InitState_137(dictionary, states[137]);
    InitState_138(dictionary, states[138]);
    InitState_139(dictionary, states[139]);
    InitState_140(dictionary, states[140]);
    InitState_141(dictionary, states[141]);
    InitState_142(dictionary, states[142]);
    InitState_143(dictionary, states[143]);
    InitState_144(dictionary, states[144]);
    InitState_145(dictionary, states[145]);
    InitState_146(dictionary, states[146]);
    InitState_147(dictionary, states[147]);
    InitState_148(dictionary, states[148]);
    InitState_149(dictionary, states[149]);
    InitState_150(dictionary, states[150]);
    InitState_151(dictionary, states[151]);
    InitState_152(dictionary, states[152]);
    InitState_153(dictionary, states[153]);
    InitState_154(dictionary, states[154]);
    InitState_155(dictionary, states[155]);
    InitState_156(dictionary, states[156]);
    InitState_157(dictionary, states[157]);
    InitState_158(dictionary, states[158]);
    InitState_159(dictionary, states[159]);
    InitState_160(dictionary, states[160]);
    InitState_161(dictionary, states[161]);
    InitState_162(dictionary, states[162]);
    InitState_163(dictionary, states[163]);
    InitState_164(dictionary, states[164]);
    InitState_165(dictionary, states[165]);
    InitState_166(dictionary, states[166]);
    InitState_167(dictionary, states[167]);
    InitState_168(dictionary, states[168]);
    InitState_169(dictionary, states[169]);
    InitState_170(dictionary, states[170]);
    InitState_171(dictionary, states[171]);
    InitState_172(dictionary, states[172]);
    InitState_173(dictionary, states[173]);
    InitState_174(dictionary, states[174]);
    InitState_175(dictionary, states[175]);
    InitState_176(dictionary, states[176]);
    InitState_177(dictionary, states[177]);
    InitState_178(dictionary, states[178]);
    InitState_179(dictionary, states[179]);
    InitState_180(dictionary, states[180]);
    InitState_181(dictionary, states[181]);
    InitState_182(dictionary, states[182]);
    InitState_183(dictionary, states[183]);
    InitState_184(dictionary, states[184]);
    InitState_185(dictionary, states[185]);
    InitState_186(dictionary, states[186]);
    InitState_187(dictionary, states[187]);
    InitState_188(dictionary, states[188]);
    InitState_189(dictionary, states[189]);
    InitState_190(dictionary, states[190]);
    InitState_191(dictionary, states[191]);
    InitState_192(dictionary, states[192]);
    InitState_193(dictionary, states[193]);
    InitState_194(dictionary, states[194]);
    InitState_195(dictionary, states[195]);
    InitState_196(dictionary, states[196]);
    InitState_197(dictionary, states[197]);
    InitState_198(dictionary, states[198]);
    InitState_199(dictionary, states[199]);
    InitState_200(dictionary, states[200]);
    InitState_201(dictionary, states[201]);
    InitState_202(dictionary, states[202]);
    InitState_203(dictionary, states[203]);
    InitState_204(dictionary, states[204]);
    InitState_205(dictionary, states[205]);
    InitState_206(dictionary, states[206]);
    InitState_207(dictionary, states[207]);
    InitState_208(dictionary, states[208]);
    InitState_209(dictionary, states[209]);
    InitState_210(dictionary, states[210]);
    InitState_211(dictionary, states[211]);
    InitState_212(dictionary, states[212]);
    InitState_213(dictionary, states[213]);
    InitState_214(dictionary, states[214]);
    InitState_215(dictionary, states[215]);
    InitState_216(dictionary, states[216]);
    InitState_217(dictionary, states[217]);
    InitState_218(dictionary, states[218]);
    InitState_219(dictionary, states[219]);
    InitState_220(dictionary, states[220]);
    InitState_221(dictionary, states[221]);
    InitState_222(dictionary, states[222]);
    InitState_223(dictionary, states[223]);
    InitState_224(dictionary, states[224]);
    InitState_225(dictionary, states[225]);
    InitState_226(dictionary, states[226]);
    InitState_227(dictionary, states[227]);
    InitState_228(dictionary, states[228]);
    InitState_229(dictionary, states[229]);
    InitState_230(dictionary, states[230]);
    InitState_231(dictionary, states[231]);
    InitState_232(dictionary, states[232]);
    InitState_233(dictionary, states[233]);
    InitState_234(dictionary, states[234]);
    InitState_235(dictionary, states[235]);
    InitState_236(dictionary, states[236]);
    InitState_237(dictionary, states[237]);
    InitState_238(dictionary, states[238]);
    InitState_239(dictionary, states[239]);
    InitState_240(dictionary, states[240]);
    InitState_241(dictionary, states[241]);
    InitState_242(dictionary, states[242]);
    InitState_243(dictionary, states[243]);
    InitState_244(dictionary, states[244]);
    InitState_245(dictionary, states[245]);
    InitState_246(dictionary, states[246]);
    InitState_247(dictionary, states[247]);
    InitState_248(dictionary, states[248]);
    InitState_249(dictionary, states[249]);
    InitState_250(dictionary, states[250]);
    InitState_251(dictionary, states[251]);
    InitState_252(dictionary, states[252]);
    InitState_253(dictionary, states[253]);
    InitState_254(dictionary, states[254]);
    InitState_255(dictionary, states[255]);
    InitState_256(dictionary, states[256]);
    InitState_257(dictionary, states[257]);
    InitState_258(dictionary, states[258]);
    InitState_259(dictionary, states[259]);
    InitState_260(dictionary, states[260]);
    InitState_261(dictionary, states[261]);
    InitState_262(dictionary, states[262]);
    InitState_263(dictionary, states[263]);
    InitState_264(dictionary, states[264]);
    InitState_265(dictionary, states[265]);
    InitState_266(dictionary, states[266]);
    InitState_267(dictionary, states[267]);
    InitState_268(dictionary, states[268]);
    InitState_269(dictionary, states[269]);
    InitState_270(dictionary, states[270]);
    InitState_271(dictionary, states[271]);
    InitState_272(dictionary, states[272]);
    InitState_273(dictionary, states[273]);
    InitState_274(dictionary, states[274]);
    InitState_275(dictionary, states[275]);
    InitState_276(dictionary, states[276]);
    InitState_277(dictionary, states[277]);
    InitState_278(dictionary, states[278]);
    InitState_279(dictionary, states[279]);
    InitState_280(dictionary, states[280]);
    InitState_281(dictionary, states[281]);
    InitState_282(dictionary, states[282]);
    InitState_283(dictionary, states[283]);
    InitState_284(dictionary, states[284]);
    InitState_285(dictionary, states[285]);
    InitState_286(dictionary, states[286]);
    InitState_287(dictionary, states[287]);
    InitState_288(dictionary, states[288]);
    InitState_289(dictionary, states[289]);
    InitState_290(dictionary, states[290]);
    InitState_291(dictionary, states[291]);
    InitState_292(dictionary, states[292]);
    InitState_293(dictionary, states[293]);
    InitState_294(dictionary, states[294]);
    InitState_295(dictionary, states[295]);
    InitState_296(dictionary, states[296]);
    InitState_297(dictionary, states[297]);
    InitState_298(dictionary, states[298]);
    InitState_299(dictionary, states[299]);
    InitState_300(dictionary, states[300]);
    InitState_301(dictionary, states[301]);
    InitState_302(dictionary, states[302]);
    InitState_303(dictionary, states[303]);
    InitState_304(dictionary, states[304]);
    InitState_305(dictionary, states[305]);
    InitState_306(dictionary, states[306]);
    InitState_307(dictionary, states[307]);
    InitState_308(dictionary, states[308]);
    InitState_309(dictionary, states[309]);
    InitState_310(dictionary, states[310]);
    InitState_311(dictionary, states[311]);
    InitState_312(dictionary, states[312]);
    InitState_313(dictionary, states[313]);
    InitState_314(dictionary, states[314]);
    InitState_315(dictionary, states[315]);
    InitState_316(dictionary, states[316]);
    InitState_317(dictionary, states[317]);
    InitState_318(dictionary, states[318]);
    InitState_319(dictionary, states[319]);
    InitState_320(dictionary, states[320]);
    InitState_321(dictionary, states[321]);
    InitState_322(dictionary, states[322]);
    InitState_323(dictionary, states[323]);
    InitState_324(dictionary, states[324]);
    InitState_325(dictionary, states[325]);
    InitState_326(dictionary, states[326]);
    InitState_327(dictionary, states[327]);
    InitState_328(dictionary, states[328]);
    InitState_329(dictionary, states[329]);
    InitState_330(dictionary, states[330]);
    InitState_331(dictionary, states[331]);
    InitState_332(dictionary, states[332]);
    InitState_333(dictionary, states[333]);
    InitState_334(dictionary, states[334]);
    InitState_335(dictionary, states[335]);
    InitState_336(dictionary, states[336]);
    InitState_337(dictionary, states[337]);
    InitState_338(dictionary, states[338]);
    InitState_339(dictionary, states[339]);
    InitState_340(dictionary, states[340]);
    InitState_341(dictionary, states[341]);
    InitState_342(dictionary, states[342]);
    InitState_343(dictionary, states[343]);
    InitState_344(dictionary, states[344]);
    InitState_345(dictionary, states[345]);
    InitState_346(dictionary, states[346]);
    InitState_347(dictionary, states[347]);
    InitState_348(dictionary, states[348]);
    InitState_349(dictionary, states[349]);
    InitState_350(dictionary, states[350]);
    InitState_351(dictionary, states[351]);
    InitState_352(dictionary, states[352]);
    InitState_353(dictionary, states[353]);
    InitState_354(dictionary, states[354]);
    InitState_355(dictionary, states[355]);
    InitState_356(dictionary, states[356]);
    InitState_357(dictionary, states[357]);
    InitState_358(dictionary, states[358]);
    InitState_359(dictionary, states[359]);
    InitState_360(dictionary, states[360]);
    InitState_361(dictionary, states[361]);
    InitState_362(dictionary, states[362]);
    InitState_363(dictionary, states[363]);
    InitState_364(dictionary, states[364]);
    InitState_365(dictionary, states[365]);
    InitState_366(dictionary, states[366]);
    InitState_367(dictionary, states[367]);
    InitState_368(dictionary, states[368]);
    InitState_369(dictionary, states[369]);
    InitState_370(dictionary, states[370]);
    InitState_371(dictionary, states[371]);
    InitState_372(dictionary, states[372]);
    InitState_373(dictionary, states[373]);
    InitState_374(dictionary, states[374]);
    InitState_375(dictionary, states[375]);
    InitState_376(dictionary, states[376]);
    InitState_377(dictionary, states[377]);
    InitState_378(dictionary, states[378]);
    InitState_379(dictionary, states[379]);
    InitState_380(dictionary, states[380]);
    InitState_381(dictionary, states[381]);
    InitState_382(dictionary, states[382]);
    InitState_383(dictionary, states[383]);
    InitState_384(dictionary, states[384]);
    InitState_385(dictionary, states[385]);
    InitState_386(dictionary, states[386]);
    InitState_387(dictionary, states[387]);
    InitState_388(dictionary, states[388]);
    InitState_389(dictionary, states[389]);
    InitState_390(dictionary, states[390]);
    InitState_391(dictionary, states[391]);
    InitState_392(dictionary, states[392]);
    InitState_393(dictionary, states[393]);
    InitState_394(dictionary, states[394]);
    InitState_395(dictionary, states[395]);
    InitState_396(dictionary, states[396]);
    InitState_397(dictionary, states[397]);
    InitState_398(dictionary, states[398]);
    InitState_399(dictionary, states[399]);
    InitState_400(dictionary, states[400]);
    InitState_401(dictionary, states[401]);
    InitState_402(dictionary, states[402]);
    InitState_403(dictionary, states[403]);
    InitState_404(dictionary, states[404]);
    InitState_405(dictionary, states[405]);
    InitState_406(dictionary, states[406]);
    InitState_407(dictionary, states[407]);
    InitState_408(dictionary, states[408]);
    InitState_409(dictionary, states[409]);
    InitState_410(dictionary, states[410]);
    InitState_411(dictionary, states[411]);
    InitState_412(dictionary, states[412]);
    InitState_413(dictionary, states[413]);
    InitState_414(dictionary, states[414]);
    InitState_415(dictionary, states[415]);
    InitState_416(dictionary, states[416]);
    InitState_417(dictionary, states[417]);
    InitState_418(dictionary, states[418]);
    InitState_419(dictionary, states[419]);
    InitState_420(dictionary, states[420]);
    InitState_421(dictionary, states[421]);
    InitState_422(dictionary, states[422]);
    InitState_423(dictionary, states[423]);
    InitState_424(dictionary, states[424]);
    InitState_425(dictionary, states[425]);
    InitState_426(dictionary, states[426]);
    InitState_427(dictionary, states[427]);
    InitState_428(dictionary, states[428]);
    InitState_429(dictionary, states[429]);
    InitState_430(dictionary, states[430]);
    InitState_431(dictionary, states[431]);
    InitState_432(dictionary, states[432]);
    InitState_433(dictionary, states[433]);
    InitState_434(dictionary, states[434]);
    InitState_435(dictionary, states[435]);
    InitState_436(dictionary, states[436]);
    InitState_437(dictionary, states[437]);
    InitState_438(dictionary, states[438]);
    InitState_439(dictionary, states[439]);
    InitState_440(dictionary, states[440]);
    InitState_441(dictionary, states[441]);
    InitState_442(dictionary, states[442]);
    InitState_443(dictionary, states[443]);
    InitState_444(dictionary, states[444]);
    InitState_445(dictionary, states[445]);
    InitState_446(dictionary, states[446]);
    InitState_447(dictionary, states[447]);
    InitState_448(dictionary, states[448]);
    InitState_449(dictionary, states[449]);
    InitState_450(dictionary, states[450]);
    InitState_451(dictionary, states[451]);
    InitState_452(dictionary, states[452]);
    InitState_453(dictionary, states[453]);
    InitState_454(dictionary, states[454]);
    InitState_455(dictionary, states[455]);
    InitState_456(dictionary, states[456]);
    InitState_457(dictionary, states[457]);
    InitState_458(dictionary, states[458]);
    InitState_459(dictionary, states[459]);
    InitState_460(dictionary, states[460]);
    InitState_461(dictionary, states[461]);
    InitState_462(dictionary, states[462]);
    InitState_463(dictionary, states[463]);

    return true;
}

